/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2;

import com.sas.wadmin.viewdata2.ConnectionManager;
import com.sas.wadmin.viewdata2.ViewDataAbstractFactory;
import com.sas.wadmin.viewdata2.ViewDataException;
import com.sas.wadmin.viewdata2.ViewDataPanel;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.SwingUtilities;

public class RowCount {
    private int rowCount = -1;
    private Counter m_counterThread;
    private ViewDataAbstractFactory m_factory;
    private byte[] mutex = new byte[0];
    private long TIME_OUT = 3000000L;
    private byte[] wait_mutex = new byte[0];

    public RowCount(ViewDataAbstractFactory factory) {
        this.m_factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getRowCount(String libref, String sqlTableName) {
        WorkspaceFile defaultsFile = Workspace.getWorkspace().getAppDefaultsFile();
        boolean isEnableRowCount = defaultsFile.getPropertyBoolean("QuickProperties.RowCount", false);
        if (!isEnableRowCount) {
            this.m_counterThread = null;
            return;
        }
        byte[] byArray = this.mutex;
        synchronized (this.mutex) {
            this.m_counterThread = new Counter(libref, sqlTableName);
            this.m_counterThread.start();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    protected static int getRowCount(String query, Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        int count = -1;
        if (rs.next()) {
            Object o = rs.getObject(1);
            if (o != null) {
                count = rs.getInt(1);
            }
            rs.close();
            stmt.close();
        }
        return count;
    }

    public static int getRowCountFromDictionary(String libref, String sqlTableName, Connection conn) throws SQLException {
        String query = "select nobs - delobs from Sashelp.Vtable where libname = '" + libref.toUpperCase() + "' and memname = '" + sqlTableName + "' and memtype = 'DATA'";
        return RowCount.getRowCount(query, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void updateRowCountToModel() {
        if (this.m_counterThread != null && !this.m_counterThread.m_disposed) {
            byte[] byArray = this.wait_mutex;
            // MONITORENTER : this.wait_mutex
            try {
                this.wait_mutex.wait(this.TIME_OUT);
            }
            catch (InterruptedException e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            }
        }
        this.updateRowCountToModel(this.rowCount);
    }

    protected void updateRowCountToModel(int rowCount) {
        class RowCountUpdater
        implements Runnable {
            int m_rowCount;

            RowCountUpdater(int iRowCount) {
                this.m_rowCount = iRowCount;
            }

            @Override
            public void run() {
                if (RowCount.this.m_factory.hasDefaultModel()) {
                    if (this.m_rowCount != -1) {
                        RowCount.this.m_factory.getDefaultModel().setRowCount(this.m_rowCount);
                    }
                    ViewDataPanel panle = RowCount.this.m_factory.getDefaultModel().getViewDataPanel();
                    panle.setEnabled(true);
                }
            }
        }
        RowCountUpdater runnable = new RowCountUpdater(rowCount);
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        byte[] byArray = this.mutex;
        synchronized (this.mutex) {
            if (this.m_counterThread != null) {
                this.m_counterThread.dispose();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    class Counter
    implements Runnable {
        private ConnectionManager m_connManager;
        private boolean m_disposed = false;
        private String m_libref;
        private String m_sqlTableName;

        private Counter(String libref, String sqlTableName) {
            this.m_libref = libref;
            this.m_sqlTableName = sqlTableName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RowCount.this.rowCount = this.getRowCount();
            byte[] byArray = RowCount.this.wait_mutex;
            synchronized (byArray) {
                RowCount.this.wait_mutex.notifyAll();
            }
        }

        public void start() {
            new Thread(this).start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispose() {
            byte[] byArray = RowCount.this.mutex;
            synchronized (byArray) {
                if (this.m_disposed) {
                    return;
                }
                try {
                    if (this.m_connManager != null) {
                        this.m_connManager.dispose();
                    }
                }
                catch (ViewDataException e) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                }
                finally {
                    this.m_disposed = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected int getRowCount() {
            if (this.m_disposed) {
                return -1;
            }
            try {
                int rowLimit;
                byte[] byArray = RowCount.this.mutex;
                synchronized (byArray) {
                    if (this.m_disposed) {
                        int n = -1;
                        return n;
                    }
                    this.m_connManager = RowCount.this.m_factory.createConnectionManager();
                }
                int count = RowCount.getRowCountFromDictionary(this.m_libref, this.m_sqlTableName, this.m_connManager.getConnection());
                if (count < 0) {
                    String query = "select count(*) from " + this.m_libref + "." + this.m_sqlTableName;
                    count = RowCount.getRowCount(query, this.m_connManager.getConnection());
                }
                if ((rowLimit = RowCount.this.m_factory.getDefaultModel().getRowLimit()) > 0 && rowLimit < count) {
                    count = rowLimit;
                }
                int n = count;
                return n;
            }
            catch (SQLException e) {
                Workspace.getDefaultLogger().warn((Object)e.getLocalizedMessage());
                return -1;
            }
            catch (ViewDataException e) {
                Workspace.getDefaultLogger().warn((Object)e.getLocalizedMessage());
                return -1;
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().warn((Object)e.getLocalizedMessage());
                return -1;
            }
            finally {
                this.dispose();
            }
        }
    }
}

