/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2;

import com.sas.swing.models.CollectionToListModelAdapter;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.wadmin.viewdata2.ViewDataModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.ListModel;

public class QueryOptionsSubsetTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(QueryOptionsSubsetTab.class);
    private DualListSelector m_selector;
    private ViewDataModel m_model;
    private ArrayList m_columnWrappers;

    public QueryOptionsSubsetTab(ViewDataModel model) {
        this.m_model = model;
        this.initialize();
        this.layoutWidgets();
    }

    protected void initialize() {
        super.initialize();
        this.constructColumnWrappers();
        this.m_selector = new DualListSelector();
        this.m_selector.setSourceLabel(bundle.getString("QueryOptionsSubsetTab.AvailableColumnsLabel.txt"));
        ((JLabel)this.m_selector.getSourceLabelComponent()).setDisplayedMnemonic(bundle.getString("QueryOptionsSubsetTab.AvailableColumnsLabel.mnem").charAt(0));
        this.m_selector.setTargetLabel(bundle.getString("QueryOptionsSubsetTab.SelectedColumnsLabel.txt"));
        ((JLabel)this.m_selector.getTargetLabelComponent()).setDisplayedMnemonic(bundle.getString("QueryOptionsSubsetTab.SelectedColumnsLabel.mnem").charAt(0));
        this.updateFromModel();
        this.setHelpProduct("wdb");
        this.setHelpTopic("view_data_columns");
    }

    protected void constructColumnWrappers() {
        this.m_columnWrappers = new ArrayList(this.m_model.getTrueColumnCount());
        for (int i = 0; i < this.m_model.getTrueColumnCount(); ++i) {
            this.m_columnWrappers.add(new ColumnWrapper(i));
        }
    }

    protected void layoutWidgets() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_selector);
    }

    public boolean validateData() {
        if (!super.validateData()) {
            return false;
        }
        if (this.m_selector.getTargetModel().getSize() == 0) {
            MessageUtil.displayMessage((String)bundle.getString("QueryOptionsSubsetTab.NoColumns.txt"), (String)bundle.getString("QueryOptionsSubsetTab.NoColumns.title.txt"), (int)0);
            return false;
        }
        return true;
    }

    public int[] getSelectedColumns() {
        if (this.m_selector.getTargetModel().getSize() == 0) {
            return null;
        }
        int[] selectedColumns = new int[this.m_selector.getTargetModel().getSize()];
        for (int i = 0; i < selectedColumns.length; ++i) {
            int index;
            selectedColumns[i] = index = ((ColumnWrapper)this.m_selector.getTargetModel().getElementAt(i)).m_columnModelIndex;
        }
        this.sortArray(selectedColumns);
        return selectedColumns;
    }

    public boolean hasDisplayListChanged() {
        int[] displayColumns = this.m_model.getDisplayColumns();
        if (this.m_selector.getTargetModel().getSize() == 0) {
            this.updateFromModel();
        }
        if (displayColumns == null) {
            return this.m_selector.getTargetModel().getSize() != 0;
        }
        int size = this.m_selector.getTargetModel().getSize();
        if (size != displayColumns.length) {
            return true;
        }
        for (int i = 0; i < size; ++i) {
            int index = ((ColumnWrapper)this.m_selector.getTargetModel().getElementAt(i)).m_columnModelIndex;
            boolean contains = false;
            for (int j = 0; j < size; ++j) {
                if (index != displayColumns[j]) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            return true;
        }
        return false;
    }

    protected void updateColumnLabels() {
        this.m_selector.repaint();
    }

    protected void updateFromModel() {
        this.constructColumnWrappers();
        int[] displayCols = this.m_model.getDisplayColumns();
        ArrayList unselectedCols = new ArrayList(this.m_columnWrappers);
        ArrayList<ColumnWrapper> selectedCols = new ArrayList<ColumnWrapper>();
        block0: for (int i = unselectedCols.size() - 1; i >= 0; --i) {
            ColumnWrapper wrapper = (ColumnWrapper)unselectedCols.get(i);
            for (int j = 0; j < displayCols.length; ++j) {
                if (wrapper.m_columnModelIndex != displayCols[j]) continue;
                unselectedCols.remove(wrapper);
                selectedCols.add(0, wrapper);
                continue block0;
            }
        }
        this.m_selector.setModel((ListModel)new CollectionToListModelAdapter(unselectedCols));
        this.m_selector.setTargetModel((ListModel)new CollectionToListModelAdapter(selectedCols));
    }

    private void sortArray(int[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            for (int j = i + 1; j < columns.length; ++j) {
                if (columns[i] <= columns[j]) continue;
                int temp = columns[i];
                columns[i] = columns[j];
                columns[j] = temp;
            }
        }
    }

    private class ColumnWrapper {
        private int m_columnModelIndex;

        private ColumnWrapper(int columnModelIndex) {
            this.m_columnModelIndex = columnModelIndex;
        }

        protected int getModelIndex() {
            return this.m_columnModelIndex;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ColumnWrapper) {
                return ((ColumnWrapper)obj).m_columnModelIndex == this.m_columnModelIndex;
            }
            return false;
        }

        public int hashcode() {
            return super.hashCode();
        }

        public String toString() {
            return QueryOptionsSubsetTab.this.m_model.getTrueColumnName(this.m_columnModelIndex);
        }
    }
}

