/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2;

import com.sas.etl.models.data.ITable;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.viewdata2.JobTableModel;
import com.sas.wadmin.viewdata2.ViewDataDataTableModel;
import com.sas.wadmin.viewdata2.ViewDataModel;
import com.sas.workspace.DBMSNamesPropertyHandler;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.visuals.ExpressionBuilderTab;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class QueryOptionsFilterTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(QueryOptionsFilterTab.class);
    private JRadioButton m_btnNone;
    private JRadioButton m_btnSimple;
    private WAComboBox m_cmbColumns;
    private WAComboBox m_cmbFilterType;
    private WATextField m_txtSimpleValue;
    private JCheckBox m_chkApplyNOT;
    private JRadioButton m_btnComplex;
    private WATextArea m_txtComplexExpression;
    private JButton m_btnBuildExpression;
    private ViewDataModel m_model;
    private ArrayList m_columnWrappers;
    private int lastFilterStatus = 0;
    private static final int CURRENT_FILTER_STATUS_NONE = 0;
    private static final int CURRENT_FILTER_STATUS_SIMPLE = 1;
    private static final int CURRENT_FILTER_STATUS_COMPLEX = 2;
    private int lastSimpleSelectedColumnIndex = 0;
    private int lastSimpleSelectedFilterTypeIndex = 0;
    private String lastSimpleValue = "";
    private boolean lastChkApplyNOT = false;
    private String lastComplexText = "";

    public QueryOptionsFilterTab(ViewDataModel model) {
        this.m_model = model;
        this.initialize();
        this.layoutWidgets();
    }

    protected void initialize() {
        super.initialize();
        this.constructColumnWrappers();
        this.m_btnNone = new JRadioButton((Action)((Object)new NoneAction()));
        this.m_btnNone.setSelected(true);
        this.m_btnSimple = new JRadioButton((Action)((Object)new SimpleAction()));
        this.m_cmbColumns = new WAComboBox();
        this.m_cmbColumns.setSorted(true);
        this.m_cmbColumns.setPreferredSize(new Dimension(175, 20));
        this.populateColumnsCombo();
        this.m_cmbColumns.addActionListener((ActionListener)new ColumnsComboListener());
        this.m_cmbFilterType = new WAComboBox();
        this.m_txtSimpleValue = new WATextField();
        this.m_txtSimpleValue.setToolTipText(bundle.getString("QueryOptionsFilterTab.ValueLabel.tip"));
        this.m_chkApplyNOT = new JCheckBox((Action)((Object)new ApplyNOTAction()));
        this.m_btnComplex = new JRadioButton((Action)((Object)new ComplexAction()));
        this.m_txtComplexExpression = new WATextArea(5, 20);
        this.m_btnBuildExpression = new JButton((Action)((Object)new BuildExpressionAction()));
        ButtonGroup ckgroup = new ButtonGroup();
        ckgroup.add(this.m_btnNone);
        ckgroup.add(this.m_btnSimple);
        ckgroup.add(this.m_btnComplex);
        this.m_cmbColumns.setSelectedIndex(0);
        this.updateFromModel();
        this.onNone();
        this.setHelpProduct("wdb");
        this.setHelpTopic("view_data_filter");
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        WAPanel pnlSimple = this.getSimplePanel();
        WAPanel pnlComplex = this.getComplexPanel();
        this.add(this.m_btnNone, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 0), 0, 0));
        this.add(this.m_btnSimple, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)pnlSimple, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_btnComplex, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)pnlComplex, new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 30, 5, 5), 0, 0));
        this.add(new JLabel(), new GridBagConstraints(0, 6, 2, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected void updateFromModel() {
        this.constructColumnWrappers();
    }

    public void updateFromModelOnCancel() {
        this.constructColumnWrappers();
        switch (this.lastFilterStatus) {
            case 0: {
                this.m_btnNone.setSelected(true);
                this.onNone();
                break;
            }
            case 1: {
                this.m_btnSimple.setSelected(true);
                this.onSimple();
                break;
            }
            case 2: {
                this.m_btnComplex.setSelected(true);
                this.onComplex();
            }
        }
        this.m_cmbColumns.setSelectedIndex(this.lastSimpleSelectedColumnIndex);
        this.m_cmbFilterType.setSelectedIndex(this.lastSimpleSelectedFilterTypeIndex);
        this.m_txtSimpleValue.setText(this.lastSimpleValue);
        this.m_chkApplyNOT.setSelected(this.lastChkApplyNOT);
        this.m_txtComplexExpression.setText(this.lastComplexText);
    }

    public void saveCurrentFilterStatus() {
        if (this.m_btnNone.isSelected()) {
            this.lastFilterStatus = 0;
        } else if (this.m_btnSimple.isSelected()) {
            this.lastFilterStatus = 1;
        } else if (this.m_btnComplex.isSelected()) {
            this.lastFilterStatus = 2;
        }
        this.lastSimpleSelectedColumnIndex = this.m_cmbColumns.getSelectedIndex();
        this.lastSimpleSelectedFilterTypeIndex = this.m_cmbFilterType.getSelectedIndex();
        this.lastSimpleValue = this.m_txtSimpleValue.getText();
        this.lastChkApplyNOT = this.m_chkApplyNOT.isSelected();
        this.lastComplexText = this.m_txtComplexExpression.getText();
    }

    protected void constructColumnWrappers() {
        this.m_columnWrappers = new ArrayList();
        for (int i = 0; i < this.m_model.getTrueColumnCount(); ++i) {
            this.m_columnWrappers.add(new ColumnWrapper(i));
        }
    }

    protected void populateColumnsCombo() {
        int i;
        ActionListener[] listeners = this.m_cmbColumns.getActionListeners();
        for (i = 0; i < listeners.length; ++i) {
            this.m_cmbColumns.removeActionListener(listeners[i]);
        }
        this.m_cmbColumns.removeAllItems();
        for (i = 0; i < this.m_columnWrappers.size(); ++i) {
            this.m_cmbColumns.addItem(this.m_columnWrappers.get(i));
        }
        this.m_cmbColumns.setSelectedIndex(0);
        for (i = 0; i < listeners.length; ++i) {
            this.m_cmbColumns.addActionListener(listeners[i]);
        }
    }

    protected WAPanel getSimplePanel() {
        WAPanel pnlSimple = new WAPanel();
        JLabel lblColumn = new JLabel(bundle.getString("QueryOptionsFilterTab.ColumnLabel.txt"));
        lblColumn.setLabelFor((Component)this.m_cmbColumns);
        lblColumn.setDisplayedMnemonic(bundle.getString("QueryOptionsFilterTab.ColumnLabel.mnem").charAt(0));
        JLabel lblFilterType = new JLabel(bundle.getString("QueryOptionsFilterTab.FilterTypeLabel.txt"));
        lblFilterType.setLabelFor((Component)this.m_cmbFilterType);
        lblFilterType.setDisplayedMnemonic(bundle.getString("QueryOptionsFilterTab.FilterTypeLabel.mnem").charAt(0));
        JLabel lblSimpleValue = new JLabel(bundle.getString("QueryOptionsFilterTab.ValueLabel.txt"));
        lblSimpleValue.setLabelFor((Component)this.m_txtSimpleValue);
        lblSimpleValue.setDisplayedMnemonic(bundle.getString("QueryOptionsFilterTab.ValueLabel.mnem").charAt(0));
        lblSimpleValue.setToolTipText(bundle.getString("QueryOptionsFilterTab.ValueLabel.tip"));
        pnlSimple.setLayout((LayoutManager)new GridBagLayout());
        pnlSimple.add((Component)lblColumn, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 30, 5, 0), 0, 0));
        pnlSimple.add((Component)this.m_cmbColumns, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 17, 2, new Insets(5, 30, 5, 0), 0, 0));
        pnlSimple.add((Component)lblFilterType, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 30, 5, 0), 0, 0));
        pnlSimple.add((Component)this.m_cmbFilterType, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 30, 5, 0), 0, 0));
        pnlSimple.add((Component)lblSimpleValue, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 30, 5, 0), 0, 0));
        pnlSimple.add((Component)this.m_txtSimpleValue, (Object)new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 30, 5, 0), 0, 0));
        pnlSimple.add((Component)this.m_chkApplyNOT, (Object)new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 30, 5, 0), 0, 0));
        return pnlSimple;
    }

    protected WAPanel getComplexPanel() {
        WAPanel pnlComplex = new WAPanel();
        JScrollPane scroll = new JScrollPane((Component)this.m_txtComplexExpression);
        WsUIUtilities.adjustScrollPanePreferredSize((JScrollPane)scroll);
        pnlComplex.setLayout((LayoutManager)new GridBagLayout());
        pnlComplex.add((Component)scroll, (Object)new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 18, 1, new Insets(5, 30, 5, 5), 0, 0));
        pnlComplex.add((Component)this.m_btnBuildExpression, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 15, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_btnBuildExpression.setVisible(this.m_model instanceof ViewDataDataTableModel || this.m_model instanceof JobTableModel);
        return pnlComplex;
    }

    public String getFilter() {
        if (this.m_btnSimple.isSelected()) {
            int selectedIndex = this.m_cmbColumns.getSelectedIndex();
            if (selectedIndex == -1) {
                return null;
            }
            int columnIndex = ((ColumnWrapper)this.m_cmbColumns.getSelectedItem()).getColumnIndex();
            String columnName = this.m_model.getTrueColumnSQLName(columnIndex);
            String filterType = ((FilterType)this.m_cmbFilterType.getSelectedItem()).getOperator();
            String filterExpression = this.m_txtSimpleValue.getText();
            String sasColType = this.m_model.getTrueColumnSASType(columnIndex);
            if (!"C".equals(sasColType) && (filterExpression == null || "".equals(filterExpression))) {
                filterExpression = ".";
                this.m_txtSimpleValue.setText(".");
            }
            String clause = filterType.equals("BW") ? columnName + " like '" + filterExpression + "%'" : (filterType.equals("CO") ? columnName + " contains '" + filterExpression + "'" : (filterType.equals("LI") ? columnName + " like '" + filterExpression + "'" : columnName + " " + filterType + " " + this.quoteSimpleClauseValue(filterExpression, sasColType)));
            if (this.m_chkApplyNOT.isSelected()) {
                clause = "NOT(" + clause + ")";
            }
            return clause;
        }
        if (this.m_btnComplex.isSelected()) {
            return this.m_txtComplexExpression.getText();
        }
        return null;
    }

    protected String quoteSimpleClauseValue(String value, String columnType) {
        if ("C".equals(columnType)) {
            return "'" + value + "'";
        }
        return value;
    }

    public boolean hasClauseChanged() {
        String clause = this.getFilter();
        if (clause == null) {
            return this.m_model.hasFilter();
        }
        return !this.getFilter().equals(this.m_model.getFilter());
    }

    protected void onNone() {
        this.setSimpleEnabled(false);
        this.setComplexEnabled(false);
    }

    protected void onSimple() {
        this.setSimpleEnabled(true);
        this.setComplexEnabled(false);
    }

    protected void onColumnsComboValueChanged() {
        this.m_cmbFilterType.removeAllItems();
        this.m_cmbFilterType.addItem((Object)FilterType.FILTER_EQUALS);
        this.m_cmbFilterType.addItem((Object)FilterType.FILTER_LESS_THAN);
        this.m_cmbFilterType.addItem((Object)FilterType.FILTER_LESS_THAN_EQUALS);
        this.m_cmbFilterType.addItem((Object)FilterType.FILTER_GREATER_THAN);
        this.m_cmbFilterType.addItem((Object)FilterType.FILTER_GREATER_THAN_EQUALS);
        this.m_cmbFilterType.addItem((Object)FilterType.FILTER_NOT_EQUALS);
        String sasColType = this.m_model.getTrueColumnSASType(((ColumnWrapper)this.m_cmbColumns.getSelectedItem()).getColumnIndex());
        if ("C".equals(sasColType)) {
            this.m_cmbFilterType.addItem((Object)FilterType.FILTER_BEGINS_WITH);
            this.m_cmbFilterType.addItem((Object)FilterType.FILTER_CONTAINS);
            this.m_cmbFilterType.addItem((Object)FilterType.FILTER_LIKE);
        }
    }

    protected void onApplyNOT() {
    }

    protected void onComplex() {
        this.setSimpleEnabled(false);
        this.setComplexEnabled(true);
    }

    protected void onBuildExpression() {
        this.showExpressionBuilder();
    }

    protected void setSimpleEnabled(boolean enabled) {
        this.m_cmbColumns.setEnabled(enabled);
        this.m_cmbFilterType.setEnabled(enabled);
        this.m_txtSimpleValue.setEnabled(enabled);
        this.m_chkApplyNOT.setEnabled(enabled);
    }

    protected void setComplexEnabled(boolean enabled) {
        this.m_txtComplexExpression.setEnabled(enabled);
        this.m_btnBuildExpression.setEnabled(enabled);
    }

    protected void setComplexExpression(String strExpr) {
        this.m_txtComplexExpression.setText(strExpr);
    }

    protected void showExpressionBuilder() {
        if (!(this.m_model instanceof ViewDataDataTableModel) && !(this.m_model instanceof JobTableModel)) {
            MessageUtil.displayMessage((String)bundle.getString("QueryOptionsFilterTab.NoExpressionBuilder.txt"), (int)2);
            return;
        }
        if (this.m_model instanceof ViewDataDataTableModel) {
            ViewDataDataTableModel model = (ViewDataDataTableModel)this.m_model;
            try {
                List columnWrappers = this.sortColumnsByColumnName();
                ArrayList<Column> columns = new ArrayList<Column>(columnWrappers.size());
                for (int i = 0; i < columnWrappers.size(); ++i) {
                    columns.add(model.getTrueColumnMetadata(((ColumnWrapper)columnWrappers.get(i)).getColumnIndex()));
                }
                ExpressionBuilderTab tabExpressionBuilder = new ExpressionBuilderTab(columns, true);
                tabExpressionBuilder.setExpression(this.m_txtComplexExpression.getText());
                tabExpressionBuilder.setUseQuotes(this.tableNeedsQuotes(model.getDataTable()));
                WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.formatString("QueryOptionsFilterTab.ExpressionBuilderTitle.fmt.txt", (Object)this.m_model.getTableDisplayName()), true, (WAPanel)tabExpressionBuilder);
                dialog.setResizable(true);
                dialog.show();
                if (dialog.getReturnValue() == 1) {
                    this.setComplexExpression(tabExpressionBuilder.getExpression());
                }
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        } else if (this.m_model instanceof JobTableModel) {
            JobTableModel model = (JobTableModel)this.m_model;
            ITable table = model.getTable();
            com.sas.wadmin.visuals.common.ExpressionBuilderTab tabExpressionBuilder = new com.sas.wadmin.visuals.common.ExpressionBuilderTab(table.getColumns(), new ITable[0], true);
            tabExpressionBuilder.setExpression(this.m_txtComplexExpression.getText());
            tabExpressionBuilder.setUseQuotes(table.isQuoted());
            WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.formatString("QueryOptionsFilterTab.ExpressionBuilderTitle.fmt.txt", (Object)this.m_model.getTableDisplayName()), true, (WAPanel)tabExpressionBuilder);
            dialog.setResizable(true);
            dialog.show();
            if (dialog.getReturnValue() == 1) {
                this.setComplexExpression(tabExpressionBuilder.getExpression());
            }
        }
    }

    private boolean tableNeedsQuotes(DataTable table) throws MdException, RemoteException {
        String specChar = DBMSNamesPropertyHandler.getSpecCharPropertyValue((Root)table);
        String preserveCase = DBMSNamesPropertyHandler.getCasePropertyValue((Root)table);
        return specChar.compareToIgnoreCase("Y") == 0 || preserveCase.compareToIgnoreCase("Y") == 0;
    }

    private List sortColumnsByColumnName() {
        ColumnWrapper[] columnWrappers = this.m_columnWrappers.toArray(new ColumnWrapper[0]);
        for (int i = 0; i < columnWrappers.length; ++i) {
            String colNamei = this.m_model.getTrueColumnName(columnWrappers[i].getColumnIndex());
            for (int j = 0; j < this.m_columnWrappers.size(); ++j) {
                String colNamej = this.m_model.getTrueColumnName(columnWrappers[j].getColumnIndex());
                if (colNamei.compareTo(colNamej) >= 0) continue;
                ColumnWrapper temp = columnWrappers[i];
                columnWrappers[i] = columnWrappers[j];
                columnWrappers[j] = temp;
            }
        }
        return new ArrayList<ColumnWrapper>(Arrays.asList(columnWrappers));
    }

    class BuildExpressionAction
    extends WsAbstractAction {
        BuildExpressionAction() {
            super(bundle, "QueryOptionsFilterTab.BuildExpressionAction", 0);
        }

        public void actionPerformed(ActionEvent e) {
            QueryOptionsFilterTab.this.onBuildExpression();
        }
    }

    class ComplexAction
    extends WsAbstractAction {
        ComplexAction() {
            super(bundle, "QueryOptionsFilterTab.ComplexAction", 0);
        }

        public void actionPerformed(ActionEvent e) {
            QueryOptionsFilterTab.this.onComplex();
        }
    }

    class ApplyNOTAction
    extends WsAbstractAction {
        ApplyNOTAction() {
            super(bundle, "QueryOptionsFilterTab.ApplyNOTAction", 0);
        }

        public void actionPerformed(ActionEvent e) {
            QueryOptionsFilterTab.this.onApplyNOT();
        }
    }

    class ColumnsComboListener
    implements ActionListener {
        ColumnsComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            QueryOptionsFilterTab.this.onColumnsComboValueChanged();
        }
    }

    class SimpleAction
    extends WsAbstractAction {
        SimpleAction() {
            super(bundle, "QueryOptionsFilterTab.SimpleAction", 0);
        }

        public void actionPerformed(ActionEvent e) {
            QueryOptionsFilterTab.this.onSimple();
        }
    }

    class NoneAction
    extends WsAbstractAction {
        NoneAction() {
            super(bundle, "QueryOptionsFilterTab.NoneAction", 0);
        }

        public void actionPerformed(ActionEvent e) {
            QueryOptionsFilterTab.this.onNone();
        }
    }

    static class FilterType {
        protected static final String OPERATOR_BEGINSWITH = "BW";
        protected static final String OPERATOR_CONTAINS = "CO";
        protected static final String OPERATOR_LIKE = "LI";
        protected static final FilterType FILTER_EQUALS = new FilterType(QueryOptionsFilterTab.access$300().getString("QueryOptionsFilterTab.FilterTypeEquals.txt"), "=");
        protected static final FilterType FILTER_GREATER_THAN = new FilterType(QueryOptionsFilterTab.access$300().getString("QueryOptionsFilterTab.FilterTypeGreaterThan.txt"), ">");
        protected static final FilterType FILTER_GREATER_THAN_EQUALS = new FilterType(QueryOptionsFilterTab.access$300().getString("QueryOptionsFilterTab.FilterTypeGreaterThanOrEquals.txt"), ">=");
        protected static final FilterType FILTER_LESS_THAN = new FilterType(QueryOptionsFilterTab.access$300().getString("QueryOptionsFilterTab.FilterTypeLessThan.txt"), "<");
        protected static final FilterType FILTER_LESS_THAN_EQUALS = new FilterType(QueryOptionsFilterTab.access$300().getString("QueryOptionsFilterTab.FilterTypeLessThanOrEquals.txt"), "<=");
        protected static final FilterType FILTER_NOT_EQUALS = new FilterType(QueryOptionsFilterTab.access$300().getString("QueryOptionsFilterTab.FilterTypeNotEqual.txt"), "NE");
        protected static final FilterType FILTER_BEGINS_WITH = new FilterType(QueryOptionsFilterTab.access$300().getString("QueryOptionsFilterTab.FilterTypeBeginsWith.txt"), "BW");
        protected static final FilterType FILTER_CONTAINS = new FilterType(QueryOptionsFilterTab.access$300().getString("QueryOptionsFilterTab.FilterTypeContains.txt"), "CO");
        protected static final FilterType FILTER_LIKE = new FilterType(QueryOptionsFilterTab.access$300().getString("QueryOptionsFilterTab.FilterTypeLike.txt"), "LI");
        private String m_displayName;
        private String m_operator;

        private FilterType(String displayName, String operator) {
            this.m_displayName = displayName;
            this.m_operator = operator;
        }

        private String getDisplayName() {
            return this.m_displayName;
        }

        private String getOperator() {
            return this.m_operator;
        }

        public String toString() {
            return this.getDisplayName();
        }
    }

    class ColumnWrapper
    implements Comparable {
        private int m_columnIndex;

        private ColumnWrapper(int column) {
            this.m_columnIndex = column;
        }

        protected int getColumnIndex() {
            return this.m_columnIndex;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ColumnWrapper) {
                return ((ColumnWrapper)obj).m_columnIndex == this.m_columnIndex;
            }
            return false;
        }

        public int hashcode() {
            return super.hashCode();
        }

        public int compareTo(Object o) {
            if (!(o instanceof ColumnWrapper)) {
                throw new ClassCastException("Illegal compare with ColumnWrapper");
            }
            return this.toString().compareTo(o.toString());
        }

        public String toString() {
            return QueryOptionsFilterTab.this.m_model.getTrueColumnName(this.m_columnIndex);
        }
    }
}

