/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2;

import com.sas.wadmin.viewdata2.QueryOptionsFilterTab;
import com.sas.wadmin.viewdata2.QueryOptionsSortTab;
import com.sas.wadmin.viewdata2.QueryOptionsSubsetTab;
import com.sas.wadmin.viewdata2.ViewDataModel;
import com.sas.wadmin.viewdata2.event.QueryOptionsEventListener;
import com.sas.wadmin.viewdata2.event.ViewDataModelAdapter;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Frame;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class QueryOptionsDialog
extends WAPropertyDialog {
    private static WAdminResource bundle = WAdminResource.getBundle(QueryOptionsDialog.class);
    private static boolean RUN_DEAD_CODE = false;
    private ViewDataModel m_model;
    private QueryOptionsSortTab m_sortTab;
    private QueryOptionsFilterTab m_filterTab;
    private QueryOptionsSubsetTab m_subsetTab;
    private ArrayList m_queryOptionsEventListeners;
    private boolean m_initialized = false;

    public QueryOptionsDialog(ViewDataModel model) {
        super((Frame)Workspace.getWorkspace(), bundle.formatString("QueryOptionsDialog.Title.fmt.txt", (Object)model.getTableDisplayName()), true);
        this.m_model = model;
        this.m_model.addViewDataModelListener(new ModelListener());
        this.m_queryOptionsEventListeners = new ArrayList();
        this.initialize();
        this.layoutWidgets();
        this.m_initialized = true;
    }

    protected void initialize() {
        if (this.m_initialized) {
            return;
        }
        super.initialize();
        this.setResizable(true);
        this.setApplyButtonVisible(false);
        this.m_sortTab = new QueryOptionsSortTab(this.m_model);
        this.m_filterTab = new QueryOptionsFilterTab(this.m_model);
        this.m_subsetTab = new QueryOptionsSubsetTab(this.m_model);
        this.m_btnOk.setMnemonic(bundle.getString("QueryOptionsDialog.OK.mnem").charAt(0));
        this.m_btnCancel.setMnemonic(bundle.getString("QueryOptionsDialog.Cancel.mnem").charAt(0));
    }

    protected void layoutWidgets() {
        if (this.m_initialized) {
            return;
        }
        super.layoutWidgets();
        this.addTab(bundle.getString("QueryOptionsDialog.SortTabTitle.txt"), this.m_sortTab);
        this.addTab(bundle.getString("QueryOptionsDialog.FilterTabTitle.txt"), this.m_filterTab);
        this.addTab(bundle.getString("QueryOptionsDialog.ColumnsTabTitle.txt"), this.m_subsetTab);
    }

    public void show(QueryOption tab) {
        if (tab == QueryOption.OPTION_SORT) {
            this.showTab(this.m_sortTab);
        } else if (tab == QueryOption.OPTION_FILTER) {
            this.showTab(this.m_filterTab);
        } else if (tab == QueryOption.OPTION_SUBSET) {
            this.showTab(this.m_subsetTab);
        }
        this.show();
    }

    public void updateFromModel() {
        this.m_sortTab.updateFromModel();
        this.m_filterTab.updateFromModel();
        this.m_subsetTab.updateFromModel();
    }

    protected boolean onOK() {
        if (!super.onOK()) {
            return false;
        }
        boolean hasChanges = false;
        if (this.m_sortTab.hasClauseChanged()) {
            hasChanges = true;
            this.notifyQueryOptionChanged(QueryOption.OPTION_SORT);
        }
        if (this.m_filterTab.hasClauseChanged()) {
            hasChanges = true;
            this.notifyQueryOptionChanged(QueryOption.OPTION_FILTER);
            this.m_filterTab.saveCurrentFilterStatus();
        }
        if (this.m_subsetTab.hasDisplayListChanged()) {
            hasChanges = true;
            this.notifyQueryOptionChanged(QueryOption.OPTION_SUBSET);
        }
        if (hasChanges) {
            this.notifyQueryOptionsChanged();
        }
        return true;
    }

    protected boolean onCancel() {
        this.m_sortTab.updateFromModel();
        this.m_filterTab.updateFromModelOnCancel();
        this.m_subsetTab.updateFromModel();
        return super.onCancel();
    }

    protected void onFetchSuccessful() {
        this.updateFromModel();
    }

    public ArrayList getSortByColumns() {
        return this.m_sortTab.getSortByColumns();
    }

    public String getFilter() {
        return this.m_filterTab.getFilter();
    }

    public int[] getDisplayColumns() {
        return this.m_subsetTab.getSelectedColumns();
    }

    protected ViewDataModel getModel() {
        return this.m_model;
    }

    public void addQueryOptionsEventListener(QueryOptionsEventListener listener) {
        if (this.m_queryOptionsEventListeners == null || this.m_queryOptionsEventListeners.size() == 0) {
            this.m_queryOptionsEventListeners = new ArrayList();
        }
        this.m_queryOptionsEventListeners.add(listener);
    }

    public void removeQueryOptionsEventListener(QueryOptionsEventListener listener) {
        if (this.m_queryOptionsEventListeners == null || this.m_queryOptionsEventListeners.size() == 0) {
            return;
        }
        this.m_queryOptionsEventListeners.remove(listener);
    }

    public void notifyQueryOptionChanged(QueryOption option) {
        if (this.m_queryOptionsEventListeners == null || this.m_queryOptionsEventListeners.size() == 0) {
            return;
        }
        for (int i = 0; i < this.m_queryOptionsEventListeners.size(); ++i) {
            QueryOptionsEventListener listener = (QueryOptionsEventListener)this.m_queryOptionsEventListeners.get(i);
            listener.queryOptionChanged(option);
        }
    }

    public void notifyQueryOptionsChanged() {
        if (this.m_queryOptionsEventListeners == null || this.m_queryOptionsEventListeners.size() == 0) {
            return;
        }
        for (int i = 0; i < this.m_queryOptionsEventListeners.size(); ++i) {
            QueryOptionsEventListener listener = (QueryOptionsEventListener)this.m_queryOptionsEventListeners.get(i);
            listener.queryOptionsChanged();
        }
    }

    static {
        if (RUN_DEAD_CODE) {
            new QueryOption();
        }
    }

    class ModelListener
    extends ViewDataModelAdapter {
        ModelListener() {
        }

        @Override
        public void fetchSuccessful() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QueryOptionsDialog.this.onFetchSuccessful();
                }
            });
        }
    }

    public static final class QueryOption {
        public static final QueryOption OPTION_SORT = new QueryOption();
        public static final QueryOption OPTION_FILTER = new QueryOption();
        public static final QueryOption OPTION_SUBSET = new QueryOption();

        private QueryOption() {
        }
    }
}

