/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2;

import com.sas.wadmin.viewdata2.QueryOptionsDialog;
import com.sas.wadmin.viewdata2.RSCursorMover;
import com.sas.wadmin.viewdata2.SearchToolArea;
import com.sas.wadmin.viewdata2.ViewDataException;
import com.sas.wadmin.viewdata2.ViewDataJDBCModel;
import com.sas.wadmin.viewdata2.ViewDataModel;
import com.sas.wadmin.viewdata2.ViewDataPanel;
import com.sas.wadmin.viewdata2.ViewDataScrollPane;
import com.sas.wadmin.viewdata2.ViewDataTable;
import com.sas.wadmin.viewdata2.ViewDataUndoManager;
import com.sas.wadmin.viewdata2.event.CommonActionsExceptionDefaultHandler;
import com.sas.wadmin.viewdata2.event.CommonActionsExceptionHandler;
import com.sas.wadmin.viewdata2.event.ViewDataModelAdapter;
import com.sas.wadmin.viewdata2.event.ViewDataTableListener;
import com.sas.wadmin.viewdata2.event.ViewDataUndoManagerListener;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractIconFactory;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsTablePrinter;
import com.sas.workspace.WsTitledPageFormat;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.undo.UndoableEdit;

public class CommonActionsFactory {
    private static WAdminResource bundle = WAdminResource.getBundle(CommonActionsFactory.class);
    public static final CommonActionsExceptionHandler DEFAULT_HANDLER = new CommonActionsExceptionDefaultHandler();
    public static final CommonActionsExceptionHandler SHOW_MESSAGE_HANDLER = new ShowMessageExceptionHandler();

    public static JToolBar getGoToRowWidget(ViewDataTable table) {
        return CommonActionsFactory.getGoToRowWidget(table, null);
    }

    public static JToolBar getGoToRowWidget(ViewDataTable table, CommonActionsExceptionHandler handler) {
        return new GoToRowPanel(table, handler != null ? handler : new GoToRowExceptionHandler());
    }

    public static WsAbstractAction getGoToFirstRowAction(ViewDataTable table) {
        return CommonActionsFactory.getGoToFirstRowAction(table, null);
    }

    public static WsAbstractAction getGoToFirstRowAction(ViewDataTable table, CommonActionsExceptionHandler handler) {
        return new GoToFirstRowAction(table, handler);
    }

    public static WsAbstractAction getGoToLastRowAction(ViewDataTable table) {
        return CommonActionsFactory.getGoToLastRowAction(table, null);
    }

    public static WsAbstractAction getGoToLastRowAction(ViewDataTable table, CommonActionsExceptionHandler handler) {
        return new GoToLastRowAction(table, handler);
    }

    public static WsAbstractToggleAction getShowSearchScreenAction(SearchToolArea search) {
        return CommonActionsFactory.getShowSearchScreenAction(search, null);
    }

    public static WsAbstractToggleAction getShowSearchScreenAction(SearchToolArea search, CommonActionsExceptionHandler handler) {
        return new ShowSearchScreenAction(search, handler);
    }

    public static WsAbstractToggleAction getShowSortScreenAction(QueryOptionsDialog queryOptions) {
        return CommonActionsFactory.getShowSortScreenAction(queryOptions, null);
    }

    public static WsAbstractToggleAction getShowSortScreenAction(QueryOptionsDialog queryOptions, CommonActionsExceptionHandler handler) {
        return new ShowSortScreenAction(queryOptions, handler);
    }

    public static WsAbstractToggleAction getShowFilterScreenAction(QueryOptionsDialog queryOptions) {
        return CommonActionsFactory.getShowFilterScreenAction(queryOptions, null);
    }

    public static WsAbstractToggleAction getShowFilterScreenAction(QueryOptionsDialog queryOptions, CommonActionsExceptionHandler handler) {
        return new ShowFilterScreenAction(queryOptions, handler);
    }

    public static WsAbstractToggleAction getShowSubsetScreenAction(QueryOptionsDialog queryOptions) {
        return CommonActionsFactory.getShowSubsetScreenAction(queryOptions, null);
    }

    public static WsAbstractToggleAction getShowSubsetScreenAction(QueryOptionsDialog queryOptions, CommonActionsExceptionHandler handler) {
        return new ShowSubsetScreenAction(queryOptions, handler);
    }

    public static WsAbstractToggleAction getShowMetadataColumnNameAction(ViewDataModel model) {
        return CommonActionsFactory.getShowMetadataColumnNameAction(model, null);
    }

    public static WsAbstractToggleAction getShowMetadataColumnNameAction(ViewDataModel model, CommonActionsExceptionHandler handler) {
        return new ShowMetadataColumnNameAction(model, handler);
    }

    public static WsAbstractToggleAction getShowMetadataColumnLabelAction(ViewDataModel model) {
        return CommonActionsFactory.getShowMetadataColumnLabelAction(model, null);
    }

    public static WsAbstractToggleAction getShowMetadataColumnLabelAction(ViewDataModel model, CommonActionsExceptionHandler handler) {
        return new ShowMetadataColumnLabelAction(model, handler);
    }

    public static WsAbstractToggleAction getShowMetadataColumnMetadataNameAction(ViewDataModel model) {
        return CommonActionsFactory.getShowMetadataColumnMetadataNameAction(model, null);
    }

    public static WsAbstractToggleAction getShowMetadataColumnMetadataNameAction(ViewDataModel model, CommonActionsExceptionHandler handler) {
        return new ShowMetadataColumnMetadataNameAction(model, handler);
    }

    public static WsAbstractToggleAction getShowJDBCColumnNameAction(ViewDataJDBCModel model) {
        return CommonActionsFactory.getShowJDBCColumnNameAction(model, null);
    }

    public static WsAbstractToggleAction getShowJDBCColumnNameAction(ViewDataJDBCModel model, CommonActionsExceptionHandler handler) {
        return new ShowJDBCColumnNameAction(model, handler);
    }

    public static WsAbstractToggleAction getShowJDBCColumnLabelAction(ViewDataJDBCModel model) {
        return CommonActionsFactory.getShowJDBCColumnLabelAction(model, null);
    }

    public static WsAbstractToggleAction getShowJDBCColumnLabelAction(ViewDataJDBCModel model, CommonActionsExceptionHandler handler) {
        return new ShowJDBCColumnLabelAction(model, handler);
    }

    public static WsAbstractToggleAction getApplyMetadataFormatsAction(ViewDataModel model) {
        return CommonActionsFactory.getApplyMetadataFormatsAction(model, null);
    }

    public static WsAbstractToggleAction getApplyMetadataFormatsAction(ViewDataModel model, CommonActionsExceptionHandler handler) {
        return new ApplyMetadataFormatsAction(model, handler);
    }

    public static UndoRedoActionGroup getUndoRedoActionGroup(ViewDataUndoManager undoManager) {
        return CommonActionsFactory.getUndoRedoActionGroup(undoManager, null);
    }

    public static UndoRedoActionGroup getUndoRedoActionGroup(ViewDataUndoManager undoManager, CommonActionsExceptionHandler handler) {
        return new UndoRedoActionGroup(undoManager, handler);
    }

    public static WsAbstractAction getCopyAction(ViewDataTable table) {
        return CommonActionsFactory.getCopyAction(table, null);
    }

    public static WsAbstractAction getCopyAction(ViewDataTable table, CommonActionsExceptionHandler handler) {
        return new CopyAction(table, handler);
    }

    public static WsAbstractAction getPasteAction(ViewDataTable table) {
        return CommonActionsFactory.getPasteAction(table, null);
    }

    public static WsAbstractAction getPasteAction(ViewDataTable table, CommonActionsExceptionHandler handler) {
        return new PasteAction(table, handler);
    }

    public static WsAbstractAction getPasteSpecialAction(ViewDataTable table) {
        return CommonActionsFactory.getPasteSpecialAction(table, null);
    }

    public static WsAbstractAction getPasteSpecialAction(ViewDataTable table, CommonActionsExceptionHandler handler) {
        return new PasteSpecialAction(table, handler);
    }

    public static WsAbstractAction getCommitAction(ViewDataTable table) {
        return CommonActionsFactory.getCommitAction(table, null);
    }

    public static WsAbstractAction getCommitAction(ViewDataTable table, CommonActionsExceptionHandler handler) {
        return new CommitAction(table, handler);
    }

    public static WsAbstractAction getDeleteAction(ViewDataTable table) {
        return CommonActionsFactory.getDeleteAction(table, null);
    }

    public static WsAbstractAction getDeleteAction(ViewDataTable table, CommonActionsExceptionHandler handler) {
        return new DeleteAction(table, handler);
    }

    public static WsAbstractToggleAction getNullBrowseModeAction() {
        return new NullBrowseModeAction();
    }

    public static WsAbstractToggleAction getNullEditModeAction() {
        return new NullEditModeAction();
    }

    public static WsAbstractAction getPrintAction(ViewDataTable table) {
        return CommonActionsFactory.getPrintAction(table, null);
    }

    public static WsAbstractAction getPrintAction(ViewDataTable table, CommonActionsExceptionHandler handler) {
        return new PrintAction(table, handler);
    }

    public static WsAbstractAction getRefreshAction(ViewDataModel model) {
        return CommonActionsFactory.getRefreshAction(model, null);
    }

    public static WsAbstractAction getRefreshAction(ViewDataModel model, CommonActionsExceptionHandler handler) {
        return new RefreshAction(model, handler);
    }

    public static WsAbstractAction getViewDataMenuAction() {
        return new ViewDataMenuAction();
    }

    public static class GoToRowDelayCheckBoxOptionPane
    extends JOptionPane {
        private JCheckBox m_rememberDecision;

        public GoToRowDelayCheckBoxOptionPane() {
            this.setMessageType(2);
            this.setOptionType(0);
            this.initialize();
        }

        protected void initialize() {
            this.m_rememberDecision = new JCheckBox(bundle.getString("CommonActionsFactory.GoToRowLongRunningIgnore.txt"));
            this.setMessage(new Object[]{bundle.getString("CommonActionsFactory.GoToRowLongRunning.txt"), this.m_rememberDecision});
        }

        @Override
        public int getMaxCharactersPerLineCount() {
            return 60;
        }

        protected boolean getRememberDecision() {
            return this.m_rememberDecision.isSelected();
        }

        protected static boolean doLongRunningOperation() {
            WorkspaceFile file = Workspace.getWorkspace().getAppDefaultsFile();
            boolean prompt = file.getPropertyBoolean("ViewData.PromptForLongRunningNavigation", true);
            if (prompt) {
                GoToRowDelayCheckBoxOptionPane pane = new GoToRowDelayCheckBoxOptionPane();
                JDialog dialog = pane.createDialog((Component)Workspace.getWorkspace(), bundle.getString("CommonActionsFactory.GoToRowLongRunningTitle.txt"));
                dialog.setVisible(true);
                file.setPropertyBoolean("ViewData.PromptForLongRunningNavigation", !pane.getRememberDecision());
                Object value = pane.getValue();
                if (value != null && (Integer)value == 1) {
                    return false;
                }
            }
            return true;
        }
    }

    public static class ShowMessageExceptionHandler
    extends CommonActionsExceptionDefaultHandler {
        private String m_userMessage;

        public ShowMessageExceptionHandler() {
        }

        public ShowMessageExceptionHandler(String userMessage) {
            this.setUserMessage(userMessage);
        }

        @Override
        public void errorExecutingAction(Throwable e) {
            super.errorExecutingAction(e);
            String message = e.getMessage();
            if (this.getUserMessage() != null) {
                message = MessageFormat.format(this.getUserMessage(), e.getMessage());
            }
            this.displayMessage(message);
        }

        @Override
        public void errorExecutingAction(String key, Throwable e) {
            super.errorExecutingAction(e);
            String message = key + ":" + e.getMessage();
            if (this.getUserMessage() != null) {
                message = MessageFormat.format(this.getUserMessage(), key + ":" + e.getMessage());
            }
            this.displayMessage(message);
        }

        protected void displayMessage(String message) {
            MessageUtil.displayMessage((String)message, (int)0);
        }

        protected void setUserMessage(String userMessage) {
            this.m_userMessage = userMessage;
        }

        protected String getUserMessage() {
            return this.m_userMessage;
        }
    }

    public static abstract class ViewDataCommonActionGroup
    extends HashMap {
        public WsAbstractAction getAction(String name) {
            return (WsAbstractAction)this.get(name);
        }

        public WsAbstractToggleAction getToggleAction(String name) {
            return (WsAbstractToggleAction)this.get(name);
        }
    }

    static abstract class ViewDataCommonToggleAction
    extends WsAbstractToggleAction {
        private CommonActionsExceptionHandler m_exHandler;

        protected ViewDataCommonToggleAction(String resourceKey, CommonActionsExceptionHandler exHandler) {
            super(bundle, resourceKey, 0);
            this.m_exHandler = exHandler != null ? exHandler : SHOW_MESSAGE_HANDLER;
        }

        public CommonActionsExceptionHandler getExceptionHandler() {
            return this.m_exHandler;
        }
    }

    static abstract class ViewDataCommonAction
    extends WsAbstractAction {
        private CommonActionsExceptionHandler m_exHandler;

        protected ViewDataCommonAction(CommonActionsExceptionHandler exHandler) {
            this.m_exHandler = exHandler != null ? exHandler : DEFAULT_HANDLER;
        }

        protected ViewDataCommonAction(String resourceKey, CommonActionsExceptionHandler exHandler) {
            this(resourceKey, exHandler, 0);
        }

        protected ViewDataCommonAction(String resourceKey, CommonActionsExceptionHandler exHandler, int options) {
            super(bundle, resourceKey, options);
            this.m_exHandler = exHandler != null ? exHandler : DEFAULT_HANDLER;
        }

        public CommonActionsExceptionHandler getExceptionHandler() {
            return this.m_exHandler;
        }
    }

    public static class GoToRowExceptionHandler
    extends ShowMessageExceptionHandler {
        @Override
        public void errorExecutingAction(Throwable e) {
            if (e.getCause() != null && e.getCause() instanceof ArrayIndexOutOfBoundsException) {
                MessageUtil.displayMessage((String)bundle.getString("CommonActionsFactory.GoToRowIndexOutOfBound.txt"), (int)0);
                return;
            }
            super.errorExecutingAction(e);
        }
    }

    public static class ViewDataMenuAction
    extends WsAbstractAction {
        public ViewDataMenuAction() {
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    public static class RefreshAction
    extends ViewDataCommonAction {
        private ViewDataModel m_model;

        public RefreshAction(ViewDataModel model, CommonActionsExceptionHandler exHandler) {
            super("CommonActionsFactory.RefreshAction", exHandler);
            this.setMenuSupportId("Common:Refresh");
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Refresh"));
            this.m_model = model;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (this.m_model.isFetchDataRunning()) {
                    return;
                }
                if (this.clearQueryOptions()) {
                    this.m_model.clearQueryOptions();
                }
                this.m_model.refresh();
            }
            catch (ViewDataException ex) {
                this.getExceptionHandler().errorExecutingAction(ex);
            }
        }

        public void setEnabled(boolean bEnabled) {
            super.setEnabled(bEnabled ? bEnabled : !this.m_model.isFetchDataRunning() && this.m_model.hasDataFetchError());
        }

        protected boolean clearQueryOptions() {
            WorkspaceFile file = Workspace.getWorkspace().getAppDefaultsFile();
            boolean clearQueryOptions = false;
            if (file.getPropertyString("ViewData.RefreshClearQueryoptions") != null) {
                clearQueryOptions = file.getPropertyBoolean("ViewData.RefreshClearQueryoptions", false);
            }
            if (clearQueryOptions) {
                return true;
            }
            ClearQueryOptionsCheckBoxOptionPane pane = new ClearQueryOptionsCheckBoxOptionPane();
            JDialog dialog = pane.createDialog((Component)Workspace.getWorkspace(), bundle.getString("CommonActionsFactory.RefreshClearQueryOptionsPromptTitle.txt"));
            dialog.setVisible(true);
            file.setPropertyBoolean("ViewData.RefreshClearQueryoptions", pane.getRememberDecision());
            Object value = pane.getValue();
            return value != null && (Integer)value == 0;
        }

        class ClearQueryOptionsCheckBoxOptionPane
        extends JOptionPane {
            private JCheckBox m_rememberDecision;

            public ClearQueryOptionsCheckBoxOptionPane() {
                this.setMessageType(2);
                this.setOptionType(0);
                this.initialize();
            }

            protected void initialize() {
                this.m_rememberDecision = new JCheckBox(bundle.getString("CommonActionsFactory.RefreshAlwaysClearQueryOptionsOption.txt"));
                this.setMessage(new Object[]{bundle.getString("CommonActionsFactory.RefreshClearQueryOptionsPrompt.txt"), this.m_rememberDecision});
            }

            @Override
            public int getMaxCharactersPerLineCount() {
                return 60;
            }

            protected boolean getRememberDecision() {
                return this.m_rememberDecision.isSelected();
            }
        }
    }

    public static class PrintAction
    extends ViewDataCommonAction {
        private ViewDataTable m_table;

        public PrintAction(ViewDataTable table, CommonActionsExceptionHandler exHandler) {
            super("CommonActionsFactory.PrintAction", exHandler);
            this.setMenuSupportId("Common:Print");
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Print"));
            this.m_table = table;
        }

        public void actionPerformed(ActionEvent e) {
            WsTablePrinter printer = null;
            try {
                if (!this.m_table.getViewDataModel().isRowCountKnown()) {
                    this.m_table.getViewDataModel().gotoLastRow();
                }
                String title = bundle.formatString("CommonActionsFactory.PrintDialogTitle.fmt.txt", (Object)this.m_table.getViewDataModel().getTableDisplayName());
                printer = new WsTablePrinter((JTable)((Object)this.m_table), (PageFormat)new WsTitledPageFormat(title), false);
                PrinterJob pjob = PrinterJob.getPrinterJob();
                if (!Workspace.getWorkspace().isPrinterConnected(pjob)) {
                    return;
                }
                pjob.setJobName(title);
                pjob.setPageable((Pageable)printer);
                if (pjob.printDialog()) {
                    OpRequestUI oppDlg = new OpRequestUI((Frame)Workspace.getWorkspace(), bundle.formatString("CommonActionsFactory.PrintingProgressMessage.fmt.txt", (Object)this.m_table.getViewDataModel().getTableDisplayName()), bundle.getString("CommonActionsFactory.PrintingProgressTitle.txt"));
                    oppDlg.setDelayBeforeProgressCancelDialog(1000);
                    oppDlg.execute((Runnable)new PrintRunnable(printer, pjob));
                }
            }
            catch (SQLException ex) {
                this.getExceptionHandler().errorExecutingAction(ex);
            }
            catch (ViewDataException ex) {
                this.getExceptionHandler().errorExecutingAction(ex);
            }
        }

        class PrintRunnable
        implements Runnable {
            private PrinterJob m_job;
            private WsTablePrinter m_printer;

            PrintRunnable(WsTablePrinter printer, PrinterJob job) {
                this.m_printer = printer;
                this.m_job = job;
            }

            @Override
            public void run() {
                try {
                    this.m_job.print();
                }
                catch (PrinterException ex) {
                    PrintAction.this.getExceptionHandler().errorExecutingAction(ex);
                }
                finally {
                    this.m_printer.dispose();
                }
            }
        }
    }

    public static class NullEditModeAction
    extends ViewDataCommonToggleAction {
        public NullEditModeAction() {
            super("CommonActionsFactory.NullEditModeAction", null);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Edit"));
            this.setSelected(true);
        }

        public void actionPerformed(ActionEvent e) {
            this.setSelected(true);
        }
    }

    public static class NullBrowseModeAction
    extends ViewDataCommonToggleAction {
        public NullBrowseModeAction() {
            super("CommonActionsFactory.NullBrowseModeAction", null);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Browse"));
            this.setSelected(true);
        }

        public void actionPerformed(ActionEvent e) {
            this.setSelected(true);
        }
    }

    public static class DeleteAction
    extends ViewDataCommonAction {
        private ViewDataTable m_table;

        public DeleteAction(ViewDataTable table, CommonActionsExceptionHandler exHandler) {
            super("CommonActionsFactory.DeleteAction", exHandler);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:DeleteRows"));
            this.m_table = table;
            this.setEnabled(this.m_table.getSelectedCellCount() > 0);
            this.m_table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    this.setEnabledState();
                }
            });
            this.m_table.addViewDataTableListener(new ViewDataTableListener(){

                @Override
                public void rowUpdateStarted(int row, boolean isAppendRow) {
                    this.setEnabledState();
                }

                @Override
                public void rowUpdateEnded() {
                    this.setEnabledState();
                }

                @Override
                public void rowUpdateCancelled() {
                    this.setEnabledState();
                }
            });
        }

        public void actionPerformed(ActionEvent e) {
            this.m_table.undoableDeleteSelectedRows();
        }

        protected void setEnabledState() {
            this.setEnabled(this.m_table.getSelectedCellCount() > 0 && !this.m_table.isEditingInProgress());
        }

        public void setEnabled(boolean bEnabled) {
            super.setEnabled(this.m_table.getSelectedCellCount() > 0 && !this.m_table.isEditingInProgress());
        }
    }

    public static class CommitAction
    extends ViewDataCommonAction {
        private ViewDataTable m_table;

        public CommitAction(ViewDataTable table, CommonActionsExceptionHandler exHandler) {
            super("CommonActionsFactory.CommitAction", exHandler);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:CommitChanges"));
            this.m_table = table;
            this.setEnabled(this.m_table.getSelectedCellCount() > 0);
            this.m_table.addViewDataTableListener(new ViewDataTableListener(){

                @Override
                public void rowUpdateStarted(int row, boolean isAppendRow) {
                    this.setEnabledState();
                }

                @Override
                public void rowUpdateEnded() {
                    this.setEnabledState();
                }

                @Override
                public void rowUpdateCancelled() {
                    this.setEnabledState();
                }
            });
        }

        public void actionPerformed(ActionEvent e) {
            this.m_table.commitEditRow();
        }

        protected void setEnabledState() {
            this.setEnabled(this.m_table.isEditingInProgress());
        }

        public void setEnabled(boolean bEnabled) {
            super.setEnabled(this.m_table.isEditingInProgress());
        }
    }

    public static class PasteSpecialAction
    extends ViewDataCommonAction {
        private ViewDataTable m_table;

        public PasteSpecialAction(ViewDataTable table, CommonActionsExceptionHandler exHandler) {
            super("CommonActionsFactory.PasteSpecialAction", exHandler, 1);
            this.m_table = table;
        }

        public void actionPerformed(ActionEvent e) {
            this.m_table.onPasteSpecialData();
        }
    }

    public static class PasteAction
    extends ViewDataCommonAction {
        private ViewDataTable m_table;

        public PasteAction(ViewDataTable table, CommonActionsExceptionHandler exHandler) {
            super("CommonActionsFactory.PasteAction", exHandler);
            this.m_table = table;
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Paste"));
            this.setEnabledState();
            this.m_table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    this.setEnabledState();
                }
            });
            this.m_table.addViewDataTableListener(new ViewDataTableListener(){

                @Override
                public void rowUpdateStarted(int row, boolean isAppendRow) {
                    this.setEnabledState();
                }

                @Override
                public void rowUpdateEnded() {
                    this.setEnabledState();
                }

                @Override
                public void rowUpdateCancelled() {
                    this.setEnabledState();
                }
            });
        }

        public void actionPerformed(ActionEvent e) {
            this.m_table.paste();
        }

        protected void setEnabledState() {
            this.setEnabled(this.m_table.getSelectedCellCount() > 0 || this.m_table.isEditingInProgress());
        }

        public void setEnabled(boolean bEnabled) {
            super.setEnabled(this.m_table.getSelectedCellCount() > 0 || this.m_table.isEditingInProgress());
        }
    }

    public static class CopyAction
    extends ViewDataCommonAction {
        private ViewDataTable m_table;

        public CopyAction(ViewDataTable table, CommonActionsExceptionHandler exHandler) {
            super("CommonActionsFactory.CopyAction", exHandler);
            this.m_table = table;
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Copy"));
            this.setEnabledState();
            this.m_table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    this.setEnabledState();
                }
            });
            this.m_table.addViewDataTableListener(new ViewDataTableListener(){

                @Override
                public void rowUpdateStarted(int row, boolean isAppendRow) {
                    this.setEnabledState();
                }

                @Override
                public void rowUpdateEnded() {
                    this.setEnabledState();
                }

                @Override
                public void rowUpdateCancelled() {
                    this.setEnabledState();
                }
            });
        }

        public void actionPerformed(ActionEvent e) {
            this.m_table.copy();
        }

        protected void setEnabledState() {
            this.setEnabled(this.m_table.getSelectedCellCount() > 0 && !this.m_table.isEditingInProgress());
        }

        public void setEnabled(boolean bEnabled) {
            super.setEnabled(this.m_table.getSelectedCellCount() > 0 && !this.m_table.isEditingInProgress());
        }
    }

    public static class UndoRedoActionGroup
    extends ViewDataCommonActionGroup {
        public static final String KEY_UNDO_ACTION = "undo";
        public static final String KEY_REDO_ACTION = "redo";
        private ViewDataUndoManager m_undoManager;

        public UndoRedoActionGroup(ViewDataUndoManager undoManager, CommonActionsExceptionHandler exHandler) {
            this.m_undoManager = undoManager;
            this.put(KEY_UNDO_ACTION, new UndoAction(exHandler));
            this.put(KEY_REDO_ACTION, new RedoAction(exHandler));
            this.refreshActions();
            this.m_undoManager.addUndoManagerListener(new UndoManagerListener());
        }

        protected void onUndo() {
            this.m_undoManager.undo();
            this.m_undoManager.updateWorkspaceUIComponents(true);
            this.refreshActions();
        }

        protected void onRedo() {
            this.m_undoManager.redo();
            this.m_undoManager.updateWorkspaceUIComponents(true);
            this.refreshActions();
        }

        protected void onUndoAdded() {
            this.refreshActions();
        }

        protected void onUndoPerformed() {
            this.refreshActions();
        }

        protected void onRedoPerformed() {
            this.refreshActions();
        }

        protected void refreshActions() {
            this.getAction(KEY_UNDO_ACTION).setEnabled(this.m_undoManager.canUndo());
            this.getAction(KEY_REDO_ACTION).setEnabled(this.m_undoManager.canRedo());
        }

        class UndoManagerListener
        implements ViewDataUndoManagerListener {
            UndoManagerListener() {
            }

            @Override
            public void undoableAdded(UndoableEdit undoable) {
                UndoRedoActionGroup.this.onUndoAdded();
            }

            @Override
            public void undoPerfomed(ViewDataUndoManager manager) {
                UndoRedoActionGroup.this.onUndoPerformed();
            }

            @Override
            public void redoPerfomed(ViewDataUndoManager manager) {
                UndoRedoActionGroup.this.onRedoPerformed();
            }
        }

        class RedoAction
        extends ViewDataCommonAction {
            RedoAction(CommonActionsExceptionHandler exHandler) {
                super("CommonActionsFactory.RedoAction", exHandler);
                this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Redo"));
                this.setEnabled(UndoRedoActionGroup.this.m_undoManager.canRedo());
            }

            public void actionPerformed(ActionEvent e) {
                UndoRedoActionGroup.this.onRedo();
            }

            public void setEnabled(boolean bEnabled) {
                super.setEnabled(UndoRedoActionGroup.this.m_undoManager.canRedo());
            }
        }

        class UndoAction
        extends ViewDataCommonAction {
            UndoAction(CommonActionsExceptionHandler exHandler) {
                super("CommonActionsFactory.UndoAction", exHandler);
                this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Undo"));
                this.setEnabled(UndoRedoActionGroup.this.m_undoManager.canUndo());
            }

            public void actionPerformed(ActionEvent e) {
                UndoRedoActionGroup.this.onUndo();
            }

            public void setEnabled(boolean bEnabled) {
                super.setEnabled(UndoRedoActionGroup.this.m_undoManager.canUndo());
            }
        }
    }

    public static class ApplyMetadataFormatsAction
    extends ViewDataCommonToggleAction {
        private ViewDataModel m_model;

        public ApplyMetadataFormatsAction(ViewDataModel model, CommonActionsExceptionHandler exHandler) {
            super("CommonActionsFactory.ApplyMetadataFormatsAction", exHandler);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Format"));
            this.m_model = model;
            this.setSelected(this.m_model.isApplyFormats());
            this.setHidable(true);
            this.m_model.addViewDataModelListener(new ViewDataModelAdapter(){

                @Override
                public void fetchComplete() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.setSelected(m_model.isApplyFormats());
                        }
                    });
                }

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (!"ApplyFormats".equals(e.getPropertyName())) {
                        return;
                    }
                    this.setSelected(m_model.isApplyFormats());
                }
            });
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.m_model.setApplyFormats(!this.m_model.isApplyFormats());
                this.m_model.fetchData();
            }
            catch (ViewDataException e1) {
                this.getExceptionHandler().errorExecutingAction(e1);
            }
        }
    }

    public static class ShowJDBCColumnLabelAction
    extends ViewDataCommonToggleAction {
        private ViewDataJDBCModel m_model;

        public ShowJDBCColumnLabelAction(ViewDataJDBCModel model, CommonActionsExceptionHandler exHandler) {
            super("CommonActionsFactory.ShowJDBCColumnLabelAction", exHandler);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:ColumnDescriptions"));
            this.m_model = model;
            this.setSelected(this.m_model.getShowLabel());
            this.setHidable(true);
            this.m_model.addViewDataModelListener(new ViewDataModelAdapter(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (!"ColumnDisplayLabel".equals(e.getPropertyName())) {
                        return;
                    }
                    this.setSelected(m_model.getShowLabel());
                }
            });
        }

        public void actionPerformed(ActionEvent e) {
            this.m_model.setShowLabel(!this.m_model.getShowLabel());
            this.setSelected(this.m_model.getShowLabel());
        }
    }

    public static class ShowJDBCColumnNameAction
    extends ViewDataCommonToggleAction {
        private ViewDataJDBCModel m_model;

        public ShowJDBCColumnNameAction(ViewDataJDBCModel model, CommonActionsExceptionHandler exHandler) {
            super("CommonActionsFactory.ShowJDBCColumnNameAction", exHandler);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:ColumnNames"));
            this.m_model = model;
            this.setSelected(this.m_model.getShowColumnName());
            this.setHidable(true);
            this.m_model.addViewDataModelListener(new ViewDataModelAdapter(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (!"ColumnDisplayLabel".equals(e.getPropertyName())) {
                        return;
                    }
                    this.setSelected(m_model.getShowColumnName());
                }
            });
        }

        public void actionPerformed(ActionEvent e) {
            this.m_model.setShowColumnName(!this.m_model.getShowColumnName());
            this.setSelected(this.m_model.getShowColumnName());
        }
    }

    public static class ShowMetadataColumnMetadataNameAction
    extends ViewDataCommonToggleAction {
        private ViewDataModel m_model;

        public ShowMetadataColumnMetadataNameAction(ViewDataModel model, CommonActionsExceptionHandler exHandler) {
            super("CommonActionsFactory.ShowMetadataColumnMetadataNameAction", exHandler);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:ColumnMetadataNames"));
            this.m_model = model;
            this.setSelected(this.m_model.isShowMetadataName());
            this.setHidable(true);
            this.m_model.addViewDataModelListener(new ViewDataModelAdapter(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (!"ColumnDisplayLabel".equals(e.getPropertyName())) {
                        return;
                    }
                    this.setSelected(m_model.isShowMetadataName());
                }
            });
        }

        public void actionPerformed(ActionEvent e) {
            this.m_model.setShowMetadataName(!this.m_model.isShowMetadataName());
            this.setSelected(this.m_model.isShowMetadataName());
        }
    }

    public static class ShowMetadataColumnLabelAction
    extends ViewDataCommonToggleAction {
        private ViewDataModel m_model;

        public ShowMetadataColumnLabelAction(ViewDataModel model, CommonActionsExceptionHandler exHandler) {
            super("CommonActionsFactory.ShowMetadataColumnLabelAction", exHandler);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:ColumnDescriptions"));
            this.m_model = model;
            this.setSelected(this.m_model.isShowLabel());
            this.setHidable(true);
            this.m_model.addViewDataModelListener(new ViewDataModelAdapter(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (!"ColumnDisplayLabel".equals(e.getPropertyName())) {
                        return;
                    }
                    this.setSelected(m_model.isShowLabel());
                }
            });
        }

        public void actionPerformed(ActionEvent e) {
            this.m_model.setShowLabel(!this.m_model.isShowLabel());
            this.setSelected(this.m_model.isShowLabel());
        }
    }

    public static class ShowMetadataColumnNameAction
    extends ViewDataCommonToggleAction {
        private ViewDataModel m_model;

        public ShowMetadataColumnNameAction(ViewDataModel model, CommonActionsExceptionHandler exHandler) {
            super("CommonActionsFactory.ShowMetadataColumnNameAction", exHandler);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:ColumnNames"));
            this.m_model = model;
            this.setSelected(this.m_model.isShowColumnName());
            this.setHidable(true);
            this.m_model.addViewDataModelListener(new ViewDataModelAdapter(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (!"ColumnDisplayLabel".equals(e.getPropertyName())) {
                        return;
                    }
                    this.setSelected(m_model.isShowColumnName());
                }
            });
        }

        public void actionPerformed(ActionEvent e) {
            this.m_model.setShowColumnName(!this.m_model.isShowColumnName());
            this.setSelected(this.m_model.isShowColumnName());
        }
    }

    public static class ShowSubsetScreenAction
    extends ViewDataCommonToggleAction {
        private QueryOptionsDialog m_queryOptions;

        public ShowSubsetScreenAction(QueryOptionsDialog queryOptions, CommonActionsExceptionHandler exHandler) {
            super("CommonActionsFactory.ShowSubsetScreenAction", exHandler);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:SubsetColumns"));
            this.m_queryOptions = queryOptions;
            this.setHidable(true);
            this.m_queryOptions.getModel().addViewDataModelListener(new ViewDataModelAdapter(){

                @Override
                public void fetchComplete() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.setSelected(m_queryOptions.getModel().hasSubsetClause());
                        }
                    });
                }
            });
        }

        public void actionPerformed(ActionEvent e) {
            this.setSelected(this.m_queryOptions.getModel().hasSubsetClause());
            this.m_queryOptions.show(QueryOptionsDialog.QueryOption.OPTION_SUBSET);
        }
    }

    public static class ShowFilterScreenAction
    extends ViewDataCommonToggleAction {
        private QueryOptionsDialog m_queryOptions;

        public ShowFilterScreenAction(QueryOptionsDialog queryOptions, CommonActionsExceptionHandler exHandler) {
            super("CommonActionsFactory.ShowFilterScreenAction", exHandler);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Filter"));
            this.m_queryOptions = queryOptions;
            this.setHidable(true);
            this.m_queryOptions.getModel().addViewDataModelListener(new ViewDataModelAdapter(){

                @Override
                public void fetchComplete() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.setSelected(m_queryOptions.getModel().hasFilter());
                        }
                    });
                }
            });
        }

        public void actionPerformed(ActionEvent e) {
            this.setSelected(this.m_queryOptions.getModel().hasFilter());
            this.m_queryOptions.show(QueryOptionsDialog.QueryOption.OPTION_FILTER);
        }
    }

    public static class ShowSortScreenAction
    extends ViewDataCommonToggleAction {
        private QueryOptionsDialog m_queryOptions;

        public ShowSortScreenAction(QueryOptionsDialog queryOptions, CommonActionsExceptionHandler exHandler) {
            super("CommonActionsFactory.ShowSortScreenAction", exHandler);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Sort"));
            this.m_queryOptions = queryOptions;
            this.setHidable(true);
            this.m_queryOptions.getModel().addViewDataModelListener(new ViewDataModelAdapter(){

                @Override
                public void fetchComplete() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.setSelected(m_queryOptions.getModel().hasSortColumns());
                        }
                    });
                }
            });
        }

        public void actionPerformed(ActionEvent e) {
            this.setSelected(this.m_queryOptions.getModel().hasSortColumns());
            this.m_queryOptions.show(QueryOptionsDialog.QueryOption.OPTION_SORT);
        }
    }

    public static class ShowSearchScreenAction
    extends ViewDataCommonToggleAction {
        private SearchToolArea m_search;

        public ShowSearchScreenAction(SearchToolArea search, CommonActionsExceptionHandler exHandler) {
            super("CommonActionsFactory.ShowSearchScreenAction", exHandler);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Find"));
            this.m_search = search;
        }

        public void actionPerformed(ActionEvent e) {
            this.m_search.setVisible(!this.m_search.isVisible());
            this.m_search.revalidate();
            this.m_search.repaint();
        }
    }

    public static class GoToLastRowAction
    extends ViewDataCommonAction {
        private ViewDataTable m_table;

        public GoToLastRowAction(ViewDataTable table, CommonActionsExceptionHandler exHandler) {
            super("CommonActionsFactory.GoToLastRowAction", exHandler);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:LastRow"));
            this.m_table = table;
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            int curRow = this.m_table.rowAtPoint(this.m_table.getViewPosition());
            curRow = curRow < 0 ? 0 : curRow;
            int destRow = 0;
            destRow = this.m_table.getViewDataModel().isRowCountKnown() ? this.m_table.getRowCount() : this.m_table.getViewDataModel().getRowCount();
            ViewDataModel model = (ViewDataModel)((Object)this.m_table.getModel());
            boolean needDialog = model.getRSAbsoluteEstimator().needLongRunningDialog(curRow, destRow);
            if (needDialog && !GoToRowDelayCheckBoxOptionPane.doLongRunningOperation()) {
                return;
            }
            boolean needNewThread = model.getRSAbsoluteEstimator().needNewThread(curRow, destRow);
            if (needNewThread) {
                ViewDataScrollPane.ViewDataScrollPaneViewPort viewPort = (ViewDataScrollPane.ViewDataScrollPaneViewPort)this.m_table.getParent();
                ViewDataPanel vdp = (ViewDataPanel)((Object)viewPort.getParent().getParent());
                vdp.setEnabled(false);
                model.setFetchDataRunning(true);
                vdp.updateTitle();
                RSCursorMover runnable = new RSCursorMover(curRow, destRow, model){

                    @Override
                    protected void runInEventDispatchThread() {
                        ViewDataModel model = (ViewDataModel)((Object)m_table.getModel());
                        model.setFetchDataRunning(false);
                        m_table.gotoCurrentLastRow();
                        ViewDataScrollPane.ViewDataScrollPaneViewPort viewPort = (ViewDataScrollPane.ViewDataScrollPaneViewPort)m_table.getParent();
                        ViewDataPanel vdp = (ViewDataPanel)((Object)viewPort.getParent().getParent());
                        vdp.setEnabled(true);
                        vdp.updateTitle();
                    }
                };
                Thread thread = new Thread(runnable);
                thread.start();
            } else {
                model.getRSAbsoluteEstimator().UpdateAbsolutingRSTime(curRow, destRow);
                this.m_table.gotoCurrentLastRow();
            }
        }
    }

    public static class GoToFirstRowAction
    extends ViewDataCommonAction {
        private ViewDataTable m_table;

        public GoToFirstRowAction(ViewDataTable table, CommonActionsExceptionHandler exHandler) {
            super("CommonActionsFactory.GoToFirstRowAction", exHandler);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:FirstRow"));
            this.m_table = table;
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            int destRow = 1;
            int curRow = this.m_table.rowAtPoint(this.m_table.getViewPosition());
            curRow = curRow < 0 ? 0 : curRow;
            ViewDataModel model = (ViewDataModel)((Object)this.m_table.getModel());
            boolean needDialog = model.getRSAbsoluteEstimator().needLongRunningDialog(++curRow, destRow);
            if (needDialog && !GoToRowDelayCheckBoxOptionPane.doLongRunningOperation()) {
                return;
            }
            boolean needNewThread = model.getRSAbsoluteEstimator().needNewThread(curRow, destRow);
            if (needNewThread) {
                ViewDataScrollPane.ViewDataScrollPaneViewPort viewPort = (ViewDataScrollPane.ViewDataScrollPaneViewPort)this.m_table.getParent();
                ViewDataPanel vdp = (ViewDataPanel)((Object)viewPort.getParent().getParent());
                vdp.setEnabled(false);
                model.setFetchDataRunning(true);
                vdp.updateTitle();
                RSCursorMover runnable = new RSCursorMover(curRow, destRow, model){

                    @Override
                    protected void runInEventDispatchThread() {
                        ViewDataModel model = (ViewDataModel)((Object)m_table.getModel());
                        model.setFetchDataRunning(false);
                        int destRow = this.getDestRow();
                        this.gotoRow(destRow);
                        ViewDataScrollPane.ViewDataScrollPaneViewPort viewPort = (ViewDataScrollPane.ViewDataScrollPaneViewPort)m_table.getParent();
                        ViewDataPanel vdp = (ViewDataPanel)((Object)viewPort.getParent().getParent());
                        vdp.setEnabled(true);
                        vdp.updateTitle();
                    }
                };
                Thread thread = new Thread(runnable);
                thread.start();
            } else {
                model.getRSAbsoluteEstimator().UpdateAbsolutingRSTime(curRow, destRow);
                this.gotoRow(destRow);
            }
        }

        private void gotoRow(int gotoRow) {
            try {
                this.m_table.gotoRow(gotoRow - 1);
            }
            catch (SQLException e1) {
                this.getExceptionHandler().errorExecutingAction(e1);
            }
            catch (ViewDataException e1) {
                this.getExceptionHandler().errorExecutingAction(e1);
            }
        }
    }

    public static class GoToRowPanel
    extends JToolBar {
        private ViewDataTable m_table;
        private JTextField m_txtStartingRow;
        private JButton m_btnGoToRow;
        private GoToRowAction m_actGoToRow;

        public GoToRowPanel(ViewDataTable table, CommonActionsExceptionHandler exHandler) {
            this.m_table = table;
            this.setRollover(true);
            this.setFloatable(false);
            this.m_actGoToRow = new GoToRowAction(exHandler);
            this.initialize();
            this.layoutWidgets();
        }

        protected void initialize() {
            this.m_txtStartingRow = new WAIntTextField(false);
            this.m_txtStartingRow.setColumns(5);
            this.m_txtStartingRow.setBorder(new LineBorder(SystemColor.controlDkShadow, 1));
            this.m_txtStartingRow.setMinimumSize(new Dimension(40, 0));
            this.m_txtStartingRow.setMaximumSize(new Dimension(40, 22));
            this.m_txtStartingRow.setPreferredSize(new Dimension(40, 22));
            this.m_txtStartingRow.setAction((Action)((Object)this.m_actGoToRow));
            this.m_btnGoToRow = WsUIUtilities.createFlatTextButton((WsAbstractAction)this.m_actGoToRow);
        }

        protected void layoutWidgets() {
            JLabel lblGoToRow = new JLabel(bundle.getString("CommonActionsFactory.GoToRowLabel.txt"));
            lblGoToRow.setLabelFor(this.m_txtStartingRow);
            lblGoToRow.setDisplayedMnemonic(bundle.getString("CommonActionsFactory.GoToRowLabel.mnem").charAt(0));
            Dimension space = new Dimension(4, 10);
            this.setLayout(new BoxLayout(this, 2));
            this.add(Box.createRigidArea(space));
            this.add(lblGoToRow);
            this.add(Box.createRigidArea(space));
            this.add(this.m_txtStartingRow);
            this.add(Box.createRigidArea(space));
            this.add(this.m_btnGoToRow);
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.m_txtStartingRow.setEnabled(enabled);
            this.m_btnGoToRow.setEnabled(enabled);
        }

        class GoToRowAction
        extends ViewDataCommonAction {
            GoToRowAction(CommonActionsExceptionHandler exHandler) {
                super("CommonActionsFactory.GoToRowAction", exHandler, 0);
            }

            public void actionPerformed(ActionEvent e) {
                try {
                    int rowCount = GoToRowPanel.this.m_table.getRowCount();
                    int destRow = new Integer(GoToRowPanel.this.m_txtStartingRow.getText());
                    int n = destRow = destRow == 0 ? 1 : destRow;
                    if (destRow <= rowCount) {
                        int curRow = GoToRowPanel.this.m_table.rowAtPoint(GoToRowPanel.this.m_table.getViewPosition());
                        curRow = curRow < 0 ? 0 : curRow;
                        ViewDataModel model = (ViewDataModel)((Object)GoToRowPanel.this.m_table.getModel());
                        boolean needDialog = model.getRSAbsoluteEstimator().needLongRunningDialog(++curRow, destRow);
                        if (needDialog && !GoToRowDelayCheckBoxOptionPane.doLongRunningOperation()) {
                            return;
                        }
                        boolean needNewThread = model.getRSAbsoluteEstimator().needNewThread(curRow, destRow);
                        if (needNewThread) {
                            ViewDataScrollPane.ViewDataScrollPaneViewPort viewPort = (ViewDataScrollPane.ViewDataScrollPaneViewPort)GoToRowPanel.this.m_table.getParent();
                            ViewDataPanel vdp = (ViewDataPanel)((Object)viewPort.getParent().getParent());
                            vdp.setEnabled(false);
                            model.setFetchDataRunning(true);
                            vdp.updateTitle();
                            RSCursorMover runnable = new RSCursorMover(curRow, destRow, model){

                                @Override
                                protected void runInEventDispatchThread() {
                                    ViewDataModel model = (ViewDataModel)((Object)GoToRowPanel.this.m_table.getModel());
                                    model.setFetchDataRunning(false);
                                    int destRow = this.getDestRow();
                                    GoToRowAction.this.gotoRow(destRow);
                                    ViewDataScrollPane.ViewDataScrollPaneViewPort viewPort = (ViewDataScrollPane.ViewDataScrollPaneViewPort)GoToRowPanel.this.m_table.getParent();
                                    ViewDataPanel vdp = (ViewDataPanel)((Object)viewPort.getParent().getParent());
                                    vdp.setEnabled(true);
                                    vdp.updateTitle();
                                }
                            };
                            Thread thread = new Thread(runnable);
                            thread.start();
                        } else {
                            model.getRSAbsoluteEstimator().UpdateAbsolutingRSTime(curRow, destRow);
                            this.gotoRow(destRow);
                        }
                    } else {
                        this.gotoRow(destRow);
                    }
                }
                catch (NumberFormatException e1) {
                    MessageUtil.displayMessage((String)bundle.getString("CommonActionsFactory.GoToRowInvalidRowNumber.txt"), (int)0);
                }
            }

            private void gotoRow(int gotoRow) {
                try {
                    GoToRowPanel.this.m_table.gotoRow(gotoRow - 1);
                }
                catch (SQLException e1) {
                    this.getExceptionHandler().errorExecutingAction(e1);
                }
                catch (ViewDataException e1) {
                    this.getExceptionHandler().errorExecutingAction(e1);
                }
            }
        }
    }
}

