/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2;

import com.sas.metadata.remote.MdException;
import com.sas.wadmin.viewdata2.ViewDataModel;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import java.rmi.RemoteException;

public class ColumnDisplayLabelHelper {
    private boolean m_showColumnName;
    private boolean m_showLabel;
    private boolean m_showMetadataName;
    private ViewDataModel m_viewDataModel;

    public ColumnDisplayLabelHelper(ViewDataModel viewDataModel) {
        this.m_viewDataModel = viewDataModel;
        this.init();
    }

    private void init() {
        WorkspaceFile file = Workspace.getWorkspace().getAppDefaultsFile();
        this.m_showMetadataName = file.getPropertyBoolean("ViewData.ShowMetadataNameInColumnHeader", false);
        this.m_showColumnName = file.getPropertyBoolean("ViewData.ShowColumnNameInColumnHeader", true);
        this.m_showLabel = file.getPropertyBoolean("ViewData.ShowDescriptionInColumnHeader", false);
    }

    public void setShowColumnName(boolean show) {
        if (this.m_showColumnName == show) {
            return;
        }
        this.m_showColumnName = show;
        this.m_viewDataModel.firePropertyChanged("ColumnDisplayLabel", new Boolean(!this.m_showColumnName), new Boolean(this.m_showColumnName));
    }

    public void setShowLabel(boolean show) {
        if (this.m_showLabel == show) {
            return;
        }
        this.m_showLabel = show;
        this.m_viewDataModel.firePropertyChanged("ColumnDisplayLabel", new Boolean(!this.m_showLabel), new Boolean(this.m_showLabel));
    }

    public void setShowMetadataName(boolean show) {
        if (this.m_showMetadataName == show) {
            return;
        }
        this.m_showMetadataName = show;
        this.m_viewDataModel.firePropertyChanged("ColumnDisplayLabel", new Boolean(!this.m_showMetadataName), new Boolean(this.m_showMetadataName));
    }

    public boolean getShowColumnName() {
        return this.m_showColumnName;
    }

    public boolean getShowLabel() {
        return this.m_showLabel;
    }

    public boolean getShowMetadataName() {
        return this.m_showMetadataName;
    }

    public String getColumnDisplayName(int column) throws MdException, RemoteException {
        String name = this.m_viewDataModel.getTrueColumnName(column);
        String label = this.m_viewDataModel.getTrueColumnDescription(column);
        String mdname = this.m_viewDataModel.getTrueColumnObjectName(column);
        if (this.m_showColumnName) {
            if (this.m_showLabel) {
                if (this.m_showMetadataName) {
                    return this.getFormattedLabel(name, label, mdname);
                }
                return this.getFormattedLabel(name, label);
            }
            if (this.m_showMetadataName) {
                return this.getFormattedLabel(name, mdname);
            }
            return name;
        }
        if (this.m_showLabel) {
            if (this.m_showMetadataName) {
                return this.getFormattedLabel(label, mdname);
            }
            return label != null && !"".equals(label) ? label : name;
        }
        if (this.m_showMetadataName) {
            return mdname;
        }
        return name;
    }

    private String getFormattedLabel(String s1, String s2) {
        return s1 + " (" + s2 + ")";
    }

    private String getFormattedLabel(String s1, String s2, String s3) {
        return s1 + " (" + s2 + ": " + s3 + ")";
    }
}

