/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata;

import com.sas.metadata.remote.Column;
import com.sas.wadmin.viewdata.ColumnDisplayLabelHelper;
import com.sas.wadmin.viewdata.ViewDataFindComparable;
import com.sas.wadmin.viewdata.ViewDataFindPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

public class ViewDataFindDialog
extends WAStandardDialog {
    private static WAdminResource bundle = WAdminResource.getBundle(ViewDataFindDialog.class);
    private List m_columns;
    private ViewDataFindPanel m_findPanel;
    private ArrayList m_findActionListeners;
    private ColumnDisplayLabelHelper m_labelHelper;

    public ViewDataFindDialog(String tableName, List columns, ColumnDisplayLabelHelper labelHelper) {
        super((Frame)Workspace.getWorkspace(), bundle.formatString("ViewDataFindDialog.Title.fmt.txt", (Object)tableName), false);
        this.m_columns = columns;
        this.m_labelHelper = labelHelper;
        this.m_findActionListeners = new ArrayList();
        this.initialize();
    }

    protected void initialize() {
        super.initialize();
        this.setOKButtonVisible(true);
        this.setApplyButtonVisible(false);
        this.setCancelButtonVisible(true);
        this.setHelpButtonVisible(true);
        this.m_btnOk.setText(bundle.getString("ViewDataFindDialog.Find.txt"));
        this.m_btnOk.setMnemonic(bundle.getString("ViewDataFindDialog.Find.mnem").charAt(0));
        this.m_btnCancel.setMnemonic(bundle.getString("ViewDataFindDialog.Cancel.mnem").charAt(0));
        this.m_findPanel = new ViewDataFindPanel(this.m_columns, this.m_labelHelper);
        this.m_findPanel.moveDataToView();
        this.setMainPanel(this.m_findPanel);
    }

    protected boolean onOK() {
        this.m_findPanel.moveDataToStore();
        this.notifyFindActionListeners(null);
        return false;
    }

    protected boolean onCancel() {
        this.setVisible(false);
        return false;
    }

    public void setSearchString(String searchString) {
        this.m_findPanel.setSearchString(searchString);
    }

    public boolean hasFindCondition() {
        return this.m_findPanel.hasFindCondition();
    }

    public ViewDataFindComparable getFindComparable() {
        return this.m_findPanel.getFindComparable();
    }

    public Column[] getSelectedColumns() {
        return this.m_findPanel.getSelectedColumns();
    }

    public boolean isForwardSearch() {
        return this.m_findPanel.isForwardSearch();
    }

    public void addFindActionListener(ActionListener listener) {
        this.m_findActionListeners.add(listener);
    }

    public void removeFindActionListener(ActionListener listener) {
        this.m_findActionListeners.remove(listener);
    }

    public void notifyFindActionListeners(ActionEvent e) {
        for (int i = 0; i < this.m_findActionListeners.size(); ++i) {
            ((ActionListener)this.m_findActionListeners.get(i)).actionPerformed(e);
        }
    }
}

