/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AttributeProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerContext;
import com.sas.rio.MVAResultSet;
import com.sas.table.StaticRowLabelInterface;
import com.sas.wadmin.viewdata.ColumnDisplayLabelHelper;
import com.sas.wadmin.viewdata.JDBCTableModelException;
import com.sas.wadmin.viewdata.JDBCTableModelListener;
import com.sas.wadmin.visuals.ParametersModel;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsIntegerTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public abstract class JDBCTableModel
extends WsAbstractTableModel
implements StaticRowLabelInterface {
    private static final int PAGE_WITHIN_BOUND = 0;
    private static final int PAGE_OUT_OF_BOUND = 1;
    private static final int PAGE_BOUND_INDETERMINATE = -1;
    protected static final int COLUMN_DISPLAY_WIDTH = 150;
    private static final int PREFERRED_PAGE_SIZE = 100;
    public static final String SASCOLUMNTYPE_CHARACTER = "C";
    public static final String SASCOLUMNTYPE_NUMERIC = "N";
    public static final int SEARCH_DIRECTION_UP = 1;
    public static final int SEARCH_DIRECTION_DOWN = 2;
    public static final int ROW_COUNT_UNKNOWN = -1;
    private static WAdminResource bundle = WAdminResource.getBundle(JDBCTableModel.class);
    private DataTable m_dataTable;
    private boolean m_isParameterized;
    private List m_columnMetadataList;
    private ColumnDisplayLabelHelper m_labelHelper;
    private int[] m_sortColumns;
    private int[] m_sortDirections;
    private String m_whereClause;
    private int[] m_displayColumns;
    private WsAppServer m_appServer;
    private MVAResultSet m_resultSet;
    private boolean m_fetchDataRunning = false;
    private ArrayList m_dataFetchListeners;
    private boolean m_applyFormats = true;
    private int m_cachedPageCount = 2;
    private int m_currentPageNumber = 0;
    private int m_currentMaxPageNumber = -1;
    private int m_lastPageNumber = -1;
    private int m_currentPageSize = -1;
    private boolean m_alwaysContinueSearch = false;

    protected JDBCTableModel(DataTable table) {
        this.resetColumnDetails();
        this.m_dataTable = table;
        this.m_dataFetchListeners = new ArrayList();
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        this.m_columnMetadataList = this.getDataTable().getColumns();
        this.setStorePopulated(true);
    }

    public void constructModel() throws JDBCTableModelException {
        this.removeAllColumns();
        try {
            this.moveDataToModel();
        }
        catch (MdException mde) {
            throw new JDBCTableModelException(mde);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void moveDataToModel() throws MdException, RemoteException {
        this.setParameterized(this.checkIfParameterized());
        this.createTableColumns();
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public void clear() {
        this.m_currentPageNumber = 0;
        this.m_currentMaxPageNumber = -1;
        this.m_lastPageNumber = -1;
        this.fireTableRowsDeleted(0, this.m_currentPageSize - 1);
        this.m_currentPageSize = -1;
    }

    public void close() {
        this.removeAllColumns();
        this.removeAllModelListeners();
    }

    protected boolean checkIfParameterized() throws MdException, RemoteException {
        return this.getParameterizedMacroDeclaration() != null;
    }

    protected String getParameterizedMacroDeclaration() throws MdException, RemoteException {
        StringBuffer buffer = new ParametersModel((Root)this.getDataTable()).getParameterMacroCode();
        if (buffer == null) {
            return null;
        }
        return buffer.toString();
    }

    protected void setColumnMetadataList(List columnMetadataList) {
        this.m_columnMetadataList = columnMetadataList;
    }

    private void createTableColumns() throws MdException, RemoteException {
        this.clear();
        int nColumns = this.getColumnMetadata().size();
        if (nColumns == 0) {
            if (this.m_aColumns.length != 0) {
                this.removeAllColumns();
            }
            throw new MdException(bundle.getString("JDBCTableModel.NoColumns.txt"));
        }
        this.m_aColumns = new WsAbstractTableColumn[this.getDisplayColumns().length];
        for (int i = 0; i < this.getDisplayColumns().length; ++i) {
            String label = this.getColumnDisplayName(this.getDisplayColumns()[i]);
            String type = this.getColumnType(this.getDisplayColumns()[i]);
            this.m_aColumns[i] = type.equals(SASCOLUMNTYPE_CHARACTER) ? new WsStringTableColumn(i, label, 150) : new WsIntegerTableColumn(i, label, 150);
        }
        this.fireTableStructureChanged();
    }

    protected void removeAllColumns() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                JDBCTableModel.this.clear();
                JDBCTableModel.this.resetColumnDetails();
                JDBCTableModel.this.fireTableStructureChanged();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InterruptedException e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            }
        }
    }

    private void resetColumnDetails() {
        this.m_aColumns = new WsAbstractTableColumn[0];
        this.m_sortColumns = null;
        this.resetQueryOptions();
    }

    protected List getColumnMetadata() {
        return this.m_columnMetadataList;
    }

    protected Column getColumnMetadata(int col) {
        return (Column)this.getColumnMetadata().get(col);
    }

    protected int getColumnIndex(Column col) {
        try {
            List colList = this.getColumnMetadata();
            for (int i = 0; i < colList.size(); ++i) {
                if (!((Column)colList.get(i)).getFQID().equals(col.getFQID())) continue;
                return i;
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        return -1;
    }

    public void setSortedColumns(int[] sortColumns, int[] sortDirections) {
        if (sortColumns.length != sortDirections.length) {
            throw new IllegalArgumentException("Sorted columns and sort orders donot correspond.");
        }
        this.m_sortColumns = sortColumns;
        this.m_sortDirections = sortDirections;
    }

    public int[] getSortedColumns() {
        return this.m_sortColumns;
    }

    public int[] getSortedColumnOrder() {
        return this.m_sortDirections;
    }

    public void clearSortColumns() {
        this.m_sortColumns = null;
        this.m_sortDirections = null;
    }

    public String getWhereClause() {
        return this.m_whereClause;
    }

    public void setWhereClause(String whereClause) {
        this.m_whereClause = whereClause;
    }

    public void clearWhereClause() {
        this.setWhereClause(null);
    }

    public int[] getDisplayColumns() {
        if (this.m_displayColumns == null || this.m_displayColumns.length == 0) {
            this.setDisplayColumnsAll();
        }
        return this.m_displayColumns;
    }

    public void setDisplayColumns(int[] displayColumns) {
        if (displayColumns == null || displayColumns.length == 0 && this.m_aColumns.length != 0) {
            this.setDisplayColumnsAll();
        } else {
            this.m_displayColumns = displayColumns;
        }
    }

    protected void setDisplayColumnsAll() {
        this.m_displayColumns = new int[this.m_columnMetadataList.size()];
        for (int i = 0; i < this.m_displayColumns.length; ++i) {
            this.m_displayColumns[i] = i;
        }
    }

    public int getColumnDisplayIndex(int modelIndex) {
        int[] displayCols = this.getDisplayColumns();
        for (int i = 0; i < displayCols.length; ++i) {
            if (displayCols[i] != modelIndex) continue;
            return i;
        }
        return -1;
    }

    public void resetDisplayColumns() {
        this.setDisplayColumnsAll();
    }

    protected void resetQueryOptions() {
        this.m_sortDirections = null;
        this.m_whereClause = null;
        this.m_displayColumns = null;
    }

    public void setColumnDisplayLabelHelper(ColumnDisplayLabelHelper lblHelper) {
        this.m_labelHelper = lblHelper;
    }

    protected String getColumnDisplayName(int index) {
        Column column = this.getColumnMetadata(index);
        return this.getColumnDisplayName(column);
    }

    protected String getColumnDisplayName(Column column) {
        try {
            if (this.m_labelHelper != null) {
                return this.m_labelHelper.getColumnDisplayName(column);
            }
            String description = column.getDesc();
            String label = description == null || "".equals(description.trim()) ? column.getSASColumnName() : description;
            return label;
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
            return "";
        }
    }

    public String getColumnType(int index) {
        try {
            return this.getColumnMetadata(index).getSASColumnType();
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
            return "";
        }
    }

    public void fetchData() throws JDBCTableModelException {
        this.verifyFetchDataRunning();
        this.clear();
        Runnable dataFetchRunnable = this.getDataFetchRunnable();
        Thread dataFetchThread = new Thread(dataFetchRunnable);
        this.fireFetchStarted();
        dataFetchThread.start();
    }

    protected abstract Runnable getDataFetchRunnable() throws JDBCTableModelException;

    protected int getFetchSize() {
        return this.getPreferredPageSize() * (this.m_cachedPageCount + 1);
    }

    public boolean getApplyFormats() {
        return this.m_applyFormats;
    }

    public void setApplyFormats(boolean applyFormats) throws JDBCTableModelException {
        this.verifyFetchDataRunning();
        if (this.m_applyFormats == applyFormats) {
            return;
        }
        this.m_applyFormats = applyFormats;
        this.firePropertyChanged("CONNECTION_PROPERTY_APPLY_FORMATS", !this.m_applyFormats, this.m_applyFormats);
    }

    public abstract int getTotalRowCount();

    private void setFetchDataRunning(boolean running) {
        this.m_fetchDataRunning = running;
    }

    public boolean isFetchDataRunning() {
        return this.m_fetchDataRunning;
    }

    private void verifyFetchDataRunning() throws JDBCTableModelException {
        if (this.isFetchDataRunning()) {
            throw new JDBCTableModelException(bundle.getString("JDBCTableModel.FetchDataAlreadyRunning.txt"));
        }
    }

    public Object getValueAt(int row, int col) {
        if (this.isFetchDataRunning()) {
            return null;
        }
        if (row + 1 > this.getCurrentPageSize()) {
            return null;
        }
        int absrow = row + 1 + (this.getCurrentPageNumber() - 1) * this.getPreferredPageSize();
        try {
            if (this.getResultSet().absolute(absrow)) {
                return this.getResultSet().getObject(col + 1);
            }
        }
        catch (SQLException e) {
            Workspace.getDefaultLogger().warn((Object)e.getMessage());
        }
        return null;
    }

    public int[] find(Comparable c, int[] columns) throws JDBCTableModelException, SQLException {
        return this.find(c, columns, 2);
    }

    public int[] find(Comparable c, int[] columns, int direction) throws JDBCTableModelException, SQLException {
        int startRow;
        int n = startRow = direction == 2 ? this.getRowRange()[0] - 1 : this.getRowRange()[1] - 1;
        if (startRow >= 0) {
            return this.find(c, columns, direction, startRow, columns[0]);
        }
        return new int[]{-1, -1};
    }

    public int[] find(Comparable c, int[] columns, int direction, int startRow, int startCol) throws JDBCTableModelException, SQLException {
        return this.find(c, columns, direction, startRow, startCol, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] find(Comparable c, int[] columns, int direction, int startRow, int startCol, boolean include) throws JDBCTableModelException, SQLException {
        int i;
        this.verifyFetchDataRunning();
        int startColIndex = -1;
        for (int i2 = 0; i2 < columns.length; ++i2) {
            if (columns[i2] != startCol) continue;
            startColIndex = i2;
            break;
        }
        if (startColIndex == -1) {
            return new int[]{-1, -1};
        }
        if (!include) {
            if (direction == 2) {
                if (startColIndex == columns.length - 1) {
                    startColIndex = 0;
                    ++startRow;
                } else {
                    ++startColIndex;
                }
            } else if (startColIndex == 0) {
                startColIndex = columns.length - 1;
                if (--startRow < 0) {
                    return new int[]{-1, -1};
                }
            } else {
                --startColIndex;
            }
        }
        class SearchTimerTask
        extends TimerTask {
            boolean areYouSure = false;

            SearchTimerTask() {
            }

            @Override
            public void run() {
                this.areYouSure = true;
                this.cancel();
            }
        }
        SearchTimerTask task = new SearchTimerTask();
        Timer timer = new Timer(true);
        timer.schedule((TimerTask)task, new Date(System.currentTimeMillis() + 20000L));
        boolean confirmed = false;
        boolean[] charCols = new boolean[columns.length];
        for (i = 0; i < columns.length; ++i) {
            charCols[i] = SASCOLUMNTYPE_CHARACTER.equals(this.getColumnType(columns[i]));
        }
        try {
            while (this.getResultSet().absolute(startRow + 1)) {
                Object value;
                if (direction == 2) {
                    for (i = startColIndex; i < columns.length; ++i) {
                        if (task.areYouSure && !confirmed) {
                            if (!this.confirmSearchContinue()) {
                                int[] nArray = new int[]{-1, -1};
                                return nArray;
                            }
                            confirmed = true;
                        }
                        if (c.compareTo((value = this.getResultSet().getString(columns[i] + 1)) == null || charCols[i] ? value : ((String)value).trim()) != 0) continue;
                        int[] nArray = new int[]{startRow, columns[i]};
                        return nArray;
                    }
                    ++startRow;
                    startColIndex = 0;
                    continue;
                }
                for (i = startColIndex; i >= 0; --i) {
                    if (task.areYouSure && !confirmed) {
                        if (!this.confirmSearchContinue()) {
                            value = new int[]{-1, -1};
                            return value;
                        }
                        confirmed = true;
                    }
                    if (c.compareTo((value = this.getResultSet().getString(columns[i] + 1)) == null || charCols[i] ? value : ((String)value).trim()) != 0) continue;
                    int[] nArray = new int[]{startRow, columns[i]};
                    return nArray;
                }
                if (--startRow < 0) {
                    break;
                }
                startColIndex = columns.length - 1;
            }
        }
        finally {
            task.cancel();
            timer.cancel();
        }
        return new int[]{-1, -1};
    }

    private boolean confirmSearchContinue() {
        if (this.m_alwaysContinueSearch) {
            return true;
        }
        class SearchConfirmRunnable
        implements Runnable {
            int m_option = 0;
            boolean m_alwaysContinue = true;

            SearchConfirmRunnable() {
            }

            @Override
            public void run() {
                JCheckBox checkBox = new JCheckBox(bundle.getString("JDBCTableModel.AlwaysContinueSearch.txt"));
                this.m_option = JOptionPane.showConfirmDialog((Component)Workspace.getWorkspace(), new Object[]{bundle.getString("JDBCTableModel.ContinueSearch.txt"), checkBox}, bundle.getString("JDBCTableModel.ConfirmSearch.txt"), 0);
                this.m_alwaysContinue = checkBox.isSelected();
            }
        }
        SearchConfirmRunnable runnable = new SearchConfirmRunnable();
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        this.m_alwaysContinueSearch = runnable.m_alwaysContinue;
        return runnable.m_option == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(JDBCTableModelListener listener) {
        ArrayList arrayList = this.m_dataFetchListeners;
        synchronized (arrayList) {
            this.m_dataFetchListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(JDBCTableModelListener listener) {
        ArrayList arrayList = this.m_dataFetchListeners;
        synchronized (arrayList) {
            this.m_dataFetchListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllModelListeners() {
        ArrayList arrayList = this.m_dataFetchListeners;
        synchronized (arrayList) {
            this.m_dataFetchListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firePropertyChanged(String name, Object oldValue, Object newValue) {
        ArrayList arrayList = this.m_dataFetchListeners;
        synchronized (arrayList) {
            for (JDBCTableModelListener listener : this.m_dataFetchListeners) {
                listener.propertyChange(new PropertyChangeEvent((Object)this, name, oldValue, newValue));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireColumnMetadataChanged() {
        ArrayList arrayList = this.m_dataFetchListeners;
        synchronized (arrayList) {
            for (JDBCTableModelListener listener : this.m_dataFetchListeners) {
                listener.columnMetadataChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireFetchStarted() {
        this.setFetchDataRunning(true);
        ArrayList arrayList = this.m_dataFetchListeners;
        synchronized (arrayList) {
            for (JDBCTableModelListener listener : this.m_dataFetchListeners) {
                listener.fetchStarted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDataFetchSuccess() {
        this.setFetchDataRunning(false);
        ArrayList arrayList = this.m_dataFetchListeners;
        synchronized (arrayList) {
            for (JDBCTableModelListener listener : this.m_dataFetchListeners) {
                listener.fetchSuccessful();
            }
        }
        this.fireFetchCompleted();
    }

    protected void fireDataFetchError(Exception e) {
        this.fireDataFetchError(new JDBCTableModelException(e));
    }

    protected void fireDataFetchError(JDBCTableModelException e) {
        this.fireDataFetchError(e.getMessage(), e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDataFetchError(String msg, JDBCTableModelException e) {
        this.setFetchDataRunning(false);
        ArrayList arrayList = this.m_dataFetchListeners;
        synchronized (arrayList) {
            for (JDBCTableModelListener listener : this.m_dataFetchListeners) {
                listener.fetchError(msg, e);
            }
        }
        this.fireFetchCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireFetchCompleted() {
        this.setFetchDataRunning(false);
        ArrayList arrayList = this.m_dataFetchListeners;
        synchronized (arrayList) {
            for (JDBCTableModelListener listener : this.m_dataFetchListeners) {
                listener.fetchComplete();
            }
        }
    }

    public int getPreferredPageSize() {
        return 100;
    }

    public boolean loadNextPage() throws JDBCTableModelException {
        return this.loadPage(this.m_currentPageNumber + 1);
    }

    public boolean loadPreviousPage() throws JDBCTableModelException {
        return this.loadPage(this.m_currentPageNumber - 1);
    }

    public boolean loadFirstPage() throws JDBCTableModelException {
        return this.loadPage(1);
    }

    public boolean loadLastPage() throws JDBCTableModelException {
        this.verifyFetchDataRunning();
        if (this.isAtLastPage()) {
            return true;
        }
        int lastPage = this.getLastPageNumber();
        if (lastPage == -1) {
            return false;
        }
        return this.loadPage(lastPage);
    }

    public boolean loadPage(int pageNo) throws JDBCTableModelException {
        int rowCount;
        this.verifyFetchDataRunning();
        if (this.checkPageBounds(pageNo) == 1) {
            return false;
        }
        if (this.m_currentPageNumber == pageNo) {
            return true;
        }
        try {
            rowCount = this.calculateRowCountInPage(pageNo);
            if (rowCount == -1) {
                return false;
            }
        }
        catch (SQLException se) {
            throw new JDBCTableModelException(se);
        }
        this.m_currentPageNumber = pageNo;
        int oldPageSize = this.m_currentPageSize;
        this.m_currentPageSize = rowCount;
        this.checkAndSetLastPage(pageNo);
        if (oldPageSize < this.m_currentPageSize) {
            this.fireTableRowsInserted(oldPageSize < 0 ? 0 : oldPageSize, this.m_currentPageSize - 1);
        } else if (oldPageSize > this.m_currentPageSize) {
            this.fireTableRowsDeleted(this.m_currentPageSize, oldPageSize - 1);
        }
        return true;
    }

    public boolean loadRow(int rowNumber) throws JDBCTableModelException {
        try {
            if (!this.peekRow(rowNumber)) {
                return false;
            }
        }
        catch (SQLException se) {
            throw new JDBCTableModelException(se);
        }
        return this.loadPage(this.getPageNumber(rowNumber));
    }

    public int getCurrentPageNumber() {
        return this.m_currentPageNumber;
    }

    public int getCurrentPageSize() {
        return this.m_currentPageSize;
    }

    public int[] getRowRange() {
        int[] range = new int[2];
        int currentPageSize = this.getCurrentPageSize();
        if (currentPageSize < 0) {
            range[0] = -1;
            range[1] = -1;
        } else if (currentPageSize == 0) {
            range[0] = 0;
            range[1] = 0;
        } else {
            range[0] = (this.getCurrentPageNumber() - 1) * this.getPreferredPageSize() + 1;
            range[1] = range[0] + currentPageSize - 1;
        }
        return range;
    }

    public boolean isAtFirstPage() {
        return this.m_currentPageNumber == 1;
    }

    public boolean isAtLastPage() {
        return this.m_lastPageNumber != -1 && this.m_currentPageNumber == this.m_lastPageNumber;
    }

    public int getRowCount() {
        if (this.checkPageBounds(this.m_currentPageNumber) == 1) {
            return 0;
        }
        return this.m_currentPageSize;
    }

    private int checkPageBounds(int pageNo) {
        if (pageNo < 1) {
            return 1;
        }
        if (this.m_lastPageNumber != -1) {
            if (pageNo > this.m_lastPageNumber) {
                return 1;
            }
        } else {
            return -1;
        }
        return 0;
    }

    private int getLastPageNumber() {
        int lastRow = 0;
        try {
            if (this.getResultSet().last()) {
                lastRow = this.getResultSet().getRow();
            }
        }
        catch (SQLException se) {
            Workspace.getDefaultLogger().warn((Object)("Unable to get last row number: " + se.getMessage()));
            return -1;
        }
        return (int)Math.ceil((double)lastRow / (double)this.getPreferredPageSize());
    }

    private int calculateRowCountInPage(int pageNo) throws SQLException {
        int lowerLimit = (pageNo - 1) * this.getPreferredPageSize() + 1;
        int upperLimit = pageNo * this.getPreferredPageSize();
        if (this.getResultSet().absolute(lowerLimit)) {
            if (this.getResultSet().absolute(upperLimit)) {
                return this.getPreferredPageSize();
            }
            if (this.getResultSet().last()) {
                return this.getResultSet().getRow() - lowerLimit + 1;
            }
        }
        if (pageNo == 1) {
            return 0;
        }
        return -1;
    }

    private void checkAndSetLastPage(int pageNo) {
        if (this.m_lastPageNumber != -1) {
            return;
        }
        this.setCurrentMaxPageNo(pageNo);
        if (this.m_currentPageSize < this.getPreferredPageSize()) {
            this.setLastPageNo(pageNo);
            return;
        }
        try {
            if (!this.peekPage(pageNo + 1)) {
                this.setLastPageNo(pageNo);
            }
        }
        catch (SQLException se) {
            this.handleIfSAPError(se);
            this.setLastPageNo(pageNo);
            Workspace.getDefaultLogger().warn((Object)("Error peeking next page: " + se.getMessage()));
        }
    }

    private void setCurrentMaxPageNo(int pageNo) {
        if (pageNo > this.m_currentMaxPageNumber) {
            this.m_currentMaxPageNumber = pageNo;
        }
    }

    private void setLastPageNo(int pageNo) {
        if (pageNo != -1) {
            this.m_lastPageNumber = pageNo;
        }
    }

    private boolean peekPage(int pageNo) throws SQLException {
        if (pageNo <= this.m_currentMaxPageNumber) {
            return true;
        }
        return this.peekRow((pageNo - 1) * this.getPreferredPageSize());
    }

    public boolean peekRow(int rowNo) throws SQLException {
        return this.getResultSet().absolute(rowNo + 1);
    }

    public int convertToAbsoluteRowNumber(int pageRowNumber) {
        if (pageRowNumber < 0 || pageRowNumber > this.getCurrentPageSize() - 1) {
            return -1;
        }
        return this.getPreferredPageSize() * (this.getCurrentPageNumber() - 1) + pageRowNumber;
    }

    public int convertToPageRowNumber(int absoluteRowNumber) {
        if (absoluteRowNumber < 0) {
            return -1;
        }
        return absoluteRowNumber % this.getPreferredPageSize();
    }

    public int getPageNumber(int rowNumber) {
        return (int)Math.ceil((double)(rowNumber + 1) / (double)this.getPreferredPageSize());
    }

    public Object getRowLabel(int index) {
        return Integer.toString(index + this.getRowRange()[0]);
    }

    public Object[] getRowLabels(int startIndex, int count) {
        int rowFirst = this.getRowRange()[0];
        Object[] oaLabels = new Object[count];
        for (int iLabel = 0; iLabel < count; ++iLabel) {
            oaLabels[iLabel] = Integer.toString(startIndex + iLabel + rowFirst);
        }
        return oaLabels;
    }

    public boolean isRowLabelsSupported() {
        return true;
    }

    public boolean isRowsLabelSupported() {
        return true;
    }

    protected DataTable getDataTable() {
        return this.m_dataTable;
    }

    public boolean isParameterized() {
        return this.m_isParameterized;
    }

    public void setParameterized(boolean parameterized) {
        this.m_isParameterized = parameterized;
    }

    protected void setAppServer(WsAppServer appServer) {
        this.m_appServer = appServer;
    }

    public WsAppServer getAppServer() {
        return this.m_appServer;
    }

    protected MVAResultSet getResultSet() {
        return this.m_resultSet;
    }

    protected void setResultSet(MVAResultSet resultSet) {
        this.m_resultSet = resultSet;
    }

    private void handleIfSAPError(SQLException se) {
        try {
            SASLibrary lib = LibraryUtil.getLibrary((DataTable)this.getDataTable(), (ServerContext)this.getAppServer().getServerContext());
            AssociationList list = ((Prototype)lib.getUsingPrototype()).getPrototypeProperties();
            for (int i = 0; i < list.size(); ++i) {
                if (!((CMetadata)list.get(i)).getCMetadataType().equals("AttributeProperty") || !((AttributeProperty)list.get(i)).getName().equals("Engine") || !((AttributeProperty)list.get(i)).getDefaultValue().equals("SASIOSR3")) continue;
                MessageUtil.displayDetailsMessage((String)bundle.formatString("JDBCTableModel.SAPTableError.txt", (Object)this.getTableDisplayName()), (int)0, (String)bundle.formatString("JDBCTableModel.SAPTableErrorDetails.txt", (Object)se.getMessage()));
            }
        }
        catch (MdException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public int[] getColumnIndices(Column[] columns) {
        int[] indices = new int[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            int index;
            Column col = columns[i];
            indices[i] = index = this.getColumnIndex(col);
        }
        return indices;
    }

    public String getTableDisplayName() {
        try {
            return this.getDataTable().getTableName();
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
            return "";
        }
    }

    public boolean isDBMSView() {
        return false;
    }
}

