/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerContext;
import com.sas.rio.MVAConnection;
import com.sas.rio.MVAResultSet;
import com.sas.rio.MVAStatement;
import com.sas.wadmin.viewdata.JDBCTableModel;
import com.sas.wadmin.viewdata.JDBCTableModelException;
import com.sas.wadmin.viewdata.RowCount;
import com.sas.wadmin.viewdata.RowCountListener;
import com.sas.workspace.DBMSNamesPropertyHandler;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OptionsPropertyHandler;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsAppServerLibraryException;
import com.sas.workspace.WsStringTableColumn;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Properties;
import javax.swing.SwingUtilities;

public class JDBCPhysicalTableTableModel
extends JDBCTableModel {
    public static final int METADATA_MODE_SASMETADATA = 1;
    public static final int METADATA_MODE_JDBCMETADATA = 2;
    private static WAdminResource bundle = WAdminResource.getBundle(JDBCPhysicalTableTableModel.class);
    private int m_metadataMode = 1;
    private MetadataTypeHelper m_mdTypeHelper;
    private boolean m_bClientCreatedAppServer;
    private int m_rowCount = -1;
    private RowCount m_counter = new RowCount();

    public JDBCPhysicalTableTableModel(PhysicalTable table) {
        this(table, null);
    }

    public JDBCPhysicalTableTableModel(PhysicalTable table, WsAppServer appServer) {
        super((DataTable)table);
        this.m_counter.addRowCountListener(new RowCountListener(){

            @Override
            public void updateRowCount(int rowCount) {
                int oldValue = JDBCPhysicalTableTableModel.this.m_rowCount;
                JDBCPhysicalTableTableModel.this.m_rowCount = rowCount;
                JDBCPhysicalTableTableModel.this.firePropertyChanged("ROW_COUNT", new Integer(oldValue), new Integer(JDBCPhysicalTableTableModel.this.m_rowCount));
            }
        });
        if (appServer != null) {
            this.setAppServer(appServer);
            this.m_bClientCreatedAppServer = true;
        }
    }

    @Override
    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        String sOptions = "<TEMPLATES><PhysicalTable><Columns/><TablePackage/></PhysicalTable><SASLibrary><DeployedComponents/><UsingPackages/></SASLibrary></TEMPLATES>";
        Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.getDataTable(), null, null, sOptions, 24972);
        super.populateStore();
    }

    @Override
    public void constructModel() throws JDBCTableModelException {
        if (this.getMetadataMode() != 1) {
            if (this.getMetadataTypeHelper() != null) {
                this.getMetadataTypeHelper().close();
            }
            this.setMetadataMode(1);
            this.setMetadataTypeHelper(null);
        }
        if (this.getMetadataTypeHelper() == null) {
            this.setMetadataTypeHelper(new SASMetadataTypeHelper());
        }
        super.constructModel();
    }

    @Override
    public void clear() {
        super.clear();
        if (this.getMetadataTypeHelper() != null) {
            this.getMetadataTypeHelper().clear();
        }
    }

    @Override
    public void close() {
        this.m_counter.dispose();
        if (this.getMetadataTypeHelper() != null) {
            this.getMetadataTypeHelper().close();
        }
        super.close();
    }

    @Override
    protected Runnable getDataFetchRunnable() throws JDBCTableModelException {
        return new DataFetchRunnable();
    }

    @Override
    public int getTotalRowCount() {
        return this.m_rowCount;
    }

    @Override
    protected String getColumnDisplayName(int index) {
        return this.getMetadataTypeHelper().getColumnDisplayName(index);
    }

    @Override
    public String getColumnType(int index) {
        return this.getMetadataTypeHelper().getColumnType(index);
    }

    @Override
    protected void setDisplayColumnsAll() {
        if (this.m_metadataMode == 1) {
            super.setDisplayColumnsAll();
            return;
        }
        int[] displayColumns = new int[this.m_mdTypeHelper.getColumnCount()];
        for (int i = 0; i < this.m_mdTypeHelper.getColumnCount(); ++i) {
            displayColumns[i] = i;
        }
        this.setDisplayColumns(displayColumns);
    }

    protected void setMetadataMode(int metadataMode) {
        this.m_metadataMode = metadataMode;
    }

    protected int getMetadataMode() {
        return this.m_metadataMode;
    }

    protected void setMetadataTypeHelper(MetadataTypeHelper mdTypeHelper) {
        this.m_mdTypeHelper = mdTypeHelper;
    }

    protected MetadataTypeHelper getMetadataTypeHelper() {
        return this.m_mdTypeHelper;
    }

    @Override
    public String getTableDisplayName() {
        try {
            return ((PhysicalTable)this.getDataTable()).getSASTableName();
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
            return "";
        }
    }

    public String getSQLTableName() throws MdException, RemoteException {
        String sASTableName = ((PhysicalTable)this.getDataTable()).getSASTableName();
        if (this.isParameterized()) {
            int indexOfAmp = sASTableName.lastIndexOf(38);
            int indexOfPeriod = sASTableName.lastIndexOf(46);
            if (indexOfAmp != -1 && indexOfPeriod < indexOfAmp) {
                sASTableName = sASTableName + ".";
            }
        }
        return DBMSNamesUtil.getQuotedString((String)sASTableName, (DataTable)this.getDataTable());
    }

    static /* synthetic */ WsAbstractTableColumn[] access$1102(JDBCPhysicalTableTableModel x0, WsAbstractTableColumn[] x1) {
        x0.m_aColumns = x1;
        return x1;
    }

    private class DataManager {
        private SASLibrary m_library;
        private MVAStatement m_statement;
        private String m_sAssignedSQLId;

        public void init() throws JDBCTableModelException, MdException, RemoteException, WsAppServerFailException, WsAppServerCodeException, WsAppServerLibraryException {
            Properties jDBCConnectionProperties = new Properties();
            jDBCConnectionProperties.put("applyFormats", "true");
            jDBCConnectionProperties.put("coerceNumericTypes", "true");
            if (JDBCPhysicalTableTableModel.this.isParameterized()) {
                jDBCConnectionProperties.put("sasifyTableNames", "none");
            }
            this.init(jDBCConnectionProperties);
        }

        public void init(Properties connProperties) throws JDBCTableModelException, MdException, RemoteException, WsAppServerFailException, WsAppServerCodeException, WsAppServerLibraryException {
            this.fetchAppServer(connProperties);
            this.initializeSession();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fetchAppServer(Properties connProperties) throws JDBCTableModelException, MdException, RemoteException, WsAppServerFailException, WsAppServerCodeException, WsAppServerLibraryException {
            if (JDBCPhysicalTableTableModel.this.m_bClientCreatedAppServer) {
                try {
                    SASLibrary iLib = LibraryUtil.getLibrary((DataTable)JDBCPhysicalTableTableModel.this.getDataTable(), (ServerContext)JDBCPhysicalTableTableModel.this.getAppServer().getServerContext());
                    if (iLib == null) {
                        return;
                    }
                    this.m_library = LibraryUtil.getClientLibrary((SASLibrary)iLib, (ServerContext)JDBCPhysicalTableTableModel.this.getAppServer().getServerContext());
                    if (this.m_library == null) {
                        throw new JDBCTableModelException(bundle.getString("JDBCPhysicalTableTableModel.LibrefFetchFail.txt"));
                    }
                    return;
                }
                finally {
                    JDBCPhysicalTableTableModel.this.getAppServer().openSQLConnection(connProperties);
                }
            }
            WsAppServer defAppServer = WsAppServer.createDefaultAppServer();
            if (defAppServer == null) {
                throw new JDBCTableModelException(bundle.getString("JDBCPhysicalTableTableModel.DefAppServerCreationFailed.txt"));
            }
            try {
                ServerContext iDefault = defAppServer.getServerContext();
                SASLibrary iLib = LibraryUtil.getLibrary((DataTable)JDBCPhysicalTableTableModel.this.getDataTable(), (ServerContext)iDefault);
                if (iLib == null) {
                    throw new JDBCTableModelException(bundle.getString("JDBCPhysicalTableTableModel.LibraryFetchFail.txt"));
                }
                this.m_library = LibraryUtil.getClientLibrary((SASLibrary)iLib, (ServerContext)iDefault);
                WsAppServer appServer = LibraryUtil.interactiveAccessPath((SASLibrary)this.m_library, (WsAppServer)defAppServer);
                if (appServer == null) {
                    Workspace.getDefaultLogger().warn((Object)"Could not fetch appserver.");
                    throw new JDBCTableModelException(bundle.getString("JDBCPhysicalTableTableModel.AppServerFetchFail.txt"));
                }
                JDBCPhysicalTableTableModel.this.setAppServer(appServer);
            }
            finally {
                if (JDBCPhysicalTableTableModel.this.getAppServer() != defAppServer) {
                    defAppServer.dispose();
                }
            }
            this.m_sAssignedSQLId = JDBCPhysicalTableTableModel.this.getAppServer().openAssignedSQLConnection(connProperties);
        }

        protected void initializeSession() throws MdException, RemoteException, WsAppServerFailException, WsAppServerCodeException {
            this.submitMacroDefinitions();
            this.submitSpecialCharactersCode();
        }

        protected void submitMacroDefinitions() throws MdException, RemoteException, WsAppServerFailException, WsAppServerCodeException {
            String macros = JDBCPhysicalTableTableModel.this.getParameterizedMacroDeclaration();
            if (macros != null) {
                this.submitSASCode(macros);
            }
        }

        protected void submitSpecialCharactersCode() throws MdException, RemoteException, WsAppServerFailException, WsAppServerCodeException {
            String specChar = DBMSNamesPropertyHandler.getSpecCharPropertyValue((Root)JDBCPhysicalTableTableModel.this.getDataTable());
            if ("Y".equals(specChar)) {
                this.submitSASCode("options VALIDVARNAME=ANY;");
            }
        }

        public MVAResultSet fetchResultSet() throws SQLException, WsAppServerFailException, MdException, RemoteException, JDBCTableModelException {
            MVAResultSet resultSet = null;
            String query = this.getQuery();
            if (this.m_statement == null) {
                if (this.m_sAssignedSQLId == null) {
                    this.m_sAssignedSQLId = JDBCPhysicalTableTableModel.this.getAppServer().openAssignedSQLConnection();
                }
                if (JDBCPhysicalTableTableModel.this.getAppServer().getAssignedSQLConnection(this.m_sAssignedSQLId) == null) {
                    throw new JDBCTableModelException(bundle.getString("JDBCPhysicalTableTableModel.UnableToConnect.txt"));
                }
                MVAConnection sqlConnection = JDBCPhysicalTableTableModel.this.getAppServer().getAssignedSQLConnection(this.m_sAssignedSQLId);
                this.m_statement = (MVAStatement)sqlConnection.createStatement(1004, 1007);
            }
            if ((resultSet = JDBCPhysicalTableTableModel.this.getAppServer().submitAssignedSQLStatement(query, this.m_statement, JDBCPhysicalTableTableModel.this.getFetchSize())) == null) {
                Workspace.getDefaultLogger().warn((Object)"Unable to fetch resultset.");
                throw new JDBCTableModelException(bundle.getString("JDBCPhysicalTableTableModel.UnknownAppServerError.txt"));
            }
            resultSet.absolute(1);
            return resultSet;
        }

        public void submitSASCode(String code) throws WsAppServerFailException, WsAppServerCodeException {
            JDBCPhysicalTableTableModel.this.getAppServer().submitSASCode(code);
        }

        private String getQuery() throws JDBCTableModelException, MdException, RemoteException {
            String libref = this.getLibRef();
            if (libref == null) {
                Workspace.getDefaultLogger().warn((Object)"Error fetching libref. Cannot form query.");
                throw new JDBCTableModelException(bundle.getString("JDBCPhysicalTableTableModel.LibrefFetchFail.txt"));
            }
            StringBuffer query = new StringBuffer("SELECT ");
            if (JDBCPhysicalTableTableModel.this.m_metadataMode == 2) {
                query.append("* ");
                this.appendTableClause(libref, query);
            } else {
                this.appendColumnsClause(query);
                this.appendTableClause(libref, query);
            }
            this.appendWhereClause(query);
            this.appendOrderByClause(query);
            Workspace.getDefaultLogger().warn((Object)query.toString());
            return query.toString();
        }

        private void appendColumnsClause(StringBuffer query) throws MdException, RemoteException, JDBCTableModelException {
            int cols = JDBCPhysicalTableTableModel.this.getDisplayColumns().length;
            for (int i = 0; i < cols; ++i) {
                String format;
                int colIndex = JDBCPhysicalTableTableModel.this.getDisplayColumns()[i];
                String colName = JDBCPhysicalTableTableModel.this.getMetadataTypeHelper().getSQLColumnName(colIndex);
                query.append(colName);
                if (JDBCPhysicalTableTableModel.this.getApplyFormats() && (format = JDBCPhysicalTableTableModel.this.getColumnMetadata(colIndex).getSASFormat()) != null && format.length() > 0) {
                    query.append(" FORMAT=");
                    query.append(format);
                    if (format.indexOf(".") == -1) {
                        query.append(".");
                    }
                }
                if (i == cols - 1) continue;
                query.append(",");
            }
        }

        private void appendTableClause(String libref, StringBuffer query) throws MdException, RemoteException {
            query.append(" FROM ").append(libref).append(".").append(JDBCPhysicalTableTableModel.this.getSQLTableName());
            this.appendTableOptions(query);
        }

        private void appendTableOptions(StringBuffer query) throws MdException, RemoteException {
            OptionsPropertyHandler OP = new OptionsPropertyHandler((Root)JDBCPhysicalTableTableModel.this.getDataTable(), false);
            String dsOptions = OP.getOptionsString();
            if (dsOptions != null && !dsOptions.trim().equals("")) {
                query.append(" (").append(dsOptions).append(") ");
            }
        }

        private void appendWhereClause(StringBuffer query) {
            if (JDBCPhysicalTableTableModel.this.getWhereClause() != null) {
                query.append(" WHERE ");
                query.append(JDBCPhysicalTableTableModel.this.getWhereClause());
            }
        }

        private void appendOrderByClause(StringBuffer query) throws MdException, RemoteException, JDBCTableModelException {
            int[] sortColumns = JDBCPhysicalTableTableModel.this.getSortedColumns();
            if (sortColumns == null || sortColumns.length == 0) {
                return;
            }
            query.append(" ORDER BY ");
            int size = sortColumns.length;
            for (int i = 0; i < size; ++i) {
                String columnName = JDBCPhysicalTableTableModel.this.getMetadataTypeHelper().getSQLColumnName(sortColumns[i]);
                query.append(columnName);
                if (JDBCPhysicalTableTableModel.this.getSortedColumnOrder()[i] == -1) {
                    query.append(" ").append("DESC");
                }
                if (i >= size - 1) continue;
                query.append(",");
            }
        }

        public String getLibRef() {
            try {
                if (this.m_library != null) {
                    return this.m_library.getLibref();
                }
                return bundle.getString("JDBCPhysicalTableTableModel.WorkLibrary.notrans");
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
                return "";
            }
        }

        public void close() {
            if (JDBCPhysicalTableTableModel.this.getAppServer() == null) {
                return;
            }
            if (!JDBCPhysicalTableTableModel.this.m_bClientCreatedAppServer) {
                JDBCPhysicalTableTableModel.this.getAppServer().dispose();
            } else {
                JDBCPhysicalTableTableModel.this.getAppServer().closeAssignedSQLConnection(this.m_sAssignedSQLId);
            }
            JDBCPhysicalTableTableModel.this.setAppServer(null);
            try {
                if (this.m_statement != null) {
                    this.m_statement.close();
                }
            }
            catch (SQLException e) {
                Workspace.getDefaultLogger().debug((Object)e.getMessage());
            }
            JDBCPhysicalTableTableModel.this.clearSortColumns();
        }
    }

    private class JDBCMetadataTypeHelper
    extends MetadataTypeHelper {
        private String[] m_aColNames;
        private String[] m_aColDisplayNames;
        private String[] m_aColDataTypes;

        private JDBCMetadataTypeHelper() {
        }

        @Override
        protected void init() throws JDBCTableModelException {
            try {
                if (this.getDataManager() != null) {
                    return;
                }
                DataManager dataManager = new DataManager();
                Properties connProps = new Properties();
                connProps.put("APPLYFORMATS", "false");
                dataManager.init(connProps);
                this.setDataManager(dataManager);
                JDBCPhysicalTableTableModel.this.m_counter.getRowCount(this.getDataManager().getLibRef(), JDBCPhysicalTableTableModel.this.getSQLTableName(), JDBCPhysicalTableTableModel.this);
            }
            catch (MdException e) {
                throw new JDBCTableModelException(e);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (WsAppServerFailException e) {
                throw new JDBCTableModelException(e);
            }
            catch (WsAppServerCodeException e) {
                throw new JDBCTableModelException(e);
            }
            catch (WsAppServerLibraryException e) {
                throw new JDBCTableModelException(e);
            }
        }

        @Override
        protected void close() {
            if (this.getDataManager() != null) {
                this.getDataManager().close();
            }
        }

        @Override
        protected int getColumnCount() {
            return this.m_aColNames == null ? 0 : this.m_aColNames.length;
        }

        @Override
        protected String getColumnDisplayName(int index) {
            return this.m_aColDisplayNames[index];
        }

        @Override
        protected String getSQLColumnName(int index) throws MdException, RemoteException {
            return DBMSNamesUtil.getQuotedString((String)this.m_aColNames[index], (DataTable)JDBCPhysicalTableTableModel.this.getDataTable());
        }

        @Override
        protected String getColumnType(int index) {
            return this.m_aColDataTypes[index];
        }

        @Override
        protected void fetchDataPreemptive() throws JDBCTableModelException {
            try {
                if (this.m_aColNames == null) {
                    DataFetchRunnable runnable = new DataFetchRunnable();
                    SwingUtilities.invokeAndWait(runnable);
                    Throwable t = runnable.getException();
                    if (t != null) {
                        Workspace.getDefaultLogger().error((Object)"", t);
                        if (t instanceof JDBCTableModelException) {
                            throw (JDBCTableModelException)t;
                        }
                        throw new JDBCTableModelException(t);
                    }
                } else {
                    this.fetchResultSet();
                }
            }
            catch (InterruptedException e) {
                throw new JDBCTableModelException(e);
            }
            catch (InvocationTargetException e) {
                throw new JDBCTableModelException(e);
            }
            catch (SQLException e) {
                throw new JDBCTableModelException(e);
            }
            catch (WsAppServerFailException e) {
                throw new JDBCTableModelException(e);
            }
            catch (MdException e) {
                throw new JDBCTableModelException(e);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }

        private void setColumnMetadata(ResultSet resultSet) throws SQLException, MdException, RemoteException {
            ResultSetMetaData metadata = resultSet.getMetaData();
            int count = metadata.getColumnCount();
            if (count == 0) {
                throw new MdException(bundle.getString("JDBCTableModel.NoColumns.txt"));
            }
            this.m_aColNames = new String[count];
            this.m_aColDisplayNames = new String[count];
            this.m_aColDataTypes = new String[count];
            for (int i = 0; i < count; ++i) {
                this.m_aColNames[i] = metadata.getColumnName(i + 1);
                this.m_aColDisplayNames[i] = this.fetchColumnDisplayName(metadata, i);
                this.m_aColDataTypes[i] = this.getSASColumnTypeForSQLType(metadata, i);
            }
        }

        private void reConstructColumnMetadataFromJDBC() {
            int nColumns = this.m_aColNames.length;
            JDBCPhysicalTableTableModel.access$1102(JDBCPhysicalTableTableModel.this, new WsAbstractTableColumn[nColumns]);
            for (int i = 0; i < nColumns; ++i) {
                String label = this.getColumnDisplayName(i);
                ((JDBCPhysicalTableTableModel)JDBCPhysicalTableTableModel.this).m_aColumns[i] = new WsStringTableColumn(i, label, 150);
            }
            JDBCPhysicalTableTableModel.this.setDisplayColumnsAll();
            JDBCPhysicalTableTableModel.this.fireTableStructureChanged();
        }

        private void fetchResultSet() throws SQLException, WsAppServerFailException, MdException, RemoteException, JDBCTableModelException {
            this.clear();
            MVAResultSet resultSet = this.getDataManager().fetchResultSet();
            JDBCPhysicalTableTableModel.this.setResultSet(resultSet);
        }

        private String fetchColumnDisplayName(ResultSetMetaData metadata, int index) {
            try {
                String label = metadata.getColumnLabel(index + 1);
                label = label == null || "".equals(label.trim()) ? metadata.getColumnName(index + 1) : label;
                return label;
            }
            catch (SQLException se) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)se);
                return null;
            }
        }

        private String getSASColumnTypeForSQLType(ResultSetMetaData metadata, int index) {
            String SASColumnType = "C";
            int columnType = 1111;
            try {
                if (metadata != null) {
                    columnType = metadata.getColumnType(index + 1);
                }
            }
            catch (SQLException se) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)se);
            }
            switch (columnType) {
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: {
                    SASColumnType = "N";
                    break;
                }
            }
            return SASColumnType;
        }

        private class DataFetchRunnable
        implements Runnable {
            private Throwable t;

            private DataFetchRunnable() {
            }

            @Override
            public void run() {
                try {
                    JDBCMetadataTypeHelper.this.fetchResultSet();
                    JDBCMetadataTypeHelper.this.setColumnMetadata((ResultSet)JDBCPhysicalTableTableModel.this.getResultSet());
                    JDBCMetadataTypeHelper.this.reConstructColumnMetadataFromJDBC();
                }
                catch (SQLException e) {
                    this.t = e;
                }
                catch (WsAppServerFailException e) {
                    this.t = e;
                }
                catch (MdException e) {
                    this.t = e;
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                catch (JDBCTableModelException e) {
                    this.t = e;
                }
            }

            public Throwable getException() {
                return this.t;
            }
        }
    }

    private class SASMetadataTypeHelper
    extends MetadataTypeHelper {
        private SASMetadataTypeHelper() {
        }

        @Override
        protected void init() throws JDBCTableModelException {
            try {
                if (this.getDataManager() != null) {
                    return;
                }
                DataManager dataManager = new DataManager();
                dataManager.init();
                this.setDataManager(dataManager);
                JDBCPhysicalTableTableModel.this.m_counter.getRowCount(this.getDataManager().getLibRef(), JDBCPhysicalTableTableModel.this.getSQLTableName(), JDBCPhysicalTableTableModel.this);
            }
            catch (MdException e) {
                throw new JDBCTableModelException(e);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (WsAppServerFailException e) {
                throw new JDBCTableModelException(e);
            }
            catch (WsAppServerCodeException e) {
                throw new JDBCTableModelException(e);
            }
            catch (WsAppServerLibraryException e) {
                throw new JDBCTableModelException(e);
            }
        }

        @Override
        protected String getSQLColumnName(int index) throws MdException, RemoteException, JDBCTableModelException {
            return JDBCPhysicalTableTableModel.this.getSQLTableName() + "." + DBMSNamesUtil.getQuotedString((String)JDBCPhysicalTableTableModel.this.getColumnMetadata(index).getSASColumnName(), (DataTable)JDBCPhysicalTableTableModel.this.getDataTable());
        }

        @Override
        protected String getColumnType(int index) {
            try {
                return JDBCPhysicalTableTableModel.this.getColumnMetadata(index).getSASColumnType();
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
                return "";
            }
        }

        @Override
        protected void fetchDataPreemptive() throws JDBCTableModelException {
            try {
                this.clear();
                MVAResultSet resultSet = this.getDataManager().fetchResultSet();
                JDBCPhysicalTableTableModel.this.setResultSet(resultSet);
            }
            catch (SQLException e) {
                throw new JDBCTableModelException(e);
            }
            catch (WsAppServerFailException e) {
                throw new JDBCTableModelException(e);
            }
            catch (MdException e) {
                throw new JDBCTableModelException(e);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }

        @Override
        protected void close() {
            if (this.getDataManager() != null) {
                this.getDataManager().close();
            }
        }
    }

    protected abstract class MetadataTypeHelper {
        private DataManager m_dataManager;

        protected MetadataTypeHelper() {
        }

        protected abstract void init() throws JDBCTableModelException;

        protected abstract void close();

        protected int getColumnCount() {
            return JDBCPhysicalTableTableModel.super.getDisplayColumns().length;
        }

        protected String getColumnDisplayName(int index) {
            return JDBCPhysicalTableTableModel.super.getColumnDisplayName(index);
        }

        protected abstract String getSQLColumnName(int var1) throws MdException, RemoteException, JDBCTableModelException;

        protected abstract String getColumnType(int var1);

        protected abstract void fetchDataPreemptive() throws JDBCTableModelException;

        protected void clear() {
            if (JDBCPhysicalTableTableModel.this.getResultSet() != null) {
                try {
                    JDBCPhysicalTableTableModel.this.getResultSet().close();
                }
                catch (SQLException se) {
                    Workspace.getDefaultLogger().warn((Object)se.getMessage());
                }
                JDBCPhysicalTableTableModel.this.setResultSet(null);
            }
        }

        protected DataManager getDataManager() {
            return this.m_dataManager;
        }

        protected void setDataManager(DataManager dataManager) {
            this.m_dataManager = dataManager;
        }
    }

    private class DataFetchRunnable
    implements Runnable {
        private DataFetchRunnable() {
        }

        @Override
        public void run() {
            try {
                JDBCPhysicalTableTableModel.this.getMetadataTypeHelper().init();
                this.fetchDataPreemptive();
                JDBCPhysicalTableTableModel.this.fireDataFetchSuccess();
            }
            catch (JDBCTableModelException e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                JDBCPhysicalTableTableModel.this.fireDataFetchError(e);
            }
        }

        private void fetchDataPreemptive() throws JDBCTableModelException {
            try {
                JDBCPhysicalTableTableModel.this.getMetadataTypeHelper().fetchDataPreemptive();
            }
            catch (JDBCTableModelException e) {
                if (!(e.getCause() instanceof WsAppServerFailException) || JDBCPhysicalTableTableModel.this.m_metadataMode == 2) {
                    throw e;
                }
                int option = MessageUtil.displayDetailsMessage((String)bundle.formatString("JDBCPhysicalTableTableModel.MetadataOutOfSyncPrompt.txt", (Object)JDBCPhysicalTableTableModel.this.getTableDisplayName()), (int)2, (int)0, (String)e.getCause().getMessage());
                if (option == 1) {
                    throw e;
                }
                WsAppServer appServer = null;
                if (JDBCPhysicalTableTableModel.this.m_bClientCreatedAppServer) {
                    appServer = JDBCPhysicalTableTableModel.this.getAppServer();
                }
                JDBCPhysicalTableTableModel.this.getMetadataTypeHelper().close();
                JDBCPhysicalTableTableModel.this.removeAllColumns();
                JDBCPhysicalTableTableModel.this.setMetadataMode(2);
                JDBCPhysicalTableTableModel.this.setMetadataTypeHelper(new JDBCMetadataTypeHelper());
                if (JDBCPhysicalTableTableModel.this.m_bClientCreatedAppServer) {
                    JDBCPhysicalTableTableModel.this.setAppServer(appServer);
                }
                JDBCPhysicalTableTableModel.this.getMetadataTypeHelper().init();
                JDBCPhysicalTableTableModel.this.getMetadataTypeHelper().fetchDataPreemptive();
            }
        }
    }
}

