/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata;

import com.sas.metadata.remote.Column;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class ColumnDisplayLabelHelper {
    public static final int SAS_COLUMN_NAME = 1;
    public static final int METADATA_NAME = 2;
    public static final int COLUMN_DESCRIPTION = 4;
    public static final String PROPERTY_DISPLAY_FORMAT = "DisplayFormat";
    private boolean m_showColumnName;
    private boolean m_showMetadataName;
    private boolean m_showDescription;
    private ArrayList m_propertyChangeListeners = new ArrayList();

    public ColumnDisplayLabelHelper() {
        this.init();
    }

    private void init() {
        WorkspaceFile file = Workspace.getWorkspace().getAppDefaultsFile();
        this.m_showMetadataName = file.getPropertyBoolean("ViewData.ShowMetadataNameInColumnHeader", false);
        this.m_showColumnName = file.getPropertyBoolean("ViewData.ShowColumnNameInColumnHeader", true);
        this.m_showDescription = file.getPropertyBoolean("ViewData.ShowDescriptionInColumnHeader", false);
    }

    public void showColumnName(boolean show) {
        if (this.m_showColumnName == show) {
            return;
        }
        this.m_showColumnName = show;
        this.notifyFormatChange();
    }

    public void showMetadataName(boolean show) {
        if (this.m_showMetadataName == show) {
            return;
        }
        this.m_showMetadataName = show;
        this.notifyFormatChange();
    }

    public void showDescription(boolean show) {
        if (this.m_showDescription == show) {
            return;
        }
        this.m_showDescription = show;
        this.notifyFormatChange();
    }

    public boolean showColumnName() {
        return this.m_showColumnName;
    }

    public boolean showMetadataName() {
        return this.m_showMetadataName;
    }

    public boolean showDescription() {
        return this.m_showDescription;
    }

    public String getColumnDisplayName(Column column) {
        if (this.m_showColumnName && !this.m_showMetadataName && !this.m_showDescription) {
            return this.getFormattedLabel(1, column);
        }
        if (!this.m_showColumnName && this.m_showMetadataName && !this.m_showDescription) {
            return this.getFormattedLabel(2, column);
        }
        if (!this.m_showColumnName && !this.m_showMetadataName && this.m_showDescription) {
            return this.getFormattedLabel(4, column);
        }
        if (this.m_showColumnName && this.m_showMetadataName && !this.m_showDescription) {
            return this.getFormattedLabel(1, 2, column);
        }
        if (this.m_showColumnName && !this.m_showMetadataName && this.m_showDescription) {
            return this.getFormattedLabel(1, 4, column);
        }
        if (!this.m_showColumnName && this.m_showMetadataName && this.m_showDescription) {
            return this.getFormattedLabel(2, 4, column);
        }
        if (this.m_showColumnName && this.m_showMetadataName && this.m_showDescription) {
            return this.getFormattedLabel(1, 2, 4, column);
        }
        return this.getFormattedLabel(1, column);
    }

    private String getFormattedLabel(int option1, Column col) {
        String s = this.getLabelForOption(option1, col);
        if (s == null || "".equals(s)) {
            s = this.getLabelForOption(1, col);
        }
        return s;
    }

    private String getFormattedLabel(int option1, int option2, Column col) {
        return this.getLabelForOption(option1, col) + " (" + this.getLabelForOption(option2, col) + ")";
    }

    private String getFormattedLabel(int option1, int option2, int option3, Column col) {
        return this.getLabelForOption(option1, col) + " (" + this.getLabelForOption(option2, col) + ": " + this.getLabelForOption(option3, col) + ")";
    }

    private String getLabelForOption(int option, Column col) {
        try {
            switch (option) {
                case 1: {
                    return col.getSASColumnName();
                }
                case 2: {
                    return col.getName();
                }
                case 4: {
                    return col.getDesc();
                }
            }
            return col.getSASColumnName();
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
            return "";
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertyChangeListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertyChangeListeners.remove(listener);
    }

    public void notifyFormatChange() {
        for (int i = 0; i < this.m_propertyChangeListeners.size(); ++i) {
            ((PropertyChangeListener)this.m_propertyChangeListeners.get(i)).propertyChange(new PropertyChangeEvent(this, PROPERTY_DISPLAY_FORMAT, null, null));
        }
    }
}

