/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.validate;

import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.ITransform;
import com.sas.wadmin.validate.ValidateEvent;
import com.sas.wadmin.validate.ValidateModelEvent;
import com.sas.wadmin.validate.ValidateModelListener;
import com.sas.wadmin.validate.ValidateResults;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.models.SimpleObject;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class ValidateModel {
    private static final WAdminResource bundle = WAdminResource.getBundle(ValidateModel.class);
    public static final String AFFILIATE_CHANGED = "AffiliatedChanged";
    public static final String SAS_APP_SERVER_CHANGED = "AppServerChanged";
    public static final String CODE_SEGMENTS_CHANGED = "CodeSegmentsChanged";
    public static final String VALIDATE_STATE_CHANGED = "ValidateStateChanged";
    public static final String CURRENT_CODE_SEGMENT_CHANGED = "CurrentCodeSegmentChanged";
    public static final String MODEL_DISPOSED = "ModelDisposed";
    public static final int INACTIVE = 0;
    public static final int VALIDATING = 1;
    public static final int STOPPING = 2;
    private SimpleObject m_affiliate;
    private WsAppServer m_srvr;
    private ICodeSegment[] m_aCodeSegments;
    private List m_lListeners = new ArrayList();
    private int m_eState = 0;
    private int m_iCurrentSegment;
    private boolean m_bStopParsing = false;
    private Thread m_thrParsing = null;
    private Object m_lock = new Object();
    private List m_lParseWork = new ArrayList();

    ValidateModel() {
    }

    ValidateModel(SimpleObject affiliate) {
        this();
        this.m_affiliate = affiliate;
    }

    public void dispose() {
        if (this.m_lListeners != null) {
            this.fireModelEvent(MODEL_DISPOSED);
        }
        this.m_affiliate = null;
        if (this.m_srvr != null) {
            this.m_srvr.close();
        }
        this.m_srvr = null;
        this.m_aCodeSegments = null;
        this.m_lListeners = null;
    }

    public void setAffiliate(SimpleObject affiliate) {
        if (this.m_affiliate == affiliate) {
            return;
        }
        this.m_affiliate = affiliate;
        this.fireModelEvent(AFFILIATE_CHANGED);
    }

    public SimpleObject getAffiliate() {
        return this.m_affiliate;
    }

    public void setSASAppServer(WsAppServer srvr) {
        if (this.m_srvr == srvr) {
            return;
        }
        this.m_srvr = srvr;
        this.fireModelEvent(SAS_APP_SERVER_CHANGED);
    }

    public WsAppServer getSASAppServer() {
        return this.m_srvr;
    }

    public void setCodeSegments(ICodeSegment[] aCodeSegments) {
        this.m_aCodeSegments = aCodeSegments;
        this.fireModelEvent(CODE_SEGMENTS_CHANGED);
        this.setCurrentCodeSegment(0);
    }

    public ICodeSegment[] getCodeSegments() {
        return this.m_aCodeSegments;
    }

    private void setValidateState(int eState) {
        if (this.m_eState == eState) {
            return;
        }
        this.m_eState = eState;
        this.fireModelEvent(VALIDATE_STATE_CHANGED);
    }

    public int getValidateState() {
        return this.m_eState;
    }

    public void setCurrentCodeSegment(int iCurrentCodeSegment) {
        if (this.m_aCodeSegments == null) {
            throw new UnsupportedOperationException("There must be code segments before the current code segment can be changed");
        }
        if (iCurrentCodeSegment < 0 || iCurrentCodeSegment > this.m_aCodeSegments.length) {
            throw new IndexOutOfBoundsException("Current code segment must be between 0 and the number of code segments");
        }
        if (this.m_iCurrentSegment == iCurrentCodeSegment) {
            return;
        }
        this.m_iCurrentSegment = iCurrentCodeSegment;
        this.fireModelEvent(CURRENT_CODE_SEGMENT_CHANGED);
    }

    public int getCurrentCodeSegment() {
        return this.m_iCurrentSegment;
    }

    public void addListener(ValidateModelListener lsnr) {
        this.m_lListeners.add(lsnr);
    }

    public void removeListener(ValidateModelListener lsnr) {
        if (this.m_lListeners != null) {
            this.m_lListeners.remove(lsnr);
        }
    }

    public void validate() {
        if (this.m_eState == 1) {
            throw new UnsupportedOperationException("Can not validate while waiting for Validate to complete");
        }
        if (this.m_srvr == null || !this.m_srvr.isSASCodeSessionOpen()) {
            throw new UnsupportedOperationException("Can not validate with out a SAS application server that has an open SAS code session");
        }
        if (this.m_aCodeSegments == null || this.m_aCodeSegments.length == 0) {
            throw new UnsupportedOperationException("Can not validate when there are no code segments to be validated.");
        }
        this.setValidateState(1);
        new ValidateSASCodeThread().start();
    }

    public void stop() {
        if (this.m_eState == 0) {
            return;
        }
        if (this.m_eState == 1) {
            this.setValidateState(2);
            this.m_srvr.kill();
            this.fireValidateEvent("ValidateStopped");
            this.setValidateState(0);
        } else {
            this.fireValidateEvent("ValidateStopped");
            this.setValidateState(0);
            this.setCurrentCodeSegment(0);
        }
    }

    private void fireValidateEvent(String sEventType) {
        this.fireValidateEvent(new ValidateEvent(this, sEventType));
    }

    private void fireSegmentStartedEvent(ICodeSegment code) {
        this.fireValidateEvent(new ValidateEvent(this, "SegmentStarted", code));
    }

    private void fireSegmentParsingEvent(ICodeSegment code, ValidateResults results) {
        this.fireValidateEvent(new ValidateEvent(this, "SegmentParsing", code, results));
    }

    private void fireSegmentCompletedEvent(ICodeSegment code, ValidateResults results) {
        this.fireValidateEvent(new ValidateEvent(this, "SegmentCompleted", code, results));
    }

    private void fireValidateEvent(String sEventType, ICodeSegment code, ValidateResults results, WsAppServerFailException ex) {
        this.fireValidateEvent(new ValidateEvent(this, sEventType, code, results, ex));
    }

    private void fireValidateEvent(ValidateEvent ev) {
        Workspace.getDefaultLogger().debug((Object)("ValidateEvent:" + ev.getType()));
        SwingUtilities.invokeLater(new FireValidateEventRunnable(ev));
    }

    private void fireModelEvent(String sEventType) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new FireModelEventRunnable(sEventType));
            return;
        }
        Workspace.getDefaultLogger().debug((Object)("ValidateModelEvent:" + sEventType));
        ValidateModelEvent ev = new ValidateModelEvent(this, sEventType);
        for (int iListener = 0; iListener < this.m_lListeners.size(); ++iListener) {
            ValidateModelListener lsnr = (ValidateModelListener)this.m_lListeners.get(iListener);
            lsnr.modelChanged(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addParseWork(ValidateResults results) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_lParseWork.add(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidateResults getParseWork() {
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_lParseWork.isEmpty()) {
                return null;
            }
            return (ValidateResults)this.m_lParseWork.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearParseWork() {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_lParseWork.clear();
        }
    }

    private class ValidateSASCodeThread
    extends Thread {
        public ValidateSASCodeThread() {
            super("Validate SAS Code");
        }

        @Override
        public void run() {
            if (ValidateModel.this.m_iCurrentSegment == 0) {
                ValidateModel.this.m_bStopParsing = true;
                while (ValidateModel.this.m_thrParsing != null && ValidateModel.this.m_thrParsing.isAlive()) {
                    try {
                        ValidateSASCodeThread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                ValidateModel.this.m_bStopParsing = false;
                ValidateModel.this.clearParseWork();
                ValidateModel.this.m_thrParsing = new ParseSASLogThread();
                ValidateModel.this.m_thrParsing.start();
                ValidateModel.this.fireValidateEvent("ValidateStarted");
            }
            ICodeSegment segment = null;
            ValidateResults results = null;
            try {
                while (true) {
                    segment = ValidateModel.this.m_aCodeSegments[ValidateModel.this.m_iCurrentSegment];
                    results = new ValidateResults();
                    results.setModelObject(segment.getModelObject());
                    ValidateModel.this.fireSegmentStartedEvent(segment);
                    results.setStartTime(System.currentTimeMillis());
                    try {
                        ValidateModel.this.m_srvr.submitSASCode(segment.toString());
                    }
                    catch (WsAppServerCodeException ex) {
                        results.setStatus(2);
                    }
                    results.setStopTime(System.currentTimeMillis());
                    results.setLog(ValidateModel.this.m_srvr.getLog());
                    results.setOutput(ValidateModel.this.m_srvr.getOutput());
                    try {
                        if (((ITransform)segment.getModelObject()).isValidateAvailable() && !((ITransform)segment.getModelObject()).isExplicitOn()) {
                            String sqlip = ValidateModel.this.m_srvr.getMacroVariableValue("etls_sql_pushDown");
                            results.setPushDown(sqlip != null ? sqlip : "-1");
                            ((IDataTransform)segment.getModelObject()).updateDBMSExecutionType();
                            results.setPushDownDBMSType(((IDataTransform)segment.getModelObject()).getDBMSExecutionTypeName());
                        } else {
                            results.setPushDown(null);
                            results.setPushDownDBMSType("SAS");
                        }
                    }
                    catch (WsAppServerFailException sqlip) {
                    }
                    catch (SQLException sqlip) {
                        // empty catch block
                    }
                    boolean bLastSegment = ValidateModel.this.m_iCurrentSegment == ValidateModel.this.m_aCodeSegments.length - 1;
                    ValidateModel.this.addParseWork(results);
                    ValidateModel.this.fireSegmentParsingEvent(segment, results);
                    if (bLastSegment) break;
                    ValidateModel.this.setCurrentCodeSegment(ValidateModel.this.m_iCurrentSegment + 1);
                }
                return;
            }
            catch (WsAppServerFailException ex) {
                if (ValidateModel.this.m_eState != 0) {
                    String sEventType = null;
                    if (ValidateModel.this.m_eState == 2) {
                        sEventType = "ValidateStopped";
                    }
                    ValidateModel.this.fireValidateEvent(sEventType, segment, results, ex);
                    ValidateModel.this.setValidateState(0);
                }
                ValidateModel.this.setCurrentCodeSegment(0);
                return;
            }
        }
    }

    private class ParseSASLogThread
    extends Thread {
        private int m_iParsingSegment;

        public ParseSASLogThread() {
            super("parsing SAS log");
            this.setPriority(1);
            this.m_iParsingSegment = 0;
        }

        @Override
        public void run() {
            while (ValidateModel.this.m_aCodeSegments != null && this.m_iParsingSegment < ValidateModel.this.m_aCodeSegments.length && ValidateModel.this.m_eState == 1 && !ValidateModel.this.m_bStopParsing) {
                ValidateResults results = ValidateModel.this.getParseWork();
                if (results == null) {
                    try {
                        ParseSASLogThread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                results.parseLog();
                ValidateModel.this.fireSegmentCompletedEvent(ValidateModel.this.m_aCodeSegments[this.m_iParsingSegment], results);
                if (this.m_iParsingSegment == ValidateModel.this.m_aCodeSegments.length - 1) {
                    ValidateModel.this.fireValidateEvent("ValidateCompleted");
                    ValidateModel.this.setValidateState(0);
                    ValidateModel.this.setCurrentCodeSegment(0);
                    continue;
                }
                ++this.m_iParsingSegment;
            }
        }
    }

    private class FireModelEventRunnable
    implements Runnable {
        private String m_sEventType;

        FireModelEventRunnable(String sEventType) {
            this.m_sEventType = sEventType;
        }

        @Override
        public void run() {
            ValidateModel.this.fireModelEvent(this.m_sEventType);
        }
    }

    private class FireValidateEventRunnable
    implements Runnable {
        private ValidateEvent m_event;

        FireValidateEventRunnable(ValidateEvent event) {
            this.m_event = event;
        }

        @Override
        public void run() {
            for (int iListener = 0; iListener < ValidateModel.this.m_lListeners.size(); ++iListener) {
                ValidateModelListener lsnr = (ValidateModelListener)ValidateModel.this.m_lListeners.get(iListener);
                lsnr.validateEventHappened(this.m_event);
            }
        }
    }
}

