/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.validate;

import com.sas.etl.models.job.ICodeSegment;
import com.sas.wadmin.validate.ValidateModel;
import com.sas.wadmin.validate.ValidateResults;
import com.sas.workspace.WsAppServerFailException;
import java.util.EventObject;

public class ValidateEvent
extends EventObject {
    public static final String VALIDATE_STARTED = "ValidateStarted";
    public static final String SEGMENT_STARTED = "SegmentStarted";
    public static final String SEGMENT_PARSING = "SegmentParsing";
    public static final String SEGMENT_COMPLETED = "SegmentCompleted";
    public static final String SEGMENT_PUSHED_DOWN = "SegmentPushedDown";
    public static final String VALIDATE_COMPLETED = "ValidateCompleted";
    public static final String VALIDATE_STOPPED = "ValidateStopped";
    private String m_sType;
    private ICodeSegment m_codeSegment;
    private ValidateResults m_results;
    private WsAppServerFailException m_exception;
    private long m_time;

    public ValidateEvent(ValidateModel mdl, String sType) {
        this(mdl, sType, null);
    }

    public ValidateEvent(ValidateModel mdl, String sType, ICodeSegment code) {
        this(mdl, sType, code, null);
    }

    public ValidateEvent(ValidateModel mdl, String sType, ICodeSegment code, ValidateResults results) {
        this(mdl, sType, code, results, null);
    }

    public ValidateEvent(ValidateModel mdl, String sType, ICodeSegment code, ValidateResults results, WsAppServerFailException ex) {
        super(mdl);
        this.m_time = results != null ? results.getStopTime() : System.currentTimeMillis();
        this.m_sType = sType;
        this.m_codeSegment = code;
        this.m_results = results;
        this.m_exception = ex;
    }

    public String getType() {
        return this.m_sType;
    }

    public ICodeSegment getCodeSegment() {
        return this.m_codeSegment;
    }

    public ValidateResults getResults() {
        return this.m_results;
    }

    public WsAppServerFailException getException() {
        return this.m_exception;
    }

    public long getTime() {
        return this.m_time;
    }
}

