/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.teradataloader;

import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.TableLoaderTransformModel;
import com.sas.etl.models.job.transforms.TeradataTableLoaderTransformModel;
import com.sas.wadmin.transforms.loader.NameValueComboBoxModel;
import com.sas.wadmin.transforms.loader.TableLoader42LoadTechniquePropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class TeradataLoaderLoadTechniqueTab
extends TableLoader42LoadTechniquePropertyTab {
    private static final WAdminResource m_bundle = WAdminResource.getBundle(TeradataLoaderLoadTechniqueTab.class);
    protected JCheckBox m_chkUseTPTUtilities;
    protected JCheckBox m_chkSupportRestart;
    private cUseTPTUtilitiesListener m_chkUseTPTUtilitiesListener;
    private cSupportRestartListener m_chkSupportRestartListener;

    public TeradataLoaderLoadTechniqueTab(TeradataTableLoaderTransformModel obj) {
        super((TableLoaderTransformModel)obj);
        this.setHelpTopic("load_technique_tera");
    }

    private TeradataTableLoaderTransformModel getTeradataModel() {
        return (TeradataTableLoaderTransformModel)this.m_model;
    }

    @Override
    protected NameValueComboBoxModel createNewComboModel(String name, boolean sorted) {
        return new NameValueComboBoxModel(m_bundle, "TeradataLoaderLoadTechniqueTab." + name, sorted);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.m_chkUseTPTUtilities = WsUIUtilities.createCheckBox((WAdminResource)m_bundle, (String)"TeradataTableLoader.UseTPTUtilities", (int)5);
        this.m_chkUseTPTUtilitiesListener = new cUseTPTUtilitiesListener();
        this.m_chkUseTPTUtilities.addActionListener(this.m_chkUseTPTUtilitiesListener);
        this.listenForDataChangesTo(this.m_chkUseTPTUtilities);
        this.m_chkSupportRestart = WsUIUtilities.createCheckBox((WAdminResource)m_bundle, (String)"TeradataTableLoader.SupportRestart", (int)5);
        this.m_chkSupportRestartListener = new cSupportRestartListener();
        this.m_chkSupportRestart.addActionListener(this.m_chkSupportRestartListener);
        this.listenForDataChangesTo(this.m_chkSupportRestart);
    }

    @Override
    protected void initializeLayout() {
        this.setLayout(new GridBagLayout());
        JPanel style = new JPanel();
        style.setLayout(new GridBagLayout());
        style.add((Component)this.createLoadStylePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        style.add((Component)this.createReplaceTypePanel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(style, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.createTeradataOptionsPanel(), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.createConstraintConditionPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.createIndexConditionPanel(), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.createUpdateLayoutPanel(), new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.createResetPanel(), new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 14, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected JPanel createTeradataOptionsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(Box.createVerticalStrut(5));
        panel.add(this.m_chkUseTPTUtilities);
        panel.add(this.m_chkSupportRestart);
        panel.add(Box.createVerticalStrut(5));
        return panel;
    }

    @Override
    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        bEditable = bEditable && this.m_model.getDataTargetsCount() > 0;
        this.m_chkUseTPTUtilities.setEnabled(bEditable && this.getTeradataModel().isUsingTPTUtilitiesSupported());
    }

    @Override
    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_chkUseTPTUtilities.removeActionListener(this.m_chkUseTPTUtilitiesListener);
        this.m_chkSupportRestart.removeActionListener(this.m_chkSupportRestartListener);
    }

    @Override
    public void moveDataToView() {
        this.setListeningForChanges(false);
        this.m_chkUseTPTUtilities.setSelected(this.getTeradataModel().isTPTEnabled());
        this.m_chkSupportRestart.setSelected(this.getTeradataModel().isCheckpointEnabled());
        this.m_chkUseTPTUtilities.setEnabled(this.isEditable() && this.getTeradataModel().isUsingTPTUtilitiesSupported());
        super.moveDataToView();
        this.setListeningForChanges(true);
    }

    @Override
    protected void handleModelChanged(ModelEvent ev) {
        String type = ev.getType();
        if (type.equals("TeradataTableLoaderModel:TPTUtilitiesChanged")) {
            Workspace.getDefaultLogger().debug((Object)"CHECK: USE_TPT_UTILITIES_CHANGED event");
            this.handleUseTPTUtilitiesChanged();
        } else if (type.equals("ITransform:CheckpointEnabledChanged")) {
            Workspace.getDefaultLogger().debug((Object)"CHECK: CHECKPOINT_ENABLED_CHANGED event");
            this.handleCheckpointEnabledChanged();
        } else {
            super.handleModelChanged(ev);
        }
    }

    protected void handleUseTPTUtilitiesChanged() {
        this.m_chkUseTPTUtilities.setSelected(this.getTeradataModel().isTPTEnabled());
    }

    protected void handleCheckpointEnabledChanged() {
        this.m_chkSupportRestart.setSelected(this.getTeradataModel().isCheckpointEnabled());
    }

    @Override
    protected void handleLoadStyleChanged() {
        super.handleLoadStyleChanged();
        this.m_chkUseTPTUtilities.setEnabled(this.isEditable() && this.getTeradataModel().isUsingTPTUtilitiesSupported());
    }

    private class cSupportRestartListener
    implements ActionListener {
        private cSupportRestartListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            TeradataLoaderLoadTechniqueTab.this.getTeradataModel().setCheckpointEnabled(TeradataLoaderLoadTechniqueTab.this.m_chkSupportRestart.isSelected());
        }
    }

    private class cUseTPTUtilitiesListener
    implements ActionListener {
        private cUseTPTUtilitiesListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            TeradataLoaderLoadTechniqueTab.this.getTeradataModel().setUseTPTUtilities(TeradataLoaderLoadTechniqueTab.this.m_chkUseTPTUtilities.isSelected());
        }
    }
}

