/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.tablemaintenance;

import com.sas.etl.models.job.transforms.tablemaintenance.TableMaintenanceTransformModel;
import com.sas.etl.models.job.transforms.tablemaintenance.TableStatement;
import com.sas.metadata.remote.MdException;
import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.transforms.tablemaintenance.StatementDetailsPanel;
import com.sas.wadmin.transforms.tablemaintenance.StatementModel;
import com.sas.wadmin.transforms.tablemaintenance.TableIconFactory;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDefaultTableRowModel;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsTableRowModelEvent;
import com.sas.workspace.WsTableRowModelListener;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;

public class StatementPropertyTab
extends WAPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(StatementPropertyTab.class);
    private static final String SPLIT_DETAILS_PANE_DIV_LOC = "HiveCodeSplitPanelLocation";
    private static final int UP = 0;
    private static final int DOWN = 1;
    protected TableMaintenanceTransformModel m_model;
    private StatementModel m_mdlStatements;
    private JToolBar m_tools;
    private JScrollPane m_scrStatements;
    private WsTable m_tblStatements;
    private JSplitPane m_splitPane;
    private boolean m_layoutComplete;
    private WsAbstractAction m_actMoveUp;
    private WsAbstractAction m_actMoveDown;
    private WsAbstractAction m_actRemove;
    private WsAbstractAction m_actAdd;
    private StatementDetailsPanel m_details;
    private TableModelListener m_tblMdlListener;
    private boolean m_bInMove = false;
    private int _lastSelection = -1;

    public StatementPropertyTab(TableMaintenanceTransformModel model) {
        this.setName(bundle.getString("StatementPropertyTab.Title.txt"));
        this.m_model = model;
        this.setHelpProduct("wdb");
        this.setHelpTopic("table_statement_tab");
        this.initialize();
    }

    public void initialize() {
        this.m_tblMdlListener = new TableModelListener();
        this.m_mdlStatements = new StatementModel(this.m_model);
        this.m_mdlStatements.addTableModelListener(this.m_tblMdlListener);
        this.m_details = new StatementDetailsPanel(this.m_model, null);
        this.m_details.setBorder(WsUIUtilities.createTitledBorder((String)bundle.getString("StatementPropertyTab.DetailsPanel.Title.txt")));
        this.setLayout(new GridBagLayout());
        this.createActions();
        this.createToolBar();
        this.createTable();
        JPanel statements = new JPanel();
        statements.setLayout(new GridBagLayout());
        JLabel slbl = WsUIUtilities.createLabelForComponent((JComponent)this.m_scrStatements, (String)bundle.getString("StatementPropertyTab.Statements.txt"));
        slbl.setToolTipText(bundle.getString("StatementPropertyTab.Statements.ToolTip.txt"));
        statements.add((Component)slbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        statements.add((Component)this.m_tools, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        statements.add((Component)this.m_scrStatements, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_splitPane = new JSplitPane(0, true);
        this.m_splitPane.setTopComponent(statements);
        this.m_splitPane.setBottomComponent((Component)((Object)this.m_details));
        this.add(this.m_splitPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void doLayout() {
        if (!this.m_layoutComplete) {
            WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
            this.m_splitPane.setDividerLocation(appDefaults.getPropertyInt(SPLIT_DETAILS_PANE_DIV_LOC, 100));
            this.m_splitPane.setResizeWeight(0.5);
            this.m_layoutComplete = true;
        }
        super.doLayout();
    }

    private void createTable() {
        this.m_tblStatements = new WsTable((WsAbstractTableModel)this.m_mdlStatements);
        this.m_scrStatements = new JScrollPane((Component)this.m_tblStatements);
        this.m_tblStatements.setSortingEnabled(false);
        this.m_tblStatements.setAutoResizeMode(3);
        this.m_tblStatements.setRowSelectionAllowed(true);
        this.m_tblStatements.setSelectionMode(0);
        this.m_tblStatements.setCellSelectionEnabled(false);
        TablePopupMenuListener lsnrPopup = new TablePopupMenuListener();
        this.m_tblStatements.setTablePopupMenuRequestListener((WsPopupMenuRequestListener)lsnrPopup);
        this.m_tblStatements.setRowHeaderPopupMenuRequestListener((WsPopupMenuRequestListener)lsnrPopup);
        TableSelectionListener listnr = new TableSelectionListener();
        this.m_tblStatements.getRowModel().getSelectionModel().addListSelectionListener(listnr);
        ((WsDefaultTableRowModel)this.m_tblStatements.getRowModel()).addRowModelListener((WsTableRowModelListener)new RowModelListener());
        this.m_tblStatements.setDeleteKeyAction((Action)this.m_actRemove);
    }

    private void createActions() {
        this.m_actMoveUp = new MoveUpAction();
        this.m_actMoveDown = new MoveDownAction();
        this.m_actRemove = new DeleteStatementAction();
        this.m_actAdd = new AddStatementAction();
    }

    private void createToolBar() {
        this.m_tools = WsUIUtilities.createToolBar();
        this.m_tools.add(WsUIUtilities.createFlatTextIconButton((WsAbstractAction)this.m_actAdd));
        this.m_tools.addSeparator();
        this.m_tools.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actMoveUp));
        this.m_tools.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actMoveDown));
        this.m_tools.addSeparator();
        this.m_tools.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actRemove));
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_details.setEditable(bEditable);
        this.m_actAdd.setEnabled(bEditable);
        this.m_actMoveDown.setEnabled(bEditable);
        this.m_actMoveUp.setEnabled(bEditable);
        this.m_actRemove.setEnabled(bEditable);
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyInt(SPLIT_DETAILS_PANE_DIV_LOC, this.m_splitPane.getDividerLocation());
        this.m_details.saveSettingsAndCleanUp();
    }

    public boolean validateData() {
        if (this.m_bInMove) {
            return true;
        }
        return this.m_details.validateData();
    }

    public void populateStore() throws MdException, RemoteException {
        this.m_details.populateStore();
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this._lastSelection = this.m_tblStatements.getSelectedRow();
        this.m_details.moveDataToStore();
    }

    public void moveDataToView() {
        boolean listen = this.m_tblMdlListener.isListening();
        this.m_tblMdlListener.setListening(false);
        try {
            this.m_mdlStatements.moveDataToModel();
            if (this._lastSelection < 0 && this.m_tblStatements.getRowCount() > 0) {
                this.m_tblStatements.selectRow(0);
            } else {
                this.m_tblStatements.selectRow(this._lastSelection);
            }
            this.updateSelectedStatement();
        }
        finally {
            this.m_tblMdlListener.setListening(listen);
        }
    }

    protected void updateSelectedStatement() {
        this.updateActions();
        int aRow = this.m_tblStatements.getSelectedRow();
        TableStatement transform = null;
        if (aRow > -1) {
            transform = (TableStatement)this.m_mdlStatements.getValueAt(this.m_tblStatements.convertRowIndexToModel(aRow), 4);
        }
        this.m_details.setStatement(transform);
    }

    private void setSelectedRow(int row) {
        this.m_tblStatements.selectRow(row);
        this.updateSelectedStatement();
    }

    private void updateActions() {
        int row = this.m_tblStatements.getSelectedRow();
        boolean bEditable = this.isEditable();
        this.m_actAdd.setEnabled(bEditable);
        this.m_actMoveDown.setEnabled(bEditable && row < this.m_tblStatements.getRowCount() - 1);
        this.m_actMoveUp.setEnabled(bEditable && row > 0);
        this.m_actRemove.setEnabled(bEditable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveSelectedStatements(int eDir) {
        if (eDir != 0 && eDir != 1) {
            throw new IllegalArgumentException("Direction must be UP or DOWN but is: " + eDir);
        }
        if (!this.m_tblStatements.stopCellEditing()) {
            return;
        }
        this.m_model.getModel().startCompoundUndoable();
        try {
            int[] aRows = this.m_tblStatements.getSelectedRowsFromSelectedCells();
            this.m_tblStatements.clearSelection();
            this.m_model.getModel().undoableEditHappened(this.m_tblStatements.createSelectRowsUndoable(aRows, true));
            List lTransforms = this.m_model.getStatementList();
            if (eDir == 1) {
                for (int iRow = aRows.length - 1; iRow >= 0; --iRow) {
                    TableStatement transform = this.m_mdlStatements.getStatementForRow(aRows[iRow]);
                    lTransforms.remove(transform);
                    int n = iRow;
                    aRows[n] = aRows[n] + 1;
                    lTransforms.add(aRows[iRow], transform);
                }
            } else {
                for (int iRow = 0; iRow < aRows.length; ++iRow) {
                    TableStatement transform = this.m_mdlStatements.getStatementForRow(aRows[iRow]);
                    lTransforms.remove(transform);
                    int n = iRow;
                    aRows[n] = aRows[n] - 1;
                    lTransforms.add(aRows[iRow], transform);
                }
            }
            this.m_tblStatements.selectRows(aRows);
            this.m_model.getModel().undoableEditHappened(this.m_tblStatements.createSelectRowsUndoable(aRows, false));
        }
        finally {
            this.m_model.getModel().endCompoundUndoable();
            this.updateSelectedStatement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSelectedStatements() {
        this.m_model.getModel().startCompoundUndoable();
        try {
            int[] selectedRows = this.m_tblStatements.getSelectedRowsFromSelectedCells();
            int i = 0;
            if (i < selectedRows.length) {
                TableStatement obj = this.m_mdlStatements.getStatementForRow(selectedRows[i]);
                this.m_model.removeStatement(obj);
                if (selectedRows[i] - 1 >= 0) {
                    this.m_tblStatements.selectRow(selectedRows[i] - 1);
                }
            }
            this.updateSelectedStatement();
        }
        finally {
            this.m_model.getModel().endCompoundUndoable();
        }
    }

    private void createNewStatement() {
        this.m_model.getModel().startCompoundUndoable();
        try {
            TableStatement statement = new TableStatement(this.m_model.getModel().createIDForNewObject(this.m_model.getID()), this.m_model.getModel());
            statement.setName(this.m_model.getNewStatementName());
            this.m_model.addStatement(statement);
            statement.setTransformModel(this.m_model);
        }
        finally {
            this.m_model.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveStatement(int iFrom, int iTo) {
        if (!this.m_tblStatements.stopCellEditing()) {
            return;
        }
        this.m_model.getModel().startCompoundUndoable();
        try {
            this.m_model.getModel().undoableEditHappened(this.m_tblStatements.createSelectRowUndoable(iFrom, true));
            this.m_tblStatements.clearSelection();
            TableStatement xfm = this.m_mdlStatements.getStatementForRow(iFrom);
            List lExecution = this.m_model.getStatementList();
            boolean bInExecution = lExecution.contains(xfm);
            if (bInExecution) {
                lExecution.remove(xfm);
            }
            if (iTo <= lExecution.size()) {
                lExecution.add(iTo, xfm);
            }
            this.m_tblStatements.selectRow(iTo);
            this.m_model.getModel().undoableEditHappened(this.m_tblStatements.createSelectRowUndoable(iTo, false));
        }
        finally {
            this.m_model.getModel().endCompoundUndoable();
        }
    }

    private class TableModelListener
    implements javax.swing.event.TableModelListener {
        private boolean m_isListening = true;

        private TableModelListener() {
        }

        public boolean isListening() {
            return this.m_isListening;
        }

        public void setListening(boolean listen) {
            this.m_isListening = listen;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (!this.m_isListening) {
                return;
            }
            if (e.getType() == 1) {
                StatementPropertyTab.this.setSelectedRow(e.getFirstRow());
            } else if (e.getType() == -1 && e.getFirstRow() - 1 >= 0) {
                StatementPropertyTab.this.setSelectedRow(e.getFirstRow() - 1);
            }
        }
    }

    private class MoveDownAction
    extends WsAbstractAction {
        public MoveDownAction() {
            super(bundle, "Statement.Action.MoveDown", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:MoveDown"));
        }

        public void actionPerformed(ActionEvent ev) {
            int[] aRows = StatementPropertyTab.this.m_tblStatements.getSelectedRowsFromSelectedCells();
            int iFrom = aRows[0];
            int iTo = iFrom + 1;
            StatementPropertyTab.this.m_bInMove = true;
            StatementPropertyTab.this.moveStatement(iFrom, iTo);
            StatementPropertyTab.this.m_bInMove = false;
        }
    }

    private class MoveUpAction
    extends WsAbstractAction {
        public MoveUpAction() {
            super(bundle, "Statement.Action.MoveUp", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:MoveUp"));
        }

        public void actionPerformed(ActionEvent ev) {
            int[] aRows = StatementPropertyTab.this.m_tblStatements.getSelectedRowsFromSelectedCells();
            int iFrom = aRows[0];
            int iTo = iFrom - 1;
            StatementPropertyTab.this.m_bInMove = true;
            StatementPropertyTab.this.moveStatement(iFrom, iTo);
            StatementPropertyTab.this.m_bInMove = false;
        }
    }

    private class DeleteStatementAction
    extends WsAbstractAction {
        public DeleteStatementAction() {
            super(bundle, "Statement.Action.Delete", 0);
            this.setIcon(TableIconFactory.getInstance().getIcon("TableIconFactory.Delete.image"));
        }

        public void actionPerformed(ActionEvent event) {
            StatementPropertyTab.this.removeSelectedStatements();
        }
    }

    private class AddStatementAction
    extends WsAbstractAction {
        public AddStatementAction() {
            super(bundle, "Statement.Action.New", 0);
            this.setIcon(TableIconFactory.getInstance().getIcon("TableIconFactory.Add.image"));
        }

        public void actionPerformed(ActionEvent event) {
            StatementPropertyTab.this.createNewStatement();
        }
    }

    private class RowModelListener
    implements WsTableRowModelListener {
        private RowModelListener() {
        }

        public void rowDragged(TableRowModelEvent ev) {
            WsDefaultTableRowModel mdlRows = (WsDefaultTableRowModel)StatementPropertyTab.this.m_tblStatements.getRowModel();
            mdlRows.clearRowMoves();
        }

        public void rowsRemapped(ChangeEvent ev) {
        }

        public void rowsHidden(WsTableRowModelEvent ev) {
        }

        public void rowsShown(WsTableRowModelEvent ev) {
        }
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            StatementPropertyTab.this.updateSelectedStatement();
        }
    }

    private class TablePopupMenuListener
    implements WsPopupMenuRequestListener {
        private TablePopupMenuListener() {
        }

        public void popupMenuRequested(MouseEvent ev) {
            JPopupMenu mnuPopup = new JPopupMenu();
            mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)StatementPropertyTab.this.m_actAdd));
            mnuPopup.addSeparator();
            mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)StatementPropertyTab.this.m_actMoveUp));
            mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)StatementPropertyTab.this.m_actMoveDown));
            mnuPopup.addSeparator();
            mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)StatementPropertyTab.this.m_actRemove));
            mnuPopup.show((Component)ev.getSource(), ev.getX(), ev.getY());
        }
    }
}

