/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.tablemaintenance;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.tablemaintenance.TableMaintenanceTransformModel;
import com.sas.etl.models.job.transforms.tablemaintenance.TableStatement;
import com.sas.metadata.remote.MdException;
import com.sas.table.StaticRowLabelInterface;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsBooleanTableColumn;
import com.sas.workspace.WsIconTableColumn;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.models.SimpleObject;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class StatementModel
extends WsAbstractTableModel
implements StaticRowLabelInterface {
    private static final WAdminResource bundle = WAdminResource.getBundle(StatementModel.class);
    private static final int VISIBLE_COLUMNS = 4;
    private static final int HIDDEN_COLUMNS = 2;
    public static final int NAME_COLUMN = 0;
    public static final int DESCRIPTION_COLUMN = 1;
    public static final int TARGET_COLUMN = 2;
    public static final int PASSTHRU_COLUMN = 3;
    public static final int STATEMENT_COLUMN = 4;
    public static final int TARGET_ICON_COLUMN = 5;
    private static final int NAME_WIDTH = 100;
    private static final int DESCRIPTION_WIDTH = 150;
    private static final int TARGET_WIDTH = 100;
    private static final int PASSTHRU_WIDTH = 50;
    private IModelListener m_lsnrModel;
    private TableMaintenanceTransformModel m_model;

    public StatementModel(TableMaintenanceTransformModel model) {
        this.m_model = model;
        this.m_lsnrModel = new ModelListener();
        this.m_model.getModel().addModelListener(this.m_lsnrModel);
        this.createColumnDefinitions();
    }

    public void dispose() {
        this.m_model.getModel().removeModelListener(this.m_lsnrModel);
    }

    private void createColumnDefinitions() {
        WsStringTableColumn colName = new WsStringTableColumn(0, bundle.getString("Statement.Name.txt"), 100);
        WsStringTableColumn colDescription = new WsStringTableColumn(1, bundle.getString("Statement.Description.txt"), 150);
        WsStringTableColumn colTarget = new WsStringTableColumn(2, bundle.getString("Statement.Target.txt"), 100);
        WsBooleanTableColumn colDeleteTable = new WsBooleanTableColumn(3, bundle.getString("Statement.PassThru.txt"), 50);
        colDeleteTable.setEditable(false);
        WsObjectTableColumn colStatement = new WsObjectTableColumn();
        WsIconTableColumn colTargetIcon = new WsIconTableColumn();
        colTarget.setIconColumn(5);
        colName.setEditable(false);
        colDescription.setEditable(false);
        colTarget.setEditable(false);
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = colName;
        this.m_aColumns[1] = colDescription;
        this.m_aColumns[2] = colTarget;
        this.m_aColumns[3] = colDeleteTable;
        this.m_aColumns[4] = colStatement;
        this.m_aColumns[5] = colTargetIcon;
    }

    public int getColumnCount() {
        return 4;
    }

    public int getHiddenColumnCount() {
        return 2;
    }

    public String getToolTipAt(int iRow, int iColumn) {
        Object value = this.getValueAt(iRow, iColumn);
        if (value instanceof String && value != null && value.toString().length() > 0) {
            return value.toString();
        }
        return null;
    }

    public void moveDataToModel() {
        this.clear();
        for (TableStatement statement : this.m_model.getStatements()) {
            this.m_lData.add(this.createRowValues(statement));
        }
        this.fireTableModelPopulated();
    }

    public void moveDataToStore() {
        throw new UnsupportedOperationException("moveDataToStore is not supported");
    }

    public void populateStore() throws MdException, RemoteException {
        throw new UnsupportedOperationException("populateStore is not supported");
    }

    private List createRowValues(TableStatement statement) {
        ArrayList<Object> lValues = new ArrayList<Object>(6);
        lValues.add(statement.getName());
        lValues.add(statement.getDescription());
        lValues.add(this.getTargetName(statement.getTargetTable()));
        lValues.add(statement.getPassThru());
        lValues.add(statement);
        lValues.add(this.getTargetIcon(statement.getTargetTable()));
        return lValues;
    }

    private String getTargetName(IPhysicalTable target) {
        return target != null ? target.getName() : bundle.getString("StatementDetailsPanel.None.txt");
    }

    private Icon getTargetIcon(IPhysicalTable target) {
        if (target instanceof IWorkTable) {
            return AppIconFactory.getInstance().getIconForPrivateType("Type:WorkTable", 16);
        }
        if (target instanceof IPhysicalTable) {
            return AppIconFactory.getInstance().getIconForSimpleObject((SimpleObject)target);
        }
        return null;
    }

    public Object getRowLabel(int iRow) {
        return null;
    }

    public Object[] getRowLabels(int iStartRow, int nRows) {
        return null;
    }

    public boolean isRowLabelsSupported() {
        return true;
    }

    public boolean isRowsLabelSupported() {
        return true;
    }

    public int getRowIndex(TableStatement statement) {
        for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
            List lValues = (List)this.m_lData.get(iRow);
            TableStatement tr = (TableStatement)lValues.get(4);
            if (tr != statement) continue;
            return iRow;
        }
        return -1;
    }

    public TableStatement getStatementForRow(int iRow) {
        return (TableStatement)this.getValueAt(iRow, 4);
    }

    public int addStatement(TableStatement statement) {
        int iRow = this.m_model.getStatementList().indexOf(statement);
        this.insertRow(iRow - 1, this.createRowValues(statement));
        return iRow;
    }

    public int addStatementToModel(TableStatement statement) {
        this.m_model.addStatement(statement);
        return this.getRowIndex(statement);
    }

    private int removeStatement(TableStatement statement) {
        int iRow = this.getRowIndex(statement);
        this.deleteRow(iRow);
        return iRow;
    }

    public void removeSelectedTransform(int i) {
        this.removeStatement(this.getStatementForRow(i));
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            TableStatement statement;
            int rowIndex;
            String sType = ev.getType();
            IObject obj = ev.getModelObject();
            if (sType == "ModelController:UnknownChanges") {
                StatementModel.this.moveDataToModel();
            } else if (StatementModel.this.m_model == obj) {
                if ("stmt_added".equals(sType)) {
                    StatementModel.this.addStatement((TableStatement)ev.getData());
                } else if ("stmt_removed".equals(sType)) {
                    StatementModel.this.removeStatement((TableStatement)ev.getData());
                } else if ("stmt_moved".equals(sType)) {
                    StatementModel.this.removeStatement((TableStatement)ev.getData());
                    StatementModel.this.addStatement((TableStatement)ev.getData());
                }
            } else if (obj instanceof TableStatement && (rowIndex = StatementModel.this.getRowIndex(statement = (TableStatement)obj)) > -1) {
                if ("Object:NameChanged".equals(sType)) {
                    StatementModel.this.setValueAt(statement.getName(), rowIndex, 0);
                } else if ("Object:DescriptionChanged".equals(sType)) {
                    StatementModel.this.setValueAt(statement.getDescription(), rowIndex, 1);
                } else if ("targ_table_cd".equals(sType)) {
                    StatementModel.this.setValueAt(StatementModel.this.getTargetName(statement.getTargetTable()), rowIndex, 2);
                    StatementModel.this.setValueAt(StatementModel.this.getTargetIcon(statement.getTargetTable()), rowIndex, 5);
                } else if ("pass_thru_cd".equals(sType)) {
                    StatementModel.this.setValueAt(statement.getPassThru(), rowIndex, 3);
                }
            }
        }
    }
}

