/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.tablemaintenance;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.data.dbmstypes.BaseDBMSType;
import com.sas.etl.models.data.dbmstypes.IDBMSType;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.ICodeGenerationEnvironment;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.tablemaintenance.TableMaintenanceTransformModel;
import com.sas.etl.models.job.transforms.tablemaintenance.TableStatement;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.transforms.tablemaintenance.StatementCodePane;
import com.sas.wadmin.transforms.tablemaintenance.StatementCodePanel;
import com.sas.wadmin.visuals.common.DisplayableItem;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.models.SimpleObject;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class StatementDetailsPanel
extends WAPanel {
    private static final WAdminResource bundle = WAdminResource.getBundle(StatementDetailsPanel.class);
    private static final String NONE = bundle.getString("StatementDetailsPanel.None.txt");
    private TableStatement m_statement;
    private WATextField m_txtName;
    private WATextField m_txtDescription;
    private JCheckBox m_chkGeneratePassThru;
    private IModelListener m_modelListener;
    private StatementCodePanel m_statementCodePanel;
    private TableMaintenanceTransformModel m_transform;
    private WAComboBox m_cmbOutput;
    private DataItemListener m_itemListener;
    private List<DisplayableItem<IPhysicalTable>> m_targets;
    private WsAbstractAction m_actSubmit;
    private JButton m_btnSubmit;

    public StatementDetailsPanel(TableMaintenanceTransformModel transform, TableStatement statement) {
        this.m_transform = transform;
        this.m_statement = statement;
        this.m_targets = new ArrayList<DisplayableItem<IPhysicalTable>>();
        this.initialize();
        this.m_modelListener = new cModelListener();
        this.m_itemListener = new DataItemListener();
        this.setStatement(statement);
    }

    protected void initialize() {
        this.setLayout(new GridBagLayout());
        this.m_statementCodePanel = new StatementCodePanel(null, StatementCodePane.EditorType.SAS);
        this.m_txtName = new WATextField(32);
        this.m_txtName.setMaxCharacters(32);
        JLabel name = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtName, (String)bundle.getString("StatementDetailsPanel.Name.txt"));
        name.setToolTipText(bundle.getString("StatementDetailsPanel.Name.ToolTip.txt"));
        this.m_txtName.addFocusListener((FocusListener)new TextFieldFocusListener());
        this.m_txtDescription = new WATextField(55);
        JLabel desc = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtDescription, (String)bundle.getString("StatementDetailsPanel.Description.txt"));
        desc.setToolTipText(bundle.getString("StatementDetailsPanel.Description.ToolTip.txt"));
        this.m_txtDescription.addFocusListener((FocusListener)new TextFieldFocusListener());
        this.m_chkGeneratePassThru = WsUIUtilities.createCheckBox((WsAbstractToggleAction)new cPassThru());
        this.m_chkGeneratePassThru.addActionListener(new PassThruListener());
        this.m_actSubmit = this.createViewInformationAction();
        this.m_btnSubmit = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actSubmit);
        this.m_cmbOutput = new WAComboBox(false);
        this.m_cmbOutput.setRenderer((ListCellRenderer)new ComboBoxRenderer());
        JLabel outputlbl = WsUIUtilities.createLabelForComponent((JComponent)this.m_cmbOutput, (String)bundle.getString("StatementDetails.Output.txt"));
        outputlbl.setToolTipText(bundle.getString("StatementDetails.Output.ToolTip.txt"));
        this.m_cmbOutput.setPrototypeDisplayValue((Object)"01234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ");
        this.add(name, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_txtName, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add(desc, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
        this.add((Component)this.m_txtDescription, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add(outputlbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.m_cmbOutput, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this.m_chkGeneratePassThru, new GridBagConstraints(4, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 0, 0), 0, 0));
        this.add(this.m_btnSubmit, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 25, 0, 0), 0, 0));
        JLabel codelbl = WsUIUtilities.createLabelForComponent((JComponent)((Object)this.m_statementCodePanel), (String)bundle.getString("StatementPropertyTab.Code.Label.txt"));
        codelbl.setToolTipText(bundle.getString("StatementPropertyTab.Code.Label.ToolTip.txt"));
        this.add(codelbl, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(15, 0, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_statementCodePanel), new GridBagConstraints(0, 3, 5, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    public TableStatement getStatement() {
        return this.m_statement;
    }

    public void setStatement(TableStatement statement) {
        if (this.m_statement == statement) {
            return;
        }
        if (this.m_statement != null) {
            this.m_statement.getModel().removeModelListener(this.m_modelListener);
        }
        this.m_statement = statement;
        this.m_statementCodePanel.setCodeSource(this.m_statement != null ? this.m_statement.getCodeContainer() : null);
        this.m_statementCodePanel.setStatement(this.m_statement);
        this.m_targets = this.getItems(this.m_transform.getAllPhysicalTables());
        this.m_cmbOutput.removeItemListener((ItemListener)this.m_itemListener);
        this.m_cmbOutput.removeAllItems();
        for (DisplayableItem<IPhysicalTable> item : this.m_targets) {
            this.m_cmbOutput.addItem(item);
        }
        this.setSelectedItem(this.m_statement != null ? this.m_statement.getTargetTable() : null);
        if (statement != null) {
            this.m_txtName.setText(statement.getName());
            this.m_txtDescription.setText(statement.getDescription());
            this.m_chkGeneratePassThru.setSelected(statement.getPassThru());
            IPhysicalTable table = this.m_statement.getTargetTable();
            if (table != null) {
                if (!table.getDBMSType().isPassThroughSupported()) {
                    this.m_chkGeneratePassThru.setSelected(false);
                    this.m_chkGeneratePassThru.setEnabled(false);
                } else {
                    this.m_chkGeneratePassThru.setSelected(statement.getPassThru());
                    this.m_chkGeneratePassThru.setEnabled(true);
                }
            }
        } else {
            this.m_txtName.setText("");
            this.m_txtDescription.setText("");
            this.m_chkGeneratePassThru.setSelected(true);
        }
        this.setEditable(this.isEditable());
        this.updateActions();
        this.m_cmbOutput.addItemListener((ItemListener)this.m_itemListener);
        if (this.m_statement != null) {
            this.m_statement.getModel().addModelListener(this.m_modelListener);
        }
    }

    private List<DisplayableItem<IPhysicalTable>> getItems(IPhysicalTable[] tables) {
        ArrayList<DisplayableItem<IPhysicalTable>> items = new ArrayList<DisplayableItem<IPhysicalTable>>();
        DisplayableItem<Object> none = new DisplayableItem<Object>(NONE, null);
        items.add(none);
        if (tables != null) {
            for (IPhysicalTable table : tables) {
                DisplayableItem<IPhysicalTable> item = new DisplayableItem<IPhysicalTable>(table.getName(), table);
                items.add(item);
            }
        }
        return items;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_txtName.setEditable(bEditable && this.m_statement != null);
        this.m_txtDescription.setEditable(bEditable && this.m_statement != null);
        this.m_btnSubmit.setEnabled(bEditable && this.m_statement != null);
        if (this.m_statement != null) {
            IPhysicalTable table = this.m_statement.getTargetTable();
            if (table != null) {
                this.m_chkGeneratePassThru.setEnabled(bEditable && table.getDBMSType().isPassThroughSupported());
            } else {
                this.m_chkGeneratePassThru.setEnabled(bEditable);
            }
        } else {
            this.m_chkGeneratePassThru.setEnabled(bEditable && this.m_statement != null);
        }
        this.m_statementCodePanel.setEditable(bEditable && this.m_statement != null);
        this.m_cmbOutput.setEnabled(bEditable && this.m_statement != null);
    }

    public void updateText() {
        this.m_statementCodePanel.setCodeSource(this.m_statement != null ? this.m_statement.getCodeContainer() : null);
    }

    public void saveSettingsAndCleanUp() {
        if (this.m_statement != null) {
            this.m_statement.getModel().removeModelListener(this.m_modelListener);
        }
        this.m_statementCodePanel.saveSettingsAndCleanUp();
        super.saveSettingsAndCleanUp();
    }

    private void updateActions() {
    }

    public boolean validateData() {
        return super.validateData() && this.m_statementCodePanel.validateData();
    }

    private WsAbstractAction createViewInformationAction() {
        return new cViewInformationAction();
    }

    private DisplayableItem<IPhysicalTable> getTableFromDisplayItems(List<DisplayableItem<IPhysicalTable>> tables, IPhysicalTable table) {
        for (DisplayableItem<IPhysicalTable> h : tables) {
            if (h.getObject() != table) continue;
            return h;
        }
        return null;
    }

    private String getOraclePartitionDiscoveryCode(ICodeSegment cs, IPhysicalTable table, ICodeGenerationEnvironment environment, IServer defaultServer) {
        try {
            StringBuffer libnameStatement = table.getLibrary().getAccessPath(environment, false, null);
            cs.addSourceCode(libnameStatement.toString()).addSourceCode(";\n\n");
        }
        catch (RemoteException e1) {
            e1.printStackTrace();
        }
        catch (MdException e1) {
            e1.printStackTrace();
        }
        catch (BadServerDefinitionException e1) {
            e1.printStackTrace();
        }
        catch (BadLibraryDefinitionException e1) {
            e1.printStackTrace();
        }
        IDBMSType dbType = table.getDBMSType();
        cs.addSourceCode("proc sql;\n").indent();
        try {
            cs.addSourceCode("connect using ").addSourceCode(table.getLibref(defaultServer)).addSourceCode(" as Oracle;\n");
            cs.addSourceCode("\ncreate table work.partition_info as select * from connection to ").addSourceCode(((BaseDBMSType)dbType).getNickName(cs, table)).addSourceCode("\n");
            cs.indent();
            cs.addSourceCode("(select TABLE_NAME,\n");
            cs.addSourceCode("        COMPOSITE,\n");
            cs.addSourceCode("        PARTITION_NAME,\n");
            cs.addSourceCode("        SUBPARTITION_COUNT,\n");
            cs.addSourceCode("        HIGH_VALUE_LENGTH,\n");
            cs.addSourceCode("        PARTITION_POSITION,\n");
            cs.addSourceCode("        TABLESPACE_NAME,\n");
            cs.addSourceCode("        PCT_FREE,\n");
            cs.addSourceCode("        PCT_USED,\n");
            cs.addSourceCode("        INI_TRANS,\n");
            cs.addSourceCode("        MAX_TRANS,\n");
            cs.addSourceCode("        INITIAL_EXTENT,\n");
            cs.addSourceCode("        NEXT_EXTENT,\n");
            cs.addSourceCode("        MIN_EXTENT,\n");
            cs.addSourceCode("        MAX_EXTENT,\n");
            cs.addSourceCode("        COMPOSITE,\n");
            cs.addSourceCode("        PCT_INCREASE,\n");
            cs.addSourceCode("        FREELISTS,\n");
            cs.addSourceCode("        FREELIST_GROUPS,\n");
            cs.addSourceCode("        LOGGING,\n");
            cs.addSourceCode("        NUM_ROWS,\n");
            cs.addSourceCode("        BLOCKS,\n");
            cs.addSourceCode("        EMPTY_BLOCKS,\n");
            cs.addSourceCode("        AVG_SPACE,\n");
            cs.addSourceCode("        CHAIN_CNT,\n");
            cs.addSourceCode("        AVG_ROW_LEN,\n");
            cs.addSourceCode("        SAMPLE_SIZE,\n");
            cs.addSourceCode("        LAST_ANALYZED,\n");
            cs.addSourceCode("        BUFFER_POOL,\n");
            cs.addSourceCode("        GLOBAL_STATS,\n");
            cs.addSourceCode("        USER_STATS\n");
            cs.addSourceCode("from user_tab_partitions\n");
            cs.addSourceCode("where table_name = '").addSourceCode(table.getDBMSTableName(true)).addSourceCode("');\n");
            if (cs.getIndents() > 0) {
                cs.unIndent(1);
            }
            cs.addSourceCode("quit;");
        }
        catch (CodegenException e) {
            e.printStackTrace();
        }
        catch (BadLibraryDefinitionException e) {
            e.printStackTrace();
        }
        return cs.toString();
    }

    private String getOracleTableDiscoveryCode(ICodeSegment cs, IPhysicalTable table, ICodeGenerationEnvironment environment, IServer defaultServer) {
        try {
            StringBuffer libnameStatement = table.getLibrary().getAccessPath(environment, false, null);
            cs.addSourceCode(libnameStatement.toString()).addSourceCode(";\n\n");
        }
        catch (RemoteException e1) {
            e1.printStackTrace();
        }
        catch (MdException e1) {
            e1.printStackTrace();
        }
        catch (BadServerDefinitionException e1) {
            e1.printStackTrace();
        }
        catch (BadLibraryDefinitionException e1) {
            e1.printStackTrace();
        }
        IDBMSType dbType = table.getDBMSType();
        cs.addSourceCode("proc sql;\n").indent();
        try {
            cs.addSourceCode("connect using ").addSourceCode(table.getLibref(defaultServer)).addSourceCode(" as Oracle;\n");
            cs.addSourceCode("\ncreate table work.table_info as select * from connection to ").addSourceCode(((BaseDBMSType)dbType).getNickName(cs, table)).addSourceCode("\n");
            cs.indent();
            cs.addSourceCode("(select TABLE_NAME,\n");
            cs.addSourceCode("        TABLESPACE_NAME,\n");
            cs.addSourceCode("        CLUSTER_NAME,\n");
            cs.addSourceCode("        IOT_NAME,\n");
            cs.addSourceCode("        STATUS,\n");
            cs.addSourceCode("        PCT_FREE,\n");
            cs.addSourceCode("        PCT_USED,\n");
            cs.addSourceCode("        INI_TRANS,\n");
            cs.addSourceCode("        MAX_TRANS,\n");
            cs.addSourceCode("        INITIAL_EXTENT,\n");
            cs.addSourceCode("        NEXT_EXTENT,\n");
            cs.addSourceCode("        MIN_EXTENTS,\n");
            cs.addSourceCode("        MAX_EXTENTS,\n");
            cs.addSourceCode("        PCT_INCREASE,\n");
            cs.addSourceCode("        FREELISTS,\n");
            cs.addSourceCode("        FREELIST_GROUPS,\n");
            cs.addSourceCode("        LOGGING,\n");
            cs.addSourceCode("        BACKED_UP,\n");
            cs.addSourceCode("        NUM_ROWS,\n");
            cs.addSourceCode("        BLOCKS,\n");
            cs.addSourceCode("        EMPTY_BLOCKS,\n");
            cs.addSourceCode("        AVG_SPACE,\n");
            cs.addSourceCode("        CHAIN_CNT,\n");
            cs.addSourceCode("        AVG_ROW_LEN,\n");
            cs.addSourceCode("        AVG_SPACE_FREELIST_BLOCKS,\n");
            cs.addSourceCode("        NUM_FREELIST_BLOCKS,\n");
            cs.addSourceCode("        DEGREE,\n");
            cs.addSourceCode("        INSTANCES,\n");
            cs.addSourceCode("        CACHE,\n");
            cs.addSourceCode("        TABLE_LOCK,\n");
            cs.addSourceCode("        SAMPLE_SIZE,\n");
            cs.addSourceCode("        LAST_ANALYZED,\n");
            cs.addSourceCode("        PARTITIONED,\n");
            cs.addSourceCode("        IOT_TYPE,\n");
            cs.addSourceCode("        TEMPORARY,\n");
            cs.addSourceCode("        SECONDARY,\n");
            cs.addSourceCode("        NESTED,\n");
            cs.addSourceCode("        BUFFER_POOL,\n");
            cs.addSourceCode("        ROW_MOVEMENT,\n");
            cs.addSourceCode("        GLOBAL_STATS,\n");
            cs.addSourceCode("        USER_STATS,\n");
            cs.addSourceCode("        DURATION,\n");
            cs.addSourceCode("        SKIP_CORRUPT,\n");
            cs.addSourceCode("        MONITORING,\n");
            cs.addSourceCode("        CLUSTER_OWNER,\n");
            cs.addSourceCode("        DEPENDENCIES,\n");
            cs.addSourceCode("        COMPRESSION,\n");
            cs.addSourceCode("        DROPPED\n");
            cs.addSourceCode("from user_tables\n");
            cs.addSourceCode("where table_name = '").addSourceCode(table.getDBMSTableName(true)).addSourceCode("');\n");
            if (cs.getIndents() > 0) {
                cs.unIndent(1);
            }
            cs.addSourceCode("quit;");
        }
        catch (CodegenException e) {
            e.printStackTrace();
        }
        catch (BadLibraryDefinitionException e) {
            e.printStackTrace();
        }
        return cs.toString();
    }

    private String getOracleColumnDiscoveryCode(ICodeSegment cs, IPhysicalTable table, ICodeGenerationEnvironment environment, IServer defaultServer) {
        try {
            StringBuffer libnameStatement = table.getLibrary().getAccessPath(environment, false, null);
            cs.addSourceCode(libnameStatement.toString()).addSourceCode(";\n\n");
        }
        catch (RemoteException e1) {
            e1.printStackTrace();
        }
        catch (MdException e1) {
            e1.printStackTrace();
        }
        catch (BadServerDefinitionException e1) {
            e1.printStackTrace();
        }
        catch (BadLibraryDefinitionException e1) {
            e1.printStackTrace();
        }
        IDBMSType dbType = table.getDBMSType();
        cs.addSourceCode("proc sql;\n").indent();
        try {
            cs.addSourceCode("connect using ").addSourceCode(table.getLibref(defaultServer)).addSourceCode(" as Oracle;\n");
            cs.addSourceCode("\ncreate table work.tablecolumn_info as select * from connection to ").addSourceCode(((BaseDBMSType)dbType).getNickName(cs, table)).addSourceCode("\n");
            cs.indent();
            cs.addSourceCode("(select TABLE_NAME,\n");
            cs.addSourceCode("        COLUMN_NAME,\n");
            cs.addSourceCode("        DATA_TYPE,\n");
            cs.addSourceCode("        DATA_TYPE_MOD,\n");
            cs.addSourceCode("        DATA_TYPE_OWNER,\n");
            cs.addSourceCode("        DATA_LENGTH,\n");
            cs.addSourceCode("        DATA_PRECISION,\n");
            cs.addSourceCode("        DATA_SCALE,\n");
            cs.addSourceCode("        NULLABLE,\n");
            cs.addSourceCode("        COLUMN_ID,\n");
            cs.addSourceCode("        DEFAULT_LENGTH,\n");
            cs.addSourceCode("        NUM_DISTINCT,\n");
            cs.addSourceCode("        LOW_VALUE,\n");
            cs.addSourceCode("        HIGH_VALUE,\n");
            cs.addSourceCode("        DENSITY,\n");
            cs.addSourceCode("        NUM_NULLS,\n");
            cs.addSourceCode("        NUM_BUCKETS,\n");
            cs.addSourceCode("        LAST_ANALYZED,\n");
            cs.addSourceCode("        SAMPLE_SIZE,\n");
            cs.addSourceCode("        CHARACTER_SET_NAME,\n");
            cs.addSourceCode("        CHAR_COL_DECL_LENGTH,\n");
            cs.addSourceCode("        GLOBAL_STATS,\n");
            cs.addSourceCode("        USER_STATS,\n");
            cs.addSourceCode("        AVG_COL_LEN,\n");
            cs.addSourceCode("        CHAR_LENGTH,\n");
            cs.addSourceCode("        CHAR_USED,\n");
            cs.addSourceCode("        V80_FMT_IMAGE,\n");
            cs.addSourceCode("        DATA_UPGRADED,\n");
            cs.addSourceCode("        HISTOGRAM\n");
            cs.addSourceCode("from user_tab_columns\n");
            cs.addSourceCode("where table_name = '").addSourceCode(table.getDBMSTableName(true)).addSourceCode("');\n");
            if (cs.getIndents() > 0) {
                cs.unIndent(1);
            }
            cs.addSourceCode("quit;");
        }
        catch (CodegenException e) {
            e.printStackTrace();
        }
        catch (BadLibraryDefinitionException e) {
            e.printStackTrace();
        }
        return cs.toString();
    }

    private String getNonOracleTableDescribeCode(ICodeSegment cs, IPhysicalTable table, ICodeGenerationEnvironment environment, IServer defaultServer) {
        try {
            StringBuffer libnameStatement = table.getLibrary().getAccessPath(environment, false, null);
            cs.addSourceCode(libnameStatement.toString()).addSourceCode(";\n\n");
            IDBMSType dbType = table.getDBMSType();
            cs.addSourceCode("proc sql;\n").indent();
            cs.addSourceCode("create table work.table_info_other").indent();
            cs.addSourceCode("as select * from sashelp.vtable");
            cs.addSourceCode("\n");
            cs.addSourceCode("where libname = \"").addSourceCode(table.getLibrary().getLibref().toUpperCase()).addSourceCode("\"").addSourceCode(" and memname = \"").addSourceCode(table.getSASTableName().toUpperCase()).addSourceCode("\";");
            cs.unIndent().unIndent().addSourceCode("quit;\n");
            cs.addSourceCode("title \"").addSourceCode(bundle.getString("StatementDetailsPanel.OutputTitle.TableInfo.txt")).addSourceCode("\";\n");
        }
        catch (RemoteException e1) {
            e1.printStackTrace();
        }
        catch (MdException e1) {
            e1.printStackTrace();
        }
        catch (BadServerDefinitionException e1) {
            e1.printStackTrace();
        }
        catch (BadLibraryDefinitionException e1) {
            e1.printStackTrace();
        }
        return cs.toString();
    }

    private String getNonOracleColumnDescribeCode(ICodeSegment cs, IPhysicalTable table, ICodeGenerationEnvironment environment, IServer defaultServer) {
        try {
            StringBuffer libnameStatement = table.getLibrary().getAccessPath(environment, false, null);
            cs.addSourceCode(libnameStatement.toString()).addSourceCode(";\n\n");
            IDBMSType dbType = table.getDBMSType();
            cs.addSourceCode("proc sql;\n").indent();
            cs.addSourceCode("create table work.column_info_other").indent();
            cs.addSourceCode("as select * from sashelp.vcolumn");
            cs.addSourceCode("\n");
            cs.addSourceCode("where libname = \"").addSourceCode(table.getLibrary().getLibref().toUpperCase()).addSourceCode("\"").addSourceCode(" and memname = \"").addSourceCode(table.getSASTableName().toUpperCase()).addSourceCode("\";\n");
            cs.unIndent().unIndent().addSourceCode("quit;\n");
        }
        catch (RemoteException e1) {
            e1.printStackTrace();
        }
        catch (MdException e1) {
            e1.printStackTrace();
        }
        catch (BadServerDefinitionException e1) {
            e1.printStackTrace();
        }
        catch (BadLibraryDefinitionException e1) {
            e1.printStackTrace();
        }
        return cs.toString();
    }

    private boolean doesTableHaveRows(ICodeSegment cs, String tableName, String macroName, WsAppServer wsAppServer) throws WsAppServerFailException, WsAppServerCodeException {
        cs.genGetNumRows(tableName, "", macroName, false, "1");
        wsAppServer.submitSASCode(cs.toString());
        try {
            String num_Rows = wsAppServer.getMacroVariableValue(macroName);
            return !"0".equals(num_Rows);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setSelectedItem(IPhysicalTable item) {
        boolean isListening = this.m_itemListener.isListening();
        this.m_itemListener.setListening(false);
        try {
            this.m_cmbOutput.setSelectedItem(this.getTableFromDisplayItems(this.m_targets, item));
            this.setPassThruCheckBoxStatus(item);
        }
        finally {
            this.m_itemListener.setListening(isListening);
        }
    }

    public void setPassThruCheckBoxStatus(IPhysicalTable table) {
        if (table != null) {
            if (table.getDBMSType().isPassThroughSupported()) {
                this.m_chkGeneratePassThru.setSelected(true);
                this.m_chkGeneratePassThru.setEnabled(true);
                if (this.m_statement != null) {
                    this.m_statement.setPassThru(this.m_statement.getPassThru());
                }
            } else {
                this.m_chkGeneratePassThru.setSelected(false);
                this.m_chkGeneratePassThru.setEnabled(false);
                if (this.m_statement != null) {
                    this.m_statement.setPassThru(this.m_statement.getPassThru());
                }
            }
        } else {
            this.m_chkGeneratePassThru.setSelected(this.m_statement != null ? this.m_statement.getPassThru() : true);
            this.m_chkGeneratePassThru.setEnabled(true);
        }
    }

    static /* synthetic */ TableMaintenanceTransformModel access$1200(StatementDetailsPanel x0) {
        return x0.m_transform;
    }

    static /* synthetic */ String access$1300(StatementDetailsPanel x0, ICodeSegment x1, IPhysicalTable x2, ICodeGenerationEnvironment x3, IServer x4) {
        return x0.getOraclePartitionDiscoveryCode(x1, x2, x3, x4);
    }

    static /* synthetic */ boolean access$1400(StatementDetailsPanel x0, ICodeSegment x1, String x2, String x3, WsAppServer x4) throws WsAppServerFailException, WsAppServerCodeException {
        return x0.doesTableHaveRows(x1, x2, x3, x4);
    }

    static /* synthetic */ String access$1500(StatementDetailsPanel x0, ICodeSegment x1, IPhysicalTable x2, ICodeGenerationEnvironment x3, IServer x4) {
        return x0.getOracleTableDiscoveryCode(x1, x2, x3, x4);
    }

    static /* synthetic */ String access$1600(StatementDetailsPanel x0, ICodeSegment x1, IPhysicalTable x2, ICodeGenerationEnvironment x3, IServer x4) {
        return x0.getOracleColumnDiscoveryCode(x1, x2, x3, x4);
    }

    static /* synthetic */ String access$1700(StatementDetailsPanel x0, ICodeSegment x1, IPhysicalTable x2, ICodeGenerationEnvironment x3, IServer x4) {
        return x0.getNonOracleTableDescribeCode(x1, x2, x3, x4);
    }

    static /* synthetic */ String access$1800(StatementDetailsPanel x0, ICodeSegment x1, IPhysicalTable x2, ICodeGenerationEnvironment x3, IServer x4) {
        return x0.getNonOracleColumnDescribeCode(x1, x2, x3, x4);
    }

    private class cViewInformationAction
    extends WsAbstractAction {
        public cViewInformationAction() {
            super(bundle, "StatementDetailsPanel.SubmitButton.Label", 0);
        }

        /*
         * Exception decompiling
         */
        public void actionPerformed(ActionEvent e) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class ComboBoxRenderer
    extends DefaultListCellRenderer {
        private ComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            label.setIcon(null);
            label.setText("                                          ");
            if (value instanceof DisplayableItem) {
                DisplayableItem table = (DisplayableItem)value;
                label.setText(table.toString());
                if (table.getObject() instanceof IWorkTable) {
                    label.setIcon(AppIconFactory.getInstance().getIconForPrivateType("Type:WorkTable", 16));
                } else if (table.getObject() instanceof IPhysicalTable) {
                    label.setIcon(AppIconFactory.getInstance().getIconForSimpleObject((SimpleObject)table.getObject()));
                }
            }
            return this;
        }
    }

    private class PassThruListener
    implements ActionListener {
        private PassThruListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StatementDetailsPanel.this.m_statement.setPassThru(((JCheckBox)e.getSource()).isSelected());
        }
    }

    private class cPassThru
    extends WsAbstractToggleAction {
        public cPassThru() {
            super(bundle, "TableStatementDetails.GeneratePassThru", 0);
        }

        public void actionPerformed(ActionEvent e) {
            StatementDetailsPanel.this.m_chkGeneratePassThru.setSelected(((JCheckBox)e.getSource()).isSelected());
        }
    }

    private class DataItemListener
    implements ItemListener {
        private boolean m_bIsListening = true;

        private DataItemListener() {
        }

        public void setListening(boolean listen) {
            this.m_bIsListening = listen;
        }

        public boolean isListening() {
            return this.m_bIsListening;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (!this.isListening()) {
                return;
            }
            if (e.getSource() == StatementDetailsPanel.this.m_cmbOutput) {
                if (!(StatementDetailsPanel.this.m_cmbOutput.getSelectedItem() instanceof DisplayableItem)) {
                    StatementDetailsPanel.this.m_statement.setTargetTable(null);
                    StatementDetailsPanel.this.m_chkGeneratePassThru.setSelected(true);
                    StatementDetailsPanel.this.m_chkGeneratePassThru.setEnabled(true);
                } else {
                    DisplayableItem item = (DisplayableItem)e.getItem();
                    StatementDetailsPanel.this.m_statement.setTargetTable((IPhysicalTable)item.getObject());
                    IPhysicalTable table = (IPhysicalTable)item.getObject();
                    if (table != null) {
                        if (table.getDBMSType().isPassThroughSupported()) {
                            StatementDetailsPanel.this.m_chkGeneratePassThru.setSelected(true);
                            StatementDetailsPanel.this.m_chkGeneratePassThru.setEnabled(true);
                            StatementDetailsPanel.this.m_statement.setPassThru(true);
                        } else {
                            StatementDetailsPanel.this.m_chkGeneratePassThru.setSelected(false);
                            StatementDetailsPanel.this.m_chkGeneratePassThru.setEnabled(false);
                            StatementDetailsPanel.this.m_statement.setPassThru(false);
                        }
                    } else {
                        StatementDetailsPanel.this.m_chkGeneratePassThru.setSelected(true);
                        StatementDetailsPanel.this.m_chkGeneratePassThru.setEnabled(true);
                        StatementDetailsPanel.this.m_statement.setPassThru(true);
                    }
                }
            }
        }
    }

    private class TextFieldFocusListener
    implements FocusListener {
        private TextFieldFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (StatementDetailsPanel.this.m_statement != null) {
                if (e.getSource() == StatementDetailsPanel.this.m_txtName) {
                    StatementDetailsPanel.this.m_statement.setName(StatementDetailsPanel.this.m_txtName.getText());
                } else if (e.getSource() == StatementDetailsPanel.this.m_txtDescription) {
                    StatementDetailsPanel.this.m_statement.setDescription(StatementDetailsPanel.this.m_txtDescription.getText());
                }
            }
        }
    }

    private class cModelListener
    implements IModelListener {
        private cModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            if (!StatementDetailsPanel.this.isListeningForChanges()) {
                return;
            }
            if (ev.getModelObject() != StatementDetailsPanel.this.m_statement) {
                return;
            }
            if ("Object:NameChanged".equals(ev.getType())) {
                StatementDetailsPanel.this.m_txtName.setText(ev.getData() != null ? ev.getData().toString() : "");
            } else if ("Object:DescriptionChanged".equals(ev.getType())) {
                StatementDetailsPanel.this.m_txtDescription.setText(ev.getData() != null ? ev.getData().toString() : "");
            } else if ("targ_table_cd".equals(ev.getType())) {
                StatementDetailsPanel.this.setSelectedItem((IPhysicalTable)ev.getData());
            } else if ("IUserWrittenCode:codeChanged".equals(ev.getType())) {
                StatementDetailsPanel.this.m_statementCodePanel.setCodeSource(StatementDetailsPanel.this.m_statement != null ? StatementDetailsPanel.this.m_statement.getCodeContainer() : null);
            } else if ("pass_thru_cd".equals(ev.getType())) {
                StatementDetailsPanel.this.m_chkGeneratePassThru.setSelected(ev.getData() != null ? (Boolean)ev.getData() : false);
            }
        }
    }
}

