/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.tablemaintenance;

import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.job.ICodeGenerationEnvironment;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IUserWrittenCodeContainer;
import com.sas.etl.models.job.transforms.tablemaintenance.TableMaintenanceTransformModel;
import com.sas.etl.models.job.transforms.tablemaintenance.TableStatement;
import com.sas.etl.models.other.IServer;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.visuals.common.CodeGenerationController;
import com.sas.wadmin.visuals.common.CodeGenerationEnvironmentFactory;
import com.sas.wadmin.visuals.common.CodePane;
import com.sas.wadmin.visuals.common.ModelUIUtilities;
import com.sas.wadmin.visuals.common.enhancededitor.hive.HiveEditorKit;
import com.sas.wadmin.visuals.common.enhancededitor.impl.EnhancedDocument;
import com.sas.wadmin.visuals.common.enhancededitor.impl.EnhancedEditorPane;
import com.sas.wadmin.visuals.common.enhancededitor.impl.FindHelper;
import com.sas.wadmin.visuals.common.enhancededitor.pig.PigEditorKit;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsDropMenuAction;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.imsmc.visuals.MessageBox;
import com.sas.workspace.visuals.WsAbstractEditorPropertyTab;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class StatementCodePane
extends CodePane {
    private static final WAdminResource bundle = WAdminResource.getBundle(StatementCodePane.class);
    private static final String PIG_FILTER = "res/pig_template_filter.txt";
    private static final String PIG_LOAD = "res/pig_template_load.txt";
    private WsAbstractAction m_actAddTemplate;
    private EnhancedEditorPane m_enhancedEditor = null;
    private EditorType m_editorType = null;
    private JButton m_btnCut;
    private JButton m_btnCopy;
    private JButton m_btnPaste;
    private JButton m_btnDelete;
    private JButton m_btnScrollTop;
    private JButton m_btnScrollBottom;
    private JButton m_btnFindNext;
    private JButton m_btnFindPrev;
    private JTextField m_txtFind;
    private JLabel m_lblFind;
    private int m_iHeaderLength;
    private TableStatement m_statement;
    private FocusListener m_lsnrTextPane;

    public StatementCodePane(IUserWrittenCodeContainer parentObject, EditorType type) {
        super(parentObject, null, type.toString());
        this.m_editorType = type;
        switch (type) {
            case SAS: {
                this.setDefaultFileName("statement.sas");
                this.setDefaultMetadataName(TableStatement.DEFAULT_METADATA_NAME);
                this.setDefaultMetadataDesc(TableStatement.DEFAULT_METADATA_DESC);
                break;
            }
            case OTHER: {
                this.setDefaultFileName("statement.ddl");
                this.setDefaultMetadataName(TableStatement.DEFAULT_METADATA_NAME);
                this.setDefaultMetadataDesc(TableStatement.DEFAULT_METADATA_DESC);
            }
        }
        this.createEnhancedEditor(parentObject, type);
        this.m_lsnrTextPane = new TextPaneFocusListener();
        this.m_enhancedEditor.addFocusListener(this.m_lsnrTextPane);
    }

    private void createEnhancedEditor(IUserWrittenCodeContainer parentObject, EditorType type) {
        this.m_enhancedEditor = new EnhancedEditorPane();
        switch (type) {
            case SAS: {
                this.createPigCodePane();
                break;
            }
            case OTHER: {
                this.createHiveCodePane();
            }
        }
        this.m_enhancedEditor.setFont(new Font("Monospaced", 0, 12));
        JScrollPane scrPreCode = new JScrollPane(this.m_enhancedEditor, 20, 30);
        WsUIUtilities.adjustScrollPanePreferredSize((JScrollPane)scrPreCode);
        this.m_enhancedEditor.pack();
        this.m_enhancedEditor.setLineNumberVisible(true);
        this.add(scrPreCode, "Center");
        try {
            this.m_enhancedEditor.setText(parentObject != null ? parentObject.getCode() : "");
            this.clearUndoStack();
        }
        catch (ServerException e) {
            e.printStackTrace();
        }
    }

    private void clearUndoStack() {
        if (this.m_enhancedEditor != null && (EnhancedDocument)this.m_enhancedEditor.getDocument() != null) {
            ((EnhancedDocument)this.m_enhancedEditor.getDocument()).getUndoManager().ClearUndoStack();
        }
    }

    @Override
    protected JToolBar createToolbar() {
        JToolBar toolbar = super.createToolbar();
        for (int i = toolbar.getComponentCount() - 1; i > 4; --i) {
            Component o = toolbar.getComponent(i);
            toolbar.remove(i);
        }
        toolbar.validate();
        this.m_actCut = new cCutAction2();
        this.m_actCopy = new cCopyAction2();
        this.m_actPaste = new cPasteAction2();
        this.m_actDelete = new cDeleteAction2();
        this.m_actScrollTop = new cScrollTopAction2();
        this.m_actScrollBottom = new cScrollBottomAction2();
        this.m_btnCut = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actCut);
        this.m_btnCopy = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actCopy);
        this.m_btnPaste = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actPaste);
        this.m_btnDelete = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actDelete);
        this.m_btnScrollTop = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actScrollTop);
        this.m_btnScrollBottom = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actScrollBottom);
        toolbar.add(this.m_btnCut);
        toolbar.add(this.m_btnCopy);
        toolbar.add(this.m_btnPaste);
        toolbar.add(this.m_btnDelete);
        toolbar.addSeparator();
        toolbar.add(this.m_btnScrollTop);
        toolbar.add(this.m_btnScrollBottom);
        toolbar.addSeparator();
        this.m_actAddTemplate = new AddCodeAction();
        toolbar.addSeparator();
        toolbar.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actAddTemplate));
        toolbar.addSeparator();
        this.m_btnFindNext = WsUIUtilities.createFlatTextIconButton((WsAbstractAction)new FindAction(true));
        this.m_btnFindPrev = WsUIUtilities.createFlatTextIconButton((WsAbstractAction)new FindAction(false));
        this.m_txtFind = new WATextField(25);
        this.m_lblFind = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtFind, (String)bundle.getString("StatementCodePane.Find.txt"));
        this.m_lblFind.setToolTipText(bundle.getString("StatementCodePane.Find.ToolTip.txt"));
        ImageIcon findNextIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("res/FindNext.gif"));
        this.m_btnFindNext.setIcon(findNextIcon);
        ImageIcon findPrevIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("res/FindPrevious.gif"));
        this.m_btnFindPrev.setIcon(findPrevIcon);
        toolbar.add(this.m_lblFind);
        toolbar.add(this.m_txtFind);
        toolbar.add(this.m_btnFindNext);
        toolbar.add(this.m_btnFindPrev);
        return toolbar;
    }

    @Override
    protected void layoutWidgets() {
        super.layoutWidgets();
        this.remove((Component)this.m_cmpEditor);
    }

    protected void createPigCodePane() {
        PigEditorKit kit = new PigEditorKit();
        this.m_enhancedEditor.setEditorKitForContentType("text/pig", kit);
        this.m_enhancedEditor.setContentType("text/pig");
    }

    protected void createHiveCodePane() {
        HiveEditorKit kit = new HiveEditorKit();
        this.m_enhancedEditor.setEditorKitForContentType("text/hive", kit);
        this.m_enhancedEditor.setContentType("text/hive");
    }

    public String getText() {
        return this.m_enhancedEditor.getText();
    }

    @Override
    public void setText(String text) {
        if (this.m_enhancedEditor != null) {
            this.m_enhancedEditor.setText(text);
            this.m_enhancedEditor.setCaretPosition(0);
        }
    }

    public void saveCode() {
        this.save();
    }

    @Override
    protected boolean readLocalFile(String sFileName) {
        try {
            File fStream = new File(sFileName);
            if (!fStream.exists()) {
                FileNotFoundException ex = new FileNotFoundException(bundle.getString("HadoopCodePane.FileDoesNotExistWarning.txt"));
                throw ex;
            }
            return this.m_enhancedEditor.openFile(sFileName);
        }
        catch (IOException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean readRemoteFile(String sFileName) {
        WsAppServer appServer = WsAppServer.createDefaultAppServer();
        try {
            String contents = appServer.readFile(sFileName);
            this.m_enhancedEditor.setText(contents);
            boolean bl = true;
            return bl;
        }
        catch (GenericError ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        catch (WsAppServerFailException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        finally {
            appServer.dispose();
        }
        return false;
    }

    @Override
    public int setCodeSource(CodeGenerationController controller, IUserWrittenCodeContainer codeSource, boolean bReloadCode, boolean useDISHeaderandFooters) {
        this.m_iHeaderLength = super.setCodeSource(controller, codeSource, bReloadCode, useDISHeaderandFooters);
        this.clearUndoStack();
        return this.m_iHeaderLength;
    }

    @Override
    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        if (this.m_enhancedEditor != null) {
            this.m_enhancedEditor.setEditable(bEditable);
        }
    }

    public boolean validateData() {
        block6: {
            if (!super.validateData()) {
                return false;
            }
            IUserWrittenCodeContainer codeSource = this.getCodeSource();
            if (codeSource != null) {
                try {
                    String savedText = codeSource.getCode();
                    String visualText = this.getText();
                    if (visualText.equals(savedText)) break block6;
                    int response = MessageUtil.displayMessage((String)bundle.getString("HadoopCodePane.CodeDifferentThanSavedCode.txt"), (int)3, (int)1);
                    if (response == 0) {
                        codeSource.setUserWrittenCode(visualText);
                        break block6;
                    }
                    if (response == 1) {
                        this.setText(savedText);
                        break block6;
                    }
                    return false;
                }
                catch (ServerException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    public void setStatement(TableStatement statement) {
        this.m_statement = statement;
    }

    private File[] getUserTemplates() {
        String rootPath = System.getProperty("user.dir");
        String localFolderPath = null;
        switch (this.m_editorType) {
            case SAS: {
                localFolderPath = "\\TableMaintenance";
                break;
            }
            case OTHER: {
                localFolderPath = "\\TableMaintenance\\Other";
            }
        }
        File f = new File(rootPath + localFolderPath);
        File[] files = f.listFiles();
        return files;
    }

    private class TextPaneFocusListener
    implements FocusListener {
        private TextPaneFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent arg0) {
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            if (arg0.getOppositeComponent() == null) {
                return;
            }
            IUserWrittenCodeContainer codeSource = StatementCodePane.this.getCodeSource();
            if (codeSource != null) {
                try {
                    String savedText = codeSource.getCode();
                    String visualText = StatementCodePane.this.getText();
                    if (!visualText.equals(savedText)) {
                        int response = MessageUtil.displayMessage((String)bundle.getString("HadoopCodePane.CodeDifferentThanSavedCode.txt"), (int)3, (int)1);
                        if (response == 0) {
                            codeSource.setUserWrittenCode(visualText);
                            StatementCodePane.this.setCodeSource(StatementCodePane.this.m_statement != null ? StatementCodePane.this.m_statement.getCodeContainer() : null);
                        } else if (response == 1) {
                            StatementCodePane.this.setText(savedText);
                        }
                    }
                }
                catch (ServerException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class NewAction
    extends WsDropMenuAction {
        public NewAction() {
            super(bundle, "StatementCodePane.Action.New", 0);
        }
    }

    protected class cScrollBottomAction2
    extends CodePane.cScrollBottomAction {
        public cScrollBottomAction2() {
            super(StatementCodePane.this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StatementCodePane.this.m_enhancedEditor.setCaretPosition(StatementCodePane.this.m_enhancedEditor.getText().length());
        }
    }

    protected class cScrollTopAction2
    extends CodePane.cScrollTopAction {
        public cScrollTopAction2() {
            super(StatementCodePane.this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StatementCodePane.this.m_enhancedEditor.moveCaretPosition(0);
            StatementCodePane.this.m_enhancedEditor.select(0, 0);
        }
    }

    protected class cDeleteAction2
    extends CodePane.cDeleteAction {
        public cDeleteAction2() {
            super(StatementCodePane.this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StatementCodePane.this.m_enhancedEditor.replaceSelection("");
        }
    }

    protected class cPasteAction2
    extends WsAbstractEditorPropertyTab.cPasteAction {
        private static final long serialVersionUID = 1L;

        public cPasteAction2() {
            super((WsAbstractEditorPropertyTab)StatementCodePane.this);
        }

        public void actionPerformed(ActionEvent e) {
            StatementCodePane.this.m_enhancedEditor.paste();
        }
    }

    protected class cCopyAction2
    extends WsAbstractEditorPropertyTab.cCopyAction {
        private static final long serialVersionUID = 1L;

        public cCopyAction2() {
            super((WsAbstractEditorPropertyTab)StatementCodePane.this);
        }

        public void actionPerformed(ActionEvent e) {
            StatementCodePane.this.m_enhancedEditor.copy();
        }
    }

    protected class cCutAction2
    extends WsAbstractEditorPropertyTab.cCutAction {
        private static final long serialVersionUID = 1L;

        public cCutAction2() {
            super((WsAbstractEditorPropertyTab)StatementCodePane.this);
        }

        public void actionPerformed(ActionEvent e) {
            StatementCodePane.this.m_enhancedEditor.cut();
        }
    }

    private class FindAction
    extends WsAbstractAction {
        private boolean m_findNext;
        private FindHelper m_findHelper;

        public FindAction(boolean findNext) {
            super(bundle, findNext ? "StatementCodePane.FindNext" : "StatementCodePane.FindPrev", 0);
            this.m_findNext = findNext;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.m_findHelper == null) {
                this.m_findHelper = StatementCodePane.this.m_enhancedEditor.getFindHelper();
                this.m_findHelper.setForward(this.m_findNext);
            }
            this.m_findHelper.setFindString(StatementCodePane.this.m_txtFind.getText());
            if (this.m_findNext) {
                this.m_findHelper.findNext();
            } else {
                this.m_findHelper.findNext();
            }
            StatementCodePane.this.m_enhancedEditor.requestFocusInWindow();
        }
    }

    private class TemplateCellRenderer
    extends DefaultListCellRenderer {
        private final Icon m_icon = StatementCodePane.access$100().getIcon("StatementCodePane.CodePanel.Template.image");

        private TemplateCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setIcon(this.m_icon);
            return this;
        }
    }

    private class CodeTemplatesPanel
    extends WAPanel {
        private JLabel m_lblTemplates;
        private JList m_lstTemplates;
        private JScrollPane m_scrTemplates;

        public CodeTemplatesPanel() {
            this.initialize();
            this.layoutWidgets();
        }

        protected void initialize() {
            ArrayList<String> templateList = new ArrayList<String>();
            templateList.add(bundle.getString("StatementCodePane.Action.Alter.txt"));
            templateList.add(bundle.getString("StatementCodePane.Action.Create.txt"));
            templateList.add(bundle.getString("StatementCodePane.Action.Drop.txt"));
            File[] files = StatementCodePane.this.getUserTemplates();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    templateList.add(files[i].getName());
                }
            }
            Object[] templates = templateList.toArray();
            this.m_lstTemplates = new JList<Object>(templates);
            this.m_lstTemplates.setSelectionMode(0);
            this.m_lstTemplates.setCellRenderer(new TemplateCellRenderer());
            this.m_scrTemplates = new JScrollPane(this.m_lstTemplates);
            this.m_lblTemplates = WsUIUtilities.createLabelForComponent((JComponent)this.m_lstTemplates, (String)bundle.getString("StatementCodePane.CodeTemplatesPanel.Label.txt"));
        }

        protected void layoutWidgets() {
            this.setLayout(new GridBagLayout());
            this.add(this.m_lblTemplates, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.add(this.m_scrTemplates, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public boolean validateData() {
            if (this.m_lstTemplates.getSelectedValue() == null) {
                MessageUtil.displayMessage((String)bundle.getString("HadoopCodePane.CodeTemplatePanel.NoTemplateSelected.txt"), (String)bundle.getString("HadoopCodePane.CodeTemplatePanel.NoTemplateSelected.title"));
                return false;
            }
            return true;
        }

        public String getSelectedItem() {
            return (String)this.m_lstTemplates.getSelectedValue();
        }

        public int getSelectedIndex() {
            return this.m_lstTemplates.getSelectedIndex();
        }
    }

    private class AddCodeAction
    extends WsAbstractAction {
        public AddCodeAction() {
            super(bundle, "StatementCodePane.Action.AddCodeAction", 18);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            if (StatementCodePane.this.m_statement.getTargetTable() == null) {
                MessageUtil.displayMessage((String)bundle.getString("StatementDetailsPanel.NoTargetTableSelected.txt"));
                return;
            }
            CodeTemplatesPanel pnlTemplates = new CodeTemplatesPanel();
            WAStandardDialog dlgTemplates = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("StatementCodePane.CodeTemplatesPanel.title.txt"), true, (WAPanel)pnlTemplates);
            dlgTemplates.setHelpProduct("wdb");
            dlgTemplates.setHelpTopic("tablemaint_add_template");
            dlgTemplates.setResizable(true);
            dlgTemplates.show();
            if (dlgTemplates.getReturnValue() == 1) {
                StatementCodePane.this.m_enhancedEditor.removeFocusListener(StatementCodePane.this.m_lsnrTextPane);
                FileInputStream stream = null;
                BufferedReader reader = null;
                StringBuilder template = new StringBuilder();
                int selectedCodeIndex = pnlTemplates.getSelectedIndex();
                if (selectedCodeIndex < 3) {
                    TableMaintenanceTransformModel tm = StatementCodePane.this.m_statement.getTransformModel();
                    ICodeSegment codeSegment = null;
                    try {
                        IServer defaultServer = ModelUIUtilities.getServerForAppServer(tm.getModel(), WsAppServer.getDefaultAppServerFQID());
                        ICodeGenerationEnvironment env = CodeGenerationEnvironmentFactory.getInstance().createCodeGenerationEnvironment(tm.getJob(), defaultServer);
                        codeSegment = env.createNewCodeSegment((IObject)tm);
                    }
                    catch (RemoteException e1) {
                        e1.printStackTrace();
                    }
                    catch (MdException e1) {
                        e1.printStackTrace();
                    }
                    try {
                        String createCode;
                        if (selectedCodeIndex == 0) {
                            createCode = StatementCodePane.this.m_statement.getAlterCode(codeSegment);
                            template.append(createCode);
                        }
                        if (selectedCodeIndex == 1) {
                            createCode = StatementCodePane.this.m_statement.getCreateCode(codeSegment);
                            template.append(createCode);
                        }
                        if (selectedCodeIndex == 2) {
                            createCode = StatementCodePane.this.m_statement.getDropCode(codeSegment);
                            template.append(createCode);
                        }
                    }
                    catch (BadLibraryDefinitionException e1) {
                        e1.printStackTrace();
                    }
                    if (template.length() > 0) {
                        template.append("\n");
                    }
                } else {
                    String selectedTemplate = pnlTemplates.getSelectedItem();
                    File[] files = StatementCodePane.this.getUserTemplates();
                    try {
                        for (int i = 0; i < files.length; ++i) {
                            if (!files[i].getName().equalsIgnoreCase(selectedTemplate)) continue;
                            stream = new FileInputStream(files[i]);
                            break;
                        }
                    }
                    catch (Exception e1) {
                        MessageBox.showMessageBox(null, (String)"Error", (String)"Unable to find the selected template.", (int)64);
                    }
                }
                try {
                    if (stream == null && template.length() == 0) {
                        throw new FileNotFoundException("Unable to find the selected template.");
                    }
                    if (stream != null) {
                        reader = new BufferedReader(new InputStreamReader(stream));
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            template.append(line);
                            template.append(System.getProperty("line.separator"));
                        }
                    }
                }
                catch (Exception ex) {
                    MessageBox.showMessageBox(null, (String)bundle.getString("StatementCodePane.TemplateError.title.txt"), (String)ex.getLocalizedMessage(), (int)64);
                }
                finally {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (Exception ex) {
                        MessageBox.showMessageBox(null, (String)bundle.getString("StatementCodePane.TemplateError.title.txt"), (String)ex.getLocalizedMessage(), (int)64);
                    }
                }
                try {
                    int startPos = StatementCodePane.this.m_enhancedEditor.getCaretPosition();
                    String fullText = StatementCodePane.this.m_enhancedEditor.getText();
                    String fullTextSimpleLineFeeds = fullText.replaceAll("\r\n", "\n");
                    int sz = fullTextSimpleLineFeeds.length();
                    if (sz > 0 && sz == startPos) {
                        StringBuffer fullTextBuffer = new StringBuffer(fullTextSimpleLineFeeds);
                        fullTextBuffer.append("\n");
                        fullTextSimpleLineFeeds = fullTextBuffer.toString();
                        startPos = fullTextBuffer.length();
                    } else if (!fullTextSimpleLineFeeds.equals("") && fullTextSimpleLineFeeds.charAt(startPos) == '\n') {
                        ++startPos;
                    }
                    String textBeforeInsertSimpleLineFeeds = fullTextSimpleLineFeeds.substring(0, startPos);
                    String textAfterInsertSimpleLineFeeds = fullTextSimpleLineFeeds.substring(startPos);
                    String templateNoLineFeeds = template.toString().replaceAll("\r\n", "\n");
                    StatementCodePane.this.m_enhancedEditor.setText(textBeforeInsertSimpleLineFeeds + templateNoLineFeeds + textAfterInsertSimpleLineFeeds);
                    StatementCodePane.this.m_enhancedEditor.setCaretPosition(Math.min(startPos + templateNoLineFeeds.length(), StatementCodePane.this.m_enhancedEditor.getText().length() - 1));
                }
                catch (Exception ex) {
                    MessageBox.showMessageBox(null, (String)bundle.getString("StatementCodePane.TemplateError.title.txt"), (String)ex.getLocalizedMessage(), (int)64);
                }
                if (dlgTemplates != null) {
                    dlgTemplates.dispose();
                }
                StatementCodePane.this.m_enhancedEditor.requestFocusInWindow();
                StatementCodePane.this.m_enhancedEditor.addFocusListener(StatementCodePane.this.m_lsnrTextPane);
            }
        }
    }

    public static enum EditorType {
        SAS,
        OTHER;

    }
}

