/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.properties;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.visuals.properties.AbstractPropertiesModel;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;

public class TablePropertiesModel
extends AbstractPropertiesModel {
    private static WAdminResource bundle = WAdminResource.getBundle(TablePropertiesModel.class);
    protected static final int TABLEPROPERTYCOUNT = 2;
    protected int m_iName;
    protected int m_iDescription;
    private static final String NAME = bundle.getString("TablePropertiesModel.Property.Name.txt");
    private static final String DESCRIPTION = bundle.getString("TablePropertiesModel.Property.Description.txt");
    private ITable m_table;
    private IModelListener m_lsnrSQLModel;

    public TablePropertiesModel(ITable table) {
        this.m_table = table;
        this.m_lsnrSQLModel = this.createListener();
        this.m_table.getModel().addModelListener(this.m_lsnrSQLModel);
        this.setProperty(this.m_iName, NAME, table.getName(), TablePropertiesModel.getDefaultRenderer(), false, TablePropertiesModel.getDefaultEditor());
        this.setProperty(this.m_iDescription, DESCRIPTION, table.getDescription(), TablePropertiesModel.getDefaultRenderer(), false, TablePropertiesModel.getDefaultEditor());
    }

    protected ITable getTable() {
        return this.m_table;
    }

    protected IModelListener createListener() {
        return new QueryModelListener();
    }

    @Override
    protected void initializePropertyIndexes() {
        this.m_iName = 0;
        this.m_iDescription = 1;
    }

    @Override
    protected void initializeProperties() {
    }

    @Override
    public int getNumberOfProperties() {
        return 2;
    }

    @Override
    public void setPropertyValue(int iProperty, Object value) {
        if (iProperty == this.m_iName) {
            this.m_table.setName((String)value);
        } else if (iProperty == this.m_iDescription) {
            this.m_table.setDescription((String)value);
        } else {
            super.setPropertyValue(iProperty, value);
        }
    }

    protected void handleChange(String sAction) {
        if ("Object:NameChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iName, this.m_table.getName());
        } else if ("Object:DescriptionChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iDescription, this.m_table.getDescription());
        }
    }

    public void dispose() {
        this.m_table.getModel().removeModelListener(this.m_lsnrSQLModel);
    }

    @Override
    public void updatePropertyValues() throws MdException, RemoteException {
    }

    @Override
    public void populate() throws MdException, RemoteException {
    }

    @Override
    public void loadPropertyValues() throws MdException, RemoteException {
    }

    private class QueryModelListener
    implements IModelListener {
        private QueryModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            if (ev.getModelObject() != TablePropertiesModel.this.m_table) {
                return;
            }
            String sAction = ev.getType();
            if (sAction == null) {
                return;
            }
            TablePropertiesModel.this.handleChange(sAction);
        }
    }
}

