/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.properties;

import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.job.transforms.sql.ISourceTable;
import com.sas.wadmin.transforms.sql.properties.SQLPropertyUtil;
import com.sas.wadmin.transforms.sql.properties.TablePropertiesModel;
import com.sas.wadmin.visuals.WASASNameDocument;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsDefaultCellEditor;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.TableCellEditor;
import javax.swing.text.Document;

public class SourceTablePropertiesModel
extends TablePropertiesModel {
    private static WAdminResource bundle = WAdminResource.getBundle(SourceTablePropertiesModel.class);
    private static final int OPTIONCOUNT = 8;
    private static final int PROPERTYCOUNT = 10;
    protected int m_iAlias;
    protected int m_iUploadTableLibrary;
    protected int m_iUploadTableCaseSensitive;
    protected int m_iUploadTableSpecialCharacters;
    protected int m_iPreUploadActions;
    protected int m_iUploadBulkload;
    protected int m_iBulkloadOptions;
    protected int m_iUploadOptions;
    private static final String ALIASPROPERTYNAME = bundle.getString("SourceTablePropertiesModel.Property.Alias.txt");
    private static final String DBMSLIBRARYNAME = bundle.getString("SourceTablePropertiesModel.Property.DBMSLibrary.txt");
    private static final String CASESENSITIVENAME = bundle.getString("SourceTablePropertiesModel.Property.CaseSensitive.txt");
    private static final String SPECIALCHARACTERSNAME = bundle.getString("SourceTablePropertiesModel.Property.SpecialCharacters.txt");
    private static final String PREUPLOADACTIONNAME = bundle.getString("SourceTablePropertiesModel.Property.PreUploadActions.txt");
    private static final String UPLOADBULKLOADNAME = bundle.getString("SourceTablePropertiesModel.Property.UploadBulkload.txt");
    private static final String BULKLOADOPTIONNAME = bundle.getString("SourceTablePropertiesModel.Property.UploadBulkloadOptions.txt");
    private static final String UPLOADOPTIONNAME = bundle.getString("SourceTablePropertiesModel.Property.UploadAdditionalOptions.txt");
    private static final Integer NO_VALUE = new Integer(Integer.MIN_VALUE);
    private static TableCellEditor g_edtAlias;
    private ISourceTable m_source;

    public SourceTablePropertiesModel(ISourceTable source) {
        super((ITable)source);
        this.m_source = source;
        if (g_edtAlias == null) {
            WATextField txt = new WATextField((Document)((Object)new WASASNameDocument()), "", 0);
            txt.setMaxCharacters(32);
            g_edtAlias = new WsDefaultCellEditor(txt);
        }
        ILibrary mdoLibrary = source.getUploadLibrary();
        this.setProperty(this.m_iAlias, ALIASPROPERTYNAME, source.getAliasName(), SourceTablePropertiesModel.getDefaultRenderer(), true, g_edtAlias);
        this.setProperty(this.m_iUploadTableLibrary, DBMSLIBRARYNAME, mdoLibrary == null ? "" : mdoLibrary, SourceTablePropertiesModel.getMetadataRender(ILibrary.class), true, SourceTablePropertiesModel.getMetadataEditor(source.getModel(), 2));
        this.setProperty(this.m_iUploadTableCaseSensitive, CASESENSITIVENAME, source.isCaseSensitive(), SourceTablePropertiesModel.getDefaultBooleanRenderer(), true, SourceTablePropertiesModel.getDefaultBooleanEditor());
        this.setProperty(this.m_iUploadTableSpecialCharacters, SPECIALCHARACTERSNAME, source.isSpecialCharacters(), SourceTablePropertiesModel.getDefaultBooleanRenderer(), true, SourceTablePropertiesModel.getDefaultBooleanEditor());
        List<String> preuploadActions = Arrays.asList(ISourceTable.PREUPLOAD_ACTIONS);
        List transpreuploadActions = SQLPropertyUtil.createTranslatedList("PreUploadAction", preuploadActions);
        this.setProperty(this.m_iPreUploadActions, PREUPLOADACTIONNAME, this.m_source.getPreUploadAction(), SourceTablePropertiesModel.getListRenderer(transpreuploadActions, preuploadActions), true, SourceTablePropertiesModel.getListEditor(transpreuploadActions, preuploadActions));
        this.setProperty(this.m_iUploadBulkload, UPLOADBULKLOADNAME, source.isUploadUsingBulkload(), SourceTablePropertiesModel.getDefaultBooleanRenderer(), true, SourceTablePropertiesModel.getDefaultBooleanEditor());
        this.setProperty(this.m_iBulkloadOptions, BULKLOADOPTIONNAME, source.getBulkloadOptions(), SourceTablePropertiesModel.getDefaultRenderer(), true, SourceTablePropertiesModel.getDefaultEditor());
        this.setProperty(this.m_iUploadOptions, UPLOADOPTIONNAME, source.getAdditionalUploadOptions(), SourceTablePropertiesModel.getDefaultRenderer(), true, SourceTablePropertiesModel.getDefaultEditor());
        this.updateUploadOptionsEnabled();
    }

    @Override
    protected void initializePropertyIndexes() {
        this.m_iName = 0;
        this.m_iDescription = 1;
        this.m_iAlias = 2;
        this.m_iUploadTableLibrary = 3;
        this.m_iUploadTableCaseSensitive = 4;
        this.m_iUploadTableSpecialCharacters = 5;
        this.m_iPreUploadActions = 6;
        this.m_iUploadBulkload = 7;
        this.m_iBulkloadOptions = 8;
        this.m_iUploadOptions = 9;
    }

    @Override
    public int getNumberOfProperties() {
        return 10;
    }

    @Override
    public void setPropertyValue(int iProperty, Object value) {
        if (iProperty == this.m_iAlias) {
            this.m_source.setAliasName((String)value);
        } else if (iProperty == this.m_iUploadTableLibrary) {
            this.m_source.setUploadLibrary(value instanceof ILibrary ? (ILibrary)value : null);
        } else if (iProperty == this.m_iPreUploadActions) {
            this.m_source.setPreUploadAction((String)value);
        } else if (iProperty == this.m_iUploadBulkload) {
            this.m_source.setUploadUsingBulkload(((Boolean)value).booleanValue());
        } else if (iProperty == this.m_iBulkloadOptions) {
            this.m_source.setBulkloadOptions((String)value);
        } else if (iProperty == this.m_iUploadOptions) {
            this.m_source.setAdditionalUploadOptions((String)value);
        } else if (iProperty == this.m_iUploadTableCaseSensitive) {
            this.m_source.setCaseSensitive(((Boolean)value).booleanValue());
        } else if (iProperty == this.m_iUploadTableSpecialCharacters) {
            this.m_source.setSpecialCharacters(((Boolean)value).booleanValue());
        } else {
            super.setPropertyValue(iProperty, value);
        }
    }

    @Override
    protected void handleChange(String sAction) {
        if ("SQLAlias:AliasChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iAlias, this.m_source.getAliasName());
        } else if ("SQLSourceTable:DbmsLibraryChanged".equals(sAction)) {
            ILibrary mdoLibrary = this.m_source.getUploadLibrary();
            this.setPropertyValueImpl(this.m_iUploadTableLibrary, mdoLibrary == null ? "" : mdoLibrary);
        } else if ("SQLSourceTable:PreUploadActionChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iPreUploadActions, this.m_source.getPreUploadAction());
        } else if ("SQLSourceTable:AdditionalUploadBulkloadChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iUploadBulkload, this.m_source.isUploadUsingBulkload());
        } else if ("SQLSourceTable:BulkloadOptionsChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iBulkloadOptions, this.m_source.getBulkloadOptions());
        } else if ("SQLSourceTable:UploadOptionsChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iUploadOptions, this.m_source.getAdditionalUploadOptions());
        } else if ("Table:CaseChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iUploadTableCaseSensitive, this.m_source.isCaseSensitive());
        } else if ("Table:SpecialCharsChanged".equals(sAction)) {
            this.updateUploadOptionsEnabled();
            this.setPropertyValueImpl(this.m_iUploadTableSpecialCharacters, this.m_source.isSpecialCharacters());
        } else {
            super.handleChange(sAction);
        }
        if ("SQLSourceTable:DbmsLibraryChanged".equals(sAction)) {
            this.updateUploadOptionsEnabled();
        }
    }

    private void updateUploadOptionsEnabled() {
        boolean uploadEnabled = this.m_source.getUploadLibrary() != null;
        this.setPropertyValueEditable(this.m_iPreUploadActions, uploadEnabled);
        this.setPropertyValueEditable(this.m_iUploadBulkload, uploadEnabled);
        this.setPropertyValueEditable(this.m_iUploadOptions, uploadEnabled);
        this.setPropertyValueEditable(this.m_iUploadTableCaseSensitive, uploadEnabled && !this.m_source.isSpecialCharacters());
        this.setPropertyValueEditable(this.m_iUploadTableSpecialCharacters, uploadEnabled);
        this.setPropertyValueEditable(this.m_iBulkloadOptions, uploadEnabled);
    }
}

