/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.properties;

import com.sas.etl.models.job.transforms.sql.IJoin;
import com.sas.etl.models.job.transforms.sql.ISQLBooleanExpressionContainer;
import com.sas.wadmin.transforms.sql.properties.AbstractExpressionPropertiesModel;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsDefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.table.TableCellEditor;

public class JoinPropertiesModel
extends AbstractExpressionPropertiesModel {
    private static WAdminResource bundle = WAdminResource.getBundle(JoinPropertiesModel.class);
    private int m_iType;
    private int m_iImplicit;
    private int m_iParentheses;
    private static final int PROPERTYCOUNT = 3;
    private static final String TYPEPROPERTY = bundle.getString("JoinPropertiesModel.Property.Type.txt");
    private static final String IMPLICITPROPERTY = bundle.getString("JoinPropertiesModel.Property.Implicit.txt");
    private static final String PARENTHESESPROPERTY = bundle.getString("JoinPropertiesModel.Property.Parentheses.txt");
    private IJoin m_join;
    private static TableCellEditor g_edtType;

    public JoinPropertiesModel(IJoin join) {
        super((ISQLBooleanExpressionContainer)join);
        this.m_join = join;
        boolean bEditImplicit = join.getJoinType().equals("Inner");
        this.setProperty(this.m_iType, TYPEPROPERTY, join.getJoinType(), JoinPropertiesModel.getDefaultRenderer(), true, JoinPropertiesModel.getTypeEditor());
        this.setProperty(this.m_iImplicit, IMPLICITPROPERTY, this.m_join.useImplicit(), JoinPropertiesModel.getDefaultBooleanRenderer(), bEditImplicit, JoinPropertiesModel.getDefaultBooleanEditor());
        this.setProperty(this.m_iParentheses, PARENTHESESPROPERTY, this.m_join.useParentheses(), JoinPropertiesModel.getDefaultBooleanRenderer(), true, JoinPropertiesModel.getDefaultBooleanEditor());
        this.setPropertyValueEditable(this.m_iParentheses, !this.m_join.useImplicit());
        this.updateImplicitJoinEditable();
    }

    @Override
    protected void initializePropertyIndexes() {
        super.initializePropertyIndexes();
        this.m_iType = 0;
        this.m_iImplicit = 1;
        this.m_iParentheses = 2;
    }

    @Override
    public int getNumberOfProperties() {
        return 3 + super.getNumberOfProperties();
    }

    @Override
    public void setPropertyValue(int iProperty, Object value) {
        if (iProperty == this.m_iUserWritten) {
            this.m_join.setUseUserWrittenCode(((Boolean)value).booleanValue());
        } else if (iProperty == this.m_iType) {
            this.m_join.setJoinType((String)value);
        } else if (iProperty == this.m_iImplicit) {
            this.m_join.setImplicit(((Boolean)value).booleanValue());
        } else if (iProperty == this.m_iParentheses) {
            this.m_join.setParentheses(((Boolean)value).booleanValue());
        } else {
            super.setPropertyValue(iProperty, value);
        }
    }

    @Override
    protected void handleChange(String sAction) {
        if ("Join:JoinTypeChanged".equals(sAction)) {
            String sType = this.m_join.getJoinType();
            this.setPropertyValueImpl(this.m_iType, sType);
            this.updateImplicitJoinEditable();
            this.updateUserWrittenEnabled();
        } else if ("Join:ImplicitChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iImplicit, this.m_join.useImplicit());
            this.setPropertyValueEditable(this.m_iParentheses, !this.m_join.useImplicit());
        } else if ("Join:ParenthesesChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iParentheses, this.m_join.useParentheses());
            this.setPropertyValueEditable(this.m_iParentheses, !this.m_join.useImplicit());
        } else {
            super.handleChange(sAction);
        }
    }

    private void updateImplicitJoinEditable() {
        String sType = this.m_join.getJoinType();
        this.setPropertyValueEditable(this.m_iImplicit, "Inner".equals(sType));
    }

    private static TableCellEditor getTypeEditor() {
        if (g_edtType == null) {
            Object[] saValues = new String[]{"Inner", "Left", "Right", "Full", "Union", "Cross"};
            WAComboBox cmb = new WAComboBox(saValues);
            g_edtType = new WsDefaultCellEditor((JComboBox)cmb);
        }
        return g_edtType;
    }
}

