/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.properties;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.wadmin.visuals.properties.AbstractPropertiesModel;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;

public class ColumnPropertiesModel
extends AbstractPropertiesModel {
    private static WAdminResource bundle = WAdminResource.getBundle(ColumnPropertiesModel.class);
    private static final int PROPERTYCOUNT = 8;
    protected int m_nameIndex = 0;
    protected int m_descriptionIndex;
    protected int m_columnNameIndex;
    protected int m_lengthIndex;
    protected int m_typeIndex;
    protected int m_informatIndex;
    protected int m_formatIndex;
    protected int m_isNullableIndex;
    private static final String NAME = bundle.getString("ColumnPropertiesModel.Property.Name.txt");
    private static final String DESCRIPTION = bundle.getString("ColumnPropertiesModel.Property.Description.txt");
    private static final String COLUMN_NAME = bundle.getString("ColumnPropertiesModel.Property.ColumnName.txt");
    private static final String LENGTH = bundle.getString("ColumnPropertiesModel.Property.Length.txt");
    private static final String TYPE = bundle.getString("ColumnPropertiesModel.Property.Type.txt");
    private static final String INFORMAT = bundle.getString("ColumnPropertiesModel.Property.Informat.txt");
    private static final String FORMAT = bundle.getString("ColumnPropertiesModel.Property.Format.txt");
    private static final String IS_NULLABLE = bundle.getString("ColumnPropertiesModel.Property.IsNullable.txt");
    private IColumn m_column;
    private IModelListener m_modelListener;

    public ColumnPropertiesModel(IColumn column) {
        this.m_column = column;
        this.m_modelListener = new ModelListener();
        this.m_column.getModel().addModelListener(this.m_modelListener);
        this.setProperty(this.m_nameIndex, NAME, column.getName(), ColumnPropertiesModel.getDefaultRenderer(), false, ColumnPropertiesModel.getDefaultEditor());
        this.setProperty(this.m_descriptionIndex, DESCRIPTION, column.getDescription(), ColumnPropertiesModel.getDefaultRenderer(), false, ColumnPropertiesModel.getDefaultEditor());
        this.setProperty(this.m_columnNameIndex, COLUMN_NAME, column.getColumnName(false), ColumnPropertiesModel.getDefaultRenderer(), false, ColumnPropertiesModel.getDefaultEditor());
        this.setProperty(this.m_lengthIndex, LENGTH, new Integer(column.getLength()), ColumnPropertiesModel.getDefaultRenderer(), false, ColumnPropertiesModel.getDefaultEditor());
        this.setProperty(this.m_typeIndex, TYPE, new Integer(column.getType()), ColumnPropertiesModel.getDefaultRenderer(), false, ColumnPropertiesModel.getDefaultEditor());
        this.setProperty(this.m_informatIndex, INFORMAT, column.getInformat(), ColumnPropertiesModel.getDefaultRenderer(), false, ColumnPropertiesModel.getDefaultEditor());
        this.setProperty(this.m_formatIndex, FORMAT, column.getFormat(), ColumnPropertiesModel.getDefaultRenderer(), false, ColumnPropertiesModel.getDefaultEditor());
        this.setProperty(this.m_isNullableIndex, IS_NULLABLE, column.isNullable(), ColumnPropertiesModel.getDefaultBooleanRenderer(), false, ColumnPropertiesModel.getDefaultEditor());
    }

    public IColumn getColumn() {
        return this.m_column;
    }

    @Override
    protected void initializePropertyIndexes() {
        this.m_nameIndex = 0;
        this.m_descriptionIndex = 1;
        this.m_columnNameIndex = 2;
        this.m_lengthIndex = 3;
        this.m_typeIndex = 4;
        this.m_informatIndex = 5;
        this.m_formatIndex = 6;
        this.m_isNullableIndex = 7;
    }

    @Override
    protected void initializeProperties() {
    }

    @Override
    public int getNumberOfProperties() {
        return 8;
    }

    @Override
    public void setPropertyValue(int index, Object value) {
    }

    protected void handleChange(String action) {
        if ("Object:NameChanged".equals(action)) {
            this.setPropertyValueImpl(this.m_nameIndex, this.m_column.getName());
        } else if ("Object:DescriptionChanged".equals(action)) {
            this.setPropertyValueImpl(this.m_descriptionIndex, this.m_column.getDescription());
        }
    }

    public void dispose() {
        this.m_column.getModel().removeModelListener(this.m_modelListener);
    }

    @Override
    public void updatePropertyValues() throws MdException, RemoteException {
    }

    @Override
    public void populate() throws MdException, RemoteException {
    }

    @Override
    public void loadPropertyValues() throws MdException, RemoteException, ServiceException, LogicalTypeException {
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent event) {
            if (event.getModelObject() != ColumnPropertiesModel.this.m_column) {
                return;
            }
            String action = event.getType();
            if (action == null) {
                return;
            }
            ColumnPropertiesModel.this.handleChange(action);
        }
    }
}

