/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.properties;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.sql.IClause;
import com.sas.etl.models.job.transforms.sql.IJoin;
import com.sas.etl.models.job.transforms.sql.ISQLBooleanExpressionContainer;
import com.sas.etl.models.job.transforms.sql.ISQLTransform;
import com.sas.wadmin.transforms.sql.properties.BaseClausePropertiesModel;
import com.sas.workspace.WAdminResource;

public class AbstractExpressionPropertiesModel
extends BaseClausePropertiesModel {
    private static WAdminResource bundle = WAdminResource.getBundle(AbstractExpressionPropertiesModel.class);
    protected int m_iUserWritten;
    private static final int PROPERTYCOUNT = 1;
    private static final String USERWRITTENNAME = bundle.getString("AbstractExpressionPropertiesModel.Property.UserWritten.txt");
    private ISQLBooleanExpressionContainer m_abstractExpression;
    private ISQLTransform m_transform;

    public AbstractExpressionPropertiesModel(ISQLBooleanExpressionContainer absExpr) {
        super((IClause)absExpr);
        this.m_abstractExpression = absExpr;
        this.m_transform = this.m_abstractExpression.getParentQuery().getTransformModel();
        this.setProperty(this.m_iUserWritten, USERWRITTENNAME, this.m_abstractExpression.isUsingUserWrittenCode(), AbstractExpressionPropertiesModel.getDefaultBooleanRenderer(), true, AbstractExpressionPropertiesModel.getDefaultBooleanEditor());
        this.updateUserWrittenEnabled();
    }

    @Override
    protected IModelListener createListener() {
        return new QueryModelListener();
    }

    @Override
    protected void initializePropertyIndexes() {
        super.initializePropertyIndexes();
        this.m_iUserWritten = this.getNumberOfProperties() - super.getNumberOfProperties() - 1;
    }

    @Override
    public int getNumberOfProperties() {
        return 1 + super.getNumberOfProperties();
    }

    @Override
    public void setPropertyValue(int iProperty, Object value) {
        if (iProperty == this.m_iUserWritten) {
            this.m_abstractExpression.setUseUserWrittenCode(((Boolean)value).booleanValue());
        } else {
            super.setPropertyValue(iProperty, value);
        }
    }

    @Override
    protected void handleChange(String sAction) {
        if ("Object:UserWrittenIndicatorChanged".equals(sAction)) {
            this.setPropertyValueImpl(this.m_iUserWritten, this.m_abstractExpression.isUsingUserWrittenCode());
            this.updateUserWrittenEnabled();
        } else if ("IUserWrittenCode:activeChanged".equals(sAction)) {
            this.updateUserWrittenEnabled();
        } else {
            super.handleChange(sAction);
        }
    }

    protected void updateUserWrittenEnabled() {
        if (this.m_abstractExpression == this.m_transform) {
            this.setPropertyValueEditable(this.m_iUserWritten, true);
        } else {
            boolean uwEnabled;
            boolean bl = uwEnabled = !this.m_transform.isUsingUserWrittenCode();
            if (this.m_abstractExpression instanceof IJoin) {
                if ("Inner".equals(((IJoin)this.m_abstractExpression).getJoinType())) {
                    uwEnabled = false;
                } else if ("Union".equals(((IJoin)this.m_abstractExpression).getJoinType())) {
                    uwEnabled = false;
                } else if ("Cross".equals(((IJoin)this.m_abstractExpression).getJoinType())) {
                    uwEnabled = false;
                }
            }
            this.setPropertyValueEditable(this.m_iUserWritten, uwEnabled);
        }
    }

    private class QueryModelListener
    implements IModelListener {
        private QueryModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            if (ev.getModelObject() != AbstractExpressionPropertiesModel.this.m_abstractExpression && ev.getModelObject() != AbstractExpressionPropertiesModel.this.m_transform) {
                return;
            }
            String sAction = ev.getType();
            if (sAction == null) {
                return;
            }
            AbstractExpressionPropertiesModel.this.handleChange(sAction);
        }
    }
}

