/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.pfd;

import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.pfd.PFDPanel;
import com.sas.wadmin.pfd.WAPFDNodeModel;
import com.sas.wadmin.transforms.sql.model.ClauseInterface;
import com.sas.wadmin.transforms.sql.model.ClauseType;
import com.sas.wadmin.transforms.sql.model.CreateSelect;
import com.sas.wadmin.transforms.sql.model.Join;
import com.sas.wadmin.transforms.sql.model.JoinType;
import com.sas.wadmin.transforms.sql.model.Query;
import com.sas.wadmin.transforms.sql.model.SQLUtil;
import com.sas.wadmin.transforms.sql.model.SourceTableInterface;
import com.sas.wadmin.transforms.sql.pfd.ClauseNode;
import com.sas.wadmin.transforms.sql.pfd.JoinNode;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.objectselector.ObjectSelectorPanel;
import com.sas.workspace.visuals.pfd.WsPFDTemplateNode;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JPopupMenu;

public class TemplateNode
extends WsPFDTemplateNode {
    private static WAdminResource bundle = WAdminResource.getBundle(TemplateNode.class);
    private Query m_mdlQuery;
    private boolean m_bSource;
    private WsAbstractAction m_actSelectTable;
    private WsAbstractAction m_actAddJoin;
    private WsAbstractAction m_actAddSubQuery;

    public TemplateNode(String sText, Query mdlQuery, boolean bSource) {
        super(sText);
        this.m_mdlQuery = mdlQuery;
        this.m_bSource = bSource;
    }

    public TemplateNode(Point pt, Dimension size, String sText, Query mdlQuery, boolean bSource) {
        super(pt, size, sText);
        this.m_mdlQuery = mdlQuery;
        this.m_bSource = bSource;
    }

    protected void initialize() {
        super.initialize();
        this.m_actSelectTable = new SelectTableAction();
        this.m_actAddJoin = new AddJoinAction();
        this.m_actAddSubQuery = new AddSubQueryAction();
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_actSelectTable.setEnabled(bEditable);
    }

    public void addPopupMenuItems(JPopupMenu menuPopup) {
        menuPopup.add((Action)this.m_actSelectTable);
        if (this.m_bSource) {
            menuPopup.add((Action)this.m_actAddJoin);
            menuPopup.add((Action)this.m_actAddSubQuery);
        }
    }

    public boolean isDropValid(Point ptEvent, List lObjects) {
        try {
            CMetadata mdoObject;
            System.out.println(lObjects);
            if (lObjects.size() != 1) {
                return false;
            }
            Object obj = lObjects.get(0);
            if (obj instanceof CMetadata && (mdoObject = (CMetadata)obj).getCMetadataType().equals("PhysicalTable")) {
                return true;
            }
            if (!this.m_bSource) {
                return false;
            }
            if (obj instanceof JoinType) {
                return true;
            }
            return obj == ClauseType.SUBQUERY;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    public boolean drop(Point ptEvent, List lObjects) {
        try {
            CMetadata mdoObject;
            if (lObjects.size() != 1) {
                return false;
            }
            Object obj = lObjects.get(0);
            if (obj instanceof CMetadata && (mdoObject = (CMetadata)obj).getCMetadataType().equals("PhysicalTable")) {
                PFDPanel pfdParent = null;
                try {
                    pfdParent = SQLUtil.getPFDPanel(this.m_mdlQuery.getSQLModel().getTransformationStep());
                }
                catch (MdException me) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                MdObjectStore store = this.m_mdlQuery.getSQLModel().getObjectStore();
                String fQID = mdoObject.getFQID();
                List allTables = this.m_mdlQuery.getSourceDataTables();
                PhysicalTable sqlTable = null;
                for (int i = 0; i < allTables.size(); ++i) {
                    DataTable table = (DataTable)allTables.get(i);
                    if (!table.getFQID().equalsIgnoreCase(fQID)) continue;
                    sqlTable = (PhysicalTable)table;
                    break;
                }
                PhysicalTable mdoTable = null;
                if (sqlTable == null) {
                    WAPFDNodeModel node = pfdParent.getNodeModel(fQID);
                    if (node != null) {
                        WAPFDNodeModel pfdModel = pfdParent.getNodeModel(fQID);
                        PhysicalTable pfdTable = (PhysicalTable)pfdModel.getMetadataObject();
                        mdoTable = (PhysicalTable)Workspace.getMdFactory().createComplexMetadataObject(store, (CMetadata)pfdTable);
                    }
                } else {
                    mdoTable = sqlTable;
                }
                if (mdoTable == null) {
                    boolean goToServer = store.getIsGoToServerForMetadata();
                    if (!goToServer) {
                        store.setIsGotToServerForMetadata(true);
                    }
                    mdoTable = (PhysicalTable)store.getObject(mdoObject.getFQID());
                    Vector vComplex = new Vector();
                    String template = "<Templates><PhysicalTable><Extensions/><PropertySets/><TablePackage/><Indexes/><ForeignKeys/><UniqueKeys/><Columns><Column><Keys/><Indexes/><PropertySets/><Extensions/></Column></Columns></PhysicalTable></Templates>";
                    try {
                        mdoTable = (PhysicalTable)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((MdStore)store, "PhysicalTable", mdoObject.getFQID(), null, vComplex, template, 268);
                    }
                    catch (MdException me) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
                    }
                    catch (RemoteException re) {
                        Workspace.handleRemoteException((RemoteException)re);
                    }
                    store.setIsGotToServerForMetadata(goToServer);
                }
                if (this.m_bSource) {
                    if (!this.m_mdlQuery.isTargetTableUsed((DataTable)mdoTable)) {
                        MessageUtil.displayMessage((String)bundle.getString("Common.TargetTblAsSource.Error.txt"), (int)0);
                        return false;
                    }
                    SourceTableInterface srcTable = null;
                    if (this.m_mdlQuery.isSourceTableUsed(mdoTable)) {
                        srcTable = this.m_mdlQuery.addSourceAliasTable(mdoTable);
                        if (srcTable == null) {
                            return false;
                        }
                    } else {
                        srcTable = this.m_mdlQuery.addSourceTable((DataTable)mdoTable);
                    }
                    this.setTargetInput(srcTable);
                } else {
                    if (this.m_mdlQuery.isTargetTableUsed((DataTable)mdoTable)) {
                        MessageUtil.displayMessage((String)bundle.getString("Common.TargetTableUsed.Error.txt"), (int)0);
                        return false;
                    }
                    this.setSourceOutput(mdoTable);
                }
                return true;
            }
            if (!this.m_bSource) {
                return false;
            }
            if (obj instanceof JoinType) {
                this.setTargetInput(this.m_mdlQuery.addJoin(null, null, ((JoinType)obj).getJoinType()));
                return true;
            }
            if (obj == ClauseType.SUBQUERY) {
                this.setTargetInput(this.m_mdlQuery.addSubQuery());
                return true;
            }
            return false;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    private PhysicalTable selectTable() {
        ObjectSelectorPanel pnl = new ObjectSelectorPanel(Workspace.getWorkspace().getUserContext(), 3);
        String sTitle = bundle.getString("TemplateNode.SelectTableDialog.Title.txt");
        WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sTitle, true, (WAPanel)pnl);
        dlg.setResizable(true);
        dlg.setHelpProduct("shared");
        dlg.setHelpTopic("import_column_win");
        dlg.show();
        if (dlg.getReturnValue() == 1) {
            try {
                SimpleObject table = pnl.getSelectedObject();
                return (PhysicalTable)ObjectConverter.getInstance().convertToJOMAObject(this.m_mdlQuery.getSQLModel().getObjectStore(), table);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
        return null;
    }

    private void setTargetInput(SourceTableInterface table) {
        PFDPort portFrom = this.getOutputPort();
        Vector lLinks = portFrom.getFromLinks();
        if (lLinks.size() != 1) {
            throw new IllegalStateException("Incorrect number of links from template");
        }
        PFDLink link = (PFDLink)lLinks.get(0);
        ClauseNode node = (ClauseNode)link.getToNode();
        if (node instanceof JoinNode) {
            PFDPort portTo = link.getToPort();
            if (portTo == node.getPort("leftPort")) {
                ((Join)node.getClause()).setLeftSide(table);
            } else {
                ((Join)node.getClause()).setRightSide(table);
            }
        } else {
            this.m_mdlQuery.getFrom().setSource(table);
        }
    }

    private void setSourceOutput(PhysicalTable mdoTable) {
        ClauseInterface clause = this.m_mdlQuery.getParentClause();
        if (!(clause instanceof CreateSelect)) {
            throw new IllegalStateException("Attempting to set the target of a query that is not a CreateTarget");
        }
        ((CreateSelect)clause).setTargetTable((DataTable)mdoTable);
    }

    private class AddSubQueryAction
    extends WsAbstractAction {
        public AddSubQueryAction() {
            super(bundle, "TemplateNode.Action.AddSubQuery", 256);
        }

        public void actionPerformed(ActionEvent ev) {
            TemplateNode.this.setTargetInput(TemplateNode.this.m_mdlQuery.addSubQuery());
        }
    }

    private class AddJoinAction
    extends WsAbstractAction {
        public AddJoinAction() {
            super(bundle, "TemplateNode.Action.AddJoin", 256);
        }

        public void actionPerformed(ActionEvent ev) {
            TemplateNode.this.setTargetInput(TemplateNode.this.m_mdlQuery.addJoin(null, null, "Inner"));
        }
    }

    private class SelectTableAction
    extends WsAbstractAction {
        public SelectTableAction() {
            super(bundle, "TemplateNode.Action.SelectTable", 256);
        }

        public void actionPerformed(ActionEvent ev) {
            PhysicalTable mdoTable = TemplateNode.this.selectTable();
            if (mdoTable != null) {
                if (TemplateNode.this.m_bSource) {
                    SourceTableInterface srcTable = null;
                    if (!TemplateNode.this.m_mdlQuery.isTargetTableUsed((DataTable)mdoTable)) {
                        MessageUtil.displayMessage((String)bundle.getString("Common.TargetTblAsSource.Error.txt"), (int)0);
                        return;
                    }
                    if (TemplateNode.this.m_mdlQuery.isSourceTableUsed(mdoTable)) {
                        srcTable = TemplateNode.this.m_mdlQuery.addSourceAliasTable(mdoTable);
                        if (srcTable == null) {
                            return;
                        }
                    } else {
                        srcTable = TemplateNode.this.m_mdlQuery.addSourceTable((DataTable)mdoTable);
                    }
                    TemplateNode.this.setTargetInput(srcTable);
                } else {
                    if (TemplateNode.this.m_mdlQuery.isTargetTableUsed((DataTable)mdoTable)) {
                        MessageUtil.displayMessage((String)bundle.getString("Common.TargetTableUsed.Error.txt"), (int)0);
                        return;
                    }
                    TemplateNode.this.setSourceOutput(mdoTable);
                }
            }
        }
    }
}

