/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.pfd;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.wadmin.transforms.sql.model.ClauseInterface;
import com.sas.wadmin.transforms.sql.model.ClauseType;
import com.sas.wadmin.transforms.sql.model.CreateSelect;
import com.sas.wadmin.transforms.sql.model.JoinType;
import com.sas.wadmin.transforms.sql.model.Query;
import com.sas.wadmin.transforms.sql.model.SourceTable;
import com.sas.wadmin.transforms.sql.model.SourceTableInterface;
import com.sas.wadmin.transforms.sql.model.TableInterface;
import com.sas.wadmin.transforms.sql.model.TargetTable;
import com.sas.wadmin.transforms.sql.pfd.TableNode;
import com.sas.wadmin.viewdata2.ViewDataView;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.WsViewFactory;
import com.sas.workspace.visuals.pfd.WsPFDTableIconNode;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPopupMenu;

public class TableIconNode
extends WsPFDTableIconNode
implements TableNode {
    private static WAdminResource bundle = WAdminResource.getBundle(TableIconNode.class);
    private WsAbstractAction m_actProperties;
    private WsAbstractAction m_actViewData;
    private WsAbstractAction m_actDelete;
    private WsAbstractToggleAction m_actCreateView;
    private TableInterface m_table;
    private Query m_mdlQuery;
    private boolean m_bSource;
    private boolean m_bPhysical;

    public TableIconNode(TableInterface table, Query mdlQuery, boolean bSource) throws RemoteException {
        super(table.getDisplayTableName(), table.getDataTable().getCMetadataType(), table.getDataTable().getFQID(), table.isTableAView());
        this.m_table = table;
        this.m_mdlQuery = mdlQuery;
        this.m_bSource = bSource;
        this.m_actProperties = new PropertiesAction();
        this.m_actViewData = new ViewDataAction();
        this.m_actDelete = new DeleteAction();
        this.setDeleteAction((Action)this.m_actDelete);
        this.m_actCreateView = new CreateViewAction();
        this.m_bPhysical = table.getDataTable().getCMetadataType().equals("PhysicalTable");
        this.m_actDelete.setEnabled(this.m_bPhysical && this.m_bSource && this.isEditable());
    }

    @Override
    public TableInterface getTable() {
        return this.m_table;
    }

    public void addPopupMenuItems(JPopupMenu menuPopup) {
        menuPopup.add((Action)this.m_actProperties);
        menuPopup.add((Action)this.m_actViewData);
        if (this.m_table.isChangeViewSupported()) {
            menuPopup.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actCreateView));
        }
        menuPopup.add((Action)this.m_actDelete);
    }

    public void setActive(boolean bActive) {
        super.setActive(bActive);
        this.m_actProperties.setActive(bActive);
        this.m_actDelete.setActive(bActive);
        this.m_actViewData.setActive(bActive);
        if (!this.m_bPhysical) {
            this.m_actViewData.setEnabled(this.canViewData());
        }
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_actDelete.setEnabled(bEditable && this.m_bPhysical && this.m_bSource);
        this.m_actCreateView.setEnabled(bEditable && this.m_table.isChangeViewSupported());
    }

    public boolean isDropValid(Point ptEvent, List lObjects) {
        try {
            if (!this.m_bPhysical) {
                return false;
            }
            if (lObjects.size() != 1) {
                return false;
            }
            if (!this.m_bSource) {
                return false;
            }
            Object obj = lObjects.get(0);
            if (obj instanceof CMetadata) {
                CMetadata mdoObject = (CMetadata)obj;
                return mdoObject.getCMetadataType().equals("PhysicalTable");
            }
            if (obj instanceof JoinType) {
                return true;
            }
            return obj == ClauseType.SUBQUERY;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    @Override
    public boolean isSource() {
        return this.m_bSource;
    }

    public boolean drop(Point ptEvent, List lObjects) {
        try {
            if (!this.m_bPhysical) {
                return false;
            }
            if (lObjects.size() != 1) {
                return false;
            }
            Object obj = lObjects.get(0);
            if (obj instanceof CMetadata) {
                CMetadata mdoObject = (CMetadata)obj;
                if (mdoObject.getCMetadataType().equals("PhysicalTable")) {
                    PhysicalTable mdoTable = (PhysicalTable)Workspace.getMdFactory().createComplexMetadataObject(this.m_mdlQuery.getSQLModel().getObjectStore(), mdoObject.getName(), mdoObject.getCMetadataType(), mdoObject.getFQID());
                    if (this.m_bSource) {
                        if (((SourceTable)this.m_table).isSourceDataTableEqual((DataTable)mdoTable)) {
                            MessageUtil.displayMessage((String)bundle.getString("Common.ReplaceSameTable.Error.txt"), (int)0);
                            return false;
                        }
                        if (!this.m_mdlQuery.isTargetTableUsed((DataTable)mdoTable)) {
                            MessageUtil.displayMessage((String)bundle.getString("Common.TargetTblAsSource.Error.txt"), (int)0);
                            return false;
                        }
                        SourceTableInterface newTable = null;
                        if (this.m_mdlQuery.isSourceTableUsed(mdoTable, (SourceTableInterface)((Object)this.m_table))) {
                            newTable = this.m_mdlQuery.addSourceAliasTable(mdoTable);
                            if (newTable == null) {
                                return false;
                            }
                        } else {
                            newTable = this.m_mdlQuery.addSourceTable((DataTable)mdoTable);
                        }
                        this.m_mdlQuery.replaceSource((SourceTableInterface)((Object)this.m_table), newTable);
                    } else {
                        if (this.m_mdlQuery.isTargetTableUsed((DataTable)mdoTable)) {
                            MessageUtil.displayMessage((String)bundle.getString("Common.TargetTableUsed.Error.txt"), (int)0);
                            return false;
                        }
                        this.setSourceOutput(mdoTable);
                    }
                    return true;
                }
                return false;
            }
            if (!this.m_bSource) {
                return false;
            }
            if (obj instanceof JoinType) {
                this.m_mdlQuery.insertJoin(((JoinType)obj).getJoinType(), (SourceTableInterface)((Object)this.m_table));
                return true;
            }
            if (obj == ClauseType.SUBQUERY) {
                this.m_mdlQuery.insertSubQuery((SourceTableInterface)((Object)this.m_table));
                return true;
            }
            return false;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    private void setSourceOutput(PhysicalTable mdoTable) {
        ClauseInterface clause = this.m_mdlQuery.getParentClause();
        if (!(clause instanceof CreateSelect)) {
            throw new IllegalStateException("Attempting to set the target of a query that is not a CreateTarget");
        }
        ((CreateSelect)clause).setTargetTable((DataTable)mdoTable);
    }

    @Override
    public void refresh(String sAction) {
        if ("MemberTypeChanged".equals(sAction)) {
            boolean bView = this.m_table.isTableAView();
            this.setView(bView);
            this.m_actCreateView.setSelected(bView);
        } else if ("AliasChanged".equals(sAction)) {
            this.getLabel().setText(this.m_table.getDisplayTableName());
        }
    }

    private boolean canViewData() {
        return this.m_table.getSQLModel().getViewWorkTables();
    }

    private class CreateViewAction
    extends WsAbstractToggleAction {
        public CreateViewAction() {
            super(bundle, "TableIconNode.Action.CreateView", 257);
            this.setEnabled(TableIconNode.this.m_table.isChangeViewSupported());
            this.setSelected(TableIconNode.this.m_table.isTableAView());
        }

        public void actionPerformed(ActionEvent ev) {
            TableIconNode.this.m_table.setIsTableAView(this.isSelected());
        }
    }

    private class DeleteAction
    extends WsAbstractAction {
        public DeleteAction() {
            super(bundle, "TableIconNode.Action.Delete", 258);
            this.setMenuSupportId("delete");
        }

        public void actionPerformed(ActionEvent ev) {
            String sTitle = this.getText();
            String sMessage = bundle.formatString("TableIconNode.Action.DeleteWarning.txt", (Object)TableIconNode.this.getTable().getDataTableName());
            int eAnswer = MessageUtil.displayMessage((String)sMessage, (String)sTitle, (int)2, (int)0);
            if (eAnswer != 0) {
                return;
            }
            TableIconNode.this.m_table.remove();
        }
    }

    private class ViewDataAction
    extends WsAbstractAction {
        public ViewDataAction() {
            super(bundle, "TableIconNode.Action.ViewData", 257);
            this.setMenuSupportId("viewdata");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent ev) {
            try {
                WsAppServer appServer = TableIconNode.this.m_mdlQuery.getSQLModel().getWsAppServer();
                HashMap<String, WsAppServer> map = new HashMap<String, WsAppServer>();
                if (appServer != null) {
                    map.put("AppServer", appServer);
                }
                try {
                    if (TableIconNode.this.m_table instanceof TargetTable) {
                        ((TargetTable)TableIconNode.this.m_table).moveDataToStore();
                    }
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Writing");
                }
                WsViewFactory.showView((CMetadata)TableIconNode.this.m_table.getDataTable(), ViewDataView.class, map, (MdStore)TableIconNode.this.m_table.getDataTable().getObjectStore());
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    private class PropertiesAction
    extends WsAbstractAction {
        public PropertiesAction() {
            super(bundle, "TableIconNode.Action.Properties", 258);
            this.setMenuSupportId("properties");
        }

        public void actionPerformed(ActionEvent ev) {
            try {
                TableIconNode.this.m_table.getSQLModel().moveDataToStore();
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Writing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            Action actDefault = TableIconNode.this.getDefaultAction();
            if (actDefault != null && actDefault.isEnabled()) {
                actDefault.actionPerformed(ev);
            }
        }
    }
}

