/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.pfd;

import com.sas.graphics.components.pfd.PFDDrawablePrimitive;
import com.sas.graphics.components.pfd.PFDPolygon;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.wadmin.transforms.sql.model.Join;
import com.sas.wadmin.transforms.sql.model.JoinType;
import com.sas.wadmin.transforms.sql.model.Query;
import com.sas.wadmin.transforms.sql.model.SourceTableInterface;
import com.sas.wadmin.transforms.sql.pfd.ClauseNode;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsUIUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;

public class JoinNode
extends ClauseNode {
    private static WAdminResource bundle = WAdminResource.getBundle(JoinNode.class);
    private WsAbstractAction m_actSwapInputs;
    private WsAbstractToggleAction m_actInnerJoin;
    private WsAbstractToggleAction m_actFullJoin;
    private WsAbstractToggleAction m_actLeftJoin;
    private WsAbstractToggleAction m_actRightJoin;
    private WsAbstractToggleAction m_actCrossJoin;
    private WsAbstractToggleAction m_actUnionJoin;
    private WsAbstractToggleAction m_actImplicit;
    private WsAbstractToggleAction m_actParentheses;
    private static final Color JOIN_BORDER = new Color(159, 98, 189);
    private static final Color JOIN_FILL = new Color(221, 203, 231);
    private static final int PORT_SIZE = 6;
    private static final int PORT_OFFSET = 3;
    public static final String LEFT_INPUT_PORT = "leftPort";
    public static final String RIGHT_INPUT_PORT = "rightPort";
    private PFDPort m_portLeft;
    private PFDPort m_portRight;

    public JoinNode(Join join) {
        super(join);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.setShape(7);
        PFDDrawablePrimitive draw = this.getDrawable();
        draw.getPen().setColor(JOIN_BORDER);
        draw.getBrush().setColor(JOIN_FILL);
        this.m_portRight = this.createPort(RIGHT_INPUT_PORT);
        this.m_portLeft = this.createPort(LEFT_INPUT_PORT);
        this.m_actSwapInputs = new SwapInputsAction();
        this.m_actInnerJoin = new InnerJoinAction();
        this.m_actFullJoin = new FullJoinAction();
        this.m_actLeftJoin = new LeftJoinAction();
        this.m_actRightJoin = new RightJoinAction();
        this.m_actCrossJoin = new CrossJoinAction();
        this.m_actUnionJoin = new UnionJoinAction();
        this.m_actImplicit = new ImplicitAction();
        this.m_actParentheses = new ParenthesesAction();
    }

    public PFDPort getPort(String sName) {
        if (sName.equals(LEFT_INPUT_PORT)) {
            return this.m_portLeft;
        }
        if (sName.equals(RIGHT_INPUT_PORT)) {
            return this.m_portRight;
        }
        return super.getPort(sName);
    }

    private PFDPort createPort(String sName) {
        PFDPort port = new PFDPort();
        port.setName(sName);
        port.setType(5);
        port.setValidFromPort(false);
        port.setValidToPort(true);
        port.setToLinkDirection(0.0);
        port.setEndSegmentLength(10);
        this.addPrimitive((PFDPrimitive)port);
        return port;
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.generatePolygon();
    }

    public void setFlowDirection(String sDirection) {
        super.setFlowDirection(sDirection);
        this.generatePolygon();
        this.updatePorts();
    }

    private void updatePorts() {
        String sDirection = this.getFlowDirection();
        PFDDrawablePrimitive draw = this.getDrawable();
        Point pt = new Point();
        if (sDirection.equals("Down")) {
            draw.getSpotLocation(1, pt);
            this.m_portLeft.setBBox(pt.x - 3, pt.y - 3, 6, 6);
            draw.getSpotLocation(3, pt);
            this.m_portRight.setBBox(pt.x - 3, pt.y - 3, 6, 6);
            this.m_portLeft.setToLinkDirection(4.71238898038469);
            this.m_portRight.setToLinkDirection(4.71238898038469);
            this.m_portLeft.setToLinkSpot(2);
            this.m_portRight.setToLinkSpot(2);
        } else if (sDirection.equals("Up")) {
            draw.getSpotLocation(7, pt);
            this.m_portLeft.setBBox(pt.x - 3, pt.y - 3, 6, 6);
            draw.getSpotLocation(5, pt);
            this.m_portRight.setBBox(pt.x - 3, pt.y - 3, 6, 6);
            this.m_portLeft.setToLinkDirection(1.5707963267948966);
            this.m_portRight.setToLinkDirection(1.5707963267948966);
            this.m_portLeft.setToLinkSpot(6);
            this.m_portRight.setToLinkSpot(6);
        } else if (sDirection.equals("Right")) {
            draw.getSpotLocation(1, pt);
            this.m_portLeft.setBBox(pt.x - 3, pt.y - 3, 6, 6);
            draw.getSpotLocation(7, pt);
            this.m_portRight.setBBox(pt.x - 3, pt.y - 3, 6, 6);
            this.m_portLeft.setToLinkDirection(0.0);
            this.m_portRight.setToLinkDirection(0.0);
            this.m_portLeft.setToLinkSpot(8);
            this.m_portRight.setToLinkSpot(8);
        } else {
            draw.getSpotLocation(3, pt);
            this.m_portLeft.setBBox(pt.x - 3, pt.y - 3, 6, 6);
            draw.getSpotLocation(5, pt);
            this.m_portRight.setBBox(pt.x - 3, pt.y - 3, 6, 6);
            this.m_portLeft.setToLinkDirection(Math.PI);
            this.m_portRight.setToLinkDirection(Math.PI);
            this.m_portLeft.setToLinkSpot(4);
            this.m_portRight.setToLinkSpot(4);
        }
    }

    private void generatePolygon() {
        if (this.getDrawable() instanceof PFDPolygon) {
            PFDPolygon polygon = (PFDPolygon)this.getDrawable();
            Vector<Point> vPoints = new Vector<Point>(6);
            Point pt = polygon.getLocation();
            Dimension size = polygon.getSize();
            String sDirection = this.getFlowDirection();
            if (sDirection.equals("Down")) {
                vPoints.add(new Point(pt.x, pt.y));
                vPoints.add(new Point(pt.x + size.width / 2, pt.y + size.height / 4));
                vPoints.add(new Point(pt.x + size.width, pt.y));
                vPoints.add(new Point(pt.x + size.width, pt.y + size.height * 3 / 4));
                vPoints.add(new Point(pt.x + size.width / 2, pt.y + size.height));
                vPoints.add(new Point(pt.x, pt.y + size.height * 3 / 4));
            } else if (sDirection.equals("Up")) {
                vPoints.add(new Point(pt.x, pt.y + size.height));
                vPoints.add(new Point(pt.x + size.width / 2, pt.y + size.height * 3 / 4));
                vPoints.add(new Point(pt.x + size.width, pt.y + size.height));
                vPoints.add(new Point(pt.x + size.width, pt.y + size.height / 4));
                vPoints.add(new Point(pt.x + size.width / 2, pt.y));
                vPoints.add(new Point(pt.x, pt.y + size.height / 4));
            } else if (sDirection.equals("Right")) {
                vPoints.add(new Point(pt.x, pt.y));
                vPoints.add(new Point(pt.x + size.width / 4, pt.y + size.height / 2));
                vPoints.add(new Point(pt.x, pt.y + size.height));
                vPoints.add(new Point(pt.x + size.width * 3 / 4, pt.y + size.height));
                vPoints.add(new Point(pt.x + size.width, pt.y + size.height / 2));
                vPoints.add(new Point(pt.x + size.width * 3 / 4, pt.y));
            } else {
                vPoints.add(new Point(pt.x + size.width, pt.y));
                vPoints.add(new Point(pt.x + size.width * 3 / 4, pt.y + size.height / 2));
                vPoints.add(new Point(pt.x + size.width, pt.y + size.height));
                vPoints.add(new Point(pt.x + size.width / 4, pt.y + size.height));
                vPoints.add(new Point(pt.x, pt.y + size.height / 2));
                vPoints.add(new Point(pt.x + size.width / 4, pt.y));
            }
            polygon.setVertices(vPoints);
        }
    }

    public void refresh() {
        this.setIconImage((ImageIcon)this.getClause().getIcon());
        this.getLabel().setText(this.getClause().getName());
    }

    @Override
    public void addPopupMenuItems(JPopupMenu menuPopup) {
        Join join = (Join)this.getClause();
        String sType = join.getJoinType();
        this.m_actInnerJoin.setSelected(sType.equals("Inner"));
        this.m_actFullJoin.setSelected(sType.equals("Full"));
        this.m_actLeftJoin.setSelected(sType.equals("Left"));
        this.m_actRightJoin.setSelected(sType.equals("Right"));
        this.m_actCrossJoin.setSelected(sType.equals("Cross"));
        this.m_actUnionJoin.setSelected(sType.equals("Union"));
        this.m_actImplicit.setSelected(join.useImplicit());
        this.m_actParentheses.setSelected(join.useParentheses());
        this.updateActions();
        menuPopup.add((Action)this.m_actEdit);
        menuPopup.add((Action)this.m_actSwapInputs);
        menuPopup.add((Action)this.m_actDelete);
        menuPopup.addSeparator();
        menuPopup.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actInnerJoin));
        menuPopup.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actFullJoin));
        menuPopup.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actLeftJoin));
        menuPopup.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actRightJoin));
        menuPopup.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actCrossJoin));
        menuPopup.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actUnionJoin));
        menuPopup.addSeparator();
        menuPopup.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actImplicit));
        menuPopup.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actParentheses));
    }

    @Override
    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_actSwapInputs.setEnabled(bEditable);
        this.m_actInnerJoin.setEnabled(bEditable);
        this.m_actFullJoin.setEnabled(bEditable);
        this.m_actLeftJoin.setEnabled(bEditable);
        this.m_actRightJoin.setEnabled(bEditable);
        this.m_actCrossJoin.setEnabled(bEditable);
        this.m_actUnionJoin.setEnabled(bEditable);
        this.m_actParentheses.setEnabled(bEditable);
        this.updateActions();
    }

    private void updateActions() {
        String sType = ((Join)this.getClause()).getJoinType();
        this.m_actEdit.setEnabled(!sType.equals("Cross") && !sType.equals("Union"));
        this.m_actImplicit.setEnabled(this.isEditable() && ((Join)this.getClause()).getJoinType().equals("Inner"));
    }

    @Override
    public boolean isDropValid(Point ptEvent, List lObjects) {
        if (lObjects.size() != 1) {
            return false;
        }
        return lObjects.get(0) instanceof JoinType;
    }

    @Override
    public boolean drop(Point ptEvent, List lObjects) {
        if (lObjects.size() != 1) {
            return false;
        }
        Object obj = lObjects.get(0);
        if (obj instanceof JoinType) {
            Join join = (Join)this.getClause();
            join.getParentQuery().insertJoin(((JoinType)obj).getJoinType(), join);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete() {
        Join join = (Join)this.getClause();
        SourceTableInterface srcLeft = join.getLeftSide();
        SourceTableInterface srcRight = join.getRightSide();
        join.getSQLModel().setFireEventsEnabled(false);
        try {
            SourceTableInterface src;
            if (srcLeft == null) {
                src = srcRight;
            } else if (srcRight == null) {
                src = srcLeft;
            } else {
                String sTitle = bundle.getString("JoinNode.DeleteWhichInputTitle.txt");
                DeleteWhichSidePanel pnl = new DeleteWhichSidePanel();
                WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sTitle, true);
                dlg.setMainPanel((WAPanel)pnl);
                dlg.setHelpButtonVisible(false);
                dlg.show();
                if (dlg.getReturnValue() != 1) {
                    return;
                }
                if (pnl.isDeleteLeftSelected()) {
                    srcLeft.remove();
                    src = srcRight;
                } else if (pnl.isDeleteRightSelected()) {
                    srcRight.remove();
                    src = srcLeft;
                } else {
                    srcRight.remove();
                    srcLeft.remove();
                    src = null;
                }
            }
            Query query = join.getParentQuery();
            query.replaceSource(join, src);
            join.remove();
            join.getSQLModel().setFireEventsEnabled(true);
        }
        finally {
            join.getSQLModel().setFireEventsEnabledWithOutUnknownChangesEvent();
        }
    }

    @Override
    protected WsAbstractAction createDeleteAction() {
        return new DeleteAction();
    }

    private class DeleteAction
    extends WsAbstractAction {
        public DeleteAction() {
            super(bundle, "ClauseNode.Action.Delete", 258);
            this.setMenuSupportId("delete");
        }

        public void actionPerformed(ActionEvent ev) {
            JoinNode.this.delete();
        }
    }

    private class ParenthesesAction
    extends WsAbstractToggleAction {
        public ParenthesesAction() {
            super(bundle, "JoinNode.Action.Parentheses", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            ((Join)JoinNode.this.getClause()).setUseParentheses(this.isSelected());
        }
    }

    private class ImplicitAction
    extends WsAbstractToggleAction {
        public ImplicitAction() {
            super(bundle, "JoinNode.Action.Implicit", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            ((Join)JoinNode.this.getClause()).setUseImplicit(this.isSelected());
        }
    }

    private class UnionJoinAction
    extends WsAbstractToggleAction {
        public UnionJoinAction() {
            super(bundle, "JoinNode.Action.UnionJoin", 256);
            this.setIcon(Join.getIcon("Union"));
        }

        public void actionPerformed(ActionEvent ev) {
            ((Join)JoinNode.this.getClause()).setJoinType("Union");
        }
    }

    private class CrossJoinAction
    extends WsAbstractToggleAction {
        public CrossJoinAction() {
            super(bundle, "JoinNode.Action.CrossJoin", 256);
            this.setIcon(Join.getIcon("Cross"));
        }

        public void actionPerformed(ActionEvent ev) {
            ((Join)JoinNode.this.getClause()).setJoinType("Cross");
        }
    }

    private class RightJoinAction
    extends WsAbstractToggleAction {
        public RightJoinAction() {
            super(bundle, "JoinNode.Action.RightJoin", 256);
            this.setIcon(Join.getIcon("Right"));
        }

        public void actionPerformed(ActionEvent ev) {
            ((Join)JoinNode.this.getClause()).setJoinType("Right");
        }
    }

    private class LeftJoinAction
    extends WsAbstractToggleAction {
        public LeftJoinAction() {
            super(bundle, "JoinNode.Action.LeftJoin", 256);
            this.setIcon(Join.getIcon("Left"));
        }

        public void actionPerformed(ActionEvent ev) {
            ((Join)JoinNode.this.getClause()).setJoinType("Left");
        }
    }

    private class FullJoinAction
    extends WsAbstractToggleAction {
        public FullJoinAction() {
            super(bundle, "JoinNode.Action.FullJoin", 256);
            this.setIcon(Join.getIcon("Full"));
        }

        public void actionPerformed(ActionEvent ev) {
            ((Join)JoinNode.this.getClause()).setJoinType("Full");
        }
    }

    private class InnerJoinAction
    extends WsAbstractToggleAction {
        public InnerJoinAction() {
            super(bundle, "JoinNode.Action.InnerJoin", 256);
            this.setIcon(Join.getIcon("Inner"));
        }

        public void actionPerformed(ActionEvent ev) {
            ((Join)JoinNode.this.getClause()).setJoinType("Inner");
        }
    }

    private class SwapInputsAction
    extends WsAbstractAction {
        public SwapInputsAction() {
            super(bundle, "JoinNode.Action.SwapInputs", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            Join join = (Join)JoinNode.this.getClause();
            join.swapLeftAndRightSides();
        }
    }

    private class DeleteWhichSidePanel
    extends WAPanel {
        private WATextArea m_txtDescription;
        private JRadioButton m_rbnLeft;
        private JRadioButton m_rbnRight;
        private JRadioButton m_rbnBoth;

        public DeleteWhichSidePanel() {
            this.initialize();
        }

        protected void initialize() {
            this.m_txtDescription = new WATextArea();
            this.m_txtDescription.setBehavior(1);
            this.m_txtDescription.setAutosize(true);
            this.m_txtDescription.setColumns(30);
            this.m_txtDescription.setText(bundle.getString("JoinNode.DeleteWhichInputDescription.txt"));
            this.m_rbnLeft = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"JoinNode.RadioButton.DeleteLeftInput");
            this.m_rbnRight = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"JoinNode.RadioButton.DeleteRightInput");
            this.m_rbnBoth = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"JoinNode.RadioButton.DeleteBothInputs");
            ButtonGroup grp = new ButtonGroup();
            grp.add(this.m_rbnLeft);
            grp.add(this.m_rbnRight);
            grp.add(this.m_rbnBoth);
            this.m_rbnLeft.setSelected(true);
            this.setLayout(new GridBagLayout());
            this.add((Component)this.m_txtDescription, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 10, 0), 0, 0));
            this.add(this.m_rbnLeft, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.m_rbnRight, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.m_rbnBoth, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public boolean isDeleteLeftSelected() {
            return this.m_rbnLeft.isSelected();
        }

        public boolean isDeleteRightSelected() {
            return this.m_rbnRight.isSelected();
        }

        public boolean isDeleteBothSelected() {
            return this.m_rbnBoth.isSelected();
        }
    }
}

