/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.pfd;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.wadmin.transforms.sql.model.ClauseInterface;
import com.sas.wadmin.transforms.sql.model.ClauseType;
import com.sas.wadmin.transforms.sql.model.CreateSelect;
import com.sas.wadmin.transforms.sql.model.JoinType;
import com.sas.wadmin.transforms.sql.model.Query;
import com.sas.wadmin.transforms.sql.model.SourceTable;
import com.sas.wadmin.transforms.sql.model.SourceTableInterface;
import com.sas.wadmin.transforms.sql.model.TableInterface;
import com.sas.wadmin.transforms.sql.model.TargetTable;
import com.sas.wadmin.transforms.sql.pfd.ColumnsListModel;
import com.sas.wadmin.transforms.sql.pfd.TableNode;
import com.sas.wadmin.viewdata2.ViewDataView;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.WsViewFactory;
import com.sas.workspace.visuals.pfd.WsPFDComponentNode;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

public class ColumnsListNode
extends WsPFDComponentNode
implements TableNode {
    private static WAdminResource bundle = WAdminResource.getBundle(ColumnsListNode.class);
    private WsAbstractAction m_actProperties;
    private WsAbstractAction m_actViewData;
    private WsAbstractAction m_actDelete;
    private WsAbstractToggleAction m_actSortOriginal;
    private WsAbstractToggleAction m_actSortKeyed;
    private WsAbstractToggleAction m_actSortAscending;
    private WsAbstractToggleAction m_actSortDescending;
    private WsAbstractToggleAction m_actCreateView;
    private ColumnsListModel m_mdl;
    private TableInterface m_table;
    private Query m_mdlQuery;
    private boolean m_bSource;
    private boolean m_bPhysical;

    public ColumnsListNode(TableInterface table, Query mdlQuery, ColumnsListModel mdl, boolean bSource) {
        try {
            this.m_table = table;
            this.m_mdlQuery = mdlQuery;
            this.m_mdl = mdl;
            this.m_bSource = bSource;
            JList<Object> lst = new JList<Object>(mdl);
            lst.setCellRenderer(new ColumnCellRenderer());
            JScrollPane scr = new JScrollPane(lst);
            this.setComponent(scr);
            this.setTitleText(table.getDisplayTableName());
            this.setDropOnComponentEnabled(true);
            this.m_actProperties = new PropertiesAction();
            this.m_actViewData = new ViewDataAction();
            this.m_actDelete = new DeleteAction();
            this.m_actSortOriginal = new SortOriginalAction();
            this.m_actSortKeyed = new SortKeyedAction();
            this.m_actSortAscending = new SortAscendingAction();
            this.m_actSortDescending = new SortDescendingAction();
            this.m_actCreateView = new CreateViewAction();
            this.setDeleteAction((Action)this.m_actDelete);
            this.m_bPhysical = table.getDataTable().getCMetadataType().equals("PhysicalTable");
            this.m_actDelete.setEnabled(this.m_bPhysical && this.m_bSource && this.isEditable());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void setSortOrder(int eSortOrder) {
        this.m_mdl.setSortOrder(eSortOrder);
    }

    public int getSortOrder() {
        return this.m_mdl.getSortOrder();
    }

    @Override
    public TableInterface getTable() {
        return this.m_table;
    }

    public void addPopupMenuItems(JPopupMenu menuPopup) {
        int eSortOrder = this.getSortOrder();
        this.m_actSortOriginal.setSelected(eSortOrder == 0);
        this.m_actSortKeyed.setSelected(eSortOrder == 1);
        this.m_actSortAscending.setSelected(eSortOrder == 2);
        this.m_actSortDescending.setSelected(eSortOrder == 3);
        menuPopup.add((Action)this.m_actProperties);
        menuPopup.add((Action)this.m_actViewData);
        if (this.m_table.isChangeViewSupported()) {
            menuPopup.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actCreateView));
        }
        menuPopup.add((Action)this.m_actDelete);
        menuPopup.addSeparator();
        menuPopup.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actSortOriginal));
        menuPopup.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actSortKeyed));
        menuPopup.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actSortAscending));
        menuPopup.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actSortDescending));
    }

    public void setActive(boolean bActive) {
        super.setActive(bActive);
        this.m_actProperties.setActive(bActive);
        this.m_actViewData.setActive(bActive);
        this.m_actDelete.setActive(bActive);
        if (!this.m_bPhysical) {
            this.m_actViewData.setEnabled(this.canViewData());
        }
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_actDelete.setEnabled(bEditable && this.m_bPhysical && this.m_bSource);
        this.m_actCreateView.setEnabled(bEditable && this.m_table.isChangeViewSupported());
    }

    public boolean isDropValid(Point ptEvent, List lObjects) {
        try {
            if (!this.m_bPhysical) {
                return false;
            }
            if (lObjects.size() != 1) {
                return false;
            }
            if (!this.m_bSource) {
                return false;
            }
            Object obj = lObjects.get(0);
            if (obj instanceof CMetadata) {
                CMetadata mdoObject = (CMetadata)obj;
                return mdoObject.getCMetadataType().equals("PhysicalTable");
            }
            if (obj instanceof JoinType) {
                return true;
            }
            return obj == ClauseType.SUBQUERY;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    @Override
    public boolean isSource() {
        return this.m_bSource;
    }

    @Override
    public void refresh(String sAction) {
        if ("MemberTypeChanged".equals(sAction)) {
            this.m_actCreateView.setSelected(this.m_table.isTableAView());
        } else if ("AliasChanged".equals(sAction)) {
            this.setTitleText(this.m_table.getDisplayTableName());
        }
    }

    public boolean drop(Point ptEvent, List lObjects) {
        try {
            if (!this.m_bPhysical) {
                return false;
            }
            if (lObjects.size() != 1) {
                return false;
            }
            Object obj = lObjects.get(0);
            if (obj instanceof CMetadata) {
                CMetadata mdoObject = (CMetadata)obj;
                if (mdoObject.getCMetadataType().equals("PhysicalTable")) {
                    PhysicalTable mdoTable = (PhysicalTable)Workspace.getMdFactory().createComplexMetadataObject(this.m_mdlQuery.getSQLModel().getObjectStore(), mdoObject.getName(), mdoObject.getCMetadataType(), mdoObject.getFQID());
                    if (this.m_bSource) {
                        if (((SourceTable)this.m_table).isSourceDataTableEqual((DataTable)mdoTable)) {
                            MessageUtil.displayMessage((String)bundle.getString("Common.ReplaceSameTable.Error.txt"), (int)0);
                            return false;
                        }
                        if (!this.m_mdlQuery.isTargetTableUsed((DataTable)mdoTable)) {
                            MessageUtil.displayMessage((String)bundle.getString("Common.TargetTblAsSource.Error.txt"), (int)0);
                            return false;
                        }
                        SourceTableInterface newTable = null;
                        if (this.m_mdlQuery.isSourceTableUsed(mdoTable, (SourceTableInterface)((Object)this.m_table))) {
                            newTable = this.m_mdlQuery.addSourceAliasTable(mdoTable);
                            if (newTable == null) {
                                return false;
                            }
                        } else {
                            newTable = this.m_mdlQuery.addSourceTable((DataTable)mdoTable);
                        }
                        this.m_mdlQuery.replaceSource((SourceTableInterface)((Object)this.m_table), newTable);
                    } else {
                        if (this.m_mdlQuery.isTargetTableUsed((DataTable)mdoTable)) {
                            MessageUtil.displayMessage((String)bundle.getString("Common.TargetTableUsed.Error.txt"), (int)0);
                            return false;
                        }
                        this.setSourceOutput(mdoTable);
                    }
                    return true;
                }
                return false;
            }
            if (!this.m_bSource) {
                return false;
            }
            if (obj instanceof JoinType) {
                this.m_mdlQuery.insertJoin(((JoinType)obj).getJoinType(), (SourceTableInterface)((Object)this.m_table));
                return true;
            }
            if (obj == ClauseType.SUBQUERY) {
                this.m_mdlQuery.insertSubQuery((SourceTableInterface)((Object)this.m_table));
                return true;
            }
            return false;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    private void setSourceOutput(PhysicalTable mdoTable) {
        ClauseInterface clause = this.m_mdlQuery.getParentClause();
        if (!(clause instanceof CreateSelect)) {
            throw new IllegalStateException("Attempting to set the target of a query that is not a CreateTarget");
        }
        ((CreateSelect)clause).setTargetTable((DataTable)mdoTable);
    }

    private boolean canViewData() {
        return this.m_table.getSQLModel().getViewWorkTables();
    }

    private class SortDescendingAction
    extends WsAbstractToggleAction {
        public SortDescendingAction() {
            super(bundle, "ColumnsListNode.Action.SortDescending", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            ColumnsListNode.this.setSortOrder(3);
        }
    }

    private class SortAscendingAction
    extends WsAbstractToggleAction {
        public SortAscendingAction() {
            super(bundle, "ColumnsListNode.Action.SortAscending", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            ColumnsListNode.this.setSortOrder(2);
        }
    }

    private class SortKeyedAction
    extends WsAbstractToggleAction {
        public SortKeyedAction() {
            super(bundle, "ColumnsListNode.Action.SortKeyed", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            ColumnsListNode.this.setSortOrder(1);
        }
    }

    private class SortOriginalAction
    extends WsAbstractToggleAction {
        public SortOriginalAction() {
            super(bundle, "ColumnsListNode.Action.SortOriginal", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            ColumnsListNode.this.setSortOrder(0);
        }
    }

    private class DeleteAction
    extends WsAbstractAction {
        public DeleteAction() {
            super(bundle, "ColumnsListNode.Action.Delete", 258);
            this.setMenuSupportId("delete");
        }

        public void actionPerformed(ActionEvent ev) {
            String sTitle = this.getText();
            String sMessage = bundle.formatString("TableIconNode.Action.DeleteWarning.txt", (Object)ColumnsListNode.this.getTable().getDataTableName());
            int eAnswer = MessageUtil.displayMessage((String)sMessage, (String)sTitle, (int)2, (int)0);
            if (eAnswer != 0) {
                return;
            }
            ColumnsListNode.this.m_table.remove();
        }
    }

    private class CreateViewAction
    extends WsAbstractToggleAction {
        public CreateViewAction() {
            super(bundle, "ColumnsListNode.Action.CreateView", 257);
            this.setEnabled(ColumnsListNode.this.m_table.isChangeViewSupported());
            this.setSelected(ColumnsListNode.this.m_table.isTableAView());
        }

        public void actionPerformed(ActionEvent ev) {
            ColumnsListNode.this.m_table.setIsTableAView(this.isSelected());
        }
    }

    private class ViewDataAction
    extends WsAbstractAction {
        public ViewDataAction() {
            super(bundle, "ColumnsListNode.Action.ViewData", 257);
            this.setMenuSupportId("viewdata");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent ev) {
            try {
                WsAppServer appServer = ColumnsListNode.this.m_mdlQuery.getSQLModel().getWsAppServer();
                HashMap<String, WsAppServer> map = new HashMap<String, WsAppServer>();
                if (appServer != null) {
                    map.put("AppServer", appServer);
                }
                try {
                    if (ColumnsListNode.this.m_table instanceof TargetTable) {
                        ((TargetTable)ColumnsListNode.this.m_table).moveDataToStore();
                    }
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Writing");
                }
                WsViewFactory.showView((CMetadata)ColumnsListNode.this.m_table.getDataTable(), ViewDataView.class, map, (MdStore)ColumnsListNode.this.m_table.getDataTable().getObjectStore());
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    private class PropertiesAction
    extends WsAbstractAction {
        public PropertiesAction() {
            super(bundle, "ColumnsListNode.Action.Properties", 258);
            this.setMenuSupportId("properties");
        }

        public void actionPerformed(ActionEvent ev) {
            try {
                ColumnsListNode.this.m_table.getSQLModel().moveDataToStore();
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Writing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            Action actDefault = ColumnsListNode.this.getDefaultAction();
            if (actDefault != null && actDefault.isEnabled()) {
                actDefault.actionPerformed(ev);
            }
        }
    }

    private static class ColumnCellRenderer
    extends DefaultListCellRenderer {
        private ColumnCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int iRow, boolean bSelected, boolean bFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, iRow, bSelected, bFocus);
            this.setIcon(((ColumnsListModel)list.getModel()).getIcon(value));
            return this;
        }
    }
}

