/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.model;

import com.sas.codegen.CodegenRequest;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.QueryTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Select;
import com.sas.wadmin.transforms.sql.model.AbstractClause;
import com.sas.wadmin.transforms.sql.model.AbstractSimpleExpression;
import com.sas.wadmin.transforms.sql.model.AbstractTable;
import com.sas.wadmin.transforms.sql.model.CaseStatement;
import com.sas.wadmin.transforms.sql.model.OperandInterface;
import com.sas.wadmin.transforms.sql.model.Query;
import com.sas.wadmin.transforms.sql.model.SQLModel;
import com.sas.wadmin.transforms.sql.model.SimpleExpressionInterface;
import com.sas.wadmin.transforms.sql.model.SubQuery;
import com.sas.wadmin.transforms.sql.model.TableColumn;
import com.sas.wadmin.transforms.sql.model.TableInterface;
import com.sas.wadmin.transforms.sql.model.TargetTable;
import com.sas.wadmin.transforms.sql.model.TextOperand;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsColumnMetadataUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ResultMapping
extends AbstractSimpleExpression {
    private static final WAdminResource bundle = WAdminResource.getBundle(ResultMapping.class);
    public static final String ONE_TO_ONE_ROLE = "ONETOONE";
    public static final String DERIVED_ROLE = "DERIVED";
    public static final String UNMAPPED_ROLE = "UNMAPPED";
    private List m_lSourceColumns;
    private TableColumn m_targetColumn;
    private OperandInterface m_derivedExpression;
    private String m_role;
    private AbstractClause m_parent;
    private FeatureMap m_featureMap;
    public static final String FEATUREMAP_DELETE_TEMPLATE = "<FeatureMap><SourceCode/><Extensions/><Notes/><Documents/><Properties/><SubstitutionVariables/><TransformationSources/><TransformationTargets><SourceCode/></TransformationTargets></FeatureMap>";

    public ResultMapping(List sourceColumns, TableColumn targetColumn, OperandInterface expression, String role, AbstractClause parent) {
        this.m_lSourceColumns = new ArrayList();
        if (sourceColumns != null) {
            this.m_lSourceColumns.addAll(sourceColumns);
        }
        this.m_targetColumn = targetColumn;
        this.m_derivedExpression = expression;
        this.m_role = role;
        this.m_parent = parent;
        this.setParentQuery(this.m_parent.getParentQuery());
        this.setSQLModel(this.m_parent.getSQLModel());
    }

    public ResultMapping(FeatureMap featureMap) {
        this.m_featureMap = featureMap;
        this.m_lSourceColumns = new ArrayList();
    }

    public void clearSourceColumns() {
        this.m_lSourceColumns.clear();
    }

    public void removeSourceColumn(TableColumn col) {
        this.m_lSourceColumns.remove(col);
        String type = this.getRole();
        if (type.equals(ONE_TO_ONE_ROLE) && this.m_lSourceColumns.isEmpty()) {
            this.m_role = UNMAPPED_ROLE;
        }
    }

    public void addSourceColumn(TableColumn col) {
        if (col != null) {
            this.m_lSourceColumns.add(col);
        }
    }

    public void setSourceColumns(List sourceColumns) {
        this.m_lSourceColumns.clear();
        this.m_lSourceColumns.addAll(sourceColumns);
        this.getSQLModel().fireChangeEvent(this.m_parent, "selectChanged");
    }

    public List getSourceColumns() {
        return this.m_lSourceColumns;
    }

    public void setTargetColumn(TableColumn targetColumn) {
        this.m_targetColumn = targetColumn;
    }

    public TableColumn getTargetColumn() {
        return this.m_targetColumn;
    }

    public void setRole(String role) {
        this.m_role = role;
    }

    public String getRole() {
        return this.m_role;
    }

    public void setDerivedExpression(OperandInterface expression) {
        if (this.m_derivedExpression == expression) {
            return;
        }
        if (this.m_derivedExpression != null) {
            this.m_derivedExpression.dispose();
        }
        this.m_derivedExpression = this.setDerivedExpressionImpl(expression);
        this.getSQLModel().fireChangeEvent(this.m_parent, "ExpressionChanged");
    }

    private OperandInterface setDerivedExpressionImpl(OperandInterface operand) {
        if (operand == null) {
            return operand;
        }
        operand.setParent(this);
        if (operand instanceof CaseStatement) {
            ((CaseStatement)operand).setSQLModel(this.getSQLModel());
            ((CaseStatement)operand).setParentQuery(this.getParentQuery());
            ((CaseStatement)operand).setParentClause(this.getParent());
        } else if (operand instanceof SubQuery) {
            ((SubQuery)operand).setSQLModel(this.getSQLModel());
            ((SubQuery)operand).setParentQuery(this.getParentQuery());
            ((SubQuery)operand).setParentClause(this.getParent());
        }
        return operand;
    }

    public OperandInterface getDerivedExpression() {
        return this.m_derivedExpression;
    }

    public void setFeatureMap(FeatureMap featureMap) {
        this.m_featureMap = featureMap;
    }

    public FeatureMap getFeatureMap() {
        return this.m_featureMap;
    }

    public void setParent(AbstractClause clause) {
        this.m_parent = clause;
    }

    public AbstractClause getParent() {
        return this.m_parent;
    }

    @Override
    public CodegenRequest appendCode(CodegenRequest cgReq, boolean resetPosition) {
        this.getSQLCode(cgReq, resetPosition);
        return cgReq;
    }

    @Override
    public String getSQLCode(CodegenRequest cgReq, boolean resetPosition) {
        TableColumn sourceCol;
        SQLModel model = this.m_parent.getSQLModel();
        boolean passthru = model.isPassThrough();
        String targetColName = this.m_targetColumn.getColumnName();
        int length = this.m_targetColumn.getLength();
        String type = this.m_targetColumn.getType();
        String format = this.m_targetColumn.getFormat();
        String informat = this.m_targetColumn.getInformat();
        String description = this.m_targetColumn.getDescription();
        if (this.m_role.equalsIgnoreCase(DERIVED_ROLE) || this.m_role.equalsIgnoreCase(UNMAPPED_ROLE)) {
            boolean hasText = false;
            if (this.m_derivedExpression != null) {
                this.m_derivedExpression.appendCode(cgReq, resetPosition);
                hasText = this.m_derivedExpression.hasText();
            }
            if (!hasText) {
                if (type.equalsIgnoreCase(WsColumnMetadataUtil.getDataNumericType())) {
                    cgReq.addSourceCode(".");
                } else {
                    cgReq.addSourceCode("\"\"");
                }
            }
            cgReq.addSourceCode(" as ").addSourceCode(targetColName);
            if (!passthru) {
                int start = cgReq.getSourceBuffer().lastIndexOf("\n");
                int len = cgReq.getSourceBuffer().length();
                int indentLoc = len - start - cgReq.getCurrentIndent().length();
                cgReq.addSourceCode(" length = ").addSourceCode(Integer.toString(length));
                char[] indent = new char[indentLoc];
                Arrays.fill(indent, ' ');
                if (format.length() > 0) {
                    cgReq.addSourceCode("\n").addSourceCode(String.valueOf(indent)).addSourceCode("format = ").addSourceCode(format);
                }
                if (informat.length() > 0) {
                    cgReq.addSourceCode("\n").addSourceCode(String.valueOf(indent)).addSourceCode("informat = ").addSourceCode(informat);
                }
                if (description.length() > 0) {
                    cgReq.addSourceCode("\n").addSourceCode(String.valueOf(indent)).genLabelStatement(description);
                }
            }
        } else if (!this.m_lSourceColumns.isEmpty() && (sourceCol = (TableColumn)this.m_lSourceColumns.get(0)) != null) {
            StringBuffer columnName = sourceCol.getCodegenColumnName(cgReq, this.getParentQuery());
            if (!this.m_targetColumn.isNameIdentical(sourceCol, cgReq)) {
                columnName.append(" as ").append(this.m_targetColumn.getColumnName());
            }
            cgReq.addSourceCode(columnName);
            if (!passthru) {
                char[] indent = new char[columnName.length() + 1];
                Arrays.fill(indent, ' ');
                cgReq.addSourceCode(" length = ").addSourceCode(Integer.toString(length));
                if (format.length() > 0) {
                    cgReq.addSourceCode("\n").addSourceCode(String.valueOf(indent)).addSourceCode("format = ").addSourceCode(format);
                }
                if (informat.length() > 0) {
                    cgReq.addSourceCode("\n").addSourceCode(String.valueOf(indent)).addSourceCode("informat = ").addSourceCode(informat);
                }
                if (description.length() > 0) {
                    cgReq.addSourceCode("\n").addSourceCode(String.valueOf(indent)).genLabelStatement(description);
                }
            }
        }
        return cgReq.getSource();
    }

    @Override
    public void moveDataToModel() throws MdException, RemoteException {
        if (this.m_featureMap == null) {
            return;
        }
        this.m_lSourceColumns.clear();
        Query query = this.m_parent.getParentQuery();
        this.m_role = this.m_featureMap.getTransformRole();
        AssociationList lfeatureTargets = this.m_featureMap.getFeatureTargets();
        if (!lfeatureTargets.isEmpty()) {
            Column targetColumn = (Column)lfeatureTargets.get(0);
            TargetTable target = query.getTargetTable();
            this.m_targetColumn = target.findTableColumn(targetColumn);
            ArrayList<Root> lQueryTables = new ArrayList<Root>();
            AssociationList lTransSources = this.m_featureMap.getTransformationSources();
            for (int i = 0; i < lTransSources.size(); ++i) {
                Root object = (Root)lTransSources.get(i);
                if (!object.getCMetadataType().equalsIgnoreCase("QueryTable")) continue;
                lQueryTables.add(object);
            }
            AssociationList lFeatureSources = this.m_featureMap.getFeatureSources();
            for (int i = 0; i < lFeatureSources.size(); ++i) {
                List allTables;
                TableColumn column;
                AbstractTable source;
                Column srcCol = (Column)lFeatureSources.get(i);
                if (!lQueryTables.isEmpty()) {
                    QueryTable table = (QueryTable)lQueryTables.get(i);
                    source = query.findTable((DataTable)table);
                    if (source != null) {
                        column = source.findTableColumn(srcCol);
                        if (column == null) continue;
                        this.m_lSourceColumns.add(column);
                        continue;
                    }
                    DataTable tbl = srcCol.getTable();
                    source = query.findSourceTable(tbl);
                    TableColumn column2 = source.findTableColumn(srcCol);
                    if (column2 == null) continue;
                    this.m_lSourceColumns.add(column2);
                    continue;
                }
                DataTable tbl = srcCol.getTable();
                if (tbl == null) continue;
                source = query.findTable(tbl);
                if (source == null && !(allTables = query.findAllSourceTables(tbl)).isEmpty()) {
                    source = (AbstractTable)query.findAllSourceTables(tbl).get(0);
                }
                if (source == null || (column = source.findTableColumn(srcCol)) == null) continue;
                this.m_lSourceColumns.add(column);
            }
            if (this.m_role.equalsIgnoreCase(DERIVED_ROLE)) {
                AssociationList lTransTargets = this.m_featureMap.getTransformationTargets();
                for (int i = 0; i < lTransTargets.size(); ++i) {
                    ClassifierMap clsMap;
                    String role;
                    Root object = (Root)lTransTargets.get(i);
                    if (object.getCMetadataType().equalsIgnoreCase("FeatureMap")) {
                        FeatureMap map = (FeatureMap)object;
                        if (!map.getTransformRole().equalsIgnoreCase("TextOperand")) continue;
                        this.m_derivedExpression = new TextOperand((SimpleExpressionInterface)this, map);
                        break;
                    }
                    if (object.getCMetadataType().equalsIgnoreCase("Select")) {
                        Select select = (Select)object;
                        role = select.getTransformRole();
                        if (!role.equalsIgnoreCase("SUBQUERY")) continue;
                        this.m_derivedExpression = this.getParentQuery().addSubQuery(select);
                        ((SubQuery)this.m_derivedExpression).setParentClause(this.getParent());
                        ((SubQuery)this.m_derivedExpression).setParentQuery(this.getParentQuery());
                        break;
                    }
                    if (!object.getCMetadataType().equalsIgnoreCase("ClassifierMap") || !(role = (clsMap = (ClassifierMap)object).getTransformRole()).equalsIgnoreCase("CaseStatement")) continue;
                    this.m_derivedExpression = new CaseStatement(clsMap);
                    ((CaseStatement)this.m_derivedExpression).setSQLModel(this.getSQLModel());
                    ((CaseStatement)this.m_derivedExpression).setParentClause(this.getParent());
                    ((CaseStatement)this.m_derivedExpression).setParentQuery(this.getParentQuery());
                    break;
                }
                if (this.m_derivedExpression != null) {
                    this.m_derivedExpression.moveDataToModel();
                }
            } else if (this.m_lSourceColumns.isEmpty()) {
                this.m_role = UNMAPPED_ROLE;
            }
        }
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        String mapName = "";
        String roleName = "";
        boolean isDerived = false;
        if (this.m_role.equalsIgnoreCase(ONE_TO_ONE_ROLE)) {
            mapName = bundle.getString("ResultMapping.OneToOne.txt");
            roleName = ONE_TO_ONE_ROLE;
        } else if (this.m_role.equalsIgnoreCase(DERIVED_ROLE)) {
            mapName = bundle.getString("ResultMapping.Derived.txt");
            roleName = DERIVED_ROLE;
            isDerived = true;
        } else if (this.m_role.equalsIgnoreCase(UNMAPPED_ROLE)) {
            mapName = bundle.getString("ResultMapping.Unmapped.txt");
            roleName = UNMAPPED_ROLE;
        }
        if (!this.m_role.equalsIgnoreCase(UNMAPPED_ROLE)) {
            if (this.m_featureMap == null) {
                MdObjectStore store = this.getSQLModel().getObjectStore();
                String reposId = this.getSQLModel().getRepositoryId();
                this.m_featureMap = (FeatureMap)Workspace.getMdFactory().createComplexMetadataObject(store, mapName, "FeatureMap", reposId);
            }
            this.m_featureMap.setName(mapName);
            this.m_featureMap.setTransformRole(roleName);
            AssociationList ltargets = this.m_featureMap.getFeatureTargets();
            ltargets.removeAllElements();
            ltargets.flushAll();
            if (this.m_targetColumn.getColumn() == null) {
                this.m_targetColumn.moveDataToStore();
            }
            Column targetCol = this.m_targetColumn.getColumn();
            ltargets.addElement((Object)targetCol);
            AssociationList lsources = this.m_featureMap.getFeatureSources();
            lsources.removeAllElements();
            lsources.flushAll();
            for (int i = 0; i < this.m_lSourceColumns.size(); ++i) {
                TableColumn srcMap = (TableColumn)this.m_lSourceColumns.get(i);
                if (srcMap == null) continue;
                if (srcMap.getColumn() == null) {
                    srcMap.moveDataToStore();
                }
                Column srcCol = srcMap.getColumn();
                lsources.add((Object)srcCol);
            }
            if (isDerived) {
                AssociationList ltransTargets = this.m_featureMap.getTransformationTargets();
                ltransTargets.removeAllElements();
                ltransTargets.flushAll();
                if (this.m_derivedExpression != null) {
                    this.m_derivedExpression.moveDataToStore();
                    if (!this.m_derivedExpression.getOperandType().equalsIgnoreCase("SubQueryOperand")) {
                        ltransTargets.addElement((Object)this.m_derivedExpression.getMetadataObject());
                    } else {
                        ltransTargets.addElement((Object)((SubQuery)this.m_derivedExpression).getSelectObject());
                    }
                }
            }
        } else if (this.m_role.equalsIgnoreCase(UNMAPPED_ROLE) && this.m_featureMap != null) {
            if (this.m_derivedExpression != null) {
                this.m_derivedExpression.dispose();
            }
            MdObjectStore store = (MdObjectStore)this.m_featureMap.getObjectStore();
            store.removeObjectFromStore((CMetadata)this.m_featureMap, FEATUREMAP_DELETE_TEMPLATE);
            this.m_featureMap = null;
        }
    }

    @Override
    public void dispose() {
        MdObjectStore store = null;
        if (this.m_parent != null) {
            store = this.m_parent.getSQLModel().getObjectStore();
        }
        if (this.m_derivedExpression != null) {
            this.m_derivedExpression.dispose();
            this.m_derivedExpression = null;
        }
        this.m_lSourceColumns.clear();
        this.m_role = null;
        this.m_parent = null;
        if (this.m_featureMap != null) {
            try {
                if (store == null) {
                    store = (MdObjectStore)this.m_featureMap.getObjectStore();
                }
                store.removeObjectFromStore((CMetadata)this.m_featureMap, FEATUREMAP_DELETE_TEMPLATE);
                this.m_featureMap = null;
            }
            catch (MdException me) {
                if (this.getSQLModel().isSilentModeEnabled()) {
                    System.out.print(me.getLocalizedMessage());
                } else {
                    MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Deleting");
                }
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    public boolean containsTable(TableInterface table) {
        for (int i = 0; i < this.m_lSourceColumns.size(); ++i) {
            AbstractTable srcTable;
            TableColumn map = (TableColumn)this.m_lSourceColumns.get(i);
            if (map == null || (srcTable = map.getParent()) != table) continue;
            return true;
        }
        AbstractTable tgtTable = this.m_targetColumn.getParent();
        return tgtTable == table;
    }

    public boolean containsQuery(Query query) {
        return this.m_derivedExpression instanceof SubQuery && this.m_derivedExpression == query;
    }

    @Override
    public SimpleExpressionInterface copyExpression() {
        return null;
    }
}

