/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.model;

import com.sas.codegen.CodeGenInterface;
import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.DBMSSTORE;
import com.sas.codegen.PhysicalTableCG;
import com.sas.codegen.SASSPDS;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.GroupByClause;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.OrderByClause;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.QueryTable;
import com.sas.metadata.remote.Role;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Select;
import com.sas.wadmin.pfd.MappingUtil;
import com.sas.wadmin.transforms.sql.AliasNameDialog;
import com.sas.wadmin.transforms.sql.model.AbstractClause;
import com.sas.wadmin.transforms.sql.model.AbstractTable;
import com.sas.wadmin.transforms.sql.model.ClauseInterface;
import com.sas.wadmin.transforms.sql.model.ClauseType;
import com.sas.wadmin.transforms.sql.model.From;
import com.sas.wadmin.transforms.sql.model.GroupBy;
import com.sas.wadmin.transforms.sql.model.Having;
import com.sas.wadmin.transforms.sql.model.Join;
import com.sas.wadmin.transforms.sql.model.OrderBy;
import com.sas.wadmin.transforms.sql.model.SQLModel;
import com.sas.wadmin.transforms.sql.model.SQLStatementInterface;
import com.sas.wadmin.transforms.sql.model.SelectResults;
import com.sas.wadmin.transforms.sql.model.SourceTable;
import com.sas.wadmin.transforms.sql.model.SourceTableInterface;
import com.sas.wadmin.transforms.sql.model.SubQuery;
import com.sas.wadmin.transforms.sql.model.TableAlias;
import com.sas.wadmin.transforms.sql.model.TableColumn;
import com.sas.wadmin.transforms.sql.model.TableInterface;
import com.sas.wadmin.transforms.sql.model.TargetTable;
import com.sas.wadmin.transforms.sql.model.Where;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class Query
extends AbstractClause
implements SQLStatementInterface {
    private static final WAdminResource bundle = WAdminResource.getBundle(Query.class);
    public static final String CLAUSEADDED = "ClauseAdded";
    public static final String CLAUSEREMOVED = "ClauseRemoved";
    public static final String SOURCETABLEADDED = "SourceTableAdded";
    public static final String SOURCETABLEREMOVED = "SourceTableRemoved";
    protected DataTable m_dataTable;
    protected Select m_select;
    protected ClauseInterface m_parentClause;
    protected List m_lSourceTables;
    protected TargetTable m_targetTable;
    protected SelectResults m_selectResults;
    protected From m_from;
    protected Where m_where;
    protected Having m_having;
    protected GroupBy m_groupBy;
    protected OrderBy m_orderBy;
    protected List m_lSubQuerySources;

    public Query() {
        this(null);
    }

    public Query(Select select) {
        this.m_select = select;
        this.m_lSourceTables = new ArrayList();
        this.m_lSubQuerySources = new ArrayList();
    }

    @Override
    public List getClauses() {
        ArrayList<AbstractClause> lClauses = new ArrayList<AbstractClause>(6);
        lClauses.add(this.m_selectResults);
        lClauses.add(this.m_from);
        if (this.m_where != null) {
            lClauses.add(this.m_where);
        }
        if (this.m_groupBy != null) {
            lClauses.add(this.m_groupBy);
        }
        if (this.m_having != null) {
            lClauses.add(this.m_having);
        }
        if (this.m_orderBy != null) {
            lClauses.add(this.m_orderBy);
        }
        return lClauses;
    }

    public ClauseInterface getClause(ClauseType type) {
        if (type == ClauseType.WHERE) {
            return this.m_where;
        }
        if (type == ClauseType.HAVING) {
            return this.m_having;
        }
        if (type == ClauseType.ORDERBY) {
            return this.m_orderBy;
        }
        if (type == ClauseType.GROUPBY) {
            return this.m_groupBy;
        }
        if (type == ClauseType.SELECT) {
            return this.m_selectResults;
        }
        throw new UnsupportedOperationException("Get of " + type + " not supported.");
    }

    @Override
    public String getName() {
        return this.m_parentClause.getName();
    }

    @Override
    public Query getQuery() {
        return this;
    }

    public ClauseInterface getParentClause() {
        return this.m_parentClause;
    }

    public void setParentClause(ClauseInterface parentClause) {
        this.m_parentClause = parentClause;
    }

    public ClauseInterface addClause(ClauseType type) {
        if (type == ClauseType.WHERE) {
            if (this.m_where != null) {
                return this.m_where;
            }
            this.m_where = new Where();
            this.addClauseImpl(this.m_where);
            return this.m_where;
        }
        if (type == ClauseType.HAVING) {
            if (this.m_having != null) {
                return this.m_having;
            }
            this.m_having = new Having();
            this.addClauseImpl(this.m_having);
            return this.m_having;
        }
        if (type == ClauseType.ORDERBY) {
            if (this.m_orderBy != null) {
                return this.m_orderBy;
            }
            this.m_orderBy = new OrderBy();
            this.addClauseImpl(this.m_orderBy);
            return this.m_orderBy;
        }
        if (type == ClauseType.GROUPBY) {
            if (this.m_groupBy != null) {
                return this.m_groupBy;
            }
            this.m_groupBy = new GroupBy();
            this.addClauseImpl(this.m_groupBy);
            return this.m_groupBy;
        }
        throw new UnsupportedOperationException("Add of " + type + " not supported.");
    }

    protected void addClauseImpl(AbstractClause clause) {
        clause.setSQLModel(this.getSQLModel());
        clause.setParentQuery(this);
        this.getSQLModel().fireChangeEvent(clause, CLAUSEADDED, this);
    }

    public boolean canAddClause(Class clauseClass) {
        if (clauseClass == Where.class && this.m_where == null) {
            return true;
        }
        if (clauseClass == Having.class && this.m_having == null) {
            return true;
        }
        if (clauseClass == GroupBy.class && this.m_groupBy == null) {
            return true;
        }
        return clauseClass == OrderBy.class && this.m_orderBy == null;
    }

    public void removeClause(ClauseInterface clause) {
        if (clause == this.m_where) {
            this.m_where = null;
            this.removeClauseImpl((AbstractClause)clause);
        } else if (clause == this.m_having) {
            this.m_having = null;
            this.removeClauseImpl((AbstractClause)clause);
        } else if (clause == this.m_groupBy) {
            this.m_groupBy = null;
            this.removeClauseImpl((AbstractClause)clause);
        } else if (clause == this.m_orderBy) {
            this.m_orderBy = null;
            this.removeClauseImpl((AbstractClause)clause);
        } else if (clause instanceof SubQuery) {
            ((SubQuery)clause).remove();
            this.removeClauseImpl((AbstractClause)clause);
        } else if (clause instanceof Join) {
            ((Join)clause).remove();
            this.removeClauseImpl((AbstractClause)clause);
        } else {
            this.removeClauseImpl((AbstractClause)clause);
        }
    }

    private void removeClauseImpl(AbstractClause clause) {
        clause.dispose();
        clause.setSQLModel(null);
        clause.setParentQuery(null);
        this.getSQLModel().fireChangeEvent(clause, CLAUSEREMOVED, this);
    }

    public SelectResults getSelectResults() {
        return this.m_selectResults;
    }

    public From getFrom() {
        return this.m_from;
    }

    public Where getWhere() {
        return this.m_where;
    }

    public Having getHaving() {
        return this.m_having;
    }

    public OrderBy getOrderBy() {
        return this.m_orderBy;
    }

    public GroupBy getGroupBy() {
        return this.m_groupBy;
    }

    public Join addJoin(ClassifierMap map) {
        Join join = new Join(map);
        this.addJoinImpl(join);
        return join;
    }

    public Join addJoin(SourceTableInterface left, SourceTableInterface right, String type) {
        Join join = new Join(type);
        this.addJoinImpl(join);
        join.setLeftSide(left);
        join.setRightSide(right);
        return join;
    }

    private void addJoinImpl(Join join) {
        join.setSQLModel(this.getSQLModel());
        join.setParentQuery(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Join insertJoin(String type, SourceTableInterface source) {
        SQLModel model = this.getSQLModel();
        boolean enabledEvents = model.isFireEventsEnabled();
        if (enabledEvents) {
            model.setFireEventsEnabled(false);
        }
        try {
            Join join = this.addJoin(null, null, type);
            this.replaceSource(source, join);
            join.setLeftSide(source);
            if (enabledEvents) {
                model.setFireEventsEnabled(enabledEvents);
            }
            Join join2 = join;
            return join2;
        }
        finally {
            if (enabledEvents) {
                this.getSQLModel().setFireEventsEnabledWithOutUnknownChangesEvent();
            }
        }
    }

    public SubQuery addSubQuery() {
        SubQuery subquery = new SubQuery();
        this.addSubQueryImpl(subquery);
        try {
            SQLModel model = this.getSQLModel();
            boolean enabledEvents = model.isFireEventsEnabled();
            if (enabledEvents) {
                model.setFireEventsEnabled(false);
            }
            subquery.moveDataToModel();
            if (enabledEvents) {
                model.setFireEventsEnabledWithOutUnknownChangesEvent();
            }
        }
        catch (MdException me) {
            if (this.getSQLModel().isSilentModeEnabled()) {
                System.out.print(me.getLocalizedMessage());
            } else {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return subquery;
    }

    public SubQuery addSubQuery(QueryTable table) {
        SubQuery subquery = new SubQuery(table);
        this.addSubQueryImpl(subquery);
        return subquery;
    }

    public SubQuery addSubQuery(Select select) {
        SubQuery subquery = new SubQuery(select);
        this.addSubQueryImpl(subquery);
        return subquery;
    }

    private void addSubQueryImpl(SubQuery subquery) {
        SQLModel model = this.getSQLModel();
        subquery.setSQLModel(model);
        subquery.setParentClause(this);
        subquery.setParentQuery(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubQuery insertSubQuery(SourceTableInterface source) {
        this.getSQLModel().setFireEventsEnabled(false);
        try {
            SubQuery subquery = this.addSubQuery();
            this.replaceSource(source, subquery);
            this.m_selectResults.removeResultsContainingTable((TableInterface)((Object)source));
            if (this.m_where != null) {
                this.m_where.removeExpressionsContainingSourceTable((TableInterface)((Object)source));
            }
            if (this.m_having != null) {
                this.m_having.removeExpressionsContainingSourceTable((TableInterface)((Object)source));
            }
            if (this.m_orderBy != null) {
                this.m_orderBy.removeOrderByColumnsAssociatedWithSourceTable((TableInterface)((Object)source));
            }
            if (this.m_groupBy != null) {
                this.m_groupBy.removeGroupByColumnsAssociatedWithSourceTable((TableInterface)((Object)source));
            }
            this.removeSourceTable((SourceTable)source);
            subquery.addSourceTable((SourceTable)source);
            subquery.getFrom().setSource(source);
            this.getSQLModel().setFireEventsEnabled(true);
            SubQuery subQuery = subquery;
            return subQuery;
        }
        finally {
            this.getSQLModel().setFireEventsEnabledWithOutUnknownChangesEvent();
        }
    }

    public void replaceSource(SourceTableInterface oldSource, SourceTableInterface newSource) {
        ClauseInterface parent;
        ClauseInterface clauseInterface = parent = oldSource != null ? oldSource.getParent() : this.m_from;
        if (oldSource != null && oldSource instanceof SubQuery && parent instanceof From) {
            ((SubQuery)oldSource).resetTransformRole();
        }
        if (oldSource != null && oldSource instanceof Join) {
            ((Join)oldSource).resetTransformRole();
            if (newSource instanceof AbstractTable) {
                boolean isLeftSide = false;
                isLeftSide = ((Join)oldSource).getLeftSide() == newSource;
                ((AbstractTable)((Object)newSource)).setParentNoRemove(null);
                if (isLeftSide) {
                    ((Join)oldSource).setLeftSide(null);
                } else {
                    ((Join)oldSource).setRightSide(null);
                }
            }
        }
        if (oldSource != null && oldSource instanceof AbstractTable && !(newSource instanceof AbstractTable)) {
            ((AbstractTable)((Object)oldSource)).setParentNoRemove(null);
        }
        if (parent instanceof From) {
            ((From)parent).setSource(newSource);
        } else if (parent instanceof Join) {
            Join joinParent = (Join)parent;
            if (joinParent.getLeftSide() == oldSource) {
                joinParent.setLeftSide(newSource);
            } else {
                joinParent.setRightSide(newSource);
            }
        }
        if (oldSource instanceof SourceTable && newSource instanceof SourceTable) {
            oldSource.remove();
        }
    }

    public boolean hasImplicitJoin() {
        return this.m_from.hasImplicitJoin();
    }

    @Override
    public void appendClauseCode(CodegenRequest cgReq, boolean resetPosition) {
        if (resetPosition) {
            this.setStartingPosition(cgReq.getSourceBuffer().length());
        }
        this.appendClauseCode(this.m_selectResults, cgReq, resetPosition);
        this.appendClauseCode(this.m_from, cgReq, resetPosition);
        this.appendClauseCode(this.m_where, cgReq, resetPosition);
        this.appendClauseCode(this.m_groupBy, cgReq, resetPosition);
        this.appendClauseCode(this.m_having, cgReq, resetPosition);
        this.appendClauseCode(this.m_orderBy, cgReq, resetPosition);
        if (resetPosition) {
            this.setEndingPosition(cgReq.getSourceBuffer().length());
        }
    }

    public StringBuffer getSelectResultsForPassthru() {
        StringBuffer code = new StringBuffer();
        List tableColumns = this.m_targetTable.getTableColumns();
        int size = tableColumns.size();
        CodegenRequest cgReq = this.getSQLModel().getCodegenRequest();
        for (int i = 0; i < size; ++i) {
            TableColumn tColumn = (TableColumn)tableColumns.get(i);
            String columnName = "";
            try {
                columnName = DBMSNamesUtil.getQuotedName((String)tColumn.getName(), (DataTable)tColumn.getParent().getDataTable(), (boolean)cgReq.getQuoting(), (boolean)false);
            }
            catch (MdException exc) {
                if (this.getSQLModel().isSilentModeEnabled()) {
                    System.out.print(exc.getLocalizedMessage());
                } else {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                }
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            code.append(columnName);
            char[] indent = new char[columnName.length() + 1];
            Arrays.fill(indent, ' ');
            code.append(" length = ").append(tColumn.getLength());
            String format = tColumn.getFormat();
            String informat = tColumn.getInformat();
            String desc = tColumn.getDescription();
            if (format.length() > 0) {
                code.append("\n").append(String.valueOf(indent)).append("format = ").append(format);
            }
            if (informat.length() > 0) {
                code.append("\n").append(String.valueOf(indent)).append("informat = ").append(informat);
            }
            if (desc.length() > 0) {
                code.append("\n").append(String.valueOf(indent)).append(cgReq.getLabelStatement(desc));
            }
            if (i == size - 1) continue;
            code.append(",\n");
        }
        return code;
    }

    public List getUnMappedColumns() {
        return this.m_selectResults.getUnMappedColumns();
    }

    protected void appendClauseCode(ClauseInterface clause, CodegenRequest cgReq, boolean resetPosition) {
        if (clause != null) {
            clause.appendClauseCode(cgReq, resetPosition);
        }
    }

    @Override
    public List getSourceTables() {
        return this.m_lSourceTables;
    }

    @Override
    public List getAllSourceTables() {
        ArrayList<TargetTable> list = new ArrayList<TargetTable>();
        list.addAll(this.m_lSourceTables);
        List subqueries = this.m_from.getSubqueries();
        for (int i = 0; i < subqueries.size(); ++i) {
            SubQuery subquery = (SubQuery)subqueries.get(i);
            list.add(subquery.getTargetTable());
        }
        return list;
    }

    @Override
    public List getSourceDataTables() {
        ArrayList<DataTable> sTables = new ArrayList<DataTable>();
        ArrayList sourceTables = new ArrayList();
        sourceTables.addAll(this.getSourceTables());
        sourceTables.addAll(this.getSubQuerySourceTables());
        int size = sourceTables.size();
        for (int i = 0; i < size; ++i) {
            AbstractTable table = (AbstractTable)sourceTables.get(i);
            DataTable dTable = table.getDataTable();
            if (dTable == null) continue;
            sTables.add(dTable);
        }
        return sTables;
    }

    @Override
    public boolean isSourceDataTablesSPDS() {
        boolean areSPDS = true;
        List tables = this.getSourceDataTables();
        int size = tables.size();
        if (size == 0) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            try {
                CodeGenInterface tCG = CodeGenUtil.getCodeGenClass((CMetadata)tables.get(i));
                if (tCG instanceof SASSPDS) continue;
                areSPDS = false;
                break;
            }
            catch (MdException exc) {
                if (this.getSQLModel().isSilentModeEnabled()) {
                    System.out.print(exc.getLocalizedMessage());
                    continue;
                }
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                continue;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        return areSPDS;
    }

    public SourceTableInterface addSourceTable(DataTable table) {
        SourceTable srcTable = new SourceTable(table);
        srcTable.setParentQuery(this);
        SQLModel model = this.getSQLModel();
        srcTable.setSQLModel(model);
        try {
            boolean enabledEvents = model.isFireEventsEnabled();
            if (enabledEvents) {
                model.setFireEventsEnabled(false);
            }
            srcTable.moveDataToModel();
            this.m_lSourceTables.add(srcTable);
            this.autoMap(table, this.m_dataTable);
            if (enabledEvents) {
                model.setFireEventsEnabledWithOutUnknownChangesEvent();
            }
        }
        catch (MdException me) {
            if (this.getSQLModel().isSilentModeEnabled()) {
                System.out.print(me.getLocalizedMessage());
            } else {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.getSQLModel().fireChangeEvent(srcTable, SOURCETABLEADDED);
        return srcTable;
    }

    public void removeSourceTable(SourceTable srcTable) {
        srcTable.cleanSourceMappings(this);
        this.m_lSourceTables.remove(srcTable);
        this.getSQLModel().fireChangeEvent(srcTable, SOURCETABLEREMOVED);
    }

    protected List getSubQuerySourceTables() {
        return this.m_lSubQuerySources;
    }

    public void addSubQuerySourceTable(SourceTable srcTable) {
        this.m_lSubQuerySources.add(srcTable);
    }

    public void removeSubQuerySourceTable(SourceTable srcTable) {
        this.m_lSubQuerySources.remove(srcTable);
    }

    public List getUniqueListOfSourceDataTables() {
        try {
            ArrayList<DataTable> list = new ArrayList<DataTable>();
            for (int i = 0; i < this.m_lSourceTables.size(); ++i) {
                SourceTable srcTbl = (SourceTable)this.m_lSourceTables.get(i);
                DataTable table = srcTbl.getDataTable();
                boolean found = false;
                for (int j = 0; j < list.size(); ++j) {
                    DataTable tbl = (DataTable)list.get(j);
                    if (!tbl.getFQID().equalsIgnoreCase(table.getFQID())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                list.add(table);
            }
            return list;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    public void setTargetTable(TargetTable table) {
        this.m_targetTable = table;
        if (this.m_targetTable != null) {
            this.m_dataTable = this.m_targetTable.getDataTable();
            this.m_targetTable.setParentQuery(this);
        } else {
            this.m_dataTable = null;
        }
    }

    @Override
    public TargetTable getTargetTable() {
        return this.m_targetTable;
    }

    public DataTable getTargetDataTable() {
        return this.m_dataTable;
    }

    protected void removeExpressionsContainingSourceTable(TableInterface table) {
        if (this.m_where != null) {
            this.m_where.removeExpressionsContainingSourceTable(table);
        }
        if (this.m_having != null) {
            this.m_having.removeExpressionsContainingSourceTable(table);
        }
        if (this.m_orderBy != null) {
            this.m_orderBy.removeOrderByColumnsAssociatedWithSourceTable(table);
        }
        if (this.m_groupBy != null) {
            this.m_groupBy.removeGroupByColumnsAssociatedWithSourceTable(table);
        }
    }

    protected AbstractTable findSourceTable(String aliasName) {
        AbstractTable srcTable = null;
        List srcTables = this.getAllSourceTables();
        for (int i = 0; i < srcTables.size(); ++i) {
            AbstractTable source = (AbstractTable)srcTables.get(i);
            if (!source.getAlias().equals(aliasName)) continue;
            srcTable = source;
            break;
        }
        return srcTable;
    }

    protected AbstractTable findSourceTable(DataTable table) {
        try {
            ArrayList<AbstractTable> matchingTables = new ArrayList<AbstractTable>();
            ArrayList srcTables = new ArrayList();
            srcTables.addAll(this.getAllSourceTables());
            for (int i = 0; i < srcTables.size(); ++i) {
                AbstractTable source = (AbstractTable)srcTables.get(i);
                if (source.getDataTable() == null || !source.getDataTable().getFQID().equalsIgnoreCase(table.getFQID())) continue;
                matchingTables.add(source);
                if (source.getAlias().length() != 0) continue;
                return source;
            }
            if (matchingTables.isEmpty()) {
                return null;
            }
            return (AbstractTable)matchingTables.get(0);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    protected AbstractTable findTable(DataTable table) {
        try {
            ArrayList<TargetTable> allTables = new ArrayList<TargetTable>();
            allTables.addAll(this.getAllSourceTables());
            allTables.add(this.getTargetTable());
            ArrayList<AbstractTable> matchingTables = new ArrayList<AbstractTable>();
            for (int i = 0; i < allTables.size(); ++i) {
                SourceTable srcTable;
                AbstractTable source = (AbstractTable)allTables.get(i);
                Object oTable = null;
                oTable = source.isAliased() && !(source instanceof TargetTable) ? source.getQueryTable() : source.getDataTable();
                if (oTable == null || !oTable.getFQID().equalsIgnoreCase(table.getFQID())) continue;
                matchingTables.add(source);
                if (!(source instanceof SourceTable) || (srcTable = (SourceTable)source).getAlias().length() != 0) continue;
                return srcTable;
            }
            if (matchingTables.isEmpty()) {
                return null;
            }
            return (AbstractTable)matchingTables.get(0);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    @Override
    public List findAllSourceTables(DataTable table) {
        try {
            ArrayList<AbstractTable> lsrcTables = new ArrayList<AbstractTable>();
            ArrayList allSources = new ArrayList();
            allSources.addAll(this.m_lSourceTables);
            allSources.addAll(this.m_lSubQuerySources);
            for (int i = 0; i < allSources.size(); ++i) {
                AbstractTable source = (AbstractTable)allSources.get(i);
                if (source.getDataTable() == null || !source.getDataTable().getFQID().equalsIgnoreCase(table.getFQID())) continue;
                lsrcTables.add(source);
            }
            return lsrcTables;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    public AbstractTable findSourceTable(QueryTable query) {
        try {
            List allSources = this.getAllSourceTables();
            for (int i = 0; i < allSources.size(); ++i) {
                AbstractTable source = (AbstractTable)allSources.get(i);
                TableAlias alias = source.getTableAlias();
                if (alias == null) continue;
                QueryTable qTable = alias.getQueryTable();
                if (qTable == null) {
                    DataTable oTable = source.getDataTable();
                    if (oTable == null) continue;
                    if (source.getDataTable().getFQID().equalsIgnoreCase(query.getFQID())) {
                        return source;
                    }
                }
                if (qTable.getFQID().equalsIgnoreCase(query.getFQID())) {
                    return source;
                }
                if (!source.getDataTable().getFQID().equalsIgnoreCase(query.getFQID())) continue;
                return source;
            }
            return null;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    @Override
    public void moveDataToModel() throws MdException, RemoteException {
        OrderByClause orderBy;
        GroupByClause groupBy;
        SQLModel model = this.getSQLModel();
        if (this.m_select == null) {
            this.m_select = this.createDefaultSelectMetadata();
            List ltransSources = model.getTransformSources();
            this.m_select.getClassifierSources().addAll((Collection)ltransSources);
            this.m_select.getClassifierTargets().add((Object)this.m_targetTable.getDataTable());
        }
        this.m_lSourceTables.clear();
        AssociationList lclsSources = this.m_select.getClassifierSources();
        for (int i = 0; i < lclsSources.size(); ++i) {
            DataTable source = (DataTable)lclsSources.get(i);
            String type = source.getCMetadataType();
            if (type.equalsIgnoreCase("QueryTable")) {
                AssociationList roles = source.getRoles();
                if (roles.isEmpty()) continue;
                boolean found = false;
                for (int j = 0; j < roles.size(); ++j) {
                    Role role = (Role)roles.get(j);
                    String roleType = role.getObjectRole();
                    if (!roleType.equalsIgnoreCase("Alias")) continue;
                    SourceTable srcTable = new SourceTable(source);
                    srcTable.setParentQuery(this);
                    srcTable.setSQLModel(this.getSQLModel());
                    srcTable.moveDataToModel();
                    this.m_lSourceTables.add(srcTable);
                    found = true;
                    break;
                }
                if (found) continue;
            }
            SourceTable srcTable = new SourceTable(source);
            srcTable.setParentQuery(this);
            srcTable.setSQLModel(this.getSQLModel());
            srcTable.moveDataToModel();
            this.m_lSourceTables.add(srcTable);
        }
        if (this.m_targetTable != null) {
            this.m_targetTable.setParentQuery(this);
            this.m_targetTable.moveDataToModel();
            this.m_dataTable = this.m_targetTable.getDataTable();
        }
        this.m_from = new From();
        this.addClauseImpl(this.m_from);
        this.m_from.moveDataToModel();
        AssociationList alTransSources = this.m_select.getTransformationSources();
        if (!alTransSources.isEmpty()) {
            for (int i = 0; i < alTransSources.size(); ++i) {
                Root source = (Root)alTransSources.get(i);
                if (!source.getCMetadataType().equalsIgnoreCase("ClassifierMap")) continue;
                if (((ClassifierMap)source).getTransformRole().equalsIgnoreCase("Where")) {
                    this.m_where = new Where((ClassifierMap)source);
                    this.addClauseImpl(this.m_where);
                    this.m_where.moveDataToModel();
                    continue;
                }
                if (!((ClassifierMap)source).getTransformRole().equalsIgnoreCase("Having")) continue;
                this.m_having = new Having((ClassifierMap)source);
                this.addClauseImpl(this.m_having);
                this.m_having.moveDataToModel();
            }
        }
        if ((groupBy = this.m_select.getGroupByForSelect()) != null) {
            this.m_groupBy = new GroupBy(groupBy);
            this.addClauseImpl(this.m_groupBy);
            this.m_groupBy.moveDataToModel();
        }
        if ((orderBy = this.m_select.getOrderByForSelect()) != null) {
            this.m_orderBy = new OrderBy(orderBy);
            this.addClauseImpl(this.m_orderBy);
            this.m_orderBy.moveDataToModel();
        }
        ClassifierMap mainClsMap = model.getClassifierMap();
        this.m_selectResults = new SelectResults(mainClsMap);
        this.addClauseImpl(this.m_selectResults);
        this.m_selectResults.moveDataToModel();
        if (this.getSQLModel().isFirstTime()) {
            AbstractTable source;
            int i;
            List pfdSources = model.getTransformSources();
            ArrayList<DataTable> newSources = new ArrayList<DataTable>();
            for (int i2 = 0; i2 < pfdSources.size(); ++i2) {
                DataTable table = (DataTable)pfdSources.get(i2);
                List sourceTables = this.findAllSourceTables(table);
                if (sourceTables.size() != 0) continue;
                newSources.add(table);
            }
            ArrayList<AbstractTable> removedSources = new ArrayList<AbstractTable>();
            List sources = this.getAllSourceTables();
            for (i = 0; i < sources.size(); ++i) {
                source = (AbstractTable)sources.get(i);
                if (source instanceof TargetTable) continue;
                DataTable srcTable = source.getDataTable();
                if (srcTable == null) {
                    removedSources.add(source);
                    continue;
                }
                boolean found = false;
                for (int j = 0; j < pfdSources.size(); ++j) {
                    DataTable table = (DataTable)pfdSources.get(j);
                    if (!table.getFQID().equalsIgnoreCase(srcTable.getFQID())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                removedSources.add(source);
            }
            for (i = 0; i < removedSources.size(); ++i) {
                source = (SourceTable)removedSources.get(i);
                ClauseInterface parent = source.getParent();
                if (parent instanceof Join) {
                    Join join = (Join)parent;
                    SourceTableInterface leftSide = join.getLeftSide();
                    SourceTableInterface rightSide = join.getRightSide();
                    SourceTableInterface src = null;
                    if (leftSide == source) {
                        src = rightSide;
                    } else if (rightSide == source) {
                        src = leftSide;
                    }
                    ((SourceTable)source).remove();
                    if (src != null) {
                        this.replaceSource(join, src);
                    }
                    join.remove();
                    continue;
                }
                ((SourceTable)source).remove();
            }
            for (i = 0; i < newSources.size(); ++i) {
                DataTable table = (DataTable)newSources.get(i);
                SourceTable source2 = null;
                List allSources = this.getAllSourceTables();
                int size = allSources.size();
                if (size == 0 && newSources.size() == 1) {
                    source2 = new SourceTable(table);
                    source2.setParentQuery(this);
                    source2.setSQLModel(this.getSQLModel());
                    source2.moveDataToModel();
                    this.m_lSourceTables.add(source2);
                    this.m_from.setSource(source2);
                } else if (this.m_from.hasOpenTemplates()) {
                    List objects = this.m_from.getSourceObjectsWithOpenTemplates();
                    if (!objects.isEmpty()) {
                        ClauseInterface clause = (ClauseInterface)objects.get(0);
                        source2 = new SourceTable(table);
                        source2.setParentQuery(this);
                        source2.setSQLModel(this.getSQLModel());
                        source2.moveDataToModel();
                        this.m_lSourceTables.add(source2);
                        if (clause instanceof From) {
                            this.m_from.setSource(source2);
                        } else if (clause instanceof Join) {
                            Join join = (Join)clause;
                            if (join.getLeftSide() == null) {
                                join.setLeftSide(source2);
                            } else {
                                join.setRightSide(source2);
                            }
                        }
                    }
                } else {
                    SourceTableInterface existingSource = this.m_from.getSource();
                    if (existingSource instanceof Join) {
                        ((Join)existingSource).resetTransformRole();
                    }
                    Join join = this.insertJoin("Inner", existingSource);
                    source2 = new SourceTable(table);
                    source2.setParentQuery(this);
                    source2.setSQLModel(this.getSQLModel());
                    source2.moveDataToModel();
                    this.m_lSourceTables.add(source2);
                    join.setRightSide(source2);
                }
                if (source2 == null) continue;
                this.autoMap(table, this.m_dataTable);
            }
            this.getSQLModel().resetFirstTime();
        }
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        this.m_targetTable.moveDataToStore();
        AssociationList clsSources = this.m_select.getClassifierSources();
        clsSources.removeAllElements();
        clsSources.flushAll();
        this.m_from.moveDataToStore();
        this.m_selectResults.moveDataToStore();
        if (this.m_where != null) {
            this.m_where.moveDataToStore();
        }
        if (this.m_groupBy != null) {
            this.m_groupBy.moveDataToStore();
        }
        if (this.m_having != null) {
            this.m_having.moveDataToStore();
        }
        if (this.m_orderBy != null) {
            this.m_orderBy.moveDataToStore();
        }
        for (int i = 0; i < this.m_lSourceTables.size(); ++i) {
            SourceTable srcTable = (SourceTable)this.m_lSourceTables.get(i);
            TableAlias aliasTable = srcTable.getTableAlias();
            DataTable table = srcTable.getDataTable();
            if (aliasTable == null) {
                clsSources.add((Object)table);
                continue;
            }
            clsSources.add((Object)aliasTable.getQueryTable());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateData() {
        if (this.getSQLModel().isSilentModeEnabled()) {
            return true;
        }
        if (this.m_from == null) {
            return true;
        }
        if (this.m_from.hasOpenTemplates()) {
            SQLModel model = this.getSQLModel();
            boolean enabledEvents = model.isFireEventsEnabled();
            try {
                SourceTableInterface source;
                if (enabledEvents) {
                    model.setFireEventsEnabled(false);
                }
                if ((source = this.m_from.getSource()) instanceof Join) {
                    int retValue = MessageUtil.displayMessage((String)bundle.getString("Query.EmptyTemplatesFound.Error.txt"), (int)2, (int)1);
                    if (retValue == 2) {
                        boolean bl = false;
                        return bl;
                    }
                    if (retValue == 0) {
                        List sqlObjs = this.m_from.getSourceObjectsWithOpenTemplates();
                        for (int i = 0; i < sqlObjs.size(); ++i) {
                            Object obj = sqlObjs.get(i);
                            if (obj instanceof From) continue;
                            Join join = (Join)obj;
                            Join nextJoin = null;
                            SourceTableInterface leftSide = join.getLeftSide();
                            SourceTableInterface rightSide = join.getRightSide();
                            SourceTableInterface src = null;
                            if (leftSide == null && rightSide == null) {
                                src = null;
                            } else if (leftSide == null) {
                                src = rightSide;
                            } else if (rightSide == null) {
                                src = leftSide;
                            }
                            ClauseInterface parent = join.getParent();
                            if (parent instanceof From) {
                                ((From)parent).setSource(src);
                            } else if (parent instanceof Join) {
                                Join joinParent = (Join)parent;
                                if (joinParent.getLeftSide() == join) {
                                    joinParent.setLeftSide(src);
                                } else {
                                    joinParent.setRightSide(src);
                                }
                                if (src == null) {
                                    nextJoin = joinParent;
                                    leftSide = nextJoin.getLeftSide();
                                    rightSide = nextJoin.getRightSide();
                                    if (leftSide == null && rightSide == null) continue;
                                    if (leftSide == null) {
                                        src = rightSide;
                                    } else if (rightSide == null) {
                                        src = leftSide;
                                    }
                                    parent = nextJoin.getParent();
                                    if (parent instanceof From) {
                                        ((From)parent).setSource(src);
                                    } else if (parent instanceof Join) {
                                        joinParent = (Join)parent;
                                        if (joinParent.getLeftSide() == nextJoin) {
                                            joinParent.setLeftSide(src);
                                        } else {
                                            joinParent.setRightSide(src);
                                        }
                                    }
                                }
                            }
                            join.remove();
                            if (nextJoin != null) {
                                nextJoin.remove();
                            }
                            if (!enabledEvents) continue;
                            model.setFireEventsEnabled(enabledEvents);
                        }
                    }
                } else {
                    MessageUtil.displayMessage((String)bundle.getString("Query.EmptyFromTemplate.Error.txt"), (int)2);
                }
            }
            finally {
                if (enabledEvents) {
                    model.setFireEventsEnabledWithOutUnknownChangesEvent();
                }
            }
        }
        return true;
    }

    @Override
    public void dispose() {
        for (int i = 0; i < this.m_lSourceTables.size(); ++i) {
            ((SourceTable)this.m_lSourceTables.get(i)).remove();
        }
        this.m_lSourceTables.clear();
        this.m_targetTable.remove();
        this.m_targetTable = null;
        if (this.m_from != null) {
            this.m_from.dispose();
            this.m_from = null;
        }
        if (this.m_where != null) {
            this.m_where.dispose();
            this.m_where = null;
        }
        if (this.m_having != null) {
            this.m_having.dispose();
            this.m_having = null;
        }
        if (this.m_groupBy != null) {
            this.m_groupBy.dispose();
            this.m_groupBy = null;
        }
        if (this.m_orderBy != null) {
            this.m_orderBy.dispose();
            this.m_orderBy = null;
        }
        if (this.m_selectResults != null) {
            this.m_selectResults.dispose();
            this.m_selectResults = null;
        }
    }

    protected Select getSelectObject() {
        return this.m_select;
    }

    private Select createDefaultSelectMetadata() throws MdException, RemoteException {
        Select select = (Select)Workspace.getMdFactory().createComplexMetadataObject(this.getSQLModel().getObjectStore(), "Select", "Select", this.getSQLModel().getRepositoryId());
        select.setTransformRole("Select");
        return select;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSourceTablesPassThruEnabled(CodegenRequest cgReq) {
        SourceTable src;
        SQLModel mdl = this.getSQLModel();
        List sourceTables = this.getAllSourceTables();
        sourceTables.addAll(this.getSubQuerySourceTables());
        boolean isPassThru = mdl.isPassThrough();
        ArrayList<SourceTable> cleanupTables = new ArrayList<SourceTable>();
        ArrayList<DataTable> sourceDataTables = new ArrayList<DataTable>();
        try {
            boolean canPassThrough;
            int i;
            for (i = 0; i < sourceTables.size(); ++i) {
                if (!(sourceTables.get(i) instanceof SourceTable)) continue;
                src = (SourceTable)sourceTables.get(i);
                if (src.isMoveTableToUploadLibrary()) {
                    cleanupTables.add(src);
                    DataTable table = src.getTable(cgReq);
                    sourceDataTables.add(table);
                    continue;
                }
                if (src.getDataTable() == null) continue;
                sourceDataTables.add(src.getDataTable());
            }
            if (isPassThru && !sourceDataTables.isEmpty()) {
                for (i = 0; i < sourceDataTables.size(); ++i) {
                    DBMSSTORE tableCG = (DBMSSTORE)CodeGenUtil.getCodeGenClass((CMetadata)((DataTable)sourceDataTables.get(i)));
                    if (tableCG.getPassThroughSupport()) continue;
                    boolean table = false;
                    return table;
                }
            }
            if (isPassThru && !sourceDataTables.isEmpty() && !(canPassThrough = PhysicalTableCG.hasEqualDeployedComponents(sourceDataTables, cgReq))) {
                boolean tableCG = false;
                return tableCG;
            }
        }
        catch (MdException exc) {
            if (this.getSQLModel().isSilentModeEnabled()) {
                System.out.print(exc.getLocalizedMessage());
            }
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        finally {
            for (int i = 0; i < cleanupTables.size(); ++i) {
                src = (SourceTable)cleanupTables.get(i);
                src.cleanup(cgReq);
            }
        }
        return isPassThru;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTargetTablePassThruEnabled(CodegenRequest cgReq) {
        boolean isTargetPassThru;
        block12: {
            SQLModel mdl = this.getSQLModel();
            List sourceTables = this.getSourceTables();
            boolean isPassThru = mdl.isPassThrough();
            isTargetPassThru = mdl.isTargetPassThru();
            ArrayList<SourceTable> cleanupTables = new ArrayList<SourceTable>();
            ArrayList<DataTable> sourceDataTables = new ArrayList<DataTable>();
            try {
                for (int i = 0; i < sourceTables.size(); ++i) {
                    SourceTable src = (SourceTable)sourceTables.get(i);
                    if (src.isMoveTableToUploadLibrary()) {
                        cleanupTables.add(src);
                        DataTable table = src.getTable(cgReq);
                        sourceDataTables.add(table);
                        continue;
                    }
                    if (src.getDataTable() == null) continue;
                    sourceDataTables.add(src.getDataTable());
                }
                if (isPassThru && !sourceDataTables.isEmpty() && isTargetPassThru) {
                    ArrayList tables = new ArrayList();
                    tables.add(sourceDataTables.get(0));
                    tables.add(this.getTargetDataTable());
                    isTargetPassThru = PhysicalTableCG.hasEqualDeployedComponents(tables, cgReq);
                    break block12;
                }
                if (isPassThru && !sourceDataTables.isEmpty()) break block12;
                isTargetPassThru = false;
            }
            catch (MdException exc) {
                if (this.getSQLModel().isSilentModeEnabled()) {
                    System.out.print(exc.getLocalizedMessage());
                }
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            finally {
                for (int i = 0; i < cleanupTables.size(); ++i) {
                    SourceTable src = (SourceTable)cleanupTables.get(i);
                    src.cleanup(cgReq);
                }
            }
        }
        return isTargetPassThru;
    }

    public boolean isSourceTableUsed(PhysicalTable table) {
        return this.isSourceTableUsed(table, null);
    }

    public boolean isSourceTableUsed(PhysicalTable table, SourceTableInterface excludingTable) {
        try {
            List tables = this.getSQLModel().getStatement().getAllSourceTables();
            boolean used = false;
            for (int i = 0; i < tables.size(); ++i) {
                DataTable existingTable;
                AbstractTable srcTable = (AbstractTable)tables.get(i);
                if (excludingTable != null && srcTable == excludingTable || !(existingTable = srcTable.getDataTable()).getFQID().equals(table.getFQID()) || srcTable.isAliased()) continue;
                used = true;
                break;
            }
            return used;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    public boolean isTargetTableUsed(DataTable table) {
        try {
            DataTable existingTable = null;
            existingTable = this instanceof SubQuery ? this.getSQLModel().getStatement().getQuery().getTargetDataTable() : this.getTargetDataTable();
            return !existingTable.getFQID().equals(table.getFQID());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    public SourceTableInterface addSourceAliasTable(PhysicalTable table) {
        if (this.getSQLModel().isSilentModeEnabled()) {
            return this.addSourceTable((DataTable)table);
        }
        SourceTable srcTable = null;
        AliasNameDialog dlg = new AliasNameDialog();
        dlg.setDefault(table);
        if (dlg.showDialog() == 0) {
            String alias = dlg.getAliasText();
            srcTable = (SourceTable)this.addSourceTable((DataTable)table);
            srcTable.setAlias(alias);
        }
        return srcTable;
    }

    protected void autoMap(DataTable source, DataTable target) throws MdException, RemoteException {
        if (this.m_selectResults != null) {
            this.m_selectResults.moveDataToStore();
        }
        MappingUtil.createColumnMappings(source, target, this.getSQLModel().getClassifierMap());
        ((AbstractTable)this.m_targetTable).moveDataToModel();
        if (this.m_selectResults != null) {
            this.m_selectResults.moveDataToModel();
        }
    }
}

