/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.model;

import com.sas.codegen.CodegenRequest;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.OrderByClause;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Select;
import com.sas.wadmin.transforms.sql.model.AbstractClause;
import com.sas.wadmin.transforms.sql.model.AbstractTable;
import com.sas.wadmin.transforms.sql.model.OrderByColumn;
import com.sas.wadmin.transforms.sql.model.Query;
import com.sas.wadmin.transforms.sql.model.SQLModel;
import com.sas.wadmin.transforms.sql.model.TableColumn;
import com.sas.wadmin.transforms.sql.model.TableInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class OrderBy
extends AbstractClause {
    private static final WAdminResource bundle = WAdminResource.getBundle(OrderBy.class);
    private List m_orderByColumns = new ArrayList();
    private OrderByClause m_orderByClause;
    public static final String ORDERBYCOLUMNCHANGED = "OrderByColumnChanged";
    public static final String ASCENDING = "asc";
    public static final String DESCENDING = "desc";
    public static String DEFAULT_SORT_ORDER = "asc";

    public OrderBy() {
    }

    public OrderBy(OrderByClause clause) {
        this();
        this.m_orderByClause = clause;
    }

    public static List getSortOrderTranslatedValues() {
        ArrayList<String> sortOrderTranslated = new ArrayList<String>();
        sortOrderTranslated.add(bundle.getString("OrderByColumn.Ascending.txt"));
        sortOrderTranslated.add(bundle.getString("OrderByColumn.Descending.txt"));
        return sortOrderTranslated;
    }

    public static List getSortOrderUnTranslatedValues() {
        ArrayList<String> sortOrderUnTranslated = new ArrayList<String>();
        sortOrderUnTranslated.add(ASCENDING);
        sortOrderUnTranslated.add(DESCENDING);
        return sortOrderUnTranslated;
    }

    @Override
    public String getName() {
        return "Order by";
    }

    @Override
    public Icon getIcon() {
        return bundle.getImageIcon("OrderBy.node.image");
    }

    @Override
    public void appendClauseCode(CodegenRequest cgReq, boolean resetPosition) {
        if (resetPosition) {
            this.setStartingPosition(cgReq.getSourceBuffer().length());
        }
        int size = this.m_orderByColumns.size();
        String desc = this.getDescription();
        if (desc.length() > 0) {
            cgReq.addCommentLine(desc);
        }
        cgReq.addSourceCode("order by\n");
        cgReq.indent();
        for (int i = 0; i < size; ++i) {
            OrderByColumn column = (OrderByColumn)this.m_orderByColumns.get(i);
            if (column.getTableColumn().getParent() == null) continue;
            cgReq.addSourceCode(column.getSQLCode(cgReq));
            if (i != size - 1) {
                cgReq.addSourceCode(", ");
            }
            cgReq.addSourceCode("\n");
        }
        cgReq.unIndent();
        if (resetPosition) {
            this.setEndingPosition(cgReq.getSourceBuffer().length());
        }
    }

    public List getOrderByColumns() {
        return this.m_orderByColumns;
    }

    public void addOrderByColumn(OrderByColumn column) {
        if (column == null) {
            return;
        }
        this.m_orderByColumns.add(column);
        this.getSQLModel().fireChangeEvent(this, ORDERBYCOLUMNCHANGED);
    }

    public void addOrderByColumn(int index, OrderByColumn column) {
        if (column == null) {
            return;
        }
        this.m_orderByColumns.add(index, column);
        this.getSQLModel().fireChangeEvent(this, ORDERBYCOLUMNCHANGED);
    }

    public int getIndexOfOrderByColumn(OrderByColumn column) {
        return this.m_orderByColumns.indexOf(column);
    }

    public void moveOrderByColumn(int oldIndex, int newIndex) {
        OrderByColumn column = (OrderByColumn)this.m_orderByColumns.remove(oldIndex);
        this.m_orderByColumns.add(newIndex, column);
        this.getSQLModel().fireChangeEvent(this, ORDERBYCOLUMNCHANGED);
    }

    public void removeOrderByColumn(OrderByColumn column) {
        this.m_orderByColumns.remove(column);
        column.dispose();
        column = null;
        this.getSQLModel().fireChangeEvent(this, ORDERBYCOLUMNCHANGED);
    }

    public void removeOrderByColumn(int index) {
        OrderByColumn column = (OrderByColumn)this.m_orderByColumns.get(index);
        this.m_orderByColumns.remove(index);
        column.dispose();
        column = null;
        this.getSQLModel().fireChangeEvent(this, ORDERBYCOLUMNCHANGED);
    }

    public OrderByClause getOrderByClause() {
        return this.m_orderByClause;
    }

    protected void removeOrderByColumnsAssociatedWithSourceTable(TableInterface table) {
        for (int i = this.m_orderByColumns.size() - 1; i >= 0; --i) {
            OrderByColumn column = (OrderByColumn)this.m_orderByColumns.get(i);
            if (!column.containsSourceTable(table)) continue;
            this.m_orderByColumns.remove(column);
            column.dispose();
        }
    }

    @Override
    public void moveDataToModel() throws MdException, RemoteException {
        if (this.m_orderByClause == null) {
            return;
        }
        this.setDescription(this.m_orderByClause.getDesc());
        AssociationList colList = this.m_orderByClause.getColumns();
        for (int i = 0; i < colList.size(); ++i) {
            TableColumn tColumn;
            Column col = (Column)colList.get(i);
            DataTable metaTable = col.getTable();
            Query pQuery = this.getParentQuery();
            AbstractTable table = pQuery.findTable(metaTable);
            if (table == null || (tColumn = table.findTableColumn(col)) == null) continue;
            OrderByColumn orCol = new OrderByColumn(tColumn, table, this);
            orCol.setParentForPropertySets((Root)this.m_orderByClause);
            this.m_orderByColumns.add(orCol);
            orCol.moveDataToModel();
        }
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        SQLModel model = this.getSQLModel();
        MdObjectStore store = model.getObjectStore();
        String reposId = model.getRepositoryId();
        Select select = this.getParentQuery().getSelectObject();
        if (this.m_orderByClause == null) {
            this.m_orderByClause = (OrderByClause)Workspace.getMdFactory().createComplexMetadataObject(store, "Order by", "OrderByClause", reposId);
            select.setOrderByForSelect(this.m_orderByClause);
        }
        this.m_orderByClause.setDesc(this.getDescription());
        AssociationList orderByColumns = this.m_orderByClause.getColumns();
        orderByColumns.removeAllElements();
        orderByColumns.flushAll();
        for (int i = 0; i < this.m_orderByColumns.size(); ++i) {
            OrderByColumn orCol = (OrderByColumn)this.m_orderByColumns.get(i);
            orCol.setParentForPropertySets((Root)this.m_orderByClause);
            TableColumn tableCol = orCol.getTableColumn();
            if (tableCol.getParent() != null) {
                Column col = tableCol.getColumn();
                if (col == null) {
                    tableCol.moveDataToStore();
                }
                orderByColumns.add((Object)tableCol.getColumn());
                orCol.moveDataToStore();
                continue;
            }
            orCol.dispose();
        }
    }

    @Override
    public void dispose() {
        block6: {
            try {
                for (int i = 0; i < this.m_orderByColumns.size(); ++i) {
                    OrderByColumn orCol = (OrderByColumn)this.m_orderByColumns.get(i);
                    orCol.dispose();
                }
                this.m_orderByColumns.clear();
                if (this.m_orderByClause == null) break block6;
                MdObjectStore store = (MdObjectStore)this.m_orderByClause.getObjectStore();
                try {
                    store.removeObjectFromStore((CMetadata)this.m_orderByClause, "<OrderByClause><PropertySets><Properties/><SetProperties><SpecTargetTransformations/></SetProperties></PropertySets></OrderByClause>");
                    this.m_orderByClause = null;
                }
                catch (MdException exc) {
                    if (this.getSQLModel().isSilentModeEnabled()) {
                        System.out.print(exc.getLocalizedMessage());
                        break block6;
                    }
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }
}

