/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.model;

import com.sas.codegen.CodegenRequest;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.GroupByClause;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Select;
import com.sas.wadmin.transforms.sql.model.AbstractClause;
import com.sas.wadmin.transforms.sql.model.AbstractTable;
import com.sas.wadmin.transforms.sql.model.GroupByColumn;
import com.sas.wadmin.transforms.sql.model.Query;
import com.sas.wadmin.transforms.sql.model.SQLModel;
import com.sas.wadmin.transforms.sql.model.TableColumn;
import com.sas.wadmin.transforms.sql.model.TableInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class GroupBy
extends AbstractClause {
    private static final WAdminResource bundle = WAdminResource.getBundle(GroupBy.class);
    private List m_groupByColumns = new ArrayList();
    private GroupByClause m_groupByClause;
    public static final String NAME = "name";
    public static final String POSITION = "position";
    public static String DEFAULT_COLUMN_REFERENCE = "name";
    public static final String GROUPBYCOLUMNCHANGED = "GroupByColumnChanged";

    public GroupBy() {
    }

    public GroupBy(GroupByClause groupByClause) {
        this();
        this.m_groupByClause = groupByClause;
    }

    @Override
    public String getName() {
        return "Group by";
    }

    public static List getColumnReferenceTranslatedValues() {
        ArrayList<String> columnReferenceTranslated = new ArrayList<String>();
        columnReferenceTranslated = new ArrayList();
        columnReferenceTranslated.add(bundle.getString("GroupBy.ColumnReference.Name.txt"));
        columnReferenceTranslated.add(bundle.getString("GroupBy.ColumnReference.Position.txt"));
        return columnReferenceTranslated;
    }

    public static List getColumnReferenceUnTranslatedValues() {
        ArrayList<String> columnReferenceUnTranslated = new ArrayList<String>();
        columnReferenceUnTranslated.add(NAME);
        columnReferenceUnTranslated.add(POSITION);
        return columnReferenceUnTranslated;
    }

    @Override
    public Icon getIcon() {
        return bundle.getImageIcon("GroupBy.node.image");
    }

    @Override
    public void appendClauseCode(CodegenRequest cgReq, boolean resetPosition) {
        String desc;
        if (resetPosition) {
            this.setStartingPosition(cgReq.getSourceBuffer().length());
        }
        if ((desc = this.getDescription()).length() > 0) {
            cgReq.addCommentLine(desc);
        }
        cgReq.addSourceCode("group by\n");
        cgReq.indent();
        int size = this.m_groupByColumns.size();
        for (int i = 0; i < size; ++i) {
            GroupByColumn column = (GroupByColumn)this.m_groupByColumns.get(i);
            if (column.getTableColumn().getParent() == null) continue;
            cgReq.addSourceCode(column.getSQLCode(cgReq));
            if (i != size - 1) {
                cgReq.addSourceCode(", ");
            }
            cgReq.addSourceCode("\n");
        }
        cgReq.unIndent();
        if (resetPosition) {
            this.setEndingPosition(cgReq.getSourceBuffer().length());
        }
    }

    public List getGroupByColumns() {
        return this.m_groupByColumns;
    }

    public void addGroupByColumn(GroupByColumn column) {
        if (column == null) {
            return;
        }
        this.m_groupByColumns.add(column);
        this.getSQLModel().fireChangeEvent(this, GROUPBYCOLUMNCHANGED);
    }

    public void addGroupByColumn(int index, GroupByColumn column) {
        if (column == null) {
            return;
        }
        this.m_groupByColumns.add(index, column);
        this.getSQLModel().fireChangeEvent(this, GROUPBYCOLUMNCHANGED);
    }

    public int getIndexOfGroupByColumn(GroupByColumn column) {
        return this.m_groupByColumns.indexOf(column);
    }

    public void moveGroupByColumn(int oldIndex, int newIndex) {
        GroupByColumn column = (GroupByColumn)this.m_groupByColumns.remove(oldIndex);
        this.m_groupByColumns.add(newIndex, column);
        this.getSQLModel().fireChangeEvent(this, GROUPBYCOLUMNCHANGED);
    }

    public void removeGroupByColumn(GroupByColumn column) {
        this.m_groupByColumns.remove(column);
        column.dispose();
        column = null;
        this.getSQLModel().fireChangeEvent(this, GROUPBYCOLUMNCHANGED);
    }

    public void removeGroupByColumn(int index) {
        GroupByColumn column = (GroupByColumn)this.m_groupByColumns.get(index);
        this.m_groupByColumns.remove(index);
        column.dispose();
        column = null;
        this.getSQLModel().fireChangeEvent(this, GROUPBYCOLUMNCHANGED);
    }

    protected void removeGroupByColumnsAssociatedWithSourceTable(TableInterface table) {
        for (int i = this.m_groupByColumns.size() - 1; i >= 0; --i) {
            GroupByColumn column = (GroupByColumn)this.m_groupByColumns.get(i);
            if (!column.containsSourceTable(table)) continue;
            this.m_groupByColumns.remove(column);
            column.dispose();
        }
    }

    @Override
    public void moveDataToModel() throws MdException, RemoteException {
        if (this.m_groupByClause == null) {
            return;
        }
        this.setDescription(this.m_groupByClause.getDesc());
        AssociationList colList = this.m_groupByClause.getColumns();
        for (int i = 0; i < colList.size(); ++i) {
            TableColumn tColumn;
            Column col = (Column)colList.get(i);
            DataTable metaTable = col.getTable();
            Query pQuery = this.getParentQuery();
            AbstractTable table = pQuery.findTable(metaTable);
            if (table == null || (tColumn = table.findTableColumn(col)) == null) continue;
            GroupByColumn orCol = new GroupByColumn(tColumn, table, this);
            orCol.setParentForPropertySets((Root)this.m_groupByClause);
            this.m_groupByColumns.add(orCol);
            orCol.moveDataToModel();
        }
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        SQLModel model = this.getSQLModel();
        MdObjectStore store = model.getObjectStore();
        String reposId = model.getRepositoryId();
        Select select = this.getParentQuery().getSelectObject();
        if (this.m_groupByClause == null) {
            this.m_groupByClause = (GroupByClause)Workspace.getMdFactory().createComplexMetadataObject(store, "Group by", "GroupByClause", reposId);
            select.setGroupByForSelect(this.m_groupByClause);
        }
        this.m_groupByClause.setDesc(this.getDescription());
        AssociationList groupByColumns = this.m_groupByClause.getColumns();
        groupByColumns.removeAllElements();
        groupByColumns.flushAll();
        for (int i = 0; i < this.m_groupByColumns.size(); ++i) {
            GroupByColumn orCol = (GroupByColumn)this.m_groupByColumns.get(i);
            orCol.setParentForPropertySets((Root)this.m_groupByClause);
            TableColumn tableCol = orCol.getTableColumn();
            if (tableCol.getParent() != null) {
                Column col = tableCol.getColumn();
                if (col == null) {
                    tableCol.moveDataToStore();
                }
                groupByColumns.add((Object)col);
                orCol.moveDataToStore();
                continue;
            }
            orCol.dispose();
        }
    }

    @Override
    public void dispose() {
        block6: {
            try {
                for (int i = 0; i < this.m_groupByColumns.size(); ++i) {
                    GroupByColumn orCol = (GroupByColumn)this.m_groupByColumns.get(i);
                    orCol.dispose();
                }
                this.m_groupByColumns.clear();
                if (this.m_groupByClause == null) break block6;
                MdObjectStore store = (MdObjectStore)this.m_groupByClause.getObjectStore();
                try {
                    store.removeObjectFromStore((CMetadata)this.m_groupByClause, "<GroupByClause><PropertySets><Properties/><SetProperties><SpecTargetTransformations/></SetProperties></PropertySets></GroupByClause>");
                    this.m_groupByClause = null;
                }
                catch (MdException exc) {
                    if (this.getSQLModel().isSilentModeEnabled()) {
                        System.out.print(exc.getLocalizedMessage());
                        break block6;
                    }
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }
}

