/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.model;

import com.sas.codegen.CodegenRequest;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Select;
import com.sas.wadmin.transforms.sql.model.AbstractClause;
import com.sas.wadmin.transforms.sql.model.Join;
import com.sas.wadmin.transforms.sql.model.Query;
import com.sas.wadmin.transforms.sql.model.SourceTable;
import com.sas.wadmin.transforms.sql.model.SourceTableInterface;
import com.sas.wadmin.transforms.sql.model.SubQuery;
import com.sas.wadmin.transforms.sql.model.TableInterface;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class From
extends AbstractClause {
    private static final WAdminResource bundle = WAdminResource.getBundle(From.class);
    public static final String SOURCECHANGED = "SourceChanged";
    public static final String SOURCEREMOVED = "SourceRemoved";
    private static final String JOINFROMROLE = "StartJoin";
    private static final String INLINEVIEWROLE = "InLineView";
    private SourceTableInterface m_source;

    @Override
    public String getName() {
        return "From";
    }

    public SourceTableInterface getSource() {
        return this.m_source;
    }

    public void setSource(SourceTableInterface source) {
        if (this.m_source == source) {
            return;
        }
        if (this.m_source != null) {
            this.m_source.setParent(null);
        }
        this.m_source = source;
        if (this.m_source != null) {
            this.m_source.setParent(this);
        }
        this.getSQLModel().fireChangeEvent(this, SOURCECHANGED);
    }

    protected void removeSource(SourceTableInterface table) {
        if (table == null) {
            return;
        }
        if (this.m_source == table) {
            if (table instanceof TableInterface) {
                Query query = this.getParentQuery();
                query.removeExpressionsContainingSourceTable((TableInterface)((Object)this.m_source));
                if (query instanceof SubQuery && query.getParentClause() instanceof Query) {
                    query.getParentQuery().removeExpressionsContainingSourceTable((TableInterface)((Object)this.m_source));
                }
            }
            this.m_source = null;
            this.getSQLModel().fireChangeEvent(this, SOURCECHANGED);
        }
    }

    protected boolean hasImplicitJoin() {
        if (this.m_source != null) {
            if (this.m_source instanceof SubQuery) {
                return false;
            }
            return this.m_source.hasImplicitJoin();
        }
        return false;
    }

    @Override
    public void appendClauseCode(CodegenRequest cgReq, boolean resetPosition) {
        String desc;
        if (resetPosition) {
            this.setStartingPosition(cgReq.getSourceBuffer().length());
        }
        if ((desc = this.getDescription()).length() > 0) {
            cgReq.addCommentLine(desc);
        }
        cgReq.addSourceCode("from\n").indent();
        if (this.m_source != null) {
            this.m_source.appendClauseCode(cgReq, resetPosition);
        } else {
            cgReq.addCommentLine(bundle.getString("From.TableMissing.txt"));
        }
        cgReq.unIndent().addSourceCode("\n");
        if (resetPosition) {
            this.setEndingPosition(cgReq.getSourceBuffer().length());
        }
    }

    @Override
    public void moveDataToModel() throws MdException, RemoteException {
        List srcTables = this.getParentQuery().getSourceTables();
        AssociationList alTransSources = this.getParentQuery().getSelectObject().getTransformationSources();
        if (!alTransSources.isEmpty()) {
            boolean wasFound = false;
            for (int i = 0; i < alTransSources.size(); ++i) {
                Select subQuery;
                ClassifierMap joinCM;
                Root source = (Root)alTransSources.get(i);
                String type = source.getCMetadataType();
                if (type.equalsIgnoreCase("ClassifierMap") && (joinCM = (ClassifierMap)source).getTransformRole().equalsIgnoreCase(JOINFROMROLE)) {
                    this.setSource(this.getParentQuery().addJoin((ClassifierMap)source));
                    wasFound = true;
                    break;
                }
                if (!type.equalsIgnoreCase("Select") || !(subQuery = (Select)source).getTransformRole().equalsIgnoreCase(INLINEVIEWROLE)) continue;
                this.setSource(this.getParentQuery().addSubQuery(subQuery));
                wasFound = true;
                break;
            }
            if (!wasFound) {
                if (srcTables.size() > 1) {
                    this.createDefaultJoinObjects();
                } else if (!srcTables.isEmpty()) {
                    this.setSource((SourceTable)srcTables.get(0));
                }
            }
        } else {
            if (srcTables.size() == 0) {
                return;
            }
            if (srcTables.size() > 1) {
                this.createDefaultJoinObjects();
            } else {
                this.setSource((SourceTable)srcTables.get(0));
            }
        }
        if (this.m_source != null) {
            this.m_source.moveDataToModel();
        }
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        if (this.m_source == null) {
            return;
        }
        this.m_source.moveDataToStore();
        if (this.m_source instanceof Join) {
            ClassifierMap joinCM = ((Join)this.m_source).getClassifierMap();
            joinCM.setTransformRole(JOINFROMROLE);
        }
        if (this.m_source instanceof SubQuery) {
            Select sqSelect = ((SubQuery)this.m_source).getSelectObject();
            sqSelect.setTransformRole(INLINEVIEWROLE);
        }
    }

    @Override
    public void dispose() {
        if (this.m_source != null) {
            this.m_source.remove();
        }
    }

    public boolean hasOpenTemplates() {
        if (this.m_source == null) {
            return true;
        }
        if (this.m_source instanceof SubQuery) {
            return false;
        }
        return this.m_source.hasOpenTemplates();
    }

    public List getSourceObjectsWithOpenTemplates() {
        ArrayList<From> list = new ArrayList<From>();
        if (this.m_source == null) {
            list.add(this);
        } else {
            list.addAll(this.m_source.getSourceObjectsWithOpenTemplates());
        }
        return list;
    }

    public List getSubqueries() {
        ArrayList<SourceTableInterface> list = new ArrayList<SourceTableInterface>();
        if (this.m_source == null) {
            return list;
        }
        if (this.m_source instanceof SubQuery) {
            list.add(this.m_source);
        } else {
            list.addAll(this.m_source.getSubqueries());
        }
        return list;
    }

    public void removeExpressionsContainingQuery(Query query) {
        this.m_source.removeExpressionsContainingQuery(query);
    }

    private void createDefaultJoinObjects() {
        List srcTables = this.getParentQuery().getSourceTables();
        int numberOfSrcs = srcTables.size();
        Join lastJoin = this.getParentQuery().addJoin((SourceTable)srcTables.get(0), (SourceTable)srcTables.get(1), "Inner");
        for (int i = 2; i < numberOfSrcs; ++i) {
            Join nextJoin;
            lastJoin = nextJoin = this.getParentQuery().addJoin(lastJoin, (SourceTable)srcTables.get(i), "Inner");
        }
        this.setSource(lastJoin);
    }
}

