/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.model;

import com.sas.codegen.CodegenRequest;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.QueryTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Variable;
import com.sas.wadmin.transforms.sql.model.AbstractExpression;
import com.sas.wadmin.transforms.sql.model.AbstractSimpleExpression;
import com.sas.wadmin.transforms.sql.model.CaseStatement;
import com.sas.wadmin.transforms.sql.model.OperandInterface;
import com.sas.wadmin.transforms.sql.model.Query;
import com.sas.wadmin.transforms.sql.model.SQLModel;
import com.sas.wadmin.transforms.sql.model.SQLObjectInterface;
import com.sas.wadmin.transforms.sql.model.SimpleExpressionInterface;
import com.sas.wadmin.transforms.sql.model.SubQuery;
import com.sas.wadmin.transforms.sql.model.TableInterface;
import com.sas.wadmin.transforms.sql.model.TextOperand;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.List;

public class Expression
extends AbstractSimpleExpression {
    private static final WAdminResource bundle = WAdminResource.getBundle(Expression.class);
    private static final String LEFTVARIABLENAME = "LeftOperand";
    private static final String LEFTSUBSTITUTEVARIABLE = "[1]";
    private static final String RIGHTVARIABLENAME = "RightOperand";
    private static final String RIGHTSUBSTITUTEVARIABLE = "[2]";
    private static final String EXPRESSIONFEATUREMAP = "SQLExpression";
    private static final String OPENPARENTHESIS = "OpenParenthesis";
    private static final String CLOSEPARENTHESIS = "CloseParenthesis";
    private static final String LOGICALOPERATOR = "LogicalOperator";
    public static final String LOGICALAND = "and";
    public static final String LOGICALOR = "or";
    public static final String LOGICALNOT = "not";
    public static final String LOGICALANDNOT = "and not";
    public static final String LOGICALORNOT = "or not";
    public static final String EXPRESSIONCHANGED = "ExpressionChanged";
    private AbstractExpression m_parent;
    private OperandInterface m_leftOperand;
    private OperandInterface m_rightOperand;
    private String m_operator = "";
    private String m_logicalOperator;
    private int m_openParenthesisCount = 0;
    private int m_closeParenthesisCount = 0;
    private String m_name = "";
    private String m_description = "";
    private FeatureMap m_featureMap;

    public Expression(FeatureMap featureMap) {
        this.m_featureMap = featureMap;
    }

    public Expression(String logicalOperator, OperandInterface leftOperand, String operator, OperandInterface rightOperand, int openParenCount, int closeParenCount, AbstractExpression parent) {
        this.m_parent = parent;
        if (this.m_parent != null) {
            this.setSQLModel(this.m_parent.getSQLModel());
            this.setParentQuery(this.m_parent.getParentQuery());
        }
        this.m_logicalOperator = logicalOperator;
        this.setLeftOperand(leftOperand);
        this.m_operator = operator;
        this.setRightOperand(rightOperand);
        this.m_openParenthesisCount = openParenCount;
        this.m_closeParenthesisCount = closeParenCount;
    }

    @Override
    public String getSQLCode(CodegenRequest cgReq, boolean resetPosition) {
        int i;
        StringBuffer sb = new StringBuffer();
        if (this.m_logicalOperator != null && this.m_logicalOperator.length() > 0) {
            sb.append(this.m_logicalOperator).append(" ");
        }
        if (this.m_openParenthesisCount > 0) {
            for (i = 0; i < this.m_openParenthesisCount; ++i) {
                sb.append("(");
            }
        }
        if (this.m_leftOperand != null) {
            sb.append(this.m_leftOperand.getSQLCode(cgReq.clearSourceCode(false), resetPosition)).append(!(this.m_leftOperand instanceof CaseStatement) ? " " : "");
        }
        if (this.m_operator != null && this.m_operator.length() > 0) {
            sb.append(this.m_operator).append(!(this.m_rightOperand instanceof CaseStatement) ? " " : "");
        }
        if (this.m_rightOperand != null) {
            sb.append(this.m_rightOperand.getSQLCode(cgReq.clearSourceCode(false), resetPosition));
        }
        if (this.m_closeParenthesisCount > 0) {
            for (i = 0; i < this.m_closeParenthesisCount; ++i) {
                sb.append(")");
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public CodegenRequest appendCode(CodegenRequest cgReq, boolean resetPosition) {
        int i;
        if (this.m_logicalOperator != null && this.m_logicalOperator.length() > 0) {
            cgReq.addSourceCode(this.m_logicalOperator).addSourceCode(" ");
        }
        if (this.m_openParenthesisCount > 0) {
            for (i = 0; i < this.m_openParenthesisCount; ++i) {
                cgReq.addSourceCode("(");
            }
        }
        if (this.m_leftOperand != null) {
            this.m_leftOperand.appendCode(cgReq, resetPosition).addSourceCode(!(this.m_leftOperand instanceof CaseStatement) ? " " : "\n");
        }
        if (this.m_operator != null && this.m_operator.length() > 0) {
            cgReq.addSourceCode(this.m_operator).addSourceCode(!(this.m_rightOperand instanceof CaseStatement) ? " " : "\n");
        }
        if (this.m_rightOperand != null) {
            this.m_rightOperand.appendCode(cgReq, resetPosition);
        }
        if (this.m_closeParenthesisCount > 0) {
            for (i = 0; i < this.m_closeParenthesisCount; ++i) {
                cgReq.addSourceCode(")");
            }
        }
        cgReq.addSourceCode("\n");
        return cgReq;
    }

    public OperandInterface getLeftOperand() {
        return this.m_leftOperand;
    }

    public void setLeftOperand(OperandInterface operand) {
        if (this.m_leftOperand != null) {
            this.m_leftOperand.dispose();
        }
        this.m_leftOperand = this.setOperandImpl(operand);
        this.getSQLModel().fireChangeEvent(this, EXPRESSIONCHANGED);
    }

    public void undoableSetLeftOperand(OperandInterface operand) {
        if (this.m_leftOperand != null) {
            this.m_leftOperand.setParent(null);
            if (this.m_leftOperand.getOperandType().equalsIgnoreCase("SubQueryOperand")) {
                ((SubQuery)this.m_leftOperand).removeAllSourceTablesFromParentQuery();
            }
            this.getSQLModel().addUndoableObject((SQLObjectInterface)((Object)this.m_leftOperand));
        }
        this.getSQLModel().removeUndoableObject((SQLObjectInterface)((Object)operand));
        if (operand.getOperandType().equalsIgnoreCase("SubQueryOperand")) {
            ((SubQuery)operand).addAllSourceTablesToParentQuery();
        }
        this.m_leftOperand = this.setOperandImpl(operand);
        this.getSQLModel().fireChangeEvent(this, EXPRESSIONCHANGED);
    }

    public OperandInterface getRightOperand() {
        return this.m_rightOperand;
    }

    public void setRightOperand(OperandInterface operand) {
        if (this.m_rightOperand != null) {
            this.m_rightOperand.dispose();
        }
        this.m_rightOperand = this.setOperandImpl(operand);
        this.getSQLModel().fireChangeEvent(this, EXPRESSIONCHANGED);
    }

    public void undoableSetRightOperand(OperandInterface operand) {
        if (this.m_rightOperand != null) {
            this.m_rightOperand.setParent(null);
            if (this.m_leftOperand.getOperandType().equalsIgnoreCase("SubQueryOperand")) {
                ((SubQuery)this.m_leftOperand).removeAllSourceTablesFromParentQuery();
            }
            this.getSQLModel().addUndoableObject((SQLObjectInterface)((Object)this.m_rightOperand));
        }
        this.getSQLModel().removeUndoableObject((SQLObjectInterface)((Object)operand));
        if (operand.getOperandType().equalsIgnoreCase("SubQueryOperand")) {
            ((SubQuery)operand).addAllSourceTablesToParentQuery();
        }
        this.m_rightOperand = this.setOperandImpl(operand);
        this.getSQLModel().fireChangeEvent(this, EXPRESSIONCHANGED);
    }

    private OperandInterface setOperandImpl(OperandInterface operand) {
        if (operand == null) {
            return operand;
        }
        operand.setParent(this);
        if (operand instanceof CaseStatement) {
            ((CaseStatement)operand).setSQLModel(this.getSQLModel());
            ((CaseStatement)operand).setParentQuery(this.getParentQuery());
            ((CaseStatement)operand).setParentClause(this.getParentClause());
        }
        if (operand instanceof SubQuery) {
            ((SubQuery)operand).setSQLModel(this.getSQLModel());
            ((SubQuery)operand).setParentQuery(this.getParentQuery());
            ((SubQuery)operand).setParentClause(this.getParentClause());
        }
        return operand;
    }

    public String getOperator() {
        return this.m_operator;
    }

    public void setOperator(String operator) {
        this.m_operator = operator;
        this.getSQLModel().fireChangeEvent(this, EXPRESSIONCHANGED);
    }

    public FeatureMap getFeatureMap() {
        return this.m_featureMap;
    }

    public void setFeatureMap(FeatureMap featureMap) {
        if (featureMap == null) {
            this.removeFeatureMap();
        }
        this.m_featureMap = featureMap;
    }

    public String getName() {
        if (this.m_name.length() > 0) {
            return this.m_name;
        }
        return EXPRESSIONFEATUREMAP;
    }

    public void setName(String name) {
        this.m_name = name;
        this.getSQLModel().fireChangeEvent(this, EXPRESSIONCHANGED);
    }

    public String getDescription() {
        if (this.m_description.length() > 0) {
            return this.m_description;
        }
        return "";
    }

    public void setDescription(String description) {
        this.m_description = description;
        this.getSQLModel().fireChangeEvent(this, EXPRESSIONCHANGED);
    }

    public String getLogicalOperator() {
        return this.m_logicalOperator;
    }

    public void setLogicalOperator(String logicalOperator) {
        this.m_logicalOperator = logicalOperator;
        this.getSQLModel().fireChangeEvent(this, EXPRESSIONCHANGED);
    }

    public int getOpenParenthesisCount() {
        return this.m_openParenthesisCount;
    }

    public void setOpenParenthesisCount(int count) {
        this.m_openParenthesisCount = count;
        this.getSQLModel().fireChangeEvent(this, EXPRESSIONCHANGED);
    }

    public int getClosedParenthesisCount() {
        return this.m_closeParenthesisCount;
    }

    public void setClosedParenthesisCount(int count) {
        this.m_closeParenthesisCount = count;
        this.getSQLModel().fireChangeEvent(this, EXPRESSIONCHANGED);
    }

    public void setParentClause(AbstractExpression clause) {
        this.m_parent = clause;
    }

    public AbstractExpression getParentClause() {
        return this.m_parent;
    }

    public CaseStatement addNewCaseStatement() {
        CaseStatement caseStmt = new CaseStatement();
        caseStmt.setParent(this);
        caseStmt.setSQLModel(this.getSQLModel());
        caseStmt.setParentQuery(this.getParentQuery());
        caseStmt.setParentClause(this.getParentClause());
        return caseStmt;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_logicalOperator).append(" ");
        if (this.m_openParenthesisCount > 0) {
            for (i = 1; i > this.m_openParenthesisCount; ++i) {
                sb.append("(");
            }
        }
        if (this.m_leftOperand != null) {
            sb.append(this.m_leftOperand.toString());
        }
        sb.append(this.m_operator);
        if (this.m_rightOperand != null) {
            sb.append(this.m_rightOperand.toString());
        }
        if (this.m_closeParenthesisCount > 0) {
            for (i = 1; i > this.m_closeParenthesisCount; ++i) {
                sb.append("(");
            }
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        Expression expr = null;
        if (!(o instanceof Expression)) return false;
        expr = (Expression)o;
        if (this.m_operator == null) {
            this.m_operator = "";
        }
        boolean leftEquals = false;
        if (this.m_leftOperand == null) {
            OperandInterface left = expr.getLeftOperand();
            if (left != null) return false;
            leftEquals = true;
        } else {
            leftEquals = this.m_leftOperand.equals(expr.getLeftOperand());
        }
        boolean rightEquals = false;
        if (this.m_rightOperand == null) {
            OperandInterface right = expr.getRightOperand();
            if (right != null) return false;
            rightEquals = true;
            return leftEquals && rightEquals && this.m_operator.equals(expr.getOperator());
        } else {
            rightEquals = this.m_rightOperand.equals(expr.getRightOperand());
        }
        return leftEquals && rightEquals && this.m_operator.equals(expr.getOperator());
    }

    public int hashcode() {
        return super.hashCode();
    }

    public boolean containsSourceTable(TableInterface table) {
        if (this.m_leftOperand != null && this.m_leftOperand.containsSourceTable(table)) {
            return true;
        }
        return this.m_rightOperand != null && this.m_rightOperand.containsSourceTable(table);
    }

    public boolean containsQuery(Query query) {
        if (this.m_leftOperand != null && this.m_leftOperand instanceof SubQuery && this.m_leftOperand == query) {
            return true;
        }
        return this.m_rightOperand != null && this.m_rightOperand instanceof SubQuery && this.m_rightOperand == query;
    }

    @Override
    public SimpleExpressionInterface copyExpression() {
        return new Expression(this.m_logicalOperator, this.m_leftOperand.copyOperand(), this.m_operator, this.m_rightOperand.copyOperand(), this.m_openParenthesisCount, this.m_closeParenthesisCount, null);
    }

    @Override
    public void moveDataToModel() throws MdException, RemoteException {
        if (this.m_featureMap == null) {
            return;
        }
        this.m_name = this.m_featureMap.getName();
        this.m_description = this.m_featureMap.getDesc();
        TextStore textStore = (TextStore)this.m_featureMap.getSourceCode();
        if (textStore == null) {
            if (this.getSQLModel().isSilentModeEnabled()) {
                System.out.print(bundle.getString("Expression.TextStoreMissing.Error.txt"));
            } else {
                MessageUtil.displayMessage((String)bundle.getString("Expression.TextStoreMissing.Error.txt"));
            }
            return;
        }
        String text = textStore.getStoredText().trim();
        int operatorBegIndex = -1;
        boolean leftSideExists = false;
        int leftBegIndex = text.indexOf(LEFTSUBSTITUTEVARIABLE);
        if (leftBegIndex != -1) {
            leftSideExists = true;
            operatorBegIndex = leftBegIndex + LEFTSUBSTITUTEVARIABLE.length();
        } else {
            operatorBegIndex = 0;
        }
        int operatorEndIndex = -1;
        boolean rightSideExists = false;
        int rightBegIndex = text.indexOf(RIGHTSUBSTITUTEVARIABLE);
        if (rightBegIndex != -1) {
            rightSideExists = true;
            operatorEndIndex = rightBegIndex - 1;
        } else {
            operatorEndIndex = text.length() - 1;
        }
        this.m_operator = text.substring(operatorBegIndex, operatorEndIndex + 1);
        AssociationList alSubVars = this.m_featureMap.getSubstitutionVariables();
        Root leftObject = null;
        String leftType = "";
        Root rightObject = null;
        String rightType = "";
        Root leftAlias = null;
        Root rightAlias = null;
        if (!alSubVars.isEmpty()) {
            for (int i = 0; i < alSubVars.size(); ++i) {
                Variable variable = (Variable)alSubVars.get(i);
                String marker = variable.getMarker();
                if (marker.equalsIgnoreCase(LEFTSUBSTITUTEVARIABLE)) {
                    leftObject = variable.getAssociatedObject();
                    leftType = variable.getValueType();
                }
                if (!marker.equalsIgnoreCase(RIGHTSUBSTITUTEVARIABLE)) continue;
                rightObject = variable.getAssociatedObject();
                rightType = variable.getValueType();
            }
        }
        if (leftSideExists && leftObject != null) {
            this.m_leftOperand = this.determineModelType(leftType, leftObject, leftAlias);
            this.m_leftOperand.moveDataToModel();
        }
        if (rightSideExists && rightObject != null) {
            this.m_rightOperand = this.determineModelType(rightType, rightObject, rightAlias);
            this.m_rightOperand.moveDataToModel();
        }
        AssociationList alProperties = this.m_featureMap.getProperties();
        for (int i = 0; i < alProperties.size(); ++i) {
            Property property = (Property)alProperties.get(i);
            if (property.getPropertyRole().equalsIgnoreCase(OPENPARENTHESIS)) {
                this.m_openParenthesisCount = new Integer(property.getDefaultValue());
            }
            if (property.getPropertyRole().equalsIgnoreCase(CLOSEPARENTHESIS)) {
                this.m_closeParenthesisCount = new Integer(property.getDefaultValue());
            }
            if (!property.getPropertyRole().equalsIgnoreCase(LOGICALOPERATOR)) continue;
            this.m_logicalOperator = property.getDefaultValue();
        }
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        TextStore textStore;
        if (this.m_parent == null) {
            return;
        }
        SQLModel model = this.m_parent.getSQLModel();
        MdObjectStore store = model.getObjectStore();
        String reposId = model.getRepositoryId();
        if (this.m_featureMap == null) {
            this.createNewMetadata(store, reposId);
        }
        this.m_featureMap.setName(this.getName());
        this.m_featureMap.setDesc(this.getDescription());
        AssociationList alFeatureSources = this.m_featureMap.getFeatureSources();
        alFeatureSources.removeAllElements();
        alFeatureSources.flushAll();
        AssociationList alSubVars = this.m_featureMap.getSubstitutionVariables();
        if (!alSubVars.isEmpty()) {
            store.removeObjectsFromStore((List)alSubVars);
        }
        if ((textStore = (TextStore)this.m_featureMap.getSourceCode()) == null) {
            textStore = (TextStore)Workspace.getMdFactory().createComplexMetadataObject(store, EXPRESSIONFEATUREMAP, "TextStore", reposId);
            this.m_featureMap.setSourceCode((Text)textStore);
        }
        textStore.setName(EXPRESSIONFEATUREMAP);
        textStore.setTextRole(EXPRESSIONFEATUREMAP);
        textStore.setStoredText(this.createTextStoredString());
        AssociationList alProperties = this.m_featureMap.getProperties();
        for (int i = 0; i < alProperties.size(); ++i) {
            Property prop = (Property)alProperties.get(i);
            if (prop.getPropertyRole().equalsIgnoreCase(OPENPARENTHESIS)) {
                prop.setDefaultValue(new Integer(this.m_openParenthesisCount).toString());
            }
            if (prop.getPropertyRole().equalsIgnoreCase(CLOSEPARENTHESIS)) {
                prop.setDefaultValue(new Integer(this.m_closeParenthesisCount).toString());
            }
            if (!prop.getPropertyRole().equalsIgnoreCase(LOGICALOPERATOR)) continue;
            prop.setDefaultValue(this.m_logicalOperator);
        }
        if (this.m_leftOperand != null) {
            this.m_leftOperand.moveDataToStore();
        }
        if (this.m_rightOperand != null) {
            this.m_rightOperand.moveDataToStore();
        }
        this.createVariableMetadata(store, reposId, textStore);
    }

    public boolean validate() {
        if (this.m_leftOperand != null && !this.m_leftOperand.validate()) {
            return false;
        }
        return this.m_rightOperand == null || this.m_rightOperand.validate();
    }

    private String createTextStoredString() {
        StringBuffer source = new StringBuffer();
        if (this.m_leftOperand != null) {
            source.append(LEFTSUBSTITUTEVARIABLE);
        }
        source.append(this.m_operator);
        if (this.m_rightOperand != null) {
            source.append(RIGHTSUBSTITUTEVARIABLE);
        }
        return source.toString();
    }

    private void createVariableMetadata(MdObjectStore store, String reposId, TextStore textStore) {
        try {
            Variable leftVar = (Variable)Workspace.getMdFactory().createComplexMetadataObject(store, LEFTVARIABLENAME, "Variable", reposId);
            leftVar.setMarker(LEFTSUBSTITUTEVARIABLE);
            if (this.m_leftOperand != null) {
                leftVar.setAssociatedObject(this.m_leftOperand.getMetadataObject());
                leftVar.setValueType(this.m_leftOperand.getOperandType());
            }
            leftVar.setOwningTransformation((AbstractTransformation)this.m_featureMap);
            Variable rightVar = (Variable)Workspace.getMdFactory().createComplexMetadataObject(store, RIGHTVARIABLENAME, "Variable", reposId);
            rightVar.setMarker(RIGHTSUBSTITUTEVARIABLE);
            if (this.m_rightOperand != null) {
                rightVar.setAssociatedObject(this.m_rightOperand.getMetadataObject());
                rightVar.setValueType(this.m_rightOperand.getOperandType());
            }
            rightVar.setOwningTransformation((AbstractTransformation)this.m_featureMap);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private void createNewMetadata(MdObjectStore store, String reposId) throws MdException, RemoteException {
        this.m_featureMap = (FeatureMap)Workspace.getMdFactory().createComplexMetadataObject(store, EXPRESSIONFEATUREMAP, "FeatureMap", reposId);
        this.m_featureMap.setTransformRole(EXPRESSIONFEATUREMAP);
        PropertyType propType = (PropertyType)Workspace.getMdFactory().createComplexMetadataObject(store, EXPRESSIONFEATUREMAP, "PropertyType", reposId);
        propType.setSQLType(12);
        Property property = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, OPENPARENTHESIS, "Property", reposId);
        property.setPropertyRole(OPENPARENTHESIS);
        property.setDefaultValue(new Integer(this.m_openParenthesisCount).toString());
        property.setUseValueOnly(1);
        property.setOwningType(propType);
        this.m_featureMap.getProperties().add((Object)property);
        property = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, CLOSEPARENTHESIS, "Property", reposId);
        property.setPropertyRole(CLOSEPARENTHESIS);
        property.setDefaultValue(new Integer(this.m_closeParenthesisCount).toString());
        property.setUseValueOnly(1);
        property.setOwningType(propType);
        this.m_featureMap.getProperties().add((Object)property);
        property = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, LOGICALOPERATOR, "Property", reposId);
        property.setPropertyRole(LOGICALOPERATOR);
        property.setDefaultValue(this.m_logicalOperator);
        property.setUseValueOnly(1);
        property.setOwningType(propType);
        this.m_featureMap.getProperties().add((Object)property);
    }

    private OperandInterface determineModelType(String type, Root object, Root alias) throws MdException, RemoteException {
        OperandInterface operand = null;
        if (type.equalsIgnoreCase("TextOperand")) {
            FeatureMap fMap = (FeatureMap)object;
            operand = new TextOperand((SimpleExpressionInterface)this, fMap);
        } else if (type.equalsIgnoreCase("SubQueryOperand")) {
            QueryTable queryTable = (QueryTable)object;
            operand = this.m_parent.getParentQuery().addSubQuery(queryTable);
            ((SubQuery)operand).setParentClause(this.getParentClause());
            ((SubQuery)operand).setParentQuery(this.getParentQuery());
        } else if (type.equalsIgnoreCase("CaseOperand")) {
            ClassifierMap clsMap = (ClassifierMap)object;
            operand = new CaseStatement(clsMap);
            ((CaseStatement)operand).setSQLModel(this.getSQLModel());
            ((CaseStatement)operand).setParentClause(this.getParentClause());
            ((CaseStatement)operand).setParentQuery(this.getParentQuery());
        }
        operand.setParent(this);
        return operand;
    }

    private void removeFeatureMap() {
        block7: {
            try {
                if (this.m_featureMap == null) break block7;
                MdObjectStore store = (MdObjectStore)this.m_featureMap.getObjectStore();
                try {
                    AssociationList subVars;
                    TextStore text = (TextStore)this.m_featureMap.getSourceCode();
                    if (text != null) {
                        store.removeObjectFromStore((CMetadata)text, null);
                    }
                    if (!(subVars = this.m_featureMap.getSubstitutionVariables()).isEmpty()) {
                        store.removeObjectsFromStore((List)subVars);
                    }
                    String strTemplate = "<FeatureMap><Properties></Properties></FeatureMap>";
                    store.removeObjectFromStore((CMetadata)this.m_featureMap, strTemplate);
                }
                catch (MdException me) {
                    if (this.getSQLModel().isSilentModeEnabled()) {
                        System.out.print(me.getLocalizedMessage());
                        break block7;
                    }
                    MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Deleting");
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    @Override
    public void dispose() {
        if (this.m_leftOperand != null) {
            this.m_leftOperand.dispose();
            this.m_leftOperand = null;
        }
        if (this.m_rightOperand != null) {
            this.m_rightOperand.dispose();
            this.m_rightOperand = null;
        }
        this.removeFeatureMap();
        this.m_featureMap = null;
        this.m_operator = null;
        this.m_logicalOperator = null;
        this.m_closeParenthesisCount = 0;
        this.m_openParenthesisCount = 0;
    }
}

