/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.model;

import com.sas.codegen.CodegenRequest;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.QueryTable;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.transforms.sql.model.AbstractSimpleExpression;
import com.sas.wadmin.transforms.sql.model.CaseStatement;
import com.sas.wadmin.transforms.sql.model.OperandInterface;
import com.sas.wadmin.transforms.sql.model.SQLModel;
import com.sas.wadmin.transforms.sql.model.SQLObjectInterface;
import com.sas.wadmin.transforms.sql.model.SimpleExpressionInterface;
import com.sas.wadmin.transforms.sql.model.SubQuery;
import com.sas.wadmin.transforms.sql.model.TableInterface;
import com.sas.wadmin.transforms.sql.model.TextOperand;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class CaseExpression
extends AbstractSimpleExpression {
    protected static final String EXPRESSIONFEATUREMAP = "CaseWhenThen";
    private OperandInterface m_whenOperand;
    private OperandInterface m_thenOperand;
    private FeatureMap m_featureMap;
    private CaseStatement m_parent;

    public CaseExpression(CaseStatement parent) {
        this.m_parent = parent;
    }

    public CaseExpression(OperandInterface when, OperandInterface then, CaseStatement parent) {
        this.m_parent = parent;
        this.setWhenOperand(when);
        this.setThenOperand(then);
    }

    public CaseExpression(FeatureMap featureMap) {
        this.m_featureMap = featureMap;
    }

    public void setWhenOperand(OperandInterface when) {
        if (this.m_whenOperand != null) {
            this.m_whenOperand.dispose();
        }
        this.m_whenOperand = this.setOperandImpl(when);
        if (this.m_parent != null) {
            this.m_parent.fireChangeEvent(this.m_parent, "CaseStatementChanged");
        }
    }

    public void undoableSetWhenOperand(OperandInterface operand) {
        if (this.m_whenOperand != null) {
            this.m_whenOperand.setParent(null);
            this.getSQLModel().addUndoableObject((SQLObjectInterface)((Object)this.m_whenOperand));
        }
        this.m_whenOperand = this.setOperandImpl(operand);
        this.getSQLModel().removeUndoableObject((SQLObjectInterface)((Object)operand));
        this.m_parent.fireChangeEvent(this.m_parent, "CaseStatementChanged");
    }

    public List getTableColumns() {
        ArrayList newList = new ArrayList();
        if (this.m_whenOperand != null) {
            newList.addAll(this.m_whenOperand.getTableColumns());
        }
        if (this.m_thenOperand != null) {
            newList.addAll(this.m_thenOperand.getTableColumns());
        }
        return newList;
    }

    public OperandInterface getWhenOperand() {
        return this.m_whenOperand;
    }

    public void setThenOperand(OperandInterface then) {
        if (this.m_thenOperand != null) {
            this.m_thenOperand.dispose();
        }
        this.m_thenOperand = this.setOperandImpl(then);
        if (this.m_parent != null) {
            this.m_parent.fireChangeEvent(this.m_parent, "CaseStatementChanged");
        }
    }

    public void undoableSetThenOperand(OperandInterface operand) {
        if (this.m_thenOperand != null) {
            this.m_thenOperand.setParent(null);
            this.getSQLModel().addUndoableObject((SQLObjectInterface)((Object)this.m_thenOperand));
        }
        this.m_thenOperand = this.setOperandImpl(operand);
        this.getSQLModel().removeUndoableObject((SQLObjectInterface)((Object)operand));
        this.m_parent.fireChangeEvent(this.m_parent, "CaseStatementChanged");
    }

    public OperandInterface getThenOperand() {
        return this.m_thenOperand;
    }

    private OperandInterface setOperandImpl(OperandInterface operand) {
        operand.setParent(this);
        if (operand instanceof CaseStatement) {
            ((CaseStatement)operand).setSQLModel(this.getSQLModel());
            ((CaseStatement)operand).setParentQuery(this.getParentQuery());
            ((CaseStatement)operand).setParentClause(this.m_parent.getParentClause());
        }
        if (operand instanceof SubQuery) {
            ((SubQuery)operand).setSQLModel(this.getSQLModel());
            ((SubQuery)operand).setParentQuery(this.getParentQuery());
            ((SubQuery)operand).setParentClause(this.m_parent.getParentClause());
        }
        return operand;
    }

    public FeatureMap getFeatureMap() {
        return this.m_featureMap;
    }

    public void setFeatureMap(FeatureMap featureMap) {
        this.m_featureMap = featureMap;
    }

    public void setParent(CaseStatement statement) {
        this.m_parent = statement;
    }

    @Override
    public String getSQLCode(CodegenRequest cgReq, boolean resetPosition) {
        StringBuffer sb = new StringBuffer();
        sb.append("   ").append("when ").append(this.m_whenOperand.getSQLCode(cgReq, resetPosition)).append("\n").append("   ").append("then ").append(this.m_thenOperand.getSQLCode(cgReq, resetPosition)).append("\n");
        return sb.toString();
    }

    @Override
    public CodegenRequest appendCode(CodegenRequest cgReq, boolean resetPosition) {
        cgReq.addSourceCode("when ");
        this.m_whenOperand.appendCode(cgReq, resetPosition).addSourceCode("\n").addSourceCode("then ");
        this.m_thenOperand.appendCode(cgReq, resetPosition).addSourceCode("\n");
        return cgReq;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("when ");
        if (this.m_whenOperand != null) {
            sb.append(this.m_whenOperand.toString());
        }
        sb.append("\nthen ");
        if (this.m_thenOperand != null) {
            sb.append(this.m_thenOperand.toString());
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        CaseExpression expr = null;
        if (!(o instanceof CaseExpression)) return false;
        expr = (CaseExpression)o;
        if (this.m_whenOperand != null && this.m_thenOperand != null) {
            return this.m_whenOperand.equals(expr.getWhenOperand()) && this.m_thenOperand.equals(expr.getThenOperand());
        }
        boolean whenEquals = false;
        if (this.m_whenOperand == null) {
            OperandInterface when = expr.getWhenOperand();
            if (when != null) return false;
            whenEquals = true;
        } else {
            whenEquals = this.m_whenOperand.equals(expr.getWhenOperand());
        }
        if (!whenEquals) return false;
        if (this.m_thenOperand != null) return this.m_thenOperand.equals(expr.getThenOperand());
        OperandInterface then = expr.getThenOperand();
        return then == null;
    }

    public int hashcode() {
        return super.hashCode();
    }

    public boolean containsSourceTable(TableInterface table) {
        if (this.m_whenOperand != null && this.m_whenOperand.containsSourceTable(table)) {
            return true;
        }
        return this.m_thenOperand != null && this.m_thenOperand.containsSourceTable(table);
    }

    @Override
    public SimpleExpressionInterface copyExpression() {
        return new CaseExpression(this.m_whenOperand.copyOperand(), this.m_thenOperand.copyOperand(), null);
    }

    @Override
    public void moveDataToModel() throws MdException, RemoteException {
        AssociationList targetTrans;
        if (this.m_featureMap == null) {
            return;
        }
        AssociationList sourceTrans = this.m_featureMap.getSourceTransformations();
        if (!sourceTrans.isEmpty()) {
            Root object = (Root)sourceTrans.get(0);
            String objectType = object.getCMetadataType();
            if (objectType.equalsIgnoreCase("FeatureMap")) {
                this.setWhenOperand(new TextOperand((SimpleExpressionInterface)this, (FeatureMap)object));
            } else if (objectType.equalsIgnoreCase("QueryTable")) {
                this.setWhenOperand(new SubQuery((QueryTable)object));
            } else if (objectType.equalsIgnoreCase("ClassifierMap")) {
                this.setWhenOperand(new CaseStatement((ClassifierMap)object));
            }
        }
        if (!(targetTrans = this.m_featureMap.getTargetTransformations()).isEmpty()) {
            Root object = (Root)targetTrans.get(0);
            String objectType = object.getCMetadataType();
            if (objectType.equalsIgnoreCase("FeatureMap")) {
                this.setThenOperand(new TextOperand((SimpleExpressionInterface)this, (FeatureMap)object));
            } else if (objectType.equalsIgnoreCase("QueryTable")) {
                this.setThenOperand(new SubQuery((QueryTable)object));
            } else if (objectType.equalsIgnoreCase("ClassifierMap")) {
                this.setThenOperand(new CaseStatement((ClassifierMap)object));
            }
        }
        if (this.m_whenOperand != null) {
            this.m_whenOperand.moveDataToModel();
        }
        if (this.m_thenOperand != null) {
            this.m_thenOperand.moveDataToModel();
        }
    }

    public boolean validate() {
        if (this.m_whenOperand != null && !this.m_whenOperand.validate()) {
            return false;
        }
        return this.m_thenOperand == null || this.m_thenOperand.validate();
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        if (this.m_parent == null) {
            return;
        }
        SQLModel model = this.m_parent.getSQLModel();
        MdObjectStore store = model.getObjectStore();
        String reposId = model.getRepositoryId();
        if (this.m_featureMap == null) {
            this.createNewMetadata(store, reposId);
        }
        AssociationList srcTrans = this.m_featureMap.getSourceTransformations();
        srcTrans.removeAllElements();
        srcTrans.flushAll();
        AssociationList tgtTrans = this.m_featureMap.getTargetTransformations();
        tgtTrans.removeAllElements();
        tgtTrans.flushAll();
        if (this.m_whenOperand != null) {
            this.m_whenOperand.moveDataToStore();
            srcTrans.add((Object)this.m_whenOperand.getMetadataObject());
        }
        if (this.m_thenOperand != null) {
            this.m_thenOperand.moveDataToStore();
            tgtTrans.add((Object)this.m_thenOperand.getMetadataObject());
        }
    }

    private void createNewMetadata(MdObjectStore store, String reposId) throws MdException, RemoteException {
        this.m_featureMap = (FeatureMap)Workspace.getMdFactory().createComplexMetadataObject(store, EXPRESSIONFEATUREMAP, "FeatureMap", reposId);
        this.m_featureMap.setTransformRole(EXPRESSIONFEATUREMAP);
    }

    @Override
    public void dispose() {
        block7: {
            try {
                if (this.m_whenOperand != null) {
                    this.m_whenOperand.dispose();
                    this.m_whenOperand = null;
                }
                if (this.m_thenOperand != null) {
                    this.m_thenOperand.dispose();
                    this.m_thenOperand = null;
                }
                if (this.m_featureMap == null) break block7;
                MdObjectStore store = (MdObjectStore)this.m_featureMap.getObjectStore();
                try {
                    store.removeObjectFromStore((CMetadata)this.m_featureMap, null);
                    this.m_featureMap = null;
                }
                catch (MdException me) {
                    if (this.getSQLModel().isSilentModeEnabled()) {
                        System.out.print(me.getLocalizedMessage());
                        break block7;
                    }
                    MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Deleting");
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }
}

