/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.model;

import com.sas.codegen.CodegenRequest;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Select;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.wadmin.transforms.sql.model.AbstractClause;
import com.sas.wadmin.transforms.sql.model.Expression;
import com.sas.wadmin.transforms.sql.model.ExpressionChangeEvent;
import com.sas.wadmin.transforms.sql.model.ExpressionChangeListener;
import com.sas.wadmin.transforms.sql.model.ExpressionInterface;
import com.sas.wadmin.transforms.sql.model.OperandInterface;
import com.sas.wadmin.transforms.sql.model.Query;
import com.sas.wadmin.transforms.sql.model.SQLObjectInterface;
import com.sas.wadmin.transforms.sql.model.SubQuery;
import com.sas.wadmin.transforms.sql.model.TableInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractExpression
extends AbstractClause
implements ExpressionInterface,
SQLObjectInterface {
    private static final WAdminResource bundle = WAdminResource.getBundle(AbstractExpression.class);
    protected List m_expressions = new ArrayList();
    protected List m_invalidExpressionPositions = new ArrayList();
    protected ClassifierMap m_classifierMap;
    private boolean m_fireEventsEnabled = true;
    private List m_listeners = new ArrayList();
    public static final String USERWRITTENCHANGED = "userWrittenChanged";
    public static final String USERWRITTENCODECHANGED = "userWrittenCodeChanged";
    protected boolean m_userWritten = false;
    protected String m_userWrittenCode = "";

    public AbstractExpression() {
    }

    public AbstractExpression(ClassifierMap classifierMap) {
        this();
        this.m_classifierMap = classifierMap;
    }

    @Override
    public String getSQLCode() {
        StringBuffer sb = new StringBuffer();
        if (!this.m_userWritten) {
            if (this.m_expressions == null) {
                return sb.toString();
            }
            if (!this.m_expressions.isEmpty()) {
                int tot = this.m_expressions.size();
                for (int i = 0; i < tot; ++i) {
                    Expression expr = (Expression)this.m_expressions.get(i);
                    sb.append(expr.getSQLCode(this.getSQLModel().createNewCodegenRequest(), false));
                }
            }
        } else {
            sb.append(this.m_userWrittenCode);
        }
        return sb.toString();
    }

    @Override
    public CodegenRequest appendCode(CodegenRequest cgReq, boolean resetPosition) {
        if (!this.m_userWritten && this.m_expressions != null && !this.m_expressions.isEmpty()) {
            int tot = this.m_expressions.size();
            for (int i = 0; i < tot; ++i) {
                Expression expr = (Expression)this.m_expressions.get(i);
                expr.appendCode(cgReq, resetPosition);
            }
        } else if (this.m_userWritten) {
            cgReq.addSourceCode(this.m_userWrittenCode).addSourceCode("\n");
        }
        return cgReq;
    }

    @Override
    public List getExpressions() {
        return this.m_expressions;
    }

    @Override
    public void addExpression(Expression expression) {
        if (expression == null) {
            return;
        }
        if (this.m_expressions == null) {
            this.m_expressions = new ArrayList();
        }
        expression.setParentClause(this);
        expression.setSQLModel(this.getSQLModel());
        expression.setParentQuery(this.getParentQuery());
        this.m_expressions.add(expression);
        int index = this.m_expressions.size() - 1;
        boolean exists = this.getSQLModel().removeUndoableObject(expression);
        if (exists) {
            OperandInterface operand = expression.getLeftOperand();
            if (operand.getOperandType().equalsIgnoreCase("SubQueryOperand")) {
                ((SubQuery)operand).addAllSourceTablesToParentQuery();
            }
            if ((operand = expression.getRightOperand()).getOperandType().equalsIgnoreCase("SubQueryOperand")) {
                ((SubQuery)operand).addAllSourceTablesToParentQuery();
            }
        }
        this.fireChangeEvent(expression, index, "ADDED");
        this.getSQLModel().fireChangeEvent(expression, "ExpressionChanged");
    }

    public void addExpression(int index, Expression expression) {
        if (expression == null) {
            return;
        }
        if (this.m_expressions == null) {
            this.m_expressions = new ArrayList();
        }
        expression.setParentClause(this);
        expression.setSQLModel(this.getSQLModel());
        expression.setParentQuery(this.getParentQuery());
        this.m_expressions.add(index, expression);
        boolean exists = this.getSQLModel().removeUndoableObject(expression);
        if (exists) {
            OperandInterface operand = expression.getLeftOperand();
            if (operand.getOperandType().equalsIgnoreCase("SubQueryOperand")) {
                ((SubQuery)operand).addAllSourceTablesToParentQuery();
            }
            if ((operand = expression.getRightOperand()).getOperandType().equalsIgnoreCase("SubQueryOperand")) {
                ((SubQuery)operand).addAllSourceTablesToParentQuery();
            }
        }
        this.fireChangeEvent(expression, index, "ADDED");
        this.getSQLModel().fireChangeEvent(expression, "ExpressionChanged");
    }

    public void moveExpression(int oldIndex, int newIndex) {
        Expression expression = (Expression)this.m_expressions.remove(oldIndex);
        this.m_expressions.add(newIndex, expression);
        this.getSQLModel().fireChangeEvent(this, "MODEL_CHANGED");
    }

    public void removeExpression(Expression expression) {
        int index = this.m_expressions.indexOf(expression);
        this.m_expressions.remove(expression);
        expression.dispose();
        expression = null;
        this.fireChangeEvent(expression, index, "REMOVED");
        this.getSQLModel().fireChangeEvent(expression, "ExpressionChanged");
    }

    public void undoableRemoveExpression(Expression expression) {
        int index = this.m_expressions.indexOf(expression);
        this.m_expressions.remove(expression);
        OperandInterface operand = expression.getLeftOperand();
        if (operand.getOperandType().equalsIgnoreCase("SubQueryOperand")) {
            ((SubQuery)operand).removeAllSourceTablesFromParentQuery();
        }
        if ((operand = expression.getRightOperand()).getOperandType().equalsIgnoreCase("SubQueryOperand")) {
            ((SubQuery)operand).removeAllSourceTablesFromParentQuery();
        }
        expression.setParentClause(null);
        this.getSQLModel().addUndoableObject(expression);
        this.fireChangeEvent(expression, index, "REMOVED");
        this.getSQLModel().fireChangeEvent(expression, "ExpressionChanged");
    }

    public void removeExpression(int index) {
        Expression expression = (Expression)this.m_expressions.get(index);
        this.m_expressions.remove(index);
        expression.dispose();
        expression = null;
        this.fireChangeEvent(expression, index, "REMOVED");
        this.getSQLModel().fireChangeEvent(expression, "ExpressionChanged");
    }

    public void undoableRemoveExpression(int index) {
        Expression expression = (Expression)this.m_expressions.get(index);
        OperandInterface operand = expression.getLeftOperand();
        if (operand != null && operand.getOperandType().equalsIgnoreCase("SubQueryOperand")) {
            ((SubQuery)operand).removeAllSourceTablesFromParentQuery();
        }
        if ((operand = expression.getRightOperand()) != null && operand.getOperandType().equalsIgnoreCase("SubQueryOperand")) {
            ((SubQuery)operand).removeAllSourceTablesFromParentQuery();
        }
        this.m_expressions.remove(index);
        expression.setParentClause(null);
        this.getSQLModel().addUndoableObject(expression);
        this.fireChangeEvent(expression, index, "REMOVED");
        this.getSQLModel().fireChangeEvent(expression, "ExpressionChanged");
    }

    public ClassifierMap getClassifierMap() {
        return this.m_classifierMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveDataToModel() throws MdException, RemoteException {
        this.disableFireEvents();
        try {
            int i;
            if (this.m_classifierMap == null) {
                return;
            }
            this.setDescription(this.m_classifierMap.getDesc());
            AssociationList alFeatureMaps = this.m_classifierMap.getFeatureMaps();
            for (i = 0; i < alFeatureMaps.size(); ++i) {
                FeatureMap fMap = (FeatureMap)alFeatureMaps.get(i);
                Expression expr = new Expression(fMap);
                this.addExpression(expr);
                expr.moveDataToModel();
            }
            for (i = 0; i < this.m_expressions.size(); ++i) {
                Expression expr = (Expression)this.m_expressions.get(i);
                boolean hasLeftBadExpression = false;
                boolean hasRightBadExpression = false;
                OperandInterface operand = expr.getLeftOperand();
                if (operand != null) {
                    hasLeftBadExpression = operand.hasMissingTokens();
                }
                if ((operand = expr.getRightOperand()) != null) {
                    hasRightBadExpression = operand.hasMissingTokens();
                }
                if (!hasLeftBadExpression && !hasRightBadExpression) continue;
                this.removeExpression(expr);
                if (i == 0) {
                    this.fixUpLogicalOperator();
                }
                --i;
            }
            boolean bl = this.m_userWritten = this.m_classifierMap.getIsUserDefined() == 1;
            if (this.m_userWritten) {
                TextStore text = (TextStore)this.m_classifierMap.getSourceCode();
                String code = "";
                if (text != null) {
                    code = text.getStoredText();
                }
                this.m_userWrittenCode = code;
            }
        }
        finally {
            this.enableFireEvents();
        }
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        this.m_classifierMap.setDesc(this.getDescription());
        this.m_classifierMap.setIsUserDefined(this.m_userWritten ? 1 : 0);
        if (this.m_userWritten) {
            TextStore userCode = (TextStore)this.m_classifierMap.getSourceCode();
            if (userCode == null) {
                userCode = (TextStore)Workspace.getMdFactory().createComplexMetadataObject(this.m_classifierMap.getObjectStore(), null, bundle.getString("AbstractExpression.SourceCode.txt"), "TextStore", this.m_classifierMap.getRepositoryID(), null);
                this.m_classifierMap.setSourceCode((Text)userCode);
            }
            userCode.setStoredText(this.m_userWrittenCode);
        }
    }

    public boolean validate() {
        this.m_invalidExpressionPositions = new ArrayList();
        if (this.m_expressions == null) {
            return true;
        }
        for (int i = 0; i < this.m_expressions.size(); ++i) {
            Expression expr = (Expression)this.m_expressions.get(i);
            if (expr.validate()) continue;
            this.m_invalidExpressionPositions.add(new Integer(this.m_expressions.indexOf(expr)));
        }
        return this.m_invalidExpressionPositions.size() <= 0;
    }

    public List getInvalidExpresionPositions() {
        return this.m_invalidExpressionPositions;
    }

    protected void fixUpLogicalOperator() {
        if (!this.m_expressions.isEmpty()) {
            Expression expr = (Expression)this.m_expressions.get(0);
            String logicalOperator = expr.getLogicalOperator();
            if (logicalOperator.equalsIgnoreCase("and not") || logicalOperator.equalsIgnoreCase("or not")) {
                expr.setLogicalOperator("not");
            } else {
                expr.setLogicalOperator("");
            }
        }
    }

    @Override
    public void dispose() {
        if (this.m_expressions != null) {
            for (int i = 0; i < this.m_expressions.size(); ++i) {
                Expression expr = (Expression)this.m_expressions.get(i);
                expr.dispose();
            }
            this.m_expressions.clear();
        }
        String strTemplate = "<ClassifierMap><PropertySets><PropertySet><Properties/><SetProperties/></PropertySet></PropertySets><Properties></Properties></ClassifierMap>";
        try {
            if (this.m_classifierMap != null) {
                Select select = this.getParentQuery().getSelectObject();
                select.getTransformationSources().removeElement((Object)this.m_classifierMap);
                this.getSQLModel().getObjectStore().removeObjectFromStore((CMetadata)this.m_classifierMap, strTemplate);
                this.m_classifierMap = null;
            }
        }
        catch (MdException me) {
            if (this.getSQLModel().isSilentModeEnabled()) {
                System.out.print(me.getLocalizedMessage());
            } else {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    @Override
    public List getSubQueries() {
        ArrayList<OperandInterface> subQueries = new ArrayList<OperandInterface>();
        if (this.m_expressions == null) {
            return subQueries;
        }
        for (int i = 0; i < this.m_expressions.size(); ++i) {
            OperandInterface rightOperand;
            Expression expr = (Expression)this.m_expressions.get(i);
            OperandInterface leftOperand = expr.getLeftOperand();
            if (leftOperand != null && leftOperand.getOperandType().equalsIgnoreCase("SubQueryOperand")) {
                subQueries.add(leftOperand);
            }
            if ((rightOperand = expr.getRightOperand()) == null || !rightOperand.getOperandType().equalsIgnoreCase("SubQueryOperand")) continue;
            subQueries.add(rightOperand);
        }
        return subQueries;
    }

    protected void removeExpressionsContainingSourceTable(TableInterface table) {
        if (this.m_expressions == null) {
            return;
        }
        for (int i = this.m_expressions.size() - 1; i >= 0; --i) {
            Expression expr = (Expression)this.m_expressions.get(i);
            if (!expr.containsSourceTable(table)) continue;
            String leftType = expr.getLeftOperand().getOperandType();
            String rightType = expr.getRightOperand().getOperandType();
            if (!leftType.equalsIgnoreCase("SubQueryOperand")) {
                expr.setLeftOperand(null);
            }
            if (!rightType.equalsIgnoreCase("SubQueryOperand")) {
                expr.setRightOperand(null);
            }
            if (expr.getLeftOperand() != null || expr.getRightOperand() != null) continue;
            expr.dispose();
            this.m_expressions.remove(expr);
        }
        this.fixUpLogicalOperator();
    }

    public void removeExpressionsContainingQuery(Query query) {
        if (this.m_expressions == null) {
            return;
        }
        this.getSQLModel().setFireEventsEnabled(false);
        for (int i = this.m_expressions.size() - 1; i >= 0; --i) {
            Expression expr = (Expression)this.m_expressions.get(i);
            if (!expr.containsQuery(query)) continue;
            expr.setLeftOperand(null);
            expr.setRightOperand(null);
            if (expr.getLeftOperand() != null || expr.getRightOperand() != null) continue;
            expr.dispose();
            this.m_expressions.remove(expr);
        }
        this.fixUpLogicalOperator();
        this.getSQLModel().setFireEventsEnabledWithOutUnknownChangesEvent();
    }

    public boolean fireEventsEnabled() {
        return this.m_fireEventsEnabled;
    }

    public void setFireEventsEnabled(boolean value) {
        this.m_fireEventsEnabled = value;
    }

    public void enableFireEvents() {
        this.m_fireEventsEnabled = true;
    }

    public void disableFireEvents() {
        this.m_fireEventsEnabled = false;
    }

    public void addChangeListener(ExpressionChangeListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeChangeListener(ExpressionChangeListener listener) {
        this.m_listeners.remove(listener);
    }

    public void fireChangeEvent(Expression expression, int index, String action) {
        if (!this.fireEventsEnabled()) {
            return;
        }
        for (int expressionIndex = this.m_listeners.size() - 1; expressionIndex >= 0; --expressionIndex) {
            ExpressionChangeListener listener = (ExpressionChangeListener)this.m_listeners.get(expressionIndex);
            listener.expressionChanged(new ExpressionChangeEvent(this, expression, index, action));
        }
    }

    public boolean isUserWritten() {
        return this.m_userWritten;
    }

    public void setIsUserWritten(boolean userWritten) {
        if (userWritten == this.m_userWritten) {
            return;
        }
        if (userWritten && this.m_userWrittenCode.trim().length() == 0) {
            this.m_userWrittenCode = this.getSQLCode();
        }
        this.m_userWritten = userWritten;
        this.getSQLModel().fireChangeEvent(this, USERWRITTENCHANGED, this.getParentQuery());
    }

    public void setUserWrittenCode(String code) {
        this.m_userWrittenCode = code;
        this.getSQLModel().fireChangeEvent(USERWRITTENCODECHANGED);
    }

    public String getUserWrittenCode() {
        return this.m_userWrittenCode;
    }

    protected void createClassifierMap(String strName) {
        try {
            if (this.m_classifierMap == null) {
                this.m_classifierMap = (ClassifierMap)Workspace.getMdFactory().createComplexMetadataObject(this.getSQLModel().getObjectStore(), strName, "ClassifierMap", this.getSQLModel().getRepositoryId());
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }
}

