/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.editor;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.sql.ISetOperator;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.transforms.sql.editor.JoinEditorIcons;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsCompoundIcon;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class SQLSetOperatorsPanel
extends WAPanel {
    private static final WAdminResource bundle = WAdminResource.getBundle(SQLSetOperatorsPanel.class);
    private ISetOperator m_oSetOperator;
    private JLabel m_lblSetOperatorType;
    private WAComboBox m_cmbSetOperatorType;
    private JCheckBox m_ckbIncludeDups;
    private JCheckBox m_ckbMatchByName;
    private JCheckBox m_ckbParenthesis;
    private WATextField m_txtDescription;
    private JLabel m_lblDescription;
    private FocusListener m_lsnDescription;
    private ItemListener m_lsnItem;
    private IModelListener m_lsnModel;
    private WsAbstractToggleAction m_actIncludeDups;
    private WsAbstractToggleAction m_actMatchByName;
    private WsAbstractToggleAction m_actParenthesis;

    public SQLSetOperatorsPanel(ISetOperator oSetOperator) {
        this.m_oSetOperator = oSetOperator;
        this.initialize();
        this.layoutWidgets();
    }

    protected void initialize() {
        this.m_lsnModel = new SetOperatorsModelListener();
        if (this.m_oSetOperator != null) {
            this.m_oSetOperator.getModel().addModelListener(this.m_lsnModel);
        }
        this.m_cmbSetOperatorType = new WAComboBox();
        this.m_cmbSetOperatorType.addItem((Object)"Intersect");
        this.m_cmbSetOperatorType.addItem((Object)"Outer Union");
        this.m_cmbSetOperatorType.addItem((Object)"Union");
        this.m_cmbSetOperatorType.addItem((Object)"Except");
        this.m_lblSetOperatorType = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbSetOperatorType, (WAdminResource)bundle, (String)"SQLSetOperatorsPanel.Label.TablesSetOperatorTypeCombo");
        this.m_lsnItem = new cItemListener();
        this.m_cmbSetOperatorType.addItemListener(this.m_lsnItem);
        this.m_cmbSetOperatorType.setRenderer((ListCellRenderer)new cListCellRenderer());
        this.m_actIncludeDups = this.createIncludeDupsAction();
        this.m_actMatchByName = this.createMatchByNameAction();
        this.m_actParenthesis = this.createParenthesisAction();
        this.m_ckbIncludeDups = WsUIUtilities.createCheckBox((WsAbstractToggleAction)this.m_actIncludeDups);
        this.m_ckbMatchByName = WsUIUtilities.createCheckBox((WsAbstractToggleAction)this.m_actMatchByName);
        this.m_ckbParenthesis = WsUIUtilities.createCheckBox((WsAbstractToggleAction)this.m_actParenthesis);
        this.listenForDataChangesTo(this.m_ckbIncludeDups);
        this.listenForDataChangesTo(this.m_ckbMatchByName);
        this.listenForDataChangesTo(this.m_ckbParenthesis);
        this.m_txtDescription = new WATextField();
        this.m_txtDescription.setMaxCharacters(200);
        this.m_txtDescription.setColumns(40);
        this.m_txtDescription.setEditable(true);
        this.m_txtDescription.setMinimumSize(this.m_txtDescription.getPreferredSize());
        this.m_lsnDescription = new DescriptionFieldListener();
        this.m_txtDescription.addFocusListener(this.m_lsnDescription);
        this.m_lblDescription = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtDescription, (WAdminResource)bundle, (String)"SQLSetOperatorsPanel.Label.Description");
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        JPanel typePanel = new JPanel();
        typePanel.setLayout(new GridBagLayout());
        typePanel.add((Component)this.m_lblSetOperatorType, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 10), 0, 0));
        typePanel.add((Component)this.m_cmbSetOperatorType, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 10), 0, 0));
        typePanel.add((Component)this.m_lblDescription, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 10), 0, 0));
        typePanel.add((Component)this.m_txtDescription, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 10), 0, 0));
        this.add(typePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 10, 10), 0, 0));
        this.add(this.m_ckbIncludeDups, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 10), 0, 0));
        this.add(this.m_ckbMatchByName, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 10), 0, 0));
        this.add(this.m_ckbParenthesis, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 10), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 5, 2, 2, 1.0, 1.0, 18, 1, new Insets(5, 10, 0, 0), 0, 0));
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_ckbIncludeDups.setSelected(this.m_oSetOperator.useIncludeDuplicates());
        this.m_ckbMatchByName.setSelected(this.m_oSetOperator.useMatchColumnsByName());
        this.m_ckbParenthesis.setSelected(this.m_oSetOperator.hasParenthesis());
        this.m_txtDescription.setText(this.m_oSetOperator.getDescription());
        if (this.m_oSetOperator.getType() == "Outer Union") {
            this.m_ckbIncludeDups.setEnabled(false);
        }
        this.m_cmbSetOperatorType.setSelectedItem((Object)this.m_oSetOperator.getType());
    }

    public void moveDataToStore() throws MdException, RemoteException {
        boolean i = true;
    }

    public void saveSettingsAndCleanUp() {
        this.m_txtDescription.removeFocusListener(this.m_lsnDescription);
        this.m_cmbSetOperatorType.removeItemListener(this.m_lsnItem);
        this.m_oSetOperator.getModel().removeModelListener(this.m_lsnModel);
    }

    protected WsAbstractToggleAction createMatchByNameAction() {
        return new cMatchByNameToggleAction();
    }

    protected WsAbstractToggleAction createIncludeDupsAction() {
        return new cIncludeDupsToggleAction();
    }

    protected WsAbstractToggleAction createParenthesisAction() {
        return new cParenthesisToggleAction();
    }

    private class SetOperatorsModelListener
    implements IModelListener {
        private SetOperatorsModelListener() {
        }

        public void modelChanged(ModelEvent event) {
            if (event.getModelObject() != SQLSetOperatorsPanel.this.m_oSetOperator) {
                return;
            }
            if (event.getType() == "SetOperators:IncludeDuplicatesChanged") {
                SQLSetOperatorsPanel.this.m_ckbIncludeDups.setSelected(SQLSetOperatorsPanel.this.m_oSetOperator.useIncludeDuplicates());
            } else if (event.getType() == "SetOperators:MatchByNameChanged") {
                SQLSetOperatorsPanel.this.m_ckbMatchByName.setSelected(SQLSetOperatorsPanel.this.m_oSetOperator.useMatchColumnsByName());
            } else if (event.getType() == "SetOperators:ParenthesisChanged") {
                SQLSetOperatorsPanel.this.m_ckbParenthesis.setSelected(SQLSetOperatorsPanel.this.m_oSetOperator.hasParenthesis());
            } else if (event.getType() == "Object:DescriptionChanged") {
                SQLSetOperatorsPanel.this.m_txtDescription.setText(SQLSetOperatorsPanel.this.m_oSetOperator.getDescription());
            } else if (event.getType() == "SetOperators:TypeChanged") {
                SQLSetOperatorsPanel.this.m_cmbSetOperatorType.setSelectedItem((Object)SQLSetOperatorsPanel.this.m_oSetOperator.getType());
                if (SQLSetOperatorsPanel.this.m_oSetOperator.getType() == "Outer Union") {
                    SQLSetOperatorsPanel.this.m_ckbIncludeDups.setSelected(false);
                    SQLSetOperatorsPanel.this.m_ckbIncludeDups.setEnabled(false);
                } else {
                    SQLSetOperatorsPanel.this.m_ckbIncludeDups.setEnabled(true);
                }
            }
        }
    }

    protected class DescriptionFieldListener
    implements FocusListener {
        protected DescriptionFieldListener() {
        }

        @Override
        public void focusGained(FocusEvent event) {
        }

        @Override
        public void focusLost(FocusEvent event) {
            Component source = event.getComponent();
            if (source == SQLSetOperatorsPanel.this.m_txtDescription) {
                SQLSetOperatorsPanel.this.m_oSetOperator.setDescription(SQLSetOperatorsPanel.this.m_txtDescription.getText());
            }
        }
    }

    private class cListCellRenderer
    extends DefaultListCellRenderer {
        private cListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            WsCompoundIcon iconCompound = new WsCompoundIcon();
            iconCompound.setIconGap(1);
            if (value instanceof String) {
                Icon icon = JoinEditorIcons.getIcon((String)value);
                iconCompound.addIcon(icon);
                this.setText((String)value);
            }
            if (iconCompound.getIconCount() == 0) {
                this.setIcon(null);
            } else {
                this.setIcon((Icon)iconCompound);
            }
            return this;
        }
    }

    private class cItemListener
    implements ItemListener {
        private cItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            WAComboBox cmBox = (WAComboBox)e.getSource();
            Object item = cmBox.getSelectedItem();
            SQLSetOperatorsPanel.this.m_oSetOperator.setType((String)item);
            SQLSetOperatorsPanel.this.m_txtDescription.setText(SQLSetOperatorsPanel.this.m_oSetOperator.getDescription());
            if (item == "Outer Union") {
                SQLSetOperatorsPanel.this.m_ckbIncludeDups.setSelected(false);
                SQLSetOperatorsPanel.this.m_ckbIncludeDups.setEnabled(false);
            } else {
                SQLSetOperatorsPanel.this.m_ckbIncludeDups.setEnabled(true);
            }
        }
    }

    private class cMatchByNameToggleAction
    extends WsAbstractToggleAction {
        public cMatchByNameToggleAction() {
            super(bundle, "SQLSetOperatorsPanel.MatchByName", 0);
        }

        public void actionPerformed(ActionEvent e) {
            SQLSetOperatorsPanel.this.m_oSetOperator.setMatchColumnsByName(SQLSetOperatorsPanel.this.m_ckbMatchByName.isSelected());
        }
    }

    private class cParenthesisToggleAction
    extends WsAbstractToggleAction {
        public cParenthesisToggleAction() {
            super(bundle, "SQLSetOperatorsPanel.Parenthesis", 0);
        }

        public void actionPerformed(ActionEvent e) {
            SQLSetOperatorsPanel.this.m_oSetOperator.setHasParenthesis(SQLSetOperatorsPanel.this.m_ckbParenthesis.isSelected());
        }
    }

    private class cIncludeDupsToggleAction
    extends WsAbstractToggleAction {
        public cIncludeDupsToggleAction() {
            super(bundle, "SQLSetOperatorsPanel.IncludeDups", 0);
        }

        public void actionPerformed(ActionEvent e) {
            SQLSetOperatorsPanel.this.m_oSetOperator.setIncludeDuplicates(SQLSetOperatorsPanel.this.m_ckbIncludeDups.isSelected());
        }
    }
}

