/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.editor;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.etl.models.job.transforms.sql.ISetOperator;
import com.sas.etl.models.job.transforms.sql.ISourceTable;
import com.sas.etl.models.job.transforms.sql.impl.SQLSetOperatorsTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.transforms.sql.editor.JoinEditorIcons;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsCompoundIcon;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.objectselector.ObjectSelectorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SQLSetOperatorsListPanel
extends WAPanel {
    private static final WAdminResource bundle = WAdminResource.getBundle(SQLSetOperatorsListPanel.class);
    private SQLSetOperatorsTransformModel m_model;
    private IModelListener m_lsnrModel;
    private JList m_lTablesSetOperators;
    private DefaultListModel m_mdlTablesSetOperators;
    private ListSelectionListener m_lsrTablesSetOperators;
    private JToolBar m_toolbar;
    private WsAbstractAction m_actUp;
    private WsAbstractAction m_actDown;
    private WsAbstractAction m_actAdd;
    private WsAbstractAction m_actRemove;

    public SQLSetOperatorsListPanel(SQLSetOperatorsTransformModel oSetOperators) {
        this.m_model = oSetOperators;
        this.initialize();
        this.layoutWidgets();
    }

    protected void initialize() {
        this.m_lsnrModel = new SetOperatorsModelListener();
        this.m_model.getModel().addModelListener(this.m_lsnrModel);
        this.m_actAdd = new AddAction();
        this.m_actRemove = new RemoveAction();
        this.m_actUp = new MoveUpAction();
        this.m_actDown = new MoveDownAction();
        this.createToolBar();
        this.m_lsrTablesSetOperators = new ObjectSelectionListener();
        this.m_mdlTablesSetOperators = new DefaultListModel();
        this.m_lTablesSetOperators = new JList(this.m_mdlTablesSetOperators);
        this.m_lTablesSetOperators.setCellRenderer(new cListCellRenderer());
        this.m_lTablesSetOperators.setSelectionMode(0);
        this.m_lTablesSetOperators.addListSelectionListener(this.m_lsrTablesSetOperators);
    }

    protected void layoutWidgets() {
        this.setLayout(new BorderLayout());
        this.add(this.m_toolbar, "North");
        this.add(this.m_lTablesSetOperators, "Center");
    }

    private void createToolBar() {
        this.m_toolbar = WsUIUtilities.createToolBar();
        this.m_toolbar.add(WsUIUtilities.createFlatTextIconButton((WsAbstractAction)this.m_actAdd));
        this.m_toolbar.addSeparator();
        this.m_toolbar.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actUp));
        this.m_toolbar.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actDown));
        this.m_toolbar.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actRemove));
    }

    public void updateActions() {
        Object item = this.getSelectedObject();
        if (item instanceof ISetOperator) {
            this.m_actRemove.setEnabled(false);
            this.m_actUp.setEnabled(false);
            this.m_actDown.setEnabled(false);
        } else {
            this.m_actRemove.setEnabled(item != null);
            this.m_actUp.setEnabled(item != null && this.m_mdlTablesSetOperators.size() > 1 && this.m_lTablesSetOperators.getSelectedIndex() != 0);
            this.m_actDown.setEnabled(item != null && this.m_mdlTablesSetOperators.size() > 1 && this.m_lTablesSetOperators.getSelectedIndex() != this.m_mdlTablesSetOperators.size() - 1);
        }
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.refreshSetOperatorsList();
        this.setListeningForChanges(true);
        this.m_lTablesSetOperators.setSelectedIndex(0);
        this.updateActions();
    }

    private void refreshSetOperatorsList() {
        this.m_mdlTablesSetOperators.clear();
        List operators = this.m_model.getSetOperatorsList();
        for (int iOperator = 0; iOperator < operators.size(); ++iOperator) {
            ISetOperator set = (ISetOperator)operators.get(iOperator);
            if (iOperator == 0) {
                if (set.getFirstQuery() != null) {
                    this.m_mdlTablesSetOperators.addElement(set.getFirstQuery());
                }
                if (set.getFirstQuery() != null && set.getSecondQuery() != null) {
                    this.m_mdlTablesSetOperators.addElement(set);
                }
                if (set.getSecondQuery() == null) continue;
                this.m_mdlTablesSetOperators.addElement(set.getSecondQuery());
                continue;
            }
            if (iOperator <= 0 || set.getSecondQuery() == null) continue;
            this.m_mdlTablesSetOperators.addElement(set);
            this.m_mdlTablesSetOperators.addElement(set.getSecondQuery());
        }
    }

    public void saveSettingsAndCleanUp() {
        this.m_model.getModel().removeModelListener(this.m_lsnrModel);
        this.m_lTablesSetOperators.removeListSelectionListener(this.m_lsrTablesSetOperators);
    }

    public Object getSelectedObject() {
        return this.m_lTablesSetOperators.getSelectedValue();
    }

    public void addListSelectionListener(ListSelectionListener lsnr) {
        this.m_lTablesSetOperators.getSelectionModel().addListSelectionListener(lsnr);
    }

    public void removeListSelectionListener(ListSelectionListener lsnr) {
        this.m_lTablesSetOperators.getSelectionModel().removeListSelectionListener(lsnr);
    }

    private class ObjectSelectionListener
    implements ListSelectionListener {
        private ObjectSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            SQLSetOperatorsListPanel.this.updateActions();
        }
    }

    private class SetOperatorsModelListener
    implements IModelListener {
        private SetOperatorsModelListener() {
        }

        public void modelChanged(ModelEvent event) {
            if (event.getType() == "SQLSetOperatorsTransformModel:SetOperatorRemoved" || event.getType() == "DataTransform.DataSourceRemoved" || event.getType() == "SetOperators:FirstQueryChanged" || event.getType() == "SetOperators:SecondQueryChanged" || event.getType() == "SetOperators:TypeChanged") {
                SQLSetOperatorsListPanel.this.m_mdlTablesSetOperators.clear();
                SQLSetOperatorsListPanel.this.refreshSetOperatorsList();
                if (event.getType() == "SetOperators:TypeChanged") {
                    Object item = SQLSetOperatorsListPanel.this.getSelectedObject();
                    SQLSetOperatorsListPanel.this.m_lTablesSetOperators.setSelectedValue(item, true);
                } else {
                    SQLSetOperatorsListPanel.this.m_lTablesSetOperators.setSelectedIndex(SQLSetOperatorsListPanel.this.m_mdlTablesSetOperators.size() - 1);
                }
            }
        }
    }

    private class cListCellRenderer
    extends DefaultListCellRenderer {
        private cListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            WsCompoundIcon iconCompound = new WsCompoundIcon();
            iconCompound.setIconGap(1);
            if (value instanceof IQuery) {
                ISourceTable table = null;
                if (((IQuery)value).getQuerySourceTableCount() > 0) {
                    table = ((IQuery)value).getQuerySourceTables()[0];
                }
                Icon icon = JoinEditorIcons.getTableIcon(table);
                iconCompound.addIcon(icon);
                this.setText(table.getName());
            } else if (value instanceof ISetOperator) {
                Icon icon = JoinEditorIcons.getIcon(((ISetOperator)value).getType());
                iconCompound.addIcon(icon);
                this.setText(((ISetOperator)value).getType());
            }
            if (iconCompound.getIconCount() == 0) {
                this.setIcon(null);
            } else {
                this.setIcon((Icon)iconCompound);
            }
            return this;
        }
    }

    private class AddAction
    extends WsAbstractAction {
        public AddAction() {
            super(bundle, "SQLSetOperatorsListPanel.Add", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("File:New:Table"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            ObjectSelectorPanel pnl = new ObjectSelectorPanel(Workspace.getWorkspace().getUserContext(), 3);
            String sTitle = bundle.getString("SQLSetOperatorsListPanel.TableSelector.title.txt");
            WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sTitle, true, (WAPanel)pnl);
            dlg.setResizable(true);
            dlg.show();
            ITable oTable = null;
            if (dlg.getReturnValue() == 1) {
                IModel jobModel = SQLSetOperatorsListPanel.this.m_model.getModel();
                jobModel.startCompoundUndoable();
                try {
                    SimpleObject table = pnl.getSelectedObject();
                    OMRAdapter omr = new OMRAdapter(SQLSetOperatorsListPanel.this.m_model.getModel(), Workspace.getMdFactory(), "SQLSetOperatorsListPanel.loadTable");
                    try {
                        if (table != null) {
                            PhysicalTable mdoTable = (PhysicalTable)omr.acquireOMRObject(table.getID(), "PhysicalTable");
                            oTable = (ITable)omr.acquireObjectUsingTemplate((Root)mdoTable);
                        }
                    }
                    finally {
                        omr.dispose();
                    }
                    if (!SQLSetOperatorsListPanel.this.m_model.getJob().getDataObjectsList().contains(oTable)) {
                        SQLSetOperatorsListPanel.this.m_model.getJob().getDataObjectsList().add(oTable);
                    }
                    SQLSetOperatorsListPanel.this.m_model.addDataSource((IDataObject)oTable);
                }
                catch (RemoteException ex) {
                    MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                }
                catch (MdException ex) {
                    MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                }
                finally {
                    jobModel.endCompoundUndoable();
                }
            }
        }
    }

    private class RemoveAction
    extends WsAbstractAction {
        public RemoveAction() {
            super(bundle, "SQLSetOperatorsListPanel.Remove", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Delete"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            Object item = SQLSetOperatorsListPanel.this.getSelectedObject();
            if (item instanceof IQuery) {
                ISourceTable table = ((IQuery)item).getQuerySourceTables()[0];
                IModel jobModel = SQLSetOperatorsListPanel.this.m_model.getModel();
                jobModel.startCompoundUndoable();
                try {
                    SQLSetOperatorsListPanel.this.m_model.removeDataSource((IDataObject)table);
                    SQLSetOperatorsListPanel.this.m_model.removeConnectedSource((IDataObject)table);
                    SQLSetOperatorsListPanel.this.m_model.getJob().getDataObjectsList().remove(table);
                }
                finally {
                    jobModel.endCompoundUndoable();
                }
            }
        }
    }

    private class MoveDownAction
    extends WsAbstractAction {
        public MoveDownAction() {
            super(bundle, "SQLSetOperatorsListPanel.MoveDown", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:MoveDown"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            Object item = SQLSetOperatorsListPanel.this.getSelectedObject();
            if (item instanceof IQuery) {
                IQuery query = (IQuery)item;
                ISetOperator operator = (ISetOperator)SQLSetOperatorsListPanel.this.m_mdlTablesSetOperators.get(SQLSetOperatorsListPanel.this.m_lTablesSetOperators.getSelectedIndex() + 1);
                IModel jobModel = SQLSetOperatorsListPanel.this.m_model.getModel();
                jobModel.startCompoundUndoable();
                try {
                    SQLSetOperatorsListPanel.this.m_model.moveDown(query, operator);
                }
                finally {
                    jobModel.endCompoundUndoable();
                }
            }
        }
    }

    private class MoveUpAction
    extends WsAbstractAction {
        public MoveUpAction() {
            super(bundle, "SQLSetOperatorsListPanel.MoveUp", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:MoveUp"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            Object item = SQLSetOperatorsListPanel.this.getSelectedObject();
            if (item instanceof IQuery) {
                IQuery query = (IQuery)item;
                ISetOperator operator = (ISetOperator)SQLSetOperatorsListPanel.this.m_mdlTablesSetOperators.get(SQLSetOperatorsListPanel.this.m_lTablesSetOperators.getSelectedIndex() - 1);
                IModel jobModel = SQLSetOperatorsListPanel.this.m_model.getModel();
                jobModel.startCompoundUndoable();
                try {
                    SQLSetOperatorsListPanel.this.m_model.moveUp(query, operator);
                }
                finally {
                    jobModel.endCompoundUndoable();
                }
            }
        }
    }
}

