/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.editor;

import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.job.transforms.common.IGroupBy;
import com.sas.etl.models.job.transforms.common.IOrderBy;
import com.sas.etl.models.job.transforms.sql.IClause;
import com.sas.etl.models.job.transforms.sql.IFromContainer;
import com.sas.etl.models.job.transforms.sql.IHaving;
import com.sas.etl.models.job.transforms.sql.IJoin;
import com.sas.etl.models.job.transforms.sql.ISQLBooleanExpressionContainer;
import com.sas.etl.models.job.transforms.sql.ISQLCreateStatement;
import com.sas.etl.models.job.transforms.sql.ISQLSource;
import com.sas.etl.models.job.transforms.sql.ISQLTransform;
import com.sas.etl.models.job.transforms.sql.ISelectResultsContainer;
import com.sas.etl.models.job.transforms.sql.ISourceTable;
import com.sas.etl.models.job.transforms.sql.ISubquery;
import com.sas.etl.models.job.transforms.sql.IWhere;
import com.sas.services.user.UserContextInterface;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.jobeditor.diagram.DiagramPanel;
import com.sas.wadmin.transforms.sql.editor.JoinEditorIcons;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.ISimpleObjectFilter;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.tree.AbstractTreeModel;
import com.sas.workspace.models.tree.AbstractTreeNode;
import com.sas.workspace.models.tree.IDataTreeNode;
import com.sas.workspace.models.tree.ITreeModel;
import com.sas.workspace.models.tree.ITreeNode;
import com.sas.workspace.models.tree.ITreeNodeFactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class NavigatorTreeModel
extends AbstractTreeModel {
    private static final WAdminResource bundle = WAdminResource.getBundle(NavigatorTreeModel.class);
    private ISQLTransform m_model;

    public NavigatorTreeModel(ISQLTransform model) {
        super(Workspace.getWorkspace().getUserContext(), null);
        this.m_model = model;
        ElementNode treeRoot = new ElementNode((IObject)this.m_model, this.m_model.getName());
        treeRoot.setTreeModel((ITreeModel)this);
        this.setRoot((TreeNode)((Object)treeRoot));
        treeRoot.setEditable(false);
    }

    public void populate() {
        ElementNode nodeRoot = (ElementNode)((Object)this.getRoot());
        nodeRoot.removeAllChildren();
        this.nodeStructureChanged((TreeNode)((Object)nodeRoot));
        this.populate(nodeRoot, this.m_model.getClauses());
    }

    public ISQLTransform getTransformModel() {
        return this.m_model;
    }

    protected void addCreatedObjects(Map objectsMap) {
    }

    protected void updateModifiedObjects(Map objectsMap) {
    }

    public void populate(ElementNode parent, IClause[] clauses) {
        for (int index = 0; index < clauses.length; ++index) {
            ElementNode nodeChild;
            ISubquery subquery;
            ISubquery[] alSubqueries;
            IClause clause = clauses[index];
            ElementNode node = new ElementNode((IObject)clause, this.getNodeName((IObject)clause));
            this.addNode(parent, node);
            if (clause instanceof IGroupBy || clause instanceof IOrderBy) {
                node.setAllowsChildren(false);
                continue;
            }
            if (clause instanceof ISQLCreateStatement) {
                ISQLCreateStatement create = (ISQLCreateStatement)clause;
                IDataObject target = create.getDataTarget();
                if (target == null) continue;
                ElementNode nodeTarget = new ElementNode((IObject)target, this.getNodeName((IObject)target));
                this.addNode(node, nodeTarget);
                nodeTarget.setAllowsChildren(false);
                continue;
            }
            if (clause instanceof ISelectResultsContainer) {
                alSubqueries = ((ISelectResultsContainer)clause).getSubqueries();
                if (alSubqueries.length == 0) {
                    node.setAllowsChildren(false);
                }
                for (int i = 0; i < alSubqueries.length; ++i) {
                    subquery = alSubqueries[i];
                    nodeChild = new ElementNode((IObject)subquery, "Subquery");
                    this.addNode(node, nodeChild);
                    this.populate(nodeChild, subquery.getClauses());
                }
                continue;
            }
            if (clause instanceof IFromContainer) {
                IFromContainer from = (IFromContainer)clause;
                ISQLSource source = from.getSourceOfFrom();
                node.setAllowsChildren(true);
                this.addSource(node, source);
                continue;
            }
            if (!(clause instanceof ISQLBooleanExpressionContainer)) continue;
            alSubqueries = ((ISQLBooleanExpressionContainer)clause).getSubqueries();
            if (alSubqueries.length == 0) {
                node.setAllowsChildren(false);
            }
            for (int i = 0; i < alSubqueries.length; ++i) {
                subquery = alSubqueries[i];
                nodeChild = new ElementNode((IObject)subquery, "Subquery");
                this.addNode(node, nodeChild);
                this.populate(nodeChild, subquery.getClauses());
            }
        }
    }

    public void addNode(ElementNode parent, ElementNode node) {
        node.setEditable(false);
        this.insertNodeInto((MutableTreeNode)((Object)node), (MutableTreeNode)((Object)parent), parent.getChildCount());
    }

    public void addSource(ElementNode parentNode, ISQLSource source) {
        if (source == null) {
            return;
        }
        if (source instanceof ISourceTable) {
            ElementNode node = new ElementNode((IObject)source);
            node.setAllowsChildren(false);
            this.addNode(parentNode, node);
        } else if (source instanceof ISubquery) {
            ElementNode nodeChild = new ElementNode((IObject)source, "Subquery");
            this.addNode(parentNode, nodeChild);
            this.populate(nodeChild, ((ISubquery)source).getClauses());
        } else if (source instanceof IJoin) {
            IJoin join = (IJoin)source;
            ISQLSource leftSide = join.getLeftSide();
            if (leftSide != null) {
                if (leftSide instanceof IJoin) {
                    this.addSource(parentNode, leftSide);
                } else if (leftSide instanceof ISubquery) {
                    ElementNode nodeChild = new ElementNode((IObject)leftSide, "Subquery");
                    this.addNode(parentNode, nodeChild);
                    this.populate(nodeChild, ((ISubquery)leftSide).getClauses());
                } else {
                    ElementNode node = new ElementNode((IObject)leftSide);
                    node.setAllowsChildren(false);
                    this.addNode(parentNode, node);
                }
            }
            ElementNode joinNode = new ElementNode((IObject)join);
            this.addNode(parentNode, joinNode);
            if (!join.useImplicit()) {
                ISubquery[] alSubqueries = join.getSubqueries();
                if (alSubqueries.length == 0) {
                    joinNode.setAllowsChildren(false);
                }
                for (int i = 0; i < alSubqueries.length; ++i) {
                    ISubquery subquery = alSubqueries[i];
                    ElementNode nodeChild = new ElementNode((IObject)subquery, "Subquery");
                    this.addNode(joinNode, nodeChild);
                    this.populate(nodeChild, subquery.getClauses());
                }
            } else {
                joinNode.setAllowsChildren(false);
            }
            ISQLSource rightSide = join.getRightSide();
            if (rightSide != null) {
                if (rightSide instanceof IJoin) {
                    this.addSource(parentNode, rightSide);
                } else if (rightSide instanceof ISubquery) {
                    ElementNode nodeChild = new ElementNode((IObject)rightSide, "Subquery");
                    this.addNode(parentNode, nodeChild);
                    this.populate(nodeChild, ((ISubquery)rightSide).getClauses());
                } else {
                    ElementNode node = new ElementNode((IObject)rightSide);
                    node.setAllowsChildren(false);
                    this.addNode(parentNode, node);
                }
            }
        }
    }

    protected String getNodeName(IObject object) {
        if (object instanceof ISQLCreateStatement) {
            return "Create";
        }
        if (object instanceof ISelectResultsContainer) {
            return "Select";
        }
        if (object instanceof IFromContainer) {
            return "From";
        }
        if (object instanceof IWhere) {
            return "Where";
        }
        if (object instanceof IHaving) {
            return "Having";
        }
        if (object instanceof IOrderBy) {
            return "Order by";
        }
        if (object instanceof IGroupBy) {
            return "Group by";
        }
        if (object instanceof ISourceTable || object instanceof IPhysicalTable) {
            return this.getTableName((ITable)object);
        }
        return object.getName();
    }

    protected String getTableName(ITable table) {
        String sName = "";
        String sAlias = "";
        if (table instanceof ISourceTable) {
            ISourceTable source = (ISourceTable)table;
            IPhysicalTable pTable = (IPhysicalTable)source.getAliasedTable();
            if (pTable == null) {
                return "";
            }
            sName = pTable.getName();
            sAlias = source.getAliasName();
            if (sAlias.length() < 1) {
                sAlias = pTable.getSASTableName();
            }
        } else {
            IPhysicalTable pTable = (IPhysicalTable)table;
            sName = pTable.getName();
            sAlias = pTable.getSASTableName();
        }
        if (DiagramPanel.isUserPreferenceToIncludePhysicalName()) {
            sName = bundle.formatString("SQLPhysicalTableAdapter.Name.txt", (Object)sName, (Object)sAlias);
        }
        return sName;
    }

    public ElementNode findNode(IObject object) {
        return this.findNode((IDataTreeNode)this.getRoot(), object);
    }

    public ElementNode findNode(IDataTreeNode node, IObject object) {
        if (node instanceof ElementNode && node.getData() == object) {
            return (ElementNode)node;
        }
        for (int index = 0; index < node.getChildCount(); ++index) {
            ElementNode child = this.findNode((IDataTreeNode)node.getChildAt(index), object);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    protected void removeDeletedObjects(String[] aFQIDs) {
    }

    public void addChild(IDataTreeNode newNode) {
    }

    public void addChildren(ITreeNode parentNode) {
    }

    public List findParentNodes(SimpleBrowseObject object) {
        return null;
    }

    public boolean isValidParent(ITreeNode parentNode, ITreeNode childNode) {
        return false;
    }

    public void addChild(ITreeNode newNode, ITreeNode parentNode) {
    }

    public ITreeNode createNode(Object userObject) {
        return null;
    }

    public void dispose() {
        super.dispose();
    }

    public List findNodes(String sFQID) {
        return new ArrayList();
    }

    public Comparator getNodeComparator() {
        return null;
    }

    public ITreeNodeFactory getNodeFactory() {
        return null;
    }

    public ISimpleObjectFilter getNodeFilter() {
        return null;
    }

    public UserContextInterface getUserContext() {
        return null;
    }

    public boolean isValidObject(SimpleBrowseObject simpleObj) {
        return false;
    }

    public void removeAllChildren(ITreeNode node) {
    }

    public void removeChild(ITreeNode node) {
    }

    public void setNodeComparator(Comparator comparator) {
    }

    public void setNodeFactory(ITreeNodeFactory nodeFactory) {
    }

    public void setNodeFilter(ISimpleObjectFilter nodeFilter) {
    }

    private class ElementNode
    extends AbstractTreeNode
    implements IDataTreeNode {
        private IObject m_element;

        public ElementNode(IObject element) {
            super((Object)NavigatorTreeModel.this.getNodeName(element));
            this.m_element = element;
        }

        public ElementNode(IObject element, String name) {
            super((Object)name);
            this.m_element = element;
        }

        public boolean delete() {
            return false;
        }

        public Object getData() {
            return this.m_element;
        }

        public String getID() {
            return this.m_element.getID();
        }

        public String getType() {
            if (this.m_element instanceof IClause) {
                return ((IClause)this.m_element).getClauseType().getType();
            }
            return ((ITable)this.m_element).getPublicType();
        }

        public boolean isDeleteAllowed() {
            return !(this.m_element instanceof ISelectResultsContainer) && !(this.m_element instanceof ISQLCreateStatement);
        }

        public boolean isRenameAllowed() {
            return !(this.m_element instanceof ITable);
        }

        public boolean isValidName(String sNewName) {
            return true;
        }

        public void rename(String sNewName) {
            if (this.m_element instanceof IClause) {
                this.m_element.setName(sNewName);
            }
        }

        public void expand() {
        }

        public void update() {
        }

        public Icon getIcon() {
            Icon icon = JoinEditorIcons.getIcon(this.getName());
            if (icon != null) {
                return icon;
            }
            if (this.m_element instanceof ISQLCreateStatement) {
                return AppIconFactory.getInstance().getIconForPublicType("Folder");
            }
            if (this.m_element instanceof IFromContainer) {
                return AppIconFactory.getInstance().getIconForPublicType("Folder");
            }
            if (this.m_element instanceof IJoin) {
                IJoin join = (IJoin)this.m_element;
                return JoinEditorIcons.getIcon(join.getJoinType());
            }
            if (this.m_element instanceof ITable) {
                return JoinEditorIcons.getTableIcon((ITable)this.m_element);
            }
            return AppIconFactory.getInstance().getIconForPublicType("Folder");
        }

        public boolean isFolder() {
            return false;
        }
    }
}

