/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.editor;

import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.job.IDesignTimeModel;
import com.sas.etl.models.job.transforms.sql.IAliasTable;
import com.sas.etl.models.job.transforms.sql.IClause;
import com.sas.etl.models.job.transforms.sql.IFromContainer;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.app.actions.AppActionsManager;
import com.sas.wadmin.jobeditor.diagram.DiagramTab;
import com.sas.wadmin.jobeditor.diagram.WADiagramTab;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramNode;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramStickyNote;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.DataLink;
import com.sas.wadmin.transforms.sql.editor.ActionFactory;
import com.sas.wadmin.transforms.sql.editor.INavigationListener;
import com.sas.wadmin.transforms.sql.editor.JoinDiagramModel;
import com.sas.wadmin.transforms.sql.editor.JoinDiagramPanel;
import com.sas.wadmin.transforms.sql.editor.NavigationEvent;
import com.sas.wadmin.visuals.common.SettingsToolbarItems;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractApplicationActionsManager;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.visuals.pfd.WsPFDModel;
import com.sas.workspace.visuals.pfd.WsPFDPanel;
import com.sas.workspace.visuals.pfd.WsPFDSelectionEvent;
import com.sas.workspace.visuals.pfd.WsPFDSelectionListener;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class JoinDiagramTab
extends WADiagramTab
implements SettingsToolbarItems {
    private static final WAdminResource bundle = WAdminResource.getBundle(JoinDiagramTab.class);
    private IQuery m_query;
    private JoinDiagramModel m_mdlJoinDiagram;
    private WsAbstractAction m_actDefault;
    private WsAbstractToggleAction m_actShowTableColumns;
    private List m_lNavigationListeners;
    private PropertyChangeListener m_lsnrAppDefaults;
    private static final String SHOW_DIAGRAM_TOOLBAR_KEY = "DiagramTab.ShowDiagramToolbar";

    public JoinDiagramTab(IDesignTimeModel jobModel, IQuery query) {
        this.m_query = query;
        this.setName(bundle.getString("JoinDiagramTab.Name.txt"));
        this.m_lNavigationListeners = new ArrayList();
        this.m_lsnrAppDefaults = new AppDefaultsListener();
        Workspace.getWorkspace().getAppDefaultsFile().addPropertyChangeListener(this.m_lsnrAppDefaults);
        this.m_mdlJoinDiagram = (JoinDiagramModel)this.getPFDModel();
        this.getDiagramPanel().setModel((IPersistableObject)this.m_query);
        this.getScrollComponent().setMinimumSize(new Dimension(0, 0));
        this.setDiagramToolBarVisible(DiagramTab.isUserPreferenceToShowDiagramToolBar());
        this.setHelpProduct("wdb");
        this.setHelpTopic("sql_create");
    }

    @Override
    protected WsPFDModel createPFDModel() {
        return new JoinDiagramModel(this.m_query);
    }

    protected WsPFDPanel createPFDComponent() {
        JoinDiagramModel model = (JoinDiagramModel)this.getPFDModel();
        JoinDiagramPanel diagram = new JoinDiagramPanel(model);
        diagram.setModel(model.getMainObject());
        diagram.setPopupMenuRequestListener(this.createDefaultPopupMenuRequestListener());
        diagram.getSelectionModel().addSelectionListener((WsPFDSelectionListener)new SelectionListener());
        return diagram;
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.m_actDefault = new DefaultNodeAction();
        this.getPFDComponent().setDefaultAction((Action)this.m_actDefault);
        this.m_actShowTableColumns = new ShowTableColumnsAction();
    }

    protected void installDefaults() {
    }

    @Override
    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actShowTableColumns.setActive(bActive);
    }

    public void moveDataToView() {
        this.m_actShowTableColumns.setSelected(this.m_mdlJoinDiagram.isShowColumns());
        this.setDataChanged(false);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.save();
    }

    public boolean validateData() {
        return this.save();
    }

    @Override
    public boolean save() {
        return ((JoinDiagramPanel)this.getDiagramPanel()).save();
    }

    @Override
    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        Workspace.getWorkspace().getAppDefaultsFile().removePropertyChangeListener(this.m_lsnrAppDefaults);
        this.m_mdlJoinDiagram.dispose();
    }

    @Override
    public JMenuItem[] getMenuItems() {
        return new JMenuItem[]{WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actShowTableColumns)};
    }

    public void addNavigationListener(INavigationListener listener) {
        this.m_lNavigationListeners.add(listener);
    }

    public void removeNavigationListener(INavigationListener listener) {
        this.m_lNavigationListeners.remove(listener);
    }

    private void fireNavigationEvent(IObject object) {
        if (this.m_lNavigationListeners.isEmpty()) {
            return;
        }
        NavigationEvent ev = new NavigationEvent(this, object);
        for (int iListener = 0; iListener < this.m_lNavigationListeners.size(); ++iListener) {
            INavigationListener listener = (INavigationListener)this.m_lNavigationListeners.get(iListener);
            listener.navigationChanged(ev);
        }
    }

    @Override
    protected JPopupMenu createCanvasPopupMenu() {
        DiagramContext context = new DiagramContext(this.m_query);
        JPopupMenu menuPopup = AppActionsManager.getInstance().createPopupMenuFor((WsActionContextInterface)context);
        menuPopup.addSeparator();
        menuPopup.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actShowTableColumns));
        return menuPopup;
    }

    @Override
    protected JPopupMenu createNodePopupMenu(IDiagramNode node) {
        DiagramContext context = new DiagramContext(node.getObject());
        return AppActionsManager.getInstance().createPopupMenuFor((WsActionContextInterface)context);
    }

    @Override
    protected JPopupMenu createStickyNotePopupMenu(IDiagramStickyNote note) {
        JPopupMenu mnuPopup = super.createStickyNotePopupMenu(note);
        mnuPopup.addSeparator();
        mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.getDeleteAction()));
        return mnuPopup;
    }

    @Override
    protected JPopupMenu createDataLinkPopupMenu(DataLink link) {
        JPopupMenu mnuPopup = new JPopupMenu();
        mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.getDeleteAction()));
        return mnuPopup;
    }

    public void setDeleteAction(WsAbstractAction actDelete) {
        this.getPFDComponent().setDeleteAction((Action)actDelete);
    }

    public WsAbstractAction getDeleteAction() {
        return (WsAbstractAction)this.getPFDComponent().getDeleteAction();
    }

    public void selectClause(IClause clause) {
        this.getPFDComponent().removeAllPrimitivesFromSelection();
        PFDAbstractNode node = (PFDAbstractNode)this.m_mdlJoinDiagram.getNode((IObject)clause);
        if (node != null) {
            this.getPFDComponent().addPrimitiveToSelection((PFDPrimitive)node);
            this.getPFDComponent().panToPrimitive((PFDPrimitive)node, false);
        }
    }

    private void setDiagramToolBarVisible(boolean bVisible) {
        this.getDiagramPanel().getAction("ACTION_TOGGLE_TOOLBAR").putValue("pfdAbstractAction.selected", bVisible);
        this.getScrollComponent().revalidate();
    }

    @Override
    protected boolean isContextForMainObject(WsActionContextInterface context) {
        Object[] aObjects = context.getSelectedObjects();
        return aObjects.length == 1 && (aObjects[0] == this.m_query && !(aObjects[0] instanceof IFromContainer) || aObjects[0] == this.m_query.getTransformModel());
    }

    private class AppDefaultsListener
    implements PropertyChangeListener {
        private AppDefaultsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if (JoinDiagramTab.SHOW_DIAGRAM_TOOLBAR_KEY.equals(ev.getPropertyName())) {
                JoinDiagramTab.this.setDiagramToolBarVisible((Boolean)ev.getNewValue());
            }
        }
    }

    public class DiagramContext
    implements WsActionContextInterface {
        private Object[] m_aSelectedObjects;

        public DiagramContext(Object object) {
            if (object instanceof IAliasTable) {
                ITable table = ((IAliasTable)object).getAliasedTable();
                if (table != null) {
                    object = table;
                }
            } else if (object == JoinDiagramTab.this.m_query && JoinDiagramTab.this.m_query.getParentQuery() == JoinDiagramTab.this.m_query) {
                object = JoinDiagramTab.this.m_query.getTransformModel();
            }
            this.m_aSelectedObjects = new Object[]{object};
        }

        public Object[] getSelectedObjects() {
            return this.m_aSelectedObjects;
        }

        public String getType() {
            return "DiagramTab";
        }

        public void addContextMenuItems(JPopupMenu mnuPopup) {
            if (this.m_aSelectedObjects[0] instanceof IClause) {
                Action[] aActions = ActionFactory.getInstance().createClauseActions((IClause)this.m_aSelectedObjects[0], JoinDiagramTab.this.isEditable());
                ActionFactory.addActionsToPopupMenu(mnuPopup, aActions);
            }
        }
    }

    private class SelectionListener
    implements WsPFDSelectionListener {
        private SelectionListener() {
        }

        public void selectionChanged(WsPFDSelectionEvent ev) {
            JoinDiagramTab.this.selectionChanged();
        }
    }

    private class ShowTableColumnsAction
    extends WsAbstractToggleAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public ShowTableColumnsAction() {
            super(bundle, "JoinDiagramTab.ShowColumns", 1);
        }

        public void actionPerformed(ActionEvent ev) {
            JoinDiagramTab.this.m_mdlJoinDiagram.setShowColumns(this.isSelected());
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            Object[] objs = context.getSelectedObjects();
            return objs.length == 1 && objs[0] == JoinDiagramTab.this.getMainObject();
        }
    }

    private class DefaultNodeAction
    extends WsAbstractAction {
        private DefaultNodeAction() {
        }

        public void actionPerformed(ActionEvent event) {
            PFDPrimitive[] selectedPrimitives = JoinDiagramTab.this.getPFDComponent().getSelectionModel().getPrimitives();
            if (selectedPrimitives.length == 0) {
                return;
            }
            if (selectedPrimitives[0] instanceof IDiagramNode) {
                IDiagramNode node = (IDiagramNode)selectedPrimitives[0];
                JoinDiagramTab.this.fireNavigationEvent(node.getObject());
            } else if (selectedPrimitives[0] instanceof IDiagramStickyNote) {
                JoinDiagramTab.this.getDiagramPanel().openStickyNote();
            }
        }
    }
}

