/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql.editor;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.job.IBooleanExpression;
import com.sas.etl.models.job.IExpression;
import com.sas.etl.models.job.ITextExpression;
import com.sas.etl.models.job.ITextOperand;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.sql.ICaseStatement;
import com.sas.etl.models.job.transforms.sql.IClause;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.etl.models.job.transforms.sql.ISQLBooleanExpressionContainer;
import com.sas.etl.models.job.transforms.sql.ISQLTransform;
import com.sas.etl.models.job.transforms.sql.ISubquery;
import com.sas.etl.models.job.transforms.sql.impl.Subquery;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.MdException;
import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.transforms.sql.editor.INavigationListener;
import com.sas.wadmin.transforms.sql.editor.NavigationEvent;
import com.sas.wadmin.transforms.sql.editor.SQLExpressionActions;
import com.sas.wadmin.visuals.common.ModelUndoManager;
import com.sas.wadmin.visuals.common.TablesPaletteTreeModel;
import com.sas.workspace.DNDObject;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAUndoManager;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractPopulateOnDemandTableColumn;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsDefaultCellEditor;
import com.sas.workspace.WsDefaultTableCellRenderer;
import com.sas.workspace.WsDefaultTableRowModel;
import com.sas.workspace.WsDropMenuTableCellEditor;
import com.sas.workspace.WsEnumeratedTableColumn;
import com.sas.workspace.WsLimitedPlainDocument;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsTableRowModelEvent;
import com.sas.workspace.WsTableRowModelListener;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.WsUniqueNameTableColumn;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class ExpressionPanel
extends WAPropertyTab {
    private static final int SCROLL_PANE_WIDTH = 640;
    private static final int SCROLL_PANE_HEIGHT = 198;
    private static final int BooleanColumn = 0;
    private static final int LeftParenthesisColumn = 1;
    private static final int LeftOperandColumn = 2;
    private static final int OperatorColumn = 3;
    private static final int RightOperandColumn = 4;
    private static final int RightParenthesisColumn = 5;
    private static final int NameColumn = 6;
    private static final int DescriptionColumn = 7;
    private static final int ExpressionObjectColumn = 8;
    private static final String AND_KEYWORD = "AND";
    private static final String OR_KEYWORD = "OR";
    private static final String NOT_KEYWORD = "NOT";
    private static final String AND_NOT_KEYWORD = "AND NOT";
    private static final String OR_NOT_KEYWORD = "OR NOT";
    private static final String EQUALS_OPERATOR = "=";
    private static final String NOT_EQUALS_OPERATOR = "<>";
    private static final String IN_OPERATOR = "IN";
    private static final String NOT_IN_OPERATOR = "NOT IN";
    private static final String GREATER_THAN_OPERATOR = ">";
    private static final String GREATER_THAN_EQUALS_OPERATOR = ">=";
    private static final String LESS_THAN_OPERATOR = "<";
    private static final String LESS_THAN_EQUALS_OPERATOR = "<=";
    private static final String BETWEEN_OPERATOR = "BETWEEN";
    private static final String NOT_BETWEEN_OPERATOR = "NOT BETWEEN";
    private static final String EXISTS_OPERATOR = "EXISTS";
    private static final String NOT_EXISTS_OPERATOR = "NOT EXISTS";
    private static final String MISSING_OPERATOR = "IS MISSING";
    private static final String NOT_MISSING_OPERATOR = "NOT IS MISSING";
    private static final String NULL_OPERATOR = "IS NULL";
    private static final String NOT_NULL_OPERATOR = "IS NOT NULL";
    private static final String CONTAINS_OPERATOR = "CONTAINS";
    private static final String NOT_CONTAINS_OPERATOR = "NOT CONTAINS";
    private static final String LIKE_OPERATOR = "LIKE";
    private static final String NOT_LIKE_OPERATOR = "NOT LIKE";
    private static final String SOUNDS_LIKE_OPERATOR = "=*";
    private static final String NOT_SOUNDS_LIKE_OPERATOR = "NOT =*";
    private static final String NOT_IS_NULL_OPERATOR = "NOT IS NULL";
    private static WAdminResource bundle = WAdminResource.getBundle(ExpressionPanel.class);
    private WsTable m_expressionTable;
    private ExpressionTableModel m_expressionTableModel;
    private IModelListener m_expressionModelChangeListener;
    private TableSelectionListener m_expressionTableSelectionListener;
    private RowModelListener m_expressionTableRowModelListener;
    private SQLTextAreaListener m_sqlTextAreaListener;
    private List m_lSQLNavigateListeners;
    private List m_expressions;
    private ISQLBooleanExpressionContainer m_expressionModel;
    private JButton m_upButton;
    private JButton m_downButton;
    private JButton m_groupButton;
    private JButton m_newButton;
    private JSplitPane m_splitPane;
    private WsAbstractAction m_newAction;
    private WsAbstractAction m_deleteAction;
    private WsAbstractAction m_groupAction;
    private WsAbstractAction m_ungroupAction;
    private WsAbstractAction m_ungroupAllAction;
    private WsAbstractAction m_moveUpAction;
    private WsAbstractAction m_moveDownAction;
    private WsAbstractAction m_chooseColumnsAction;
    private WsAbstractAction m_caseAction;
    private WsAbstractAction m_subqueryAction;
    private WsAbstractAction m_advancedAction;
    private WsAbstractToggleAction m_displayFiltersAction;
    private WsAbstractToggleAction m_displayFilterNamesAction;
    private WsAbstractToggleAction m_displayFilterDescriptionsAction;
    private WATextArea m_sqlText;
    private boolean m_layoutComplete;
    private boolean m_bShowSubqueryAction = true;
    private boolean m_bDeleteInProgress;
    private String m_settingsPrefix;

    public ExpressionPanel() {
        this.m_expressions = new ArrayList();
        this.m_layoutComplete = false;
        this.m_settingsPrefix = "SQL.ExpressionPanel";
        this.setHelpProduct("wdb");
        this.setHelpTopic("sql_expression");
        this.initialize();
    }

    public ExpressionPanel(ISQLBooleanExpressionContainer expressionModel) {
        this.m_expressionModel = expressionModel;
        this.m_expressions = expressionModel.getBooleanExpressionsList();
        this.m_layoutComplete = false;
        this.m_bDeleteInProgress = false;
        this.m_settingsPrefix = "SQL.ExpressionPanel";
        this.setHelpProduct("wdb");
        this.setHelpTopic("sql_expression");
        this.initialize();
    }

    public ExpressionPanel(ISQLBooleanExpressionContainer expressionModel, boolean bShowSubqueryAction) {
        this.m_expressionModel = expressionModel;
        this.m_expressions = expressionModel.getBooleanExpressionsList();
        this.m_bShowSubqueryAction = bShowSubqueryAction;
        this.m_layoutComplete = false;
        this.m_bDeleteInProgress = false;
        this.m_settingsPrefix = "SQL.ExpressionPanel";
        this.setHelpProduct("wdb");
        this.setHelpTopic("sql_expression");
        this.initialize();
    }

    protected void initialize() {
        JButton newFilterButton;
        JButton groupButton;
        JButton downButton;
        JButton upButton;
        this.setName(bundle.getString("ExpressionPanel.Title.txt"));
        this.m_expressionTableModel = new ExpressionTableModel();
        this.m_expressionTable = new ExpressionTable(this.m_expressionTableModel);
        this.m_splitPane = new JSplitPane(0, true);
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        JScrollPane expressionTablePane = new JScrollPane((Component)this.m_expressionTable);
        expressionTablePane.setPreferredSize(new Dimension(640, 198));
        expressionTablePane.setVerticalScrollBarPolicy(22);
        expressionTablePane.setHorizontalScrollBarPolicy(30);
        this.m_expressionTable.setColumnHidingEnabled(false);
        this.m_expressionTable.setColumnHoldingEnabled(false);
        this.m_expressionTable.setColumnsReorderable(false);
        this.m_expressionTable.setSortingEnabled(false);
        this.m_expressionTable.setColumnHeaderVisible(true);
        this.m_expressionTable.setRowHeaderVisible(true);
        this.m_expressionTable.setRowHoldingEnabled(false);
        this.m_expressionTable.setViewportPopupMenuEnabled(false);
        this.m_expressionTable.setOriginPopupMenuEnabled(false);
        this.m_expressionTable.setCellSelectionEnabled(true);
        this.m_expressionTable.setColumnSelectionAllowed(false);
        this.m_expressionTable.setAutoResizeMode(1);
        this.m_expressionTable.setSelectionMode(2);
        this.m_expressionTable.setEditable(true);
        this.m_expressionTable.setToolTipText(bundle.getString("ExpressionPanel.ExpressionTable.ToolTip.txt"));
        this.m_expressionTable.setTablePopupMenuEnabled(true);
        this.m_expressionTable.setNonEditableCellBackground(UIManager.getColor("TextField.inactiveBackground"));
        this.m_expressionTable.setUndoManager((UndoManager)this.waum);
        this.m_expressionTable.hideColumn(6);
        this.m_expressionTable.hideColumn(7);
        this.m_expressionTable.hideColumn(8);
        this.m_expressionTableSelectionListener = new TableSelectionListener();
        this.m_expressionTable.getRowModel().getSelectionModel().addListSelectionListener(this.m_expressionTableSelectionListener);
        this.m_expressionTable.getSelectionModel().addListSelectionListener(this.m_expressionTableSelectionListener);
        this.m_expressionTableRowModelListener = new RowModelListener();
        ((WsDefaultTableRowModel)this.m_expressionTable.getRowModel()).addRowModelListener((WsTableRowModelListener)this.m_expressionTableRowModelListener);
        this.m_expressionTable.getColumnModel().getColumn(0).setMinWidth(50);
        WsDefaultCellEditor cellEditor = (WsDefaultCellEditor)this.m_expressionTable.getColumnModel().getColumn(1).getCellEditor();
        JTextComponent cellEditorComponent = (JTextComponent)cellEditor.getComponent();
        cellEditorComponent.setDocument((Document)((Object)new CharacterDocument('(')));
        cellEditor = (WsDefaultCellEditor)this.m_expressionTable.getColumnModel().getColumn(5).getCellEditor();
        cellEditorComponent = (JTextComponent)cellEditor.getComponent();
        cellEditorComponent.setDocument((Document)((Object)new CharacterDocument(')')));
        this.m_chooseColumnsAction = new ChooseColumnsAction();
        this.m_caseAction = new CASEAction();
        if (this.m_bShowSubqueryAction) {
            this.m_subqueryAction = new SubqueryAction();
        }
        this.m_advancedAction = new AdvancedAction();
        WsDropMenuTableCellEditor leftOperandMenuCellEditor = new WsDropMenuTableCellEditor();
        leftOperandMenuCellEditor.setMultiLineEdit(true);
        leftOperandMenuCellEditor.setDropMenu(this.createOperandMenu());
        this.m_expressionTable.getColumnModel().getColumn(2).setCellEditor((TableCellEditor)leftOperandMenuCellEditor);
        WsDropMenuTableCellEditor rightOperandMenuCellEditor = new WsDropMenuTableCellEditor();
        rightOperandMenuCellEditor.setMultiLineEdit(true);
        rightOperandMenuCellEditor.setDropMenu(this.createOperandMenu());
        this.m_expressionTable.getColumnModel().getColumn(4).setCellEditor((TableCellEditor)rightOperandMenuCellEditor);
        if (this.getSettingsPrefix() != null) {
            this.m_expressionTable.restoreSettings(this.getSettingsPrefix());
        }
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout(10, 10));
        this.m_moveUpAction = new MoveUpAction();
        this.m_upButton = upButton = new JButton((Action)this.m_moveUpAction);
        upButton.setPreferredSize(new Dimension(25, 25));
        this.m_moveDownAction = new MoveDownAction();
        this.m_downButton = downButton = new JButton((Action)this.m_moveDownAction);
        downButton.setPreferredSize(new Dimension(25, 25));
        this.m_groupAction = new GroupAction();
        this.m_groupButton = groupButton = new JButton((Action)this.m_groupAction);
        groupButton.setPreferredSize(new Dimension(25, 25));
        this.m_ungroupAction = new UngroupAction();
        JButton ungroupButton = new JButton((Action)this.m_ungroupAction);
        ungroupButton.setPreferredSize(new Dimension(25, 25));
        this.m_ungroupAllAction = new UngroupAllAction();
        JButton ungroupAllButton = new JButton((Action)this.m_ungroupAllAction);
        ungroupAllButton.setPreferredSize(new Dimension(25, 25));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BorderLayout(10, 0));
        JPanel leftButtonPanel = new JPanel();
        leftButtonPanel.setLayout((LayoutManager)new WsButtonsLayout(0, 2));
        JPanel middleButtonPanel = new JPanel();
        middleButtonPanel.setLayout((LayoutManager)new WsButtonsLayout(0, 0));
        JPanel rightButtonPanel = new JPanel();
        rightButtonPanel.setLayout((LayoutManager)new WsButtonsLayout(0, 4));
        leftButtonPanel.add(groupButton);
        leftButtonPanel.add(ungroupButton);
        leftButtonPanel.add(ungroupAllButton);
        middleButtonPanel.add(upButton);
        middleButtonPanel.add(downButton);
        this.m_newAction = new NewAction();
        this.m_newButton = newFilterButton = new JButton((Action)this.m_newAction);
        this.m_deleteAction = new DeleteAction();
        JButton deleteButton = new JButton((Action)this.m_deleteAction);
        this.m_expressionTable.setDeleteKeyAction((Action)this.m_deleteAction);
        rightButtonPanel.add(newFilterButton);
        rightButtonPanel.add(deleteButton);
        buttonPanel.add((Component)leftButtonPanel, "West");
        buttonPanel.add((Component)middleButtonPanel, "Center");
        buttonPanel.add((Component)rightButtonPanel, "East");
        JPanel sqlPanel = new JPanel(new BorderLayout(10, 10));
        sqlPanel.add((Component)new JLabel(bundle.getString("ExpressionPanel.SQL.Label.txt")), "North");
        this.m_sqlText = new WATextArea();
        this.m_sqlText.setWrapStyleWord(true);
        this.m_sqlText.setEditable(false);
        JScrollPane sqlScrollPane = new JScrollPane((Component)this.m_sqlText);
        sqlScrollPane.setPreferredSize(new Dimension(640, 50));
        sqlScrollPane.setVerticalScrollBarPolicy(22);
        this.m_sqlTextAreaListener = new SQLTextAreaListener();
        this.m_sqlText.addFocusListener((FocusListener)this.m_sqlTextAreaListener);
        sqlPanel.add((Component)sqlScrollPane, "Center");
        JPanel bottomPanel = new JPanel(new BorderLayout(10, 10));
        bottomPanel.add((Component)buttonPanel, "North");
        tablePanel.add((Component)expressionTablePane, "Center");
        tablePanel.add((Component)bottomPanel, "South");
        tablePanel.setBorder(border);
        sqlPanel.setBorder(border);
        this.m_splitPane.setTopComponent(tablePanel);
        this.m_splitPane.setBottomComponent(sqlPanel);
        this.setLayout(new BorderLayout(10, 10));
        this.add(this.m_splitPane, "Center");
        this.m_expressionModelChangeListener = new ExpressionModelChangeListener();
        this.m_expressionModel.getModel().addModelListener(this.m_expressionModelChangeListener);
        this.updateComponents();
    }

    protected JPopupMenu createOperandMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_chooseColumnsAction));
        menu.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_caseAction));
        if (this.m_bShowSubqueryAction) {
            menu.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_subqueryAction));
        }
        menu.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_advancedAction));
        return menu;
    }

    public void doLayout() {
        if (!this.m_layoutComplete) {
            WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
            this.m_splitPane.setDividerLocation(appDefaults.getPropertyInt("ExpressionPanel.TableHeight", 300));
            this.m_splitPane.setResizeWeight(0.5);
            this.m_layoutComplete = true;
        }
        super.doLayout();
    }

    public void fireNavigationEvent(NavigationEvent ev) {
        if (this.m_lSQLNavigateListeners == null) {
            return;
        }
        this.fireNavigationEventImpl(ev);
    }

    public void fireNavigationEvent(IObject modelObject) {
        this.fireNavigationEvent(new NavigationEvent((Object)this, modelObject));
    }

    private void fireNavigationEventImpl(NavigationEvent ev) {
        this.logNavigationEvent(ev);
        for (int iListener = 0; iListener < this.m_lSQLNavigateListeners.size(); ++iListener) {
            ((INavigationListener)this.m_lSQLNavigateListeners.get(iListener)).navigationChanged(ev);
        }
    }

    private void logNavigationEvent(NavigationEvent ev) {
        String sObject = ev.getModelObject() != null ? ev.getModelObject().toString() : "model";
        ModelLogger.getDefaultLogger().debug((Object)("NavigationEvent: for " + sObject));
    }

    public void addSQLNavigationListener(INavigationListener lsnr) {
        if (this.m_lSQLNavigateListeners == null) {
            this.m_lSQLNavigateListeners = new ArrayList();
        }
        this.m_lSQLNavigateListeners.add(lsnr);
    }

    public void removeSQLNavigationListener(INavigationListener lsnr) {
        if (this.m_lSQLNavigateListeners != null) {
            this.m_lSQLNavigateListeners.remove(lsnr);
        }
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.updateComponents();
        this.m_expressions = this.m_expressionModel.getBooleanExpressionsList();
        this.m_expressionTableModel.moveDataToModel();
        if (this.m_expressionTable.getRowCount() > 0) {
            this.m_expressionTable.selectRow(0);
        }
        this.updateActions();
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (this.m_expressionModel.isUsingUserWrittenCode()) {
            this.m_expressionModel.setUserWrittenExpression(this.m_sqlText.getText());
        }
        this.m_expressionTableModel.moveDataToStore();
    }

    public boolean validateData() {
        this.m_expressionTable.stopCellEditing();
        return true;
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.updateComponents();
        this.updateActions();
    }

    public IBooleanExpression getExpression(int row) {
        List expressions = this.m_expressionModel.getBooleanExpressionsList();
        return (IBooleanExpression)expressions.get(row);
    }

    public boolean isCaseOrSubquerySelected() {
        IExpression operand;
        int column;
        int row;
        int[][] selectedCells = this.m_expressionTable.getSelectedCells();
        if (selectedCells != null && selectedCells.length > 1) {
            return false;
        }
        if (selectedCells != null && selectedCells.length == 1) {
            row = selectedCells[0][0];
            column = selectedCells[0][1];
        } else {
            row = this.m_expressionTable.getCurrentRow();
            column = this.m_expressionTable.getCurrentColumn();
        }
        if (column != 2 && column != 4) {
            return false;
        }
        List expressions = this.m_expressionModel.getBooleanExpressionsList();
        IBooleanExpression expression = (IBooleanExpression)expressions.get(row);
        if (column == 2) {
            operand = expression.getLeftOperand();
        } else if (column == 4) {
            operand = expression.getRightOperand();
        } else {
            return false;
        }
        return operand instanceof Subquery;
    }

    public boolean isGroupSelected() {
        int[] selectedRows = this.m_expressionTable.getSelectedRowsFromSelectedCells();
        if ((selectedRows = this.checkSelection(selectedRows)) == null || selectedRows.length == 0) {
            return false;
        }
        String leftParens = (String)this.m_expressionTableModel.getValueAt(selectedRows[0], 1);
        if (leftParens == null || leftParens.length() == 0) {
            return false;
        }
        String rightParens = (String)this.m_expressionTableModel.getValueAt(selectedRows[selectedRows.length - 1], 5);
        return rightParens != null && rightParens.length() != 0;
    }

    public boolean hasGroups() {
        for (int index = 0; index < this.m_expressionTableModel.getRowCount(); ++index) {
            String leftParens = (String)this.m_expressionTableModel.getValueAt(index, 1);
            if (leftParens.length() > 0) {
                return true;
            }
            String rightParens = (String)this.m_expressionTableModel.getValueAt(index, 5);
            if (rightParens.length() <= 0) continue;
            return true;
        }
        return false;
    }

    private ISQLTransform getSQLTransform() {
        IQuery query = this.m_expressionModel.getParentQuery();
        if (query != null) {
            ISQLTransform sql = query.getTransformModel();
            return sql;
        }
        return null;
    }

    private boolean isSQLTransformUW() {
        ISQLTransform sql = this.getSQLTransform();
        if (sql != null) {
            return sql.isUsingUserWrittenCode();
        }
        return false;
    }

    protected void updateActions() {
        int[] selectedRows = this.m_expressionTable.getSelectedRowsFromSelectedCells();
        boolean firstRowSelected = false;
        boolean lastRowSelected = false;
        boolean rowsReorderable = this.m_expressionTable.isRowsReorderable();
        selectedRows = this.checkSelection(selectedRows);
        for (int index = 0; index < selectedRows.length; ++index) {
            if (selectedRows[index] == 0) {
                firstRowSelected = true;
            }
            if (selectedRows[index] != this.m_expressionTable.getRowCount() - 1) continue;
            lastRowSelected = true;
        }
        boolean actionEnabled = this.isEditable() && !this.m_expressionModel.isUsingUserWrittenCode() && !this.isSQLTransformUW();
        this.m_newAction.setEnabled(actionEnabled);
        this.m_deleteAction.setEnabled(actionEnabled && selectedRows.length > 0 || this.m_bDeleteInProgress);
        this.m_groupAction.setEnabled(actionEnabled && selectedRows.length > 0);
        this.m_ungroupAction.setEnabled(actionEnabled && this.isGroupSelected());
        this.m_ungroupAllAction.setEnabled(actionEnabled && this.hasGroups());
        this.m_moveUpAction.setEnabled(actionEnabled && selectedRows.length > 0 && !firstRowSelected && rowsReorderable);
        this.m_moveDownAction.setEnabled(actionEnabled && selectedRows.length > 0 && !lastRowSelected && rowsReorderable);
    }

    private int[] checkSelection(int[] aOldSelection) {
        if (aOldSelection == null || aOldSelection.length == 0) {
            return aOldSelection;
        }
        int iTotalExpressions = this.m_expressions.size();
        int iCount = 0;
        for (int iSelection = 0; iSelection < aOldSelection.length; ++iSelection) {
            if (aOldSelection[iSelection] >= iTotalExpressions) continue;
            ++iCount;
        }
        int[] aSelection = new int[iCount];
        int iIndex = 0;
        for (int iSelection = 0; iSelection < aOldSelection.length; ++iSelection) {
            if (aOldSelection[iSelection] >= iTotalExpressions) continue;
            aSelection[iIndex++] = aOldSelection[iSelection];
        }
        return aSelection;
    }

    private void updateComponents() {
        boolean enable = this.isEditable() && !this.m_expressionModel.isUsingUserWrittenCode();
        this.m_expressionTable.setEnabled(enable);
        if (this.m_expressionModel != null) {
            try {
                this.m_sqlText.setText(this.m_expressionModel.getText(null, this.m_expressionModel.isQuotingNeeded(), this.m_expressionModel.isPassThru()));
            }
            catch (RemoteException e1) {
                Workspace.handleRemoteException((RemoteException)e1);
            }
            catch (CodegenException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
            }
            catch (MdException e1) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e1, (String)"Accessing");
            }
            catch (BadServerDefinitionException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
            }
            catch (BadLibraryDefinitionException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
            }
            catch (ServerException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
            }
            this.m_sqlText.setEditable(this.m_expressionModel.isUsingUserWrittenCode() && this.isEditable());
        }
    }

    public void updateWorkspaceUIComponents(boolean active) {
        super.updateWorkspaceUIComponents(active);
        this.m_newAction.setActive(active);
        this.m_deleteAction.setActive(active);
    }

    public void setInitialSelection() {
        if (this.m_expressionTable.getRowCount() > 0) {
            this.m_expressionTable.selectRow(0);
        }
    }

    public void setWAUndoManager(WAUndoManager undoManager) {
        super.setWAUndoManager(undoManager);
        this.m_expressionTable.setUndoManager((UndoManager)undoManager);
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_expressionTable.saveSettings(this.getSettingsPrefix());
        WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        appDefaults.setPropertyInt("ExpressionPanel.TableHeight", this.m_splitPane.getDividerLocation());
        appDefaults.setPropertyBoolean(this.getSettingsPrefix() + ".InitialLayout", false);
        this.m_expressionTable.getRowModel().getSelectionModel().removeListSelectionListener(this.m_expressionTableSelectionListener);
        this.m_expressionTable.getSelectionModel().removeListSelectionListener(this.m_expressionTableSelectionListener);
        ((WsDefaultTableRowModel)this.m_expressionTable.getRowModel()).removeRowModelListener((WsTableRowModelListener)this.m_expressionTableRowModelListener);
        this.m_expressionModel.getModel().removeModelListener(this.m_expressionModelChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewExpression() {
        if (!this.m_expressionTable.stopCellEditing()) {
            return;
        }
        this.m_expressionModel.getModel().startCompoundUndoable();
        try {
            int tableRow = this.m_expressionTable.getLastSelectedRow();
            int modelRow = tableRow == -1 ? this.m_expressionModel.size() - 1 : this.m_expressionModel.indexOfExpression(this.m_expressionTableModel.getExpression(tableRow));
            IBooleanExpression expression = this.m_expressionModel.createNewBooleanExpression();
            expression.setName(this.m_expressionTableModel.createUniqueNameForNewExpression());
            this.m_expressionModel.addBooleanExpression(modelRow + 1, expression);
            this.m_expressionTable.selectRow(tableRow + 1);
            this.m_expressionModel.getModel().undoableEditHappened((UndoableEdit)new SelectExpressionsUndoable(expression, false, true));
            int editColumn = Math.max(this.m_expressionTable.convertColumnIndexToView(this.m_expressionTableModel.getDefaultEditColumnIndex()), 0);
            this.m_expressionTable.editCellAt(tableRow + 1, editColumn);
        }
        finally {
            this.m_expressionModel.getModel().endCompoundUndoable();
        }
    }

    private String getTextFromOperand(IExpression operand) {
        String sExpression = "";
        if (operand instanceof ITextOperand) {
            ITextExpression exp = ((ITextOperand)operand).getTextExpression();
            exp.setUseSQLSyntax(true);
            try {
                sExpression = exp.getText(null, this.m_expressionModel.isQuotingNeeded(), this.m_expressionModel.isPassThru());
            }
            catch (RemoteException e1) {
                Workspace.handleRemoteException((RemoteException)e1);
            }
            catch (CodegenException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
            }
            catch (MdException e1) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e1, (String)"Accessing");
            }
            catch (BadServerDefinitionException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
            }
            catch (BadLibraryDefinitionException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
            }
            catch (ServerException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
            }
        }
        return sExpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveExpression(int oldIndex, int newIndex) {
        if (oldIndex == newIndex) {
            return;
        }
        String oldBooleanKeywords = (String)this.m_expressionTable.getValueAt(oldIndex, 0);
        String newBooleanKeywords = (String)this.m_expressionTable.getValueAt(newIndex, 0);
        oldBooleanKeywords = oldBooleanKeywords.toUpperCase();
        newBooleanKeywords = newBooleanKeywords.toUpperCase();
        this.m_expressionModel.getModel().startCompoundUndoable();
        try {
            IBooleanExpression expression = this.getExpression(oldIndex);
            this.m_expressionModel.removeBooleanExpression(expression);
            this.m_expressionModel.addBooleanExpression(newIndex, expression);
            if (oldBooleanKeywords.indexOf(NOT_KEYWORD) > -1) {
                if (newBooleanKeywords.indexOf(AND_KEYWORD) > -1) {
                    this.m_expressionTableModel.setValueAt(AND_NOT_KEYWORD, newIndex, 0);
                } else if (newBooleanKeywords.indexOf(OR_KEYWORD) > -1) {
                    this.m_expressionTableModel.setValueAt(OR_NOT_KEYWORD, newIndex, 0);
                } else {
                    this.m_expressionTableModel.setValueAt(NOT_KEYWORD, newIndex, 0);
                }
            } else if (newBooleanKeywords.indexOf(AND_KEYWORD) > -1) {
                this.m_expressionTableModel.setValueAt(AND_KEYWORD, newIndex, 0);
            } else if (newBooleanKeywords.indexOf(OR_KEYWORD) > -1) {
                this.m_expressionTableModel.setValueAt(OR_KEYWORD, newIndex, 0);
            } else {
                this.m_expressionTableModel.setValueAt("", newIndex, 0);
            }
            if (newBooleanKeywords.indexOf(NOT_KEYWORD) > -1) {
                if (oldBooleanKeywords.indexOf(AND_KEYWORD) > -1) {
                    this.m_expressionTableModel.setValueAt(AND_NOT_KEYWORD, oldIndex, 0);
                } else if (oldBooleanKeywords.indexOf(OR_KEYWORD) > -1) {
                    this.m_expressionTableModel.setValueAt(OR_NOT_KEYWORD, oldIndex, 0);
                } else {
                    this.m_expressionTableModel.setValueAt(NOT_KEYWORD, oldIndex, 0);
                }
            } else if (oldBooleanKeywords.indexOf(AND_KEYWORD) > -1) {
                this.m_expressionTableModel.setValueAt(AND_KEYWORD, oldIndex, 0);
            } else if (oldBooleanKeywords.indexOf(OR_KEYWORD) > -1) {
                this.m_expressionTableModel.setValueAt(OR_KEYWORD, oldIndex, 0);
            } else {
                this.m_expressionTableModel.setValueAt("", oldIndex, 0);
            }
        }
        finally {
            this.m_expressionModel.getModel().endCompoundUndoable();
        }
    }

    private void selectExpressions(IBooleanExpression[] expressions) {
        this.m_expressionTable.clearSelection();
        for (int expressionIndex = 0; expressionIndex < expressions.length; ++expressionIndex) {
            int rowIndex = this.m_expressionTableModel.getExpressionIndex(expressions[expressionIndex]);
            if (rowIndex == -1) continue;
            this.m_expressionTable.addRowToSelection(this.m_expressionTable.convertRowIndexToView(rowIndex));
        }
    }

    protected JButton createBlankButton() {
        JButton blankButton = new JButton("");
        blankButton.setBorder(null);
        blankButton.setPreferredSize(new Dimension(25, 25));
        return blankButton;
    }

    protected void displayComponentInfo() {
        for (int i = 0; i < this.m_expressionTable.getColumnModel().getColumnCount(); ++i) {
            System.out.println("Column " + i + " width is: " + this.m_expressionTable.getColumnModel().getColumn(i).getWidth());
        }
        System.out.println("Table height: " + this.m_expressionTable.getHeight());
        System.out.println("Table viewport height: " + this.m_expressionTable.getScrollPane().getViewport().getHeight());
        System.out.println("New button height: " + this.m_newButton.getHeight());
        System.out.println("Up button height: " + this.m_upButton.getHeight());
        System.out.println("Down button height: " + this.m_downButton.getHeight());
        System.out.println("Group button height: " + this.m_groupButton.getHeight());
        System.out.println("Splitter location: " + this.m_splitPane.getDividerLocation());
    }

    public void displayTableModelInfo() {
        int tableSize = this.m_expressionTable.getRowCount();
        int modelSize = this.m_expressionTableModel.getRowCount();
        int expressionModelSize = this.m_expressionModel.getBooleanExpressionsList().size();
        System.out.println("table size = " + tableSize);
        System.out.println("model size = " + modelSize);
        System.out.println("expression table model size = " + expressionModelSize);
        int maxSize = tableSize;
        if (modelSize > maxSize) {
            maxSize = modelSize;
        }
        if (expressionModelSize > maxSize) {
            maxSize = expressionModelSize;
        }
        List expressions = this.m_expressionModel.getBooleanExpressionsList();
        for (int index = 0; index < maxSize; ++index) {
            if (index < tableSize) {
                System.out.println("Table           [" + index + "] = " + this.m_expressionTable.getValueAt(index, 0) + "|" + this.m_expressionTable.getValueAt(index, 1) + "|" + this.m_expressionTable.getValueAt(index, 2) + "|" + this.m_expressionTable.getValueAt(index, 3) + "|" + this.m_expressionTable.getValueAt(index, 4) + "|" + this.m_expressionTable.getValueAt(index, 5));
            }
            if (index < modelSize) {
                System.out.println("Model           [" + index + "] = " + this.m_expressionTableModel.getValueAt(index, 0) + "|" + this.m_expressionTableModel.getValueAt(index, 1) + "|" + this.m_expressionTableModel.getValueAt(index, 2) + "|" + this.m_expressionTableModel.getValueAt(index, 3) + "|" + this.m_expressionTableModel.getValueAt(index, 4) + "|" + this.m_expressionTableModel.getValueAt(index, 5) + "|" + this.m_expressionTableModel.getValueAt(index, 6) + "|" + this.m_expressionTableModel.getValueAt(index, 7));
            }
            IBooleanExpression expression = (IBooleanExpression)expressions.get(index);
            if (index >= expressionModelSize) continue;
            System.out.println("Expression Model[" + index + "] = " + expression.getLogicalOperator() + "|" + ExpressionPanel.makeParentheses("(", expression.getOpenParenthesisCount()) + "|" + this.getTextFromOperand(expression.getLeftOperand()) + "|" + expression.getOperator() + "|" + this.getTextFromOperand(expression.getRightOperand()) + "|" + ExpressionPanel.makeParentheses(")", expression.getClosedParenthesisCount()) + "|" + expression.getName() + "|" + expression.getDescription());
        }
    }

    public String getSettingsPrefix() {
        return this.m_settingsPrefix;
    }

    public void setSettingsPrefix(String prefix) {
        this.m_settingsPrefix = prefix;
    }

    public static List expressionAsList(IBooleanExpression expression) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(expression.getLogicalOperator().toUpperCase());
        values.add(ExpressionPanel.makeParentheses("(", expression.getOpenParenthesisCount()));
        values.add((String)expression.getLeftOperand());
        values.add(expression.getOperator().toString());
        values.add((String)expression.getRightOperand());
        values.add(ExpressionPanel.makeParentheses(")", expression.getClosedParenthesisCount()));
        values.add(expression.getName());
        values.add(expression.getDescription());
        values.add((String)expression);
        return values;
    }

    public static String makeParentheses(String parenthesis, int count) {
        StringBuffer parentheses = new StringBuffer("");
        for (int parenIndex = 0; parenIndex < count; ++parenIndex) {
            parentheses.append(parenthesis);
        }
        return parentheses.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleCaseAction() {
        ICaseStatement caseStatement;
        IExpression operand;
        boolean newCase = true;
        int row = this.m_expressionTable.getCurrentRow();
        int column = this.m_expressionTable.getCurrentColumn();
        this.m_expressionTable.stopCellEditing();
        IBooleanExpression expression = (IBooleanExpression)this.m_expressionModel.getBooleanExpressionsList().get(row);
        if (column == 2) {
            operand = expression.getLeftOperand();
        } else {
            if (column != 4) return;
            operand = expression.getRightOperand();
        }
        if (operand == null || !(operand instanceof ICaseStatement)) {
            caseStatement = expression.getModel().getObjectFactory().createNewSQLCaseStatement(expression.getID(), this.m_expressionModel.getParentQuery());
        } else {
            caseStatement = (ICaseStatement)operand;
            newCase = false;
        }
        ModelUndoManager mgrUndo = new ModelUndoManager();
        boolean bOK = SQLExpressionActions.showCaseDialog(caseStatement, (IClause)this.m_expressionModel, (UndoManager)((Object)mgrUndo));
        ((UndoManager)((Object)mgrUndo)).end();
        if (bOK) {
            IModel mdl = caseStatement.getModel();
            mdl.startCompoundUndoable();
            try {
                mdl.undoableEditHappened((UndoableEdit)((Object)mgrUndo));
                if (!newCase) return;
                if (column == 4) {
                    expression.setRightOperand((IExpression)caseStatement);
                    return;
                }
                expression.setLeftOperand((IExpression)caseStatement);
                return;
            }
            finally {
                mdl.endCompoundUndoable();
            }
        } else if (newCase) {
            caseStatement.dispose();
            return;
        } else {
            ((UndoManager)((Object)mgrUndo)).undo();
        }
    }

    private class SelectExpressionsUndoable
    extends AbstractUndoableEdit {
        private IBooleanExpression[] m_undoExpressions;
        private boolean m_onUndo;
        private boolean m_onRedo;

        public SelectExpressionsUndoable(IBooleanExpression expression, boolean onUndo, boolean onRedo) {
            this(new IBooleanExpression[]{expression}, onUndo, onRedo);
        }

        public SelectExpressionsUndoable(IBooleanExpression[] expressions, boolean onUndo, boolean onRedo) {
            this.m_undoExpressions = expressions;
            this.m_onUndo = onUndo;
            this.m_onRedo = onRedo;
        }

        @Override
        public void undo() {
            super.undo();
            if (this.m_onUndo) {
                ExpressionPanel.this.selectExpressions(this.m_undoExpressions);
            }
        }

        @Override
        public void redo() {
            super.redo();
            if (this.m_onRedo) {
                ExpressionPanel.this.selectExpressions(this.m_undoExpressions);
            }
        }

        @Override
        public void die() {
            super.die();
            Arrays.fill(this.m_undoExpressions, null);
            ExpressionPanel.this.m_expressions = null;
        }
    }

    protected class SQLTextAreaListener
    implements FocusListener {
        protected SQLTextAreaListener() {
        }

        @Override
        public void focusGained(FocusEvent event) {
        }

        @Override
        public void focusLost(FocusEvent event) {
            if (ExpressionPanel.this.m_expressionModel.isUsingUserWrittenCode()) {
                ExpressionPanel.this.m_expressionModel.setUserWrittenExpression(ExpressionPanel.this.m_sqlText.getText());
            }
        }
    }

    protected class UngroupAllUndoable
    extends AbstractUndoableEdit {
        private String[] m_leftParens;
        private String[] m_rightParens;

        public UngroupAllUndoable() {
            this.m_leftParens = new String[ExpressionPanel.this.m_expressionTableModel.getRowCount()];
            this.m_rightParens = new String[ExpressionPanel.this.m_expressionTableModel.getRowCount()];
            for (int index = 0; index < ExpressionPanel.this.m_expressionTableModel.getRowCount(); ++index) {
                this.m_leftParens[index] = (String)ExpressionPanel.this.m_expressionTableModel.getValueAt(index, 1);
                this.m_rightParens[index] = (String)ExpressionPanel.this.m_expressionTableModel.getValueAt(index, 5);
            }
        }

        @Override
        public void undo() {
            ExpressionPanel.this.m_expressionTable.stopCellEditing();
            ExpressionPanel.this.m_expressionTable.clearSelection();
            super.undo();
            for (int index = 0; index < ExpressionPanel.this.m_expressionTableModel.getRowCount(); ++index) {
                ExpressionPanel.this.m_expressionTableModel.setValueAt(this.m_leftParens[index], index, 1);
                if (this.m_leftParens[index] != null && this.m_leftParens[index].length() > 0) {
                    ExpressionPanel.this.m_expressionTable.addCellToSelection(index, 1);
                }
                ExpressionPanel.this.m_expressionTableModel.setValueAt(this.m_rightParens[index], index, 5);
                if (this.m_rightParens[index] == null || this.m_rightParens[index].length() <= 0) continue;
                ExpressionPanel.this.m_expressionTable.addCellToSelection(index, 5);
            }
        }

        @Override
        public void redo() {
            ExpressionPanel.this.m_expressionTable.stopCellEditing();
            super.redo();
            List changedCells = ExpressionPanel.this.m_expressionTableModel.ungroupAll();
            if (changedCells == null) {
                return;
            }
            ExpressionPanel.this.m_expressionTable.clearSelection();
            for (int index = 0; index < changedCells.size(); ++index) {
                List cellPosition = (List)changedCells.get(index);
                Integer row = (Integer)cellPosition.get(0);
                Integer column = (Integer)cellPosition.get(1);
                ExpressionPanel.this.m_expressionTable.addCellToSelection(row.intValue(), column.intValue());
            }
        }
    }

    protected class UngroupUndoable
    extends AbstractUndoableEdit {
        private int m_firstRow;
        private int m_lastRow;

        public UngroupUndoable(int firstRow, int lastRow) {
            this.m_firstRow = firstRow;
            this.m_lastRow = lastRow;
        }

        @Override
        public void undo() {
            ExpressionPanel.this.m_expressionTable.stopCellEditing();
            super.undo();
            ExpressionPanel.this.m_expressionTableModel.groupExpression(this.m_firstRow, this.m_lastRow);
            ExpressionPanel.this.m_expressionTable.selectCell(this.m_firstRow, 1);
            ExpressionPanel.this.m_expressionTable.addCellToSelection(this.m_lastRow, 5);
        }

        @Override
        public void redo() {
            ExpressionPanel.this.m_expressionTable.stopCellEditing();
            super.redo();
            ExpressionPanel.this.m_expressionTableModel.ungroupExpression(this.m_firstRow, this.m_lastRow);
            ExpressionPanel.this.m_expressionTable.selectCell(this.m_firstRow, 1);
            ExpressionPanel.this.m_expressionTable.addCellToSelection(this.m_lastRow, 5);
        }
    }

    protected class GroupUndoable
    extends AbstractUndoableEdit {
        private int m_firstRow;
        private int m_lastRow;

        public GroupUndoable(int firstRow, int lastRow) {
            this.m_firstRow = firstRow;
            this.m_lastRow = lastRow;
        }

        @Override
        public void undo() {
            ExpressionPanel.this.m_expressionTable.stopCellEditing();
            super.undo();
            ExpressionPanel.this.m_expressionTableModel.ungroupExpression(this.m_firstRow, this.m_lastRow);
            ExpressionPanel.this.m_expressionTable.selectCell(this.m_firstRow, 1);
            ExpressionPanel.this.m_expressionTable.addCellToSelection(this.m_lastRow, 5);
        }

        @Override
        public void redo() {
            ExpressionPanel.this.m_expressionTable.stopCellEditing();
            super.redo();
            ExpressionPanel.this.m_expressionTableModel.groupExpression(this.m_firstRow, this.m_lastRow);
            ExpressionPanel.this.m_expressionTable.selectCell(this.m_firstRow, 1);
            ExpressionPanel.this.m_expressionTable.addCellToSelection(this.m_lastRow, 5);
        }
    }

    protected class cDropTargetListener
    implements DropTargetListener {
        protected cDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            e.acceptDrag(0);
        }

        @Override
        public void dragExit(DropTargetEvent e) {
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            Point ptDrop = e.getLocation();
            Component c = ExpressionPanel.this.m_expressionTable.getComponentAt(e.getLocation());
            int rowAtPoint = ((WsTable)c).rowAtPoint(ptDrop);
            int colAtPoint = ((WsTable)c).columnAtPoint(ptDrop);
            List l = this.getDraggedObjects(e.getCurrentDataFlavors());
            if (l != null && this.isValidDrop(l, rowAtPoint, colAtPoint)) {
                e.acceptDrag(e.getDropAction());
            } else {
                e.rejectDrag();
            }
            ExpressionPanel.this.m_expressionTable.stopCellEditing();
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            block6: {
                Point ptDrop = e.getLocation();
                Component c = ExpressionPanel.this.m_expressionTable.getComponentAt(e.getLocation());
                int rowAtPoint = ((WsTable)c).rowAtPoint(ptDrop);
                int colAtPoint = ((WsTable)c).columnAtPoint(ptDrop);
                List lObjects = this.getDraggedObjects(e.getCurrentDataFlavors());
                if (lObjects != null && this.isValidDrop(lObjects, rowAtPoint, colAtPoint)) {
                    try {
                        Transferable t = e.getTransferable();
                        if (t.isDataFlavorSupported(DNDObject.dndObjectDataFlavor)) {
                            e.acceptDrop(e.getDropAction());
                            Vector dndObj = (Vector)t.getTransferData(DNDObject.dndObjectDataFlavor);
                            ExpressionPanel.this.m_expressionTableModel.replaceOperand(dndObj, rowAtPoint, colAtPoint);
                            e.getDropTargetContext().dropComplete(true);
                            ExpressionPanel.this.m_expressionTableModel.fireTableCellUpdated(rowAtPoint, colAtPoint);
                            break block6;
                        }
                        e.rejectDrop();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                    catch (UnsupportedFlavorException ufe) {
                        ufe.printStackTrace();
                    }
                } else {
                    e.rejectDrop();
                }
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
        }

        public boolean isValidDrop(List lObjects, int row, int col) {
            if (row < 0) {
                return false;
            }
            if (col != 2 && col != 4) {
                return false;
            }
            if (lObjects.size() == 0) {
                return false;
            }
            for (int i = 0; i < lObjects.size(); ++i) {
                if (lObjects.get(i) instanceof IColumn) continue;
                return false;
            }
            return true;
        }

        protected List getDraggedObjects(DataFlavor[] flavors) {
            for (int iFlavor = 0; iFlavor < flavors.length; ++iFlavor) {
                if (!(flavors[iFlavor] instanceof DNDObject.DNDObjectFlavor)) continue;
                DNDObject object = ((DNDObject.DNDObjectFlavor)flavors[iFlavor]).getData();
                return object.getObjects();
            }
            return null;
        }
    }

    private class RowModelListener
    implements WsTableRowModelListener {
        private RowModelListener() {
        }

        public void rowDragged(TableRowModelEvent ev) {
            WsDefaultTableRowModel mdlRows = (WsDefaultTableRowModel)ExpressionPanel.this.m_expressionTable.getRowModel();
            mdlRows.clearRowMoves();
            if (!ExpressionPanel.this.m_expressionTable.stopCellEditing()) {
                return;
            }
            ExpressionPanel.this.moveExpression(ev.getFromIndex(), ev.getToIndex());
        }

        public void rowsRemapped(ChangeEvent ev) {
            ExpressionPanel.this.updateActions();
        }

        public void rowsHidden(WsTableRowModelEvent ev) {
        }

        public void rowsShown(WsTableRowModelEvent ev) {
        }
    }

    protected class AdvancedAction
    extends WsAbstractAction {
        public AdvancedAction() {
            super(bundle, "ExpressionPanel.Advanced", 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            IBooleanExpression expression;
            String oldExpression = null;
            int row = ExpressionPanel.this.m_expressionTable.getCurrentRow();
            int column = ExpressionPanel.this.m_expressionTable.getCurrentColumn();
            ExpressionPanel.this.m_expressionTable.stopCellEditing();
            if (column == 2) {
                expression = ExpressionPanel.this.getExpression(row);
                oldExpression = ExpressionPanel.this.getTextFromOperand(expression.getLeftOperand());
            } else if (column == 4) {
                expression = ExpressionPanel.this.getExpression(row);
                oldExpression = ExpressionPanel.this.getTextFromOperand(expression.getRightOperand());
            } else {
                Object value = ExpressionPanel.this.m_expressionTableModel.getValueAt(row, column);
                if (value != null && value instanceof String) {
                    oldExpression = (String)value;
                }
            }
            String newExpression = SQLExpressionActions.showExpressionBuilder((IClause)ExpressionPanel.this.m_expressionModel, oldExpression);
            if (newExpression != null) {
                ExpressionPanel.this.m_expressionModel.getModel().startCompoundUndoable();
                try {
                    ExpressionPanel.this.m_expressionTable.undoableSetValueAt((Object)newExpression, row, column);
                }
                finally {
                    ExpressionPanel.this.m_expressionModel.getModel().endCompoundUndoable();
                }
            }
        }
    }

    protected class SubqueryAction
    extends WsAbstractAction {
        public SubqueryAction() {
            super(bundle, "ExpressionPanel.Subquery", 0);
        }

        public void actionPerformed(ActionEvent e) {
            int row = ExpressionPanel.this.m_expressionTable.getCurrentRow();
            int column = ExpressionPanel.this.m_expressionTable.getCurrentColumn();
            ISubquery subquery = null;
            ExpressionPanel.this.m_expressionTable.stopCellEditing();
            List expressions = ExpressionPanel.this.m_expressionModel.getBooleanExpressionsList();
            IBooleanExpression expression = (IBooleanExpression)expressions.get(row);
            IExpression object = null;
            if (column == 2) {
                object = expression.getLeftOperand();
            } else if (column == 4) {
                object = expression.getRightOperand();
            }
            if (object instanceof ISubquery) {
                subquery = (ISubquery)object;
            }
            if (subquery == null) {
                subquery = ExpressionPanel.this.m_expressionModel.createNewSubquery();
                if (column == 2) {
                    ExpressionPanel.this.m_expressionTable.undoableSetValueAt((Object)subquery, row, column);
                    expression.setLeftOperand((IExpression)subquery);
                } else if (column == 4) {
                    ExpressionPanel.this.m_expressionTable.undoableSetValueAt((Object)subquery, row, column);
                    expression.setRightOperand((IExpression)subquery);
                }
            }
            ExpressionPanel.this.fireNavigationEvent((IObject)subquery);
        }
    }

    protected class CASEAction
    extends WsAbstractAction {
        public CASEAction() {
            super(bundle, "ExpressionPanel.Case", 0);
        }

        public void actionPerformed(ActionEvent e) {
            ExpressionPanel.this.handleCaseAction();
        }
    }

    protected class ChooseColumnsAction
    extends WsAbstractAction {
        public ChooseColumnsAction() {
            super(bundle, "ExpressionPanel.ChooseColumns", 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            TablesPaletteTreeModel mdlTableView = new TablesPaletteTreeModel(ExpressionPanel.this.m_expressionModel.getParentQuery().getSourcesInFrom(), new ITable[]{ExpressionPanel.this.m_expressionModel.getParentQuery().getTargetTable()});
            String newText = SQLExpressionActions.showChooseColumnsDialog(mdlTableView);
            if (newText != null) {
                int currentRow = ExpressionPanel.this.m_expressionTable.getCurrentRow();
                int currentColumn = ExpressionPanel.this.m_expressionTable.getCurrentColumn();
                WsDefaultCellEditor cellEditor = (WsDefaultCellEditor)ExpressionPanel.this.m_expressionTable.getCellEditor(currentRow, currentColumn);
                JComponent cellEditorComponent = cellEditor.getComponent();
                if (cellEditorComponent instanceof JTextComponent) {
                    ExpressionPanel.this.m_expressionModel.getModel().startCompoundUndoable();
                    try {
                        String newFullText = SQLExpressionActions.modifyOperand((JTextComponent)cellEditorComponent, newText);
                        ExpressionPanel.this.m_expressionTableModel.setValueAt(newFullText, currentRow, currentColumn);
                        ExpressionPanel.this.m_expressionTable.stopCellEditing();
                    }
                    finally {
                        ExpressionPanel.this.m_expressionModel.getModel().endCompoundUndoable();
                    }
                }
            }
        }
    }

    protected class UngroupAllAction
    extends WsAbstractAction {
        public UngroupAllAction() {
            super(bundle, "ExpressionPanel.UngroupAll", 18);
        }

        public void actionPerformed(ActionEvent e) {
            ExpressionPanel.this.m_expressionTable.stopCellEditing();
            ExpressionPanel.this.m_expressionModel.getModel().startCompoundUndoable();
            try {
                if (ExpressionPanel.this.getWAUndoManager() != null) {
                    ExpressionPanel.this.getWAUndoManager().addEdit((UndoableEdit)new UngroupAllUndoable());
                }
                ExpressionPanel.this.m_expressionTableModel.ungroupAll();
            }
            finally {
                ExpressionPanel.this.m_expressionModel.getModel().endCompoundUndoable();
            }
        }
    }

    protected class UngroupAction
    extends WsAbstractAction {
        public UngroupAction() {
            super(bundle, "ExpressionPanel.Ungroup", 18);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            ExpressionPanel.this.m_expressionTable.stopCellEditing();
            int[] selectedRows = ExpressionPanel.this.m_expressionTable.getSelectedRowsFromSelectedCells();
            if (selectedRows == null || selectedRows.length == 0) {
                return;
            }
            int firstRow = selectedRows[0];
            int lastRow = selectedRows[selectedRows.length - 1];
            ExpressionPanel.this.m_expressionModel.getModel().startCompoundUndoable();
            try {
                ExpressionPanel.this.m_expressionTableModel.ungroupExpression(firstRow, lastRow);
                if (ExpressionPanel.this.getWAUndoManager() != null) {
                    ExpressionPanel.this.getWAUndoManager().addEdit((UndoableEdit)new UngroupUndoable(firstRow, lastRow));
                }
            }
            finally {
                ExpressionPanel.this.m_expressionModel.getModel().endCompoundUndoable();
            }
        }
    }

    protected class GroupAction
    extends WsAbstractAction {
        public GroupAction() {
            super(bundle, "ExpressionPanel.Group", 18);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            ExpressionPanel.this.m_expressionTable.stopCellEditing();
            int[] selectedRows = ExpressionPanel.this.m_expressionTable.getSelectedRowsFromSelectedCells();
            if (selectedRows == null || selectedRows.length <= 0) {
                return;
            }
            int firstRow = selectedRows[0];
            int lastRow = selectedRows[selectedRows.length - 1];
            ExpressionPanel.this.m_expressionModel.getModel().startCompoundUndoable();
            try {
                ExpressionPanel.this.m_expressionTableModel.groupExpression(firstRow, lastRow);
                if (ExpressionPanel.this.getWAUndoManager() != null) {
                    ExpressionPanel.this.getWAUndoManager().addEdit((UndoableEdit)new GroupUndoable(firstRow, lastRow));
                }
            }
            finally {
                ExpressionPanel.this.m_expressionModel.getModel().endCompoundUndoable();
            }
        }
    }

    protected class ValidateAction
    extends WsAbstractAction {
        public ValidateAction() {
            super(bundle, "ExpressionPanel.Validate", 0);
        }

        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < ExpressionPanel.this.m_expressionTable.getColumnModel().getColumnCount(); ++i) {
                System.out.println("Column " + i + " width is: " + ExpressionPanel.this.m_expressionTable.getColumnModel().getColumn(i).getWidth());
            }
            System.out.println("New button height: " + ExpressionPanel.this.m_newButton.getHeight());
            System.out.println("Up button height: " + ExpressionPanel.this.m_upButton.getHeight());
            System.out.println("Down button height: " + ExpressionPanel.this.m_downButton.getHeight());
            System.out.println("Group button height: " + ExpressionPanel.this.m_groupButton.getHeight());
        }
    }

    protected class MoveDownAction
    extends WsAbstractAction {
        public MoveDownAction() {
            super(bundle, "ExpressionPanel.MoveDown", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:MoveDown"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            ExpressionPanel.this.m_expressionModel.getModel().startCompoundUndoable();
            try {
                int[] aIndex = ExpressionPanel.this.m_expressionTable.getSelectedRowsFromSelectedCells();
                for (int iIndex = 0; iIndex < aIndex.length; ++iIndex) {
                    ExpressionPanel.this.moveExpression(aIndex[iIndex], aIndex[iIndex] + 1);
                }
            }
            finally {
                ExpressionPanel.this.m_expressionModel.getModel().endCompoundUndoable();
            }
        }
    }

    protected class MoveUpAction
    extends WsAbstractAction {
        public MoveUpAction() {
            super(bundle, "ExpressionPanel.MoveUp", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:MoveUp"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            ExpressionPanel.this.m_expressionModel.getModel().startCompoundUndoable();
            try {
                int[] aIndex = ExpressionPanel.this.m_expressionTable.getSelectedRowsFromSelectedCells();
                for (int iIndex = 0; iIndex < aIndex.length; ++iIndex) {
                    ExpressionPanel.this.moveExpression(aIndex[iIndex], aIndex[iIndex] - 1);
                }
            }
            finally {
                ExpressionPanel.this.m_expressionModel.getModel().endCompoundUndoable();
            }
        }
    }

    protected class DeleteAction
    extends WsAbstractAction {
        public DeleteAction() {
            super(bundle, "ExpressionPanel.Delete", 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            ExpressionPanel.this.m_expressionTable.cancelCellEditing();
            int[] aRows = ExpressionPanel.this.m_expressionTable.getSelectedRowsFromSelectedCells();
            ExpressionPanel.this.m_expressionModel.getModel().startCompoundUndoable();
            try {
                ExpressionPanel.this.m_bDeleteInProgress = true;
                IBooleanExpression[] expressions = new IBooleanExpression[aRows.length];
                for (int iRow = 0; iRow < aRows.length; ++iRow) {
                    expressions[iRow] = ExpressionPanel.this.getExpression(aRows[iRow]);
                }
                for (int i = 0; i < expressions.length; ++i) {
                    ExpressionPanel.this.m_expressionModel.removeBooleanExpression(expressions[i]);
                }
            }
            finally {
                ExpressionPanel.this.m_expressionModel.getModel().endCompoundUndoable();
                ExpressionPanel.this.m_bDeleteInProgress = false;
            }
            int row = Math.min(aRows[aRows.length - 1] - (aRows.length - 1), ExpressionPanel.this.m_expressionTable.getRowCount() - 1);
            if (row >= 0) {
                ExpressionPanel.this.m_expressionTable.selectRow(row);
            }
            ExpressionPanel.this.updateActions();
        }
    }

    protected class EditAction
    extends WsAbstractAction {
        public EditAction() {
            super(bundle, "ExpressionPanel.Edit", 0);
        }

        public void actionPerformed(ActionEvent e) {
            ExpressionPanel.this.m_expressionModel.getModel().startCompoundUndoable();
            try {
                ExpressionPanel.this.displayTableModelInfo();
            }
            finally {
                ExpressionPanel.this.m_expressionModel.getModel().endCompoundUndoable();
            }
        }
    }

    protected class NewAction
    extends WsAbstractAction {
        public NewAction() {
            super(bundle, "ExpressionPanel.New", 0);
        }

        public void actionPerformed(ActionEvent e) {
            ExpressionPanel.this.m_expressionModel.getModel().startCompoundUndoable();
            try {
                ExpressionPanel.this.createNewExpression();
            }
            finally {
                ExpressionPanel.this.m_expressionModel.getModel().endCompoundUndoable();
            }
        }
    }

    protected class DisplayFilterDescriptionsAction
    extends WsAbstractToggleAction {
        public DisplayFilterDescriptionsAction() {
            super(bundle, "ExpressionPanel.DisplayFilterDescriptions", 0);
            List hiddenColumns = ExpressionPanel.this.m_expressionTable.getHiddenColumns();
            boolean visible = true;
            int size = hiddenColumns.size();
            for (int index = 0; index < size; ++index) {
                TableColumn tableColumn = (TableColumn)hiddenColumns.get(index);
                if (tableColumn.getModelIndex() != 7) continue;
                visible = false;
                break;
            }
            this.setSelected(visible);
        }

        public void actionPerformed(ActionEvent e) {
            if (this.isSelected()) {
                ExpressionPanel.this.m_expressionTable.showColumn(7);
            } else {
                ExpressionPanel.this.m_expressionTable.hideColumn(7);
            }
        }
    }

    protected class DisplayFilterNamesAction
    extends WsAbstractToggleAction {
        public DisplayFilterNamesAction() {
            super(bundle, "ExpressionPanel.DisplayFilterNames", 0);
            List hiddenColumns = ExpressionPanel.this.m_expressionTable.getHiddenColumns();
            boolean visible = true;
            int size = hiddenColumns.size();
            for (int index = 0; index < size; ++index) {
                TableColumn tableColumn = (TableColumn)hiddenColumns.get(index);
                if (tableColumn.getModelIndex() != 6) continue;
                visible = false;
                break;
            }
            this.setSelected(visible);
        }

        public void actionPerformed(ActionEvent e) {
            if (this.isSelected()) {
                ExpressionPanel.this.m_expressionTable.showColumn(6);
            } else {
                ExpressionPanel.this.m_expressionTable.hideColumn(6);
            }
        }
    }

    protected class DisplayFiltersAction
    extends WsAbstractToggleAction {
        public DisplayFiltersAction() {
            super(bundle, "ExpressionPanel.DisplayFilters", 0);
            List hiddenColumns = ExpressionPanel.this.m_expressionTable.getHiddenColumns();
            boolean leftOperandVisible = true;
            boolean operatorVisible = true;
            boolean rightOperandVisible = true;
            int size = hiddenColumns.size();
            for (int index = 0; index < size; ++index) {
                TableColumn tableColumn = (TableColumn)hiddenColumns.get(index);
                if (tableColumn.getModelIndex() == 2) {
                    leftOperandVisible = false;
                }
                if (tableColumn.getModelIndex() == 3) {
                    operatorVisible = false;
                }
                if (tableColumn.getModelIndex() != 4) continue;
                rightOperandVisible = false;
            }
            this.setSelected(leftOperandVisible && operatorVisible && rightOperandVisible);
        }

        public void actionPerformed(ActionEvent e) {
            if (this.isSelected()) {
                ExpressionPanel.this.m_expressionTable.showColumn(2);
                ExpressionPanel.this.m_expressionTable.showColumn(3);
                ExpressionPanel.this.m_expressionTable.showColumn(4);
            } else {
                ExpressionPanel.this.m_expressionTable.hideColumn(2);
                ExpressionPanel.this.m_expressionTable.hideColumn(3);
                ExpressionPanel.this.m_expressionTable.hideColumn(4);
            }
        }
    }

    protected class ExpressionModelChangeListener
    implements IModelListener {
        protected ExpressionModelChangeListener() {
        }

        public void modelChanged(ModelEvent event) {
            List expressions = ExpressionPanel.this.m_expressionModel.getBooleanExpressionsList();
            try {
                if (event.getType().equalsIgnoreCase("BooleanExpression:LeftOperandChanged")) {
                    int index = expressions.indexOf(event.getModelObject());
                    if (index == -1) {
                        Workspace.getDefaultLogger().error((Object)(event.getModelObject() + ": expression for left operand change event not found in expression list"));
                        return;
                    }
                    IBooleanExpression expression = (IBooleanExpression)expressions.get(index);
                    ExpressionPanel.this.m_expressionTableModel.updateExpression(expression.getLeftOperand(), index, 2);
                    ExpressionPanel.this.m_expressionTable.repaint();
                } else if (event.getType().equalsIgnoreCase("BooleanExpression:OperatorChanged")) {
                    int index = expressions.indexOf(event.getModelObject());
                    if (index == -1) {
                        Workspace.getDefaultLogger().error((Object)(event.getModelObject() + ": expression for operator change event not found in expression list"));
                        return;
                    }
                    IBooleanExpression expression = (IBooleanExpression)expressions.get(index);
                    ExpressionPanel.this.m_expressionTableModel.updateExpression(expression.getOperator(), index, 3);
                    ExpressionPanel.this.m_expressionTable.repaint();
                } else if (event.getType().equalsIgnoreCase("BooleanExpression:RightOperandChanged")) {
                    ExpressionPanel.this.m_sqlText.setText(ExpressionPanel.this.m_expressionModel.getText(null, ExpressionPanel.this.m_expressionModel.isQuotingNeeded(), ExpressionPanel.this.m_expressionModel.isPassThru()));
                    int index = expressions.indexOf(event.getModelObject());
                    if (index == -1) {
                        Workspace.getDefaultLogger().error((Object)(event.getModelObject() + ": expression for right operand change event not found in expression list"));
                        return;
                    }
                    IBooleanExpression expression = (IBooleanExpression)expressions.get(index);
                    ExpressionPanel.this.m_expressionTableModel.updateExpression(expression.getRightOperand(), index, 4);
                    ExpressionPanel.this.m_expressionTable.repaint();
                } else if (event.getType().equalsIgnoreCase("Object:UserWrittenIndicatorChanged")) {
                    ExpressionPanel.this.m_sqlText.setText(ExpressionPanel.this.m_expressionModel.getText(null, ExpressionPanel.this.m_expressionModel.isQuotingNeeded(), ExpressionPanel.this.m_expressionModel.isPassThru()));
                    ExpressionPanel.this.setEditable(ExpressionPanel.this.isEditable());
                    ExpressionPanel.this.m_expressionTable.repaint();
                } else if (event.getType().equalsIgnoreCase("Object:UserWrittenCodeChanged")) {
                    ExpressionPanel.this.m_sqlText.setText(ExpressionPanel.this.m_expressionModel.getText(null, ExpressionPanel.this.m_expressionModel.isQuotingNeeded(), ExpressionPanel.this.m_expressionModel.isPassThru()));
                    ExpressionPanel.this.setEditable(ExpressionPanel.this.isEditable());
                    ExpressionPanel.this.m_expressionTable.repaint();
                } else if ("IUserWrittenCode:activeChanged".equals(event.getType())) {
                    ExpressionPanel.this.setEditable(ExpressionPanel.this.isEditable());
                    ExpressionPanel.this.m_expressionTable.repaint();
                } else if (event.getType().equalsIgnoreCase("SQLAlias:AliasChanged") || event.getType().equalsIgnoreCase("SQL:ClauseRemoved") || event.getType().equalsIgnoreCase("Join:ImplicitChanged") || event.getType().equalsIgnoreCase("Join:JoinTypeChanged")) {
                    if (event.getModelObject() != ExpressionPanel.this.m_expressionModel) {
                        return;
                    }
                    try {
                        ExpressionPanel.this.moveDataToView();
                    }
                    catch (MdException ex) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                    }
                    catch (RemoteException re) {
                        Workspace.handleRemoteException((RemoteException)re);
                    }
                } else if (event.getType().equalsIgnoreCase("Object:BooleanExpressionAdded")) {
                    if (event.getModelObject() != ExpressionPanel.this.m_expressionModel) {
                        return;
                    }
                    int index = expressions.indexOf(event.getData());
                    if (index == -1) {
                        Workspace.getDefaultLogger().error((Object)(event.getData() + ": expression for expression add event not found in expression list"));
                        return;
                    }
                    IBooleanExpression expression = (IBooleanExpression)expressions.get(index);
                    List values = ExpressionPanel.expressionAsList(expression);
                    ExpressionPanel.this.m_expressionTableModel.insertRow(index - 1, values);
                    ExpressionPanel.this.m_sqlText.setText(ExpressionPanel.this.m_expressionModel.getText(null, ExpressionPanel.this.m_expressionModel.isQuotingNeeded(), ExpressionPanel.this.m_expressionModel.isPassThru()));
                    ExpressionPanel.this.m_expressionTable.repaint();
                } else if (event.getType().equalsIgnoreCase("Object:BooleanExpressionRemoved")) {
                    if (event.getModelObject() != ExpressionPanel.this.m_expressionModel) {
                        return;
                    }
                    ExpressionPanel.this.m_expressionTableModel.deleteExpression((IBooleanExpression)event.getData());
                    ExpressionPanel.this.m_sqlText.setText(ExpressionPanel.this.m_expressionModel.getText(null, ExpressionPanel.this.m_expressionModel.isQuotingNeeded(), ExpressionPanel.this.m_expressionModel.isPassThru()));
                    ExpressionPanel.this.m_expressionTable.repaint();
                } else {
                    ExpressionPanel.this.m_sqlText.setText(ExpressionPanel.this.m_expressionModel.getText(null, ExpressionPanel.this.m_expressionModel.isQuotingNeeded(), ExpressionPanel.this.m_expressionModel.isPassThru()));
                    ExpressionPanel.this.m_expressionTable.repaint();
                }
            }
            catch (RemoteException e1) {
                Workspace.handleRemoteException((RemoteException)e1);
            }
            catch (CodegenException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
            }
            catch (MdException e1) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e1, (String)"Accessing");
            }
            catch (BadServerDefinitionException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
            }
            catch (BadLibraryDefinitionException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
            }
            catch (ServerException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
            }
        }
    }

    protected class OperatorTableColumn
    extends WsAbstractPopulateOnDemandTableColumn {
        public OperatorTableColumn(int index, String name, int width) {
            super(index, name, width);
            this.setEditorEditable(true);
        }

        public void populate(JTable table, int row, int column) {
            this.setPossibleValues(new String[]{ExpressionPanel.EQUALS_OPERATOR, ExpressionPanel.NOT_EQUALS_OPERATOR, bundle.getString("ExpressionPanel.InOperator.txt.notrans"), bundle.getString("ExpressionPanel.NotInOperator.txt.notrans"), ExpressionPanel.GREATER_THAN_OPERATOR, ExpressionPanel.GREATER_THAN_EQUALS_OPERATOR, ExpressionPanel.LESS_THAN_OPERATOR, ExpressionPanel.LESS_THAN_EQUALS_OPERATOR, ExpressionPanel.BETWEEN_OPERATOR, ExpressionPanel.NOT_BETWEEN_OPERATOR, ExpressionPanel.EXISTS_OPERATOR, ExpressionPanel.NOT_EXISTS_OPERATOR, ExpressionPanel.MISSING_OPERATOR, ExpressionPanel.NOT_MISSING_OPERATOR, ExpressionPanel.NULL_OPERATOR, ExpressionPanel.NOT_NULL_OPERATOR, ExpressionPanel.CONTAINS_OPERATOR, ExpressionPanel.NOT_CONTAINS_OPERATOR, bundle.formatString("ExpressionPanel.LikeOperator.fmt.notrans", (Object)bundle.getString("ExpressionPanel.LikeOperator.txt")), bundle.formatString("ExpressionPanel.NotLikeOperator.fmt.notrans", (Object)bundle.getString("ExpressionPanel.NotLikeOperator.txt")), bundle.formatString("ExpressionPanel.SoundsLikeOperator.fmt.notrans", (Object)bundle.getString("ExpressionPanel.SoundsLikeOperator.txt")), bundle.formatString("ExpressionPanel.NotSoundsLikeOperator.fmt.notrans", (Object)bundle.getString("ExpressionPanel.NotSoundsLikeOperator.txt"))});
        }
    }

    protected class BooleanTableColumn
    extends WsEnumeratedTableColumn {
        public BooleanTableColumn(int index, String name, int width) {
            super(index, name, width);
        }

        public TableCellEditor createCellEditor() {
            BooleanCellEditor editor = new BooleanCellEditor();
            return editor;
        }

        public void populate(JTable table, int row, int column) {
            String[] values = row == 0 ? new String[]{"", ExpressionPanel.NOT_KEYWORD} : new String[]{ExpressionPanel.AND_KEYWORD, ExpressionPanel.OR_KEYWORD, ExpressionPanel.AND_NOT_KEYWORD, ExpressionPanel.OR_NOT_KEYWORD};
            this.setPossibleValues(values);
            this.setDefaultValue(values[0]);
        }

        protected class BooleanCellEditor
        extends WsDefaultCellEditor {
            protected WAComboBox m_comboBox = new WAComboBox();
            protected WATextField m_textField;
            protected WsDefaultCellEditor.cEditorDelegate m_textFieldDelegate;
            protected WsDefaultCellEditor.cEditorDelegate m_comboBoxDelegate = new WsDefaultCellEditor.cComboBoxDelegate((WsDefaultCellEditor)this, (JComboBox)this.m_comboBox);

            public BooleanCellEditor() {
                this.initialize((JComboBox)this.m_comboBox, this.m_comboBoxDelegate);
                this.m_comboBox.setEditable(false);
                this.m_textField = new WATextField();
                this.m_textFieldDelegate = new WsDefaultCellEditor.cTextFieldDelegate((WsDefaultCellEditor)this, (JTextField)this.m_textField);
                this.initialize(this.m_textField, this.m_textFieldDelegate);
                this.m_textField.setEditable(false);
                this.m_cmpEditor = this.m_comboBox;
                this.m_delegate = this.m_comboBoxDelegate;
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean bSelected, int iRow, int iColumn) {
                this.m_cmpEditor = this.m_comboBox;
                this.m_delegate = this.m_comboBoxDelegate;
                super.notify(table, iRow, iColumn);
                BooleanTableColumn.this.populate(table, iRow, iColumn);
                this.m_delegate.setValue(value);
                return this.m_cmpEditor;
            }
        }
    }

    protected class OperandCellEditor
    extends WsDropMenuTableCellEditor {
        public OperandCellEditor() {
            Document doc = this.m_txt.getDocument();
            doc.putProperty("filterNewlines", Boolean.FALSE);
            if (doc instanceof WsLimitedPlainDocument) {
                ((WsLimitedPlainDocument)doc).setSingleLine(false);
            }
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean selected, int row, int column) {
            IBooleanExpression expression = ExpressionPanel.this.getExpression(row);
            String operator = expression.getOperator();
            if (column == 2 && (operator.equalsIgnoreCase(ExpressionPanel.EXISTS_OPERATOR) || operator.equalsIgnoreCase(ExpressionPanel.NOT_EXISTS_OPERATOR))) {
                JComponent component = this.getComponent();
                if (component instanceof JTextComponent) {
                    ((JTextComponent)component).setEditable(false);
                }
            } else {
                JComponent component = this.getComponent();
                if (component instanceof JTextComponent) {
                    ((JTextComponent)component).setEditable(true);
                }
            }
            this.notify(table, row, column);
            this.m_delegate.setValue(value);
            return this.m_cmpEditor;
        }
    }

    protected class OperandCellRenderer
    extends WsDefaultTableCellRenderer {
        private Font m_plainFont = this.getFont();
        private Font m_italicFont = new Font(this.m_plainFont.getName(), 2, this.m_plainFont.getSize());

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, column);
            IBooleanExpression expression = ExpressionPanel.this.getExpression(row);
            IExpression operand = null;
            if (column == 2) {
                operand = expression.getLeftOperand();
            } else if (column == 4) {
                operand = expression.getRightOperand();
            } else {
                component.setFont(this.m_plainFont);
                return component;
            }
            if (operand == null) {
                component.setFont(this.m_plainFont);
                return component;
            }
            if (operand instanceof ICaseStatement || operand instanceof ISubquery) {
                component.setFont(this.m_italicFont);
                return component;
            }
            component.setFont(this.m_plainFont);
            return component;
        }
    }

    protected static class CharacterDocument
    extends WsLimitedPlainDocument {
        private char m_character;

        public CharacterDocument(char character) {
            this.m_character = character;
        }

        public void insertString(int offset, String string, AttributeSet attributes) throws BadLocationException {
            if (string == null) {
                return;
            }
            String pattern = "^[" + this.m_character + "]+$";
            if (!string.matches(pattern)) {
                return;
            }
            super.insertString(offset, string, attributes);
        }
    }

    protected class CenteredCellRenderer
    extends DefaultTableCellRenderer {
        public CenteredCellRenderer() {
            this.setHorizontalAlignment(0);
        }
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private int m_runs = 0;

        private TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (this.m_runs++ < 2) {
                ExpressionPanel.this.setInitialSelection();
            }
            ExpressionPanel.this.updateActions();
        }
    }

    private class ExpressionTableModel
    extends WsAbstractTableModel {
        protected static final int TOTAL_COLUMNS = 9;
        protected static final int HIDDEN_COLUMNS = 3;

        public ExpressionTableModel() {
            this.m_aColumns = new WsAbstractTableColumn[9];
            WsDefaultTableCellRenderer centeredRenderer = new WsDefaultTableCellRenderer();
            centeredRenderer.setHorizontalAlignment(0);
            BooleanTableColumn logicalColumn = new BooleanTableColumn(0, bundle.getString("ExpressionPanel.Column.Boolean.txt"), 50);
            logicalColumn.setPossibleValues(new String[]{ExpressionPanel.AND_KEYWORD, ExpressionPanel.OR_KEYWORD, ExpressionPanel.AND_NOT_KEYWORD, ExpressionPanel.OR_NOT_KEYWORD});
            WsDefaultCellEditor cellEditor = (WsDefaultCellEditor)logicalColumn.getCellEditor();
            WAComboBox editorComponent = (WAComboBox)cellEditor.getComponent();
            editorComponent.setEditable(false);
            this.m_aColumns[0] = logicalColumn;
            this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("ExpressionPanel.Column.LeftParen.txt"), 35);
            this.m_aColumns[1].setCellRenderer((TableCellRenderer)centeredRenderer);
            this.m_aColumns[1].setEditable(true);
            this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("ExpressionPanel.Column.LeftOperand.txt"), 200);
            this.m_aColumns[3] = new OperatorTableColumn(3, bundle.getString("ExpressionPanel.Column.Operator.txt"), 100);
            this.m_aColumns[3].setCellRenderer((TableCellRenderer)centeredRenderer);
            this.m_aColumns[4] = new WsStringTableColumn(4, bundle.getString("ExpressionPanel.Column.RightOperand.txt"), 200);
            this.m_aColumns[5] = new WsStringTableColumn(5, bundle.getString("ExpressionPanel.Column.RightParen.txt"), 35);
            this.m_aColumns[5].setCellRenderer((TableCellRenderer)centeredRenderer);
            this.m_aColumns[5].setEditable(true);
            this.m_aColumns[6] = new WsUniqueNameTableColumn((WsAbstractTableModel)this, 6, bundle.getString("ExpressionPanel.Column.Name.txt"), 100);
            ((WsUniqueNameTableColumn)this.m_aColumns[6]).setFormatString(bundle.getString("ExpressionPanel.Column.Name.fmt"));
            this.m_aColumns[7] = new WsStringTableColumn(7, bundle.getString("ExpressionPanel.Column.Description.txt"), 200);
            this.m_aColumns[8] = new WsObjectTableColumn();
            this.m_aColumns[8].setModelIndex(8);
        }

        public void populateStore() throws MdException, RemoteException {
            throw new UnsupportedOperationException("populateStore not implemented.  Model does not use a store");
        }

        public void moveDataToModel() throws MdException, RemoteException {
            this.clear();
            if (ExpressionPanel.this.m_expressions == null) {
                return;
            }
            for (int index = 0; index < ExpressionPanel.this.m_expressions.size(); ++index) {
                IBooleanExpression expression = (IBooleanExpression)ExpressionPanel.this.m_expressions.get(index);
                ArrayList<String> row = new ArrayList<String>();
                row.add(expression.getLogicalOperator().toUpperCase());
                row.add(ExpressionPanel.makeParentheses("(", expression.getOpenParenthesisCount()));
                row.add((String)expression.getLeftOperand());
                row.add(expression.getOperator().toString());
                row.add((String)expression.getRightOperand());
                row.add(ExpressionPanel.makeParentheses(")", expression.getClosedParenthesisCount()));
                row.add(expression.getName());
                row.add(expression.getDescription());
                row.add((String)expression);
                this.m_lData.add(row);
                ++this.m_nRowInstances;
            }
            this.fireTableModelPopulated();
        }

        public void moveDataToStore() throws MdException, RemoteException {
            if (!ExpressionPanel.this.hasDataChanged()) {
                return;
            }
        }

        public boolean validateData() {
            return true;
        }

        public int getColumnCount() {
            return this.m_aColumns.length;
        }

        public IBooleanExpression getExpression(int row) {
            return (IBooleanExpression)this.getValueAt(row, 8);
        }

        public int getExpressionIndex(IBooleanExpression expression) {
            for (int rowIndex = 0; rowIndex < this.m_lData.size(); ++rowIndex) {
                List values = (List)this.m_lData.get(rowIndex);
                if (values.get(8) != expression) continue;
                return rowIndex;
            }
            return -1;
        }

        public List createDefaultRowValues() {
            int currentRow = ExpressionPanel.this.m_expressionTable.getCurrentRow();
            List values = super.createDefaultRowValues();
            values.set(0, currentRow < 0 ? "" : ExpressionPanel.AND_KEYWORD);
            values.set(2, this.createTextOperand(ExpressionPanel.this.m_expressionModel.getID(), ""));
            values.set(3, ExpressionPanel.EQUALS_OPERATOR);
            values.set(4, this.createTextOperand(ExpressionPanel.this.m_expressionModel.getID(), ""));
            String name = bundle.formatString("ExpressionPanel.NewFilterName.fmt", (Object)new Integer(this.m_nRowInstances));
            values.set(6, name);
            return values;
        }

        public String createUniqueNameForNewExpression() {
            return (String)this.m_aColumns[6].createDefaultValue();
        }

        public Object getValueAt(int row, int column) {
            List expressions = ExpressionPanel.this.m_expressionModel.getBooleanExpressionsList();
            if (expressions.size() < 1) {
                return "";
            }
            IBooleanExpression expression = (IBooleanExpression)expressions.get(row);
            switch (column) {
                case 0: {
                    String logicalOperator = expression.getLogicalOperator();
                    return logicalOperator != null ? logicalOperator.toUpperCase() : "";
                }
                case 1: {
                    int leftParenCount = expression.getOpenParenthesisCount();
                    return ExpressionPanel.makeParentheses("(", leftParenCount);
                }
                case 2: {
                    IExpression object = expression.getLeftOperand();
                    if (object == null) {
                        return "";
                    }
                    if (object instanceof ICaseStatement) {
                        return bundle.getString("ExpressionPanel.CaseText.txt");
                    }
                    if (object instanceof ISubquery) {
                        return bundle.getString("ExpressionPanel.SubqueryText.txt");
                    }
                    return ExpressionPanel.this.getTextFromOperand(object);
                }
                case 3: {
                    String operator = expression.getOperator();
                    return operator != null ? operator : "";
                }
                case 4: {
                    IExpression object = expression.getRightOperand();
                    if (object == null) {
                        return "";
                    }
                    if (object instanceof ICaseStatement) {
                        return bundle.getString("ExpressionPanel.CaseText.txt");
                    }
                    if (object instanceof ISubquery) {
                        return bundle.getString("ExpressionPanel.SubqueryText.txt");
                    }
                    return ExpressionPanel.this.getTextFromOperand(object);
                }
                case 5: {
                    int rightParenCount = expression.getClosedParenthesisCount();
                    return ExpressionPanel.makeParentheses(")", rightParenCount);
                }
                case 6: {
                    String name = expression.getName();
                    return name != null ? name : "";
                }
                case 7: {
                    String description = expression.getDescription();
                    return description != null ? description : "";
                }
                case 8: {
                    return expression;
                }
            }
            return super.getValueAt(row, column);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValueAt(Object value, int row, int column) {
            if (ExpressionPanel.this.m_expressions.size() < 1) {
                return;
            }
            ExpressionPanel.this.m_expressionModel.getModel().startCompoundUndoable();
            try {
                this.updateExpression(value, row, column);
                IBooleanExpression expression = (IBooleanExpression)ExpressionPanel.this.m_expressions.get(row);
                if ((column == 2 || column == 4) && value instanceof String) {
                    super.setValueAt((Object)this.createTextOperand(expression.getID(), (String)value), row, column);
                } else {
                    super.setValueAt(value, row, column);
                }
                if (column == 3) {
                    String operator = (String)value;
                    if (operator.equalsIgnoreCase(ExpressionPanel.EXISTS_OPERATOR) || operator.equalsIgnoreCase(ExpressionPanel.NOT_EXISTS_OPERATOR)) {
                        ExpressionPanel.this.m_expressionTable.undoableSetValueAt((Object)"", row, 2);
                    }
                    if (operator.equalsIgnoreCase(ExpressionPanel.MISSING_OPERATOR) || operator.equalsIgnoreCase(ExpressionPanel.NOT_MISSING_OPERATOR) || operator.equalsIgnoreCase(ExpressionPanel.NULL_OPERATOR) || operator.equalsIgnoreCase(ExpressionPanel.NOT_NULL_OPERATOR) || operator.equalsIgnoreCase(ExpressionPanel.NOT_IS_NULL_OPERATOR)) {
                        ExpressionPanel.this.m_expressionTable.undoableSetValueAt((Object)"", row, 4);
                    }
                }
                ExpressionPanel.this.updateActions();
                ExpressionPanel.this.updateComponents();
            }
            finally {
                ExpressionPanel.this.m_expressionModel.getModel().endCompoundUndoable();
            }
        }

        public void addExpression(int row, List values) {
            IBooleanExpression expression = ExpressionPanel.this.m_expressionModel.createNewBooleanExpression();
            expression.setName((String)values.get(6));
            expression.setLeftOperand((IExpression)values.get(2));
            expression.setRightOperand((IExpression)values.get(4));
            expression.setOperator((String)values.get(3));
            expression.setOpenParenthesisCount(((String)values.get(1)).length());
            expression.setClosedParenthesisCount(((String)values.get(5)).length());
            ExpressionPanel.this.m_expressionModel.addBooleanExpression(row + 1, expression);
        }

        private ITextOperand createTextOperand(String sID, String text) {
            ITextOperand textOperand = ExpressionPanel.this.m_expressionModel.getModel().getObjectFactory().createNewSQLTextOperand(sID, ExpressionPanel.this.m_expressionModel.getParentQuery());
            ITextExpression operandExpression = ExpressionPanel.this.m_expressionModel.getModel().getObjectFactory().createNewSQLTextExpression(textOperand.getID(), ExpressionPanel.this.m_expressionModel.getParentQuery());
            operandExpression.setUseSQLSyntax(true);
            ITable[] aSourceTables = ExpressionPanel.this.m_expressionModel.getParentQuery().getSourcesInFrom();
            ArrayList<IColumn> alCols = new ArrayList<IColumn>();
            for (int i = 0; i < aSourceTables.length; ++i) {
                ITable oTable = aSourceTables[i];
                alCols.addAll(Arrays.asList(oTable.getColumns()));
            }
            ITable target = ExpressionPanel.this.m_expressionModel.getParentQuery().getTargetTable();
            alCols.addAll(Arrays.asList(target.getColumns()));
            operandExpression.setText(text, (IObject[])alCols.toArray(new IColumn[alCols.size()]));
            textOperand.setTextExpression(operandExpression);
            return textOperand;
        }

        public void updateExpression(Object value, int row, int column) {
            if (ExpressionPanel.this.m_expressions.size() < 1) {
                return;
            }
            IBooleanExpression expression = (IBooleanExpression)ExpressionPanel.this.m_expressions.get(row);
            switch (column) {
                case 0: {
                    expression.setLogicalOperator(value.toString().toLowerCase());
                    break;
                }
                case 1: {
                    expression.setOpenParenthesisCount(value.toString().length());
                    break;
                }
                case 2: {
                    if (value instanceof String) {
                        expression.setLeftOperand((IExpression)this.createTextOperand(expression.getID(), (String)value));
                        break;
                    }
                    if (value instanceof ICaseStatement) {
                        expression.setLeftOperand((IExpression)((ICaseStatement)value));
                        break;
                    }
                    if (!(value instanceof ISubquery)) break;
                    expression.setLeftOperand((IExpression)((ISubquery)value));
                    break;
                }
                case 3: {
                    String operator = (String)value;
                    if (operator.startsWith(ExpressionPanel.IN_OPERATOR)) {
                        expression.setOperator(ExpressionPanel.IN_OPERATOR);
                        break;
                    }
                    if (operator.startsWith(ExpressionPanel.NOT_IN_OPERATOR)) {
                        expression.setOperator(ExpressionPanel.NOT_IN_OPERATOR);
                        break;
                    }
                    if (operator.startsWith(ExpressionPanel.LIKE_OPERATOR)) {
                        expression.setOperator(ExpressionPanel.LIKE_OPERATOR);
                        break;
                    }
                    if (operator.startsWith(ExpressionPanel.NOT_LIKE_OPERATOR)) {
                        expression.setOperator(ExpressionPanel.NOT_LIKE_OPERATOR);
                        break;
                    }
                    if (operator.startsWith(ExpressionPanel.SOUNDS_LIKE_OPERATOR)) {
                        expression.setOperator(ExpressionPanel.SOUNDS_LIKE_OPERATOR);
                        break;
                    }
                    if (operator.startsWith(ExpressionPanel.NOT_SOUNDS_LIKE_OPERATOR)) {
                        expression.setOperator(ExpressionPanel.NOT_SOUNDS_LIKE_OPERATOR);
                        break;
                    }
                    expression.setOperator(value.toString());
                    break;
                }
                case 4: {
                    if (value instanceof String) {
                        expression.setRightOperand((IExpression)this.createTextOperand(expression.getID(), (String)value));
                        break;
                    }
                    if (value instanceof ICaseStatement) {
                        expression.setRightOperand((IExpression)((ICaseStatement)value));
                        break;
                    }
                    if (!(value instanceof ISubquery)) break;
                    expression.setRightOperand((IExpression)((ISubquery)value));
                    break;
                }
                case 5: {
                    expression.setClosedParenthesisCount(value.toString().length());
                    break;
                }
                case 6: {
                    expression.setName(value.toString());
                    break;
                }
                case 7: {
                    expression.setDescription(value.toString());
                }
            }
            this.fireTableCellUpdated(row, column);
        }

        public void appendToOperand(List values, int row, int column) {
            IBooleanExpression expression = (IBooleanExpression)ExpressionPanel.this.m_expressions.get(row);
            int nOperands = values.size();
            if (nOperands < 1) {
                return;
            }
            StringBuffer sbText = new StringBuffer();
            for (int i = 0; i < nOperands; ++i) {
                if (i > 0) {
                    sbText.append("  ");
                }
                sbText.append((String)values.get(i));
            }
            switch (column) {
                case 2: {
                    String currentLeftText = ExpressionPanel.this.getTextFromOperand(expression.getLeftOperand());
                    if (currentLeftText.length() > 0) {
                        sbText.insert(0, "  ").insert(0, currentLeftText);
                    }
                    expression.setLeftOperand((IExpression)this.createTextOperand(expression.getID(), sbText.toString()));
                    break;
                }
                case 4: {
                    String currentRightText = ExpressionPanel.this.getTextFromOperand(expression.getRightOperand());
                    if (currentRightText.length() > 0) {
                        sbText.insert(0, "  ").insert(0, currentRightText);
                    }
                    expression.setRightOperand((IExpression)this.createTextOperand(expression.getID(), sbText.toString()));
                }
            }
        }

        public void replaceOperand(List values, int row, int column) {
            int nOperands = values.size();
            if (nOperands < 1) {
                return;
            }
            StringBuffer sbText = new StringBuffer();
            for (int i = 0; i < nOperands; ++i) {
                if (i > 0) {
                    sbText.append("  ");
                }
                sbText.append(((IColumn)values.get(i)).getFullColumnName());
            }
            switch (column) {
                case 2: {
                    ExpressionPanel.this.m_expressionTable.undoableSetValueAt((Object)sbText.toString(), row, column);
                    break;
                }
                case 4: {
                    ExpressionPanel.this.m_expressionTable.undoableSetValueAt((Object)sbText.toString(), row, column);
                }
            }
        }

        public void groupExpression(int start, int end) {
            String openParentheses = (String)this.getValueAt(start, 1);
            String closeParentheses = (String)this.getValueAt(end, 5);
            openParentheses = openParentheses + "(";
            closeParentheses = closeParentheses + ")";
            this.setValueAt(openParentheses, start, 1);
            this.setValueAt(closeParentheses, end, 5);
        }

        public void ungroupExpression(int firstRow, int lastRow) {
            String leftParens = (String)ExpressionPanel.this.m_expressionTableModel.getValueAt(firstRow, 1);
            String rightParens = (String)ExpressionPanel.this.m_expressionTableModel.getValueAt(lastRow, 5);
            leftParens = leftParens.substring(0, leftParens.length() - 1);
            rightParens = rightParens.substring(0, rightParens.length() - 1);
            ExpressionPanel.this.m_expressionTableModel.setValueAt(leftParens, firstRow, 1);
            ExpressionPanel.this.m_expressionTableModel.setValueAt(rightParens, lastRow, 5);
        }

        public List ungroupAll() {
            ArrayList changedCells = new ArrayList();
            for (int index = 0; index < ExpressionPanel.this.m_expressionTableModel.getRowCount(); ++index) {
                String rightParens;
                ArrayList<Integer> cellPosition = null;
                String leftParens = (String)this.getValueAt(index, 1);
                if (leftParens != null && leftParens.length() > 0) {
                    this.setValueAt("", index, 1);
                    cellPosition = new ArrayList<Integer>();
                    cellPosition.add(new Integer(index));
                    cellPosition.add(new Integer(1));
                    changedCells.add(cellPosition);
                }
                if ((rightParens = (String)this.getValueAt(index, 5)) == null || rightParens.length() <= 0) continue;
                this.setValueAt("", index, 5);
                cellPosition = new ArrayList();
                cellPosition.add(new Integer(index));
                cellPosition.add(new Integer(5));
                changedCells.add(cellPosition);
            }
            return changedCells;
        }

        public void deleteExpression(IBooleanExpression expression) {
            for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
                List lRow = (List)this.m_lData.get(iRow);
                if (lRow.get(8) != expression) continue;
                this.deleteRow(iRow);
                break;
            }
        }

        public void loadDemoData() {
            String[][] data = new String[][]{{"", "(", "STUDENT.Age", ExpressionPanel.LESS_THAN_OPERATOR, "35", ""}, {ExpressionPanel.AND_KEYWORD, "", "STUDENT.GPA", ExpressionPanel.GREATER_THAN_OPERATOR, "3.0", ")"}, {ExpressionPanel.OR_KEYWORD, "(", "STUDENT.InState", ExpressionPanel.EQUALS_OPERATOR, "'Y'", ""}, {ExpressionPanel.AND_KEYWORD, "", "STUDENT.HomeState", ExpressionPanel.IN_OPERATOR, "('VA', 'NC')", ")"}};
            for (int i = 0; i < data.length; ++i) {
                ArrayList<String> row = new ArrayList<String>();
                for (int j = 0; j < data[i].length; ++j) {
                    if (data[i][j] != null) {
                        row.add(data[i][j]);
                        continue;
                    }
                    row.add("");
                }
                this.m_lData.add(row);
            }
        }
    }

    private class ExpressionTable
    extends WsTable {
        public ExpressionTable(WsAbstractTableModel model) {
            super(model);
            new DropTarget((Component)((Object)this), new cDropTargetListener());
        }

        public JPopupMenu createColumnHeaderPopupMenu() {
            JPopupMenu popupMenu = new JPopupMenu();
            if (ExpressionPanel.this.m_displayFiltersAction == null) {
                ExpressionPanel.this.m_displayFiltersAction = new DisplayFiltersAction();
            }
            if (ExpressionPanel.this.m_displayFilterNamesAction == null) {
                ExpressionPanel.this.m_displayFilterNamesAction = new DisplayFilterNamesAction();
            }
            if (ExpressionPanel.this.m_displayFilterDescriptionsAction == null) {
                ExpressionPanel.this.m_displayFilterDescriptionsAction = new DisplayFilterDescriptionsAction();
            }
            popupMenu.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)ExpressionPanel.this.m_displayFiltersAction));
            popupMenu.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)ExpressionPanel.this.m_displayFilterNamesAction));
            popupMenu.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)ExpressionPanel.this.m_displayFilterDescriptionsAction));
            return popupMenu;
        }

        public boolean isCellEditable(int row, int column) {
            if (column != 2 && column != 4) {
                return super.isCellEditable(row, column);
            }
            IBooleanExpression expression = ExpressionPanel.this.getExpression(row);
            String operator = expression.getOperator();
            if (column == 2 && (operator.equalsIgnoreCase(ExpressionPanel.EXISTS_OPERATOR) || operator.equalsIgnoreCase(ExpressionPanel.NOT_EXISTS_OPERATOR))) {
                return false;
            }
            if (column == 4 && (operator.equalsIgnoreCase(ExpressionPanel.MISSING_OPERATOR) || operator.equalsIgnoreCase(ExpressionPanel.NOT_MISSING_OPERATOR) || operator.equalsIgnoreCase(ExpressionPanel.NULL_OPERATOR) || operator.equalsIgnoreCase(ExpressionPanel.NOT_NULL_OPERATOR) || operator.equalsIgnoreCase(ExpressionPanel.NOT_IS_NULL_OPERATOR))) {
                return false;
            }
            return super.isCellEditable(row, column);
        }

        protected void insertRowImpl(int row, List rowValues) {
            ExpressionPanel.this.m_expressionTableModel.addExpression(row, rowValues);
            super.insertRowImpl(row, rowValues);
        }

        protected void deleteRowImpl(int row) {
            ExpressionPanel.this.updateComponents();
            super.deleteRowImpl(row);
        }

        protected void moveRowImpl(int iFrom, int iTo) {
            this.cancelCellEditing();
            ExpressionPanel.this.moveExpression(iFrom, iTo);
        }
    }
}

