/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql;

import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.wadmin.transforms.sql.TablePropertiesModel;
import com.sas.wadmin.transforms.sql.model.TargetTable;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAppServer;
import java.rmi.RemoteException;

public class TargetTablePropertiesModel
extends TablePropertiesModel {
    private static WAdminResource bundle = WAdminResource.getBundle(TargetTablePropertiesModel.class);
    private static final int OPTIONCOUNT = 3;
    private static final int PROPERTYCOUNT = 20;
    private int m_iBulkload;
    private int m_iInsertBuff;
    private int m_iBulkloadOptions;
    private static final String BULKLOADNAME = bundle.getString("TargetTablePropertiesModel.Property.Bulkload.txt");
    private static final String INSERTBUFFNAME = bundle.getString("TargetTablePropertiesModel.Property.InsertBuff.txt");
    private static final String BULKLOADOPTIONSNAME = bundle.getString("TargetTablePropertiesModel.Property.BulkloadOptions.txt");
    private static final Integer NO_VALUE = new Integer(Integer.MIN_VALUE);
    private TargetTable m_target;

    public TargetTablePropertiesModel(TargetTable target, WsAppServer wsAppServer) {
        super(target, wsAppServer);
        this.m_target = target;
        this.setProperty(this.m_iBulkload, BULKLOADNAME, target.isBulkload(), TargetTablePropertiesModel.getDefaultBooleanRenderer(), true, TargetTablePropertiesModel.getDefaultBooleanEditor());
        this.setProperty(this.m_iInsertBuff, INSERTBUFFNAME, this.m_target.getInsertBuff(), TargetTablePropertiesModel.getDefaultRenderer(), true, TargetTablePropertiesModel.getIntEditor(false, NO_VALUE));
        this.setProperty(this.m_iBulkloadOptions, BULKLOADOPTIONSNAME, this.m_target.getBulkloadOptions(), TargetTablePropertiesModel.getDefaultRenderer(), true, TargetTablePropertiesModel.getDefaultEditor());
        this.setProperty(this.m_iCreateView, CREATEVIEWNAME, target.isTableAView(), TargetTablePropertiesModel.getDefaultBooleanRenderer(), true, TargetTablePropertiesModel.getDefaultBooleanEditor());
    }

    @Override
    protected void initializePropertyIndexes() {
        this.m_iName = 0;
        this.m_iCreateView = 1;
        this.m_iInsertBuff = 2;
        this.m_iBulkload = 3;
        this.m_iBulkloadOptions = 4;
        this.m_iOptions = 5;
        this.m_iDescription = 6;
        this.m_iFolderLocation = 7;
        this.m_iCheckedOutBy = 8;
        this.m_iTableName = 9;
        this.m_iLibrary = 10;
        this.m_iDBMS = 11;
        this.m_iNumberOfRows = 12;
        this.m_iNumberOfColumns = 13;
        this.m_iLastModifiedBy = 14;
        this.m_iDateUpdated = 15;
        this.m_iDateCreated = 16;
        this.m_iLogicalType = 17;
        this.m_iMetadataID = 18;
        this.m_iUsageVersion = 19;
    }

    @Override
    public int getNumberOfProperties() {
        return 20;
    }

    @Override
    public void setPropertyValue(int iProperty, Object value) {
        if (iProperty == this.m_iBulkload) {
            this.m_target.setBulkload((Boolean)value);
        } else if (iProperty == this.m_iInsertBuff) {
            this.m_target.setInsertBuff(value.equals(NO_VALUE) ? "" : value.toString());
        } else if (iProperty == this.m_iBulkloadOptions) {
            this.m_target.setBulkloadOptions((String)value);
        } else if (iProperty == this.m_iCreateView) {
            this.m_target.setIsTableAView((Boolean)value);
        } else {
            super.setPropertyValue(iProperty, value);
        }
    }

    @Override
    public void loadPropertyValues() throws MdException, RemoteException, ServiceException, LogicalTypeException {
        super.loadPropertyValues();
        this.m_aTempValues[this.m_iBulkload] = this.m_target.isBulkload();
        this.m_aTempValues[this.m_iInsertBuff] = this.m_target.getInsertBuff();
        this.m_aTempValues[this.m_iBulkloadOptions] = this.m_target.getBulkloadOptions();
    }

    @Override
    protected void handleChange(String sAction) {
        if (sAction.equals("bulkloadChanged")) {
            this.setPropertyValueImpl(this.m_iBulkload, this.m_target.isBulkload());
        } else if (sAction.equals("insertBuffChanged")) {
            this.setPropertyValueImpl(this.m_iInsertBuff, this.m_target.getInsertBuff());
        } else if (sAction.equals("bulkloadOptionsChanged")) {
            this.setPropertyValueImpl(this.m_iBulkloadOptions, this.m_target.getBulkloadOptions());
        } else if (sAction.equals("MemberTypeChanged")) {
            this.setPropertyValueImpl(this.m_iCreateView, this.m_target.isTableAView());
        } else {
            super.handleChange(sAction);
        }
    }
}

