/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql;

import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.SASLibrary;
import com.sas.services.ServiceException;
import com.sas.wadmin.transforms.sql.TablePropertiesModel;
import com.sas.wadmin.transforms.sql.model.SourceTable;
import com.sas.wadmin.visuals.WASASNameDocument;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsDefaultCellEditor;
import java.rmi.RemoteException;
import javax.swing.table.TableCellEditor;
import javax.swing.text.Document;

public class SourceTablePropertiesModel
extends TablePropertiesModel {
    private static WAdminResource bundle = WAdminResource.getBundle(SourceTablePropertiesModel.class);
    private static final int OPTIONCOUNT = 12;
    private static final int PROPERTYCOUNT = 29;
    protected int m_iAlias;
    protected int m_iIdxWhere;
    protected int m_iFirstObs;
    protected int m_iObs;
    protected int m_iReadBuff;
    protected int m_iUploadTableLibrary;
    protected int m_iUploadTableCaseSensitive;
    protected int m_iUploadTableSpecialCharacters;
    protected int m_iPreUploadActions;
    protected int m_iUploadBulkload;
    protected int m_iBulkloadOptions;
    protected int m_iUploadOptions;
    private static final String ALIASPROPERTYNAME = bundle.getString("SourceTablePropertiesModel.Property.Alias.txt");
    private static final String IDXWHERENAME = bundle.getString("SourceTablePropertiesModel.Property.IdxWhere.txt");
    private static final String FIRSTOBSNAME = bundle.getString("SourceTablePropertiesModel.Property.FirstObs.txt");
    private static final String OBSNAME = bundle.getString("SourceTablePropertiesModel.Property.Obs.txt");
    private static final String READBUFFNAME = bundle.getString("SourceTablePropertiesModel.Property.ReadBuff.txt");
    private static final String DBMSLIBRARYNAME = bundle.getString("SourceTablePropertiesModel.Property.DBMSLibrary.txt");
    private static final String CASESENSITIVENAME = bundle.getString("SourceTablePropertiesModel.Property.CaseSensitive.txt");
    private static final String SPECIALCHARACTERSNAME = bundle.getString("SourceTablePropertiesModel.Property.SpecialCharacters.txt");
    private static final String PREUPLOADACTIONNAME = bundle.getString("SourceTablePropertiesModel.Property.PreUploadActions.txt");
    private static final String UPLOADBULKLOADNAME = bundle.getString("SourceTablePropertiesModel.Property.UploadBulkload.txt");
    private static final String BULKLOADOPTIONNAME = bundle.getString("SourceTablePropertiesModel.Property.UploadBulkloadOptions.txt");
    private static final String UPLOADOPTIONNAME = bundle.getString("SourceTablePropertiesModel.Property.UploadAdditionalOptions.txt");
    private static final Integer NO_VALUE = new Integer(Integer.MIN_VALUE);
    private static TableCellEditor g_edtAlias;
    private SourceTable m_source;

    public SourceTablePropertiesModel(SourceTable source, WsAppServer wsAppServer) {
        super(source, wsAppServer);
        try {
            this.m_source = source;
            if (g_edtAlias == null) {
                WATextField txt = new WATextField((Document)((Object)new WASASNameDocument()), "", 0);
                txt.setMaxCharacters(32);
                g_edtAlias = new WsDefaultCellEditor(txt);
            }
            SASLibrary mdoLibrary = source.getUploadLibrary();
            this.setProperty(this.m_iAlias, ALIASPROPERTYNAME, source.getAlias(), SourceTablePropertiesModel.getDefaultRenderer(), true, g_edtAlias);
            this.setProperty(this.m_iIdxWhere, IDXWHERENAME, source.isIdxWhere(), SourceTablePropertiesModel.getDefaultBooleanRenderer(), true, SourceTablePropertiesModel.getDefaultBooleanEditor());
            this.setProperty(this.m_iFirstObs, FIRSTOBSNAME, source.getFirstObs(), SourceTablePropertiesModel.getDefaultRenderer(), true, SourceTablePropertiesModel.getIntEditor(false, NO_VALUE));
            this.setProperty(this.m_iObs, OBSNAME, source.getObs(), SourceTablePropertiesModel.getDefaultRenderer(), true, SourceTablePropertiesModel.getIntEditor(false, NO_VALUE));
            this.setProperty(this.m_iReadBuff, READBUFFNAME, source.getReadBuff(), SourceTablePropertiesModel.getDefaultRenderer(), true, SourceTablePropertiesModel.getIntEditor(false, NO_VALUE));
            this.setProperty(this.m_iUploadTableLibrary, DBMSLIBRARYNAME, mdoLibrary == null ? "" : mdoLibrary, SourceTablePropertiesModel.getMetadataRender(SASLibrary.class), true, SourceTablePropertiesModel.getMetadataEditor((MdObjectStore)source.getDataTable().getObjectStore(), "SASLibrary"));
            this.setProperty(this.m_iUploadTableCaseSensitive, CASESENSITIVENAME, source.isUploadTableCaseSensitive(), SourceTablePropertiesModel.getDefaultBooleanRenderer(), true, SourceTablePropertiesModel.getDefaultBooleanEditor());
            this.setProperty(this.m_iUploadTableSpecialCharacters, SPECIALCHARACTERSNAME, source.isUploadTableSpecialCharacters(), SourceTablePropertiesModel.getDefaultBooleanRenderer(), true, SourceTablePropertiesModel.getDefaultBooleanEditor());
            this.setProperty(this.m_iPreUploadActions, PREUPLOADACTIONNAME, this.m_source.getPreUploadAction(), SourceTablePropertiesModel.getListRenderer(this.m_source.getPreUploadTranslatedValues(), this.m_source.getPreUploadUnTranslatedValues()), true, SourceTablePropertiesModel.getListEditor(this.m_source.getPreUploadTranslatedValues(), this.m_source.getPreUploadUnTranslatedValues()));
            this.setProperty(this.m_iUploadBulkload, UPLOADBULKLOADNAME, source.isUploadWithBulkload(), SourceTablePropertiesModel.getDefaultBooleanRenderer(), true, SourceTablePropertiesModel.getDefaultBooleanEditor());
            this.setProperty(this.m_iBulkloadOptions, BULKLOADOPTIONNAME, source.getBulkloadOptions(), SourceTablePropertiesModel.getDefaultRenderer(), true, SourceTablePropertiesModel.getDefaultEditor());
            this.setProperty(this.m_iUploadOptions, UPLOADOPTIONNAME, source.getAdditionalUploadOptions(), SourceTablePropertiesModel.getDefaultRenderer(), true, SourceTablePropertiesModel.getDefaultEditor());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    @Override
    protected void initializePropertyIndexes() {
        this.m_iName = 0;
        this.m_iAlias = 1;
        this.m_iObs = 2;
        this.m_iFirstObs = 3;
        this.m_iIdxWhere = 4;
        this.m_iReadBuff = 5;
        this.m_iOptions = 6;
        this.m_iUploadTableLibrary = 7;
        this.m_iUploadTableCaseSensitive = 8;
        this.m_iUploadTableSpecialCharacters = 9;
        this.m_iPreUploadActions = 10;
        this.m_iUploadBulkload = 11;
        this.m_iBulkloadOptions = 12;
        this.m_iUploadOptions = 13;
        this.m_iDescription = 14;
        this.m_iFolderLocation = 15;
        this.m_iCheckedOutBy = 16;
        this.m_iTableName = 17;
        this.m_iLibrary = 18;
        this.m_iDBMS = 19;
        this.m_iCreateView = 20;
        this.m_iNumberOfRows = 21;
        this.m_iNumberOfColumns = 22;
        this.m_iLastModifiedBy = 23;
        this.m_iDateUpdated = 24;
        this.m_iDateCreated = 25;
        this.m_iLogicalType = 26;
        this.m_iMetadataID = 27;
        this.m_iUsageVersion = 28;
    }

    @Override
    public int getNumberOfProperties() {
        return 29;
    }

    @Override
    public void setPropertyValue(int iProperty, Object value) {
        if (iProperty == this.m_iAlias) {
            this.m_source.setAlias((String)value);
        } else if (iProperty == this.m_iIdxWhere) {
            this.m_source.setIdxWhere((Boolean)value);
        } else if (iProperty == this.m_iObs) {
            this.m_source.setObs(value.equals(NO_VALUE) ? "" : value.toString());
        } else if (iProperty == this.m_iFirstObs) {
            this.m_source.setFirstObs(value.equals(NO_VALUE) ? "" : value.toString());
        } else if (iProperty == this.m_iReadBuff) {
            this.m_source.setReadBuff(value.equals(NO_VALUE) ? "" : value.toString());
        } else if (iProperty == this.m_iUploadTableLibrary) {
            this.m_source.setUploadLibrary(value instanceof SASLibrary ? (SASLibrary)value : null);
        } else if (iProperty == this.m_iPreUploadActions) {
            this.m_source.setPreUploadAction((String)value);
        } else if (iProperty == this.m_iUploadBulkload) {
            this.m_source.setUploadWithBulkload((Boolean)value);
        } else if (iProperty == this.m_iBulkloadOptions) {
            this.m_source.setBulkloadOptions((String)value);
        } else if (iProperty == this.m_iUploadOptions) {
            this.m_source.setAdditionalUploadOptions((String)value);
        } else if (iProperty == this.m_iUploadTableCaseSensitive) {
            this.m_source.setUploadTableCaseSensitive((Boolean)value);
        } else if (iProperty == this.m_iUploadTableSpecialCharacters) {
            this.m_source.setUploadTableSpecialCharacters((Boolean)value);
        } else {
            super.setPropertyValue(iProperty, value);
        }
    }

    @Override
    public void loadPropertyValues() throws MdException, RemoteException, ServiceException, LogicalTypeException {
        super.loadPropertyValues();
        SASLibrary mdoLibrary = this.m_source.getUploadLibrary();
        this.m_aTempValues[this.m_iAlias] = this.m_source.getAlias();
        this.m_aTempValues[this.m_iIdxWhere] = this.m_source.isIdxWhere();
        this.m_aTempValues[this.m_iObs] = this.m_source.getObs();
        this.m_aTempValues[this.m_iFirstObs] = this.m_source.getFirstObs();
        this.m_aTempValues[this.m_iReadBuff] = this.m_source.getReadBuff();
        this.m_aTempValues[this.m_iUploadTableLibrary] = mdoLibrary == null ? "" : mdoLibrary;
        this.m_aTempValues[this.m_iPreUploadActions] = this.m_source.getPreUploadAction();
        this.m_aTempValues[this.m_iUploadBulkload] = this.m_source.isUploadWithBulkload();
        this.m_aTempValues[this.m_iBulkloadOptions] = this.m_source.getBulkloadOptions();
        this.m_aTempValues[this.m_iUploadOptions] = this.m_source.getAdditionalUploadOptions();
        this.m_aTempValues[this.m_iUploadTableCaseSensitive] = this.m_source.isUploadTableCaseSensitive();
        this.m_aTempValues[this.m_iUploadTableSpecialCharacters] = this.m_source.isUploadTableSpecialCharacters();
    }

    @Override
    protected void handleChange(String sAction) {
        if (sAction.equals("AliasChanged")) {
            this.setPropertyValueImpl(this.m_iAlias, this.m_source.getAlias());
        } else if (sAction.equals("idxWhereChanged")) {
            this.setPropertyValueImpl(this.m_iIdxWhere, this.m_source.isIdxWhere());
        } else if (sAction.equals("obsChanged")) {
            this.setPropertyValueImpl(this.m_iObs, this.m_source.getObs());
        } else if (sAction.equals("firstObsChanged")) {
            this.setPropertyValueImpl(this.m_iFirstObs, this.m_source.getFirstObs());
        } else if (sAction.equals("readBuffChanged")) {
            this.setPropertyValueImpl(this.m_iReadBuff, this.m_source.getReadBuff());
        } else if (sAction.equals("dbmsLibraryChanged")) {
            SASLibrary mdoLibrary = this.m_source.getUploadLibrary();
            this.setPropertyValueImpl(this.m_iUploadTableLibrary, mdoLibrary == null ? "" : mdoLibrary);
        } else if (sAction.equals("preUploadActionChanged")) {
            this.setPropertyValueImpl(this.m_iPreUploadActions, this.m_source.getPreUploadAction());
        } else if (sAction.equals("uploadBulkloadChanged")) {
            this.setPropertyValueImpl(this.m_iUploadBulkload, this.m_source.isUploadWithBulkload());
        } else if (sAction.equals("bulkloadOptionsChanged")) {
            this.setPropertyValueImpl(this.m_iBulkloadOptions, this.m_source.getBulkloadOptions());
        } else if (sAction.equals("uploadOptionsChanged")) {
            this.setPropertyValueImpl(this.m_iUploadOptions, this.m_source.getAdditionalUploadOptions());
        } else if (sAction.equals("uploadCaseSensitiveChanged")) {
            this.setPropertyValueImpl(this.m_iUploadTableCaseSensitive, this.m_source.isUploadTableCaseSensitive());
        } else if (sAction.equals("uploadSpecialCharactersChanged")) {
            this.setPropertyValueImpl(this.m_iUploadTableSpecialCharacters, this.m_source.isUploadTableSpecialCharacters());
        } else {
            super.handleChange(sAction);
        }
    }
}

