/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql;

import com.sas.metadata.remote.MdException;
import com.sas.wadmin.transforms.sql.ActionFactory;
import com.sas.wadmin.transforms.sql.model.AbstractExpression;
import com.sas.wadmin.transforms.sql.model.ClauseInterface;
import com.sas.wadmin.transforms.sql.model.CreateSelect;
import com.sas.wadmin.transforms.sql.model.From;
import com.sas.wadmin.transforms.sql.model.Join;
import com.sas.wadmin.transforms.sql.model.SQLModel;
import com.sas.wadmin.transforms.sql.model.SQLStatementInterface;
import com.sas.wadmin.transforms.sql.model.SelectResults;
import com.sas.wadmin.transforms.sql.model.SourceTable;
import com.sas.wadmin.transforms.sql.model.SourceTableInterface;
import com.sas.wadmin.transforms.sql.model.SubQuery;
import com.sas.wadmin.transforms.sql.model.TableInterface;
import com.sas.wadmin.transforms.sql.model.TargetTable;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceTree;
import com.sas.workspace.WsTreeNode;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class OutlineTreeModel
extends DefaultTreeModel {
    private static WAdminResource bundle = WAdminResource.getBundle(OutlineTreeModel.class);
    private SQLModel m_mdlSQL;
    private boolean m_bEditable;

    public OutlineTreeModel(SQLModel mdlSQL) {
        super((TreeNode)((Object)new BaseNode(mdlSQL.getName())));
        this.m_mdlSQL = mdlSQL;
    }

    public void setEditable(boolean bEditable) {
        if (this.m_bEditable == bEditable) {
            return;
        }
        this.m_bEditable = bEditable;
        Enumeration<TreeNode> enumNodes = ((DefaultMutableTreeNode)this.root).depthFirstEnumeration();
        while (enumNodes.hasMoreElements()) {
            BaseNode node = (BaseNode)((Object)enumNodes.nextElement());
            node.setChangable(bEditable);
        }
    }

    public boolean isEditable() {
        return this.m_bEditable;
    }

    public void moveDataToModel() throws MdException, RemoteException {
        WsTreeNode nodeRoot = (WsTreeNode)this.getRoot();
        this.removeAllChildren(nodeRoot);
        SQLStatementInterface stmtMain = this.m_mdlSQL.getStatement();
        this.populateModel(nodeRoot, stmtMain.getClauses());
    }

    private void removeAllChildren(WsTreeNode nodeParent) {
        int nChildren = nodeParent.getChildCount();
        if (nChildren <= 0) {
            return;
        }
        int[] aChildIndexes = new int[nChildren];
        Object[] aChildNodes = new TreeNode[nChildren];
        for (int iChild = 0; iChild < nChildren; ++iChild) {
            aChildIndexes[iChild] = iChild;
            aChildNodes[iChild] = nodeParent.getChildAt(iChild);
        }
        nodeParent.removeAllChildren();
        this.nodesWereRemoved((TreeNode)nodeParent, aChildIndexes, aChildNodes);
    }

    protected void populateModel(WsTreeNode nodeParent, List lClauses) {
        for (int iClause = 0; iClause < lClauses.size(); ++iClause) {
            CreateSelect select;
            TargetTable tblTarget;
            ClauseNode nodeChild;
            SubQuery subquery;
            int i;
            List subqueries;
            ClauseInterface clause = (ClauseInterface)lClauses.get(iClause);
            ClauseNode node = this.createNode(clause);
            node.setChangable(this.m_bEditable);
            this.appendNode(nodeParent, node);
            if (clause instanceof SelectResults) {
                subqueries = ((SelectResults)clause).getSubQueries();
                for (i = 0; i < subqueries.size(); ++i) {
                    subquery = (SubQuery)subqueries.get(i);
                    nodeChild = this.createNode(subquery);
                    nodeChild.setChangable(this.m_bEditable);
                    this.appendNode(node, nodeChild);
                    this.populateModel(nodeChild, subquery.getClauses());
                }
            }
            if (clause instanceof CreateSelect && (tblTarget = (select = (CreateSelect)clause).getTargetTable()) != null) {
                TableNode nodeTarget = this.createNode(tblTarget);
                nodeTarget.setChangable(this.m_bEditable);
                this.appendNode(node, nodeTarget);
            }
            if (clause instanceof From) {
                this.addSource(node, ((From)clause).getSource());
            }
            if (!(clause instanceof AbstractExpression)) continue;
            subqueries = ((AbstractExpression)clause).getSubQueries();
            for (i = 0; i < subqueries.size(); ++i) {
                subquery = (SubQuery)subqueries.get(i);
                nodeChild = this.createNode(subquery);
                nodeChild.setChangable(this.m_bEditable);
                this.appendNode(node, nodeChild);
                this.populateModel(nodeChild, subquery.getClauses());
            }
        }
    }

    private void addSource(WsTreeNode nodeParent, SourceTableInterface source) {
        if (source == null) {
            return;
        }
        if (source instanceof SourceTable) {
            TableNode nodeSource = this.createNode((SourceTable)source);
            nodeSource.setChangable(this.m_bEditable);
            this.appendNode(nodeParent, nodeSource);
        } else if (source instanceof Join) {
            Join join = (Join)source;
            this.addSource(nodeParent, join.getLeftSide());
            ClauseNode nodeJoin = this.createNode(join);
            nodeJoin.setChangable(this.m_bEditable);
            this.appendNode(nodeParent, nodeJoin);
            List subqueries = ((AbstractExpression)((Object)source)).getSubQueries();
            for (int i = 0; i < subqueries.size(); ++i) {
                SubQuery subquery = (SubQuery)subqueries.get(i);
                ClauseNode nodeChild = new ClauseNode(subquery);
                nodeChild.setChangable(this.m_bEditable);
                this.appendNode(nodeJoin, nodeChild);
                this.populateModel(nodeChild, subquery.getClauses());
            }
            this.addSource(nodeParent, join.getRightSide());
        } else if (source instanceof SubQuery) {
            SubQuery query = (SubQuery)source;
            ClauseNode node = this.createNode(query);
            node.setChangable(this.m_bEditable);
            this.appendNode(nodeParent, node);
            this.populateModel(node, query.getClauses());
        }
    }

    private void appendNode(WsTreeNode nodeParent, WsTreeNode nodeChild) {
        this.insertNodeInto((MutableTreeNode)nodeChild, (MutableTreeNode)nodeParent, nodeParent.getChildCount());
    }

    protected TableNode createNode(TableInterface table) {
        return new TableNode(table);
    }

    protected ClauseNode createNode(ClauseInterface clause) {
        if (clause instanceof SubQuery) {
            return new SubQueryNode((SubQuery)clause);
        }
        return new ClauseNode(clause);
    }

    public TableNode findTableNode(TableInterface table) {
        return this.findTableNode((WsTreeNode)this.getRoot(), table);
    }

    private TableNode findTableNode(WsTreeNode node, TableInterface table) {
        if (node instanceof TableNode && ((TableNode)node).getTable() == table) {
            return (TableNode)node;
        }
        for (int iChild = 0; iChild < node.getChildCount(); ++iChild) {
            TableNode nodeIt = this.findTableNode((WsTreeNode)node.getChildAt(iChild), table);
            if (nodeIt == null) continue;
            return nodeIt;
        }
        return null;
    }

    public ClauseNode findClauseNode(ClauseInterface clause) {
        return this.findClauseNode((WsTreeNode)this.getRoot(), clause);
    }

    private ClauseNode findClauseNode(WsTreeNode node, ClauseInterface clause) {
        if (node instanceof ClauseNode && ((ClauseNode)node).getClause() == clause) {
            return (ClauseNode)node;
        }
        for (int iChild = 0; iChild < node.getChildCount(); ++iChild) {
            ClauseNode nodeIt = this.findClauseNode((WsTreeNode)node.getChildAt(iChild), clause);
            if (nodeIt == null) continue;
            return nodeIt;
        }
        return null;
    }

    protected void updateClauseNode(ClauseInterface clause) {
        ClauseNode node = this.findClauseNode(clause);
        if (node != null) {
            node.refresh();
            this.nodeChanged((TreeNode)((Object)node));
        }
    }

    protected void updateTableNode(TableInterface table) {
        TableNode node = this.findTableNode(table);
        if (node != null) {
            node.refresh();
            this.nodeChanged((TreeNode)((Object)node));
        }
    }

    protected static class TableNode
    extends BaseNode {
        private static final String VIEW_TYPE = "View";
        private static final Icon PHYSICALTABLEICON;
        private static final Icon PHYSICALTABLEVIEWICON;
        private static final Icon WORKTABLEICON;
        private static final Icon WORKTABLEVIEWICON;
        private TableInterface m_table;

        public TableNode(TableInterface table) {
            super(table.getDisplayTableName());
            this.m_table = table;
        }

        public TableInterface getTable() {
            return this.m_table;
        }

        @Override
        public Icon getIcon(boolean bExpanded) {
            try {
                String sType = this.m_table.getDataTable().getCMetadataType();
                boolean bView = this.m_table.isTableAView();
                if (sType.equals("PhysicalTable")) {
                    return bView ? PHYSICALTABLEVIEWICON : PHYSICALTABLEICON;
                }
                if (sType.equals("WorkTable")) {
                    return bView ? WORKTABLEVIEWICON : WORKTABLEICON;
                }
                return null;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return null;
            }
        }

        public void addPopupMenuItems(JPopupMenu menuPopup) {
            Action[] aActions = ActionFactory.getInstance().createTableActions(this.m_table, this.isChangable());
            ActionFactory.addActionsToPopupMenu(menuPopup, aActions);
        }

        private void refresh() {
            this.setName(this.m_table.getDisplayTableName());
        }

        static {
            bundle;
            PHYSICALTABLEICON = WAdminResource.getTypeIcon((String)"PhysicalTable", (boolean)true);
            bundle;
            PHYSICALTABLEVIEWICON = WAdminResource.getTypeIcon((String)"PhysicalTableView", (boolean)true);
            bundle;
            WORKTABLEICON = WAdminResource.getTypeIcon((String)"WorkTable", (boolean)true);
            bundle;
            WORKTABLEVIEWICON = WAdminResource.getTypeIcon((String)"WorkTableView", (boolean)true);
        }
    }

    protected static class SubQueryNode
    extends ClauseNode {
        public SubQueryNode(SubQuery subQuery) {
            super(subQuery);
        }

        @Override
        protected void refresh() {
            String sName = this.getClause().getName();
            String sAlias = ((SubQuery)this.getClause()).getAlias();
            if (sAlias.length() != 0) {
                sName = bundle.formatString("OutlineTreeModel.SubQueryNode.NameAndAlias.fmt.txt", (Object)sName, (Object)sAlias);
            }
            this.setName(sName);
        }
    }

    protected static class ClauseNode
    extends BaseNode {
        private ClauseInterface m_clause;

        public ClauseNode(ClauseInterface clause) {
            super(clause.getName());
            this.m_clause = clause;
            this.refresh();
        }

        public ClauseInterface getClause() {
            return this.m_clause;
        }

        @Override
        public Icon getIcon(boolean bExpanded) {
            if (this.m_clause instanceof CreateSelect || this.m_clause instanceof From) {
                return super.getIcon(bExpanded);
            }
            return this.m_clause.getIcon();
        }

        public void addPopupMenuItems(JPopupMenu menuPopup) {
            Action[] aActions = ActionFactory.getInstance().createClauseActions(this.m_clause, this.isChangable());
            ActionFactory.addActionsToPopupMenu(menuPopup, aActions);
        }

        protected void refresh() {
            String sName = this.m_clause.getName();
            String sDescription = this.m_clause.getDescription();
            if (sDescription.length() != 0) {
                sName = bundle.formatString("OutlineTreeModel.ClauseNode.NameAndDescription.fmt.txt", (Object)sName, (Object)sDescription);
            }
            this.setName(sName);
        }
    }

    private static class BaseNode
    extends WsTreeNode {
        private boolean m_bChangable;

        public BaseNode(String sName) {
            super(sName);
        }

        public void setChangable(boolean bChangable) {
            this.m_bChangable = bChangable;
        }

        public boolean isChangable() {
            return this.m_bChangable;
        }

        public Icon getIcon(boolean bExpanded) {
            return bExpanded ? WorkspaceTree.getOpenedFolderIcon() : WorkspaceTree.getClosedFolderIcon();
        }
    }
}

