/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql;

import com.sas.metadata.remote.MdException;
import com.sas.wadmin.transforms.sql.TableViewTreeModel;
import com.sas.wadmin.transforms.sql.model.AbstractTable;
import com.sas.wadmin.transforms.sql.model.GroupBy;
import com.sas.wadmin.transforms.sql.model.OrderBy;
import com.sas.wadmin.transforms.sql.model.OrderByColumn;
import com.sas.wadmin.transforms.sql.model.TableColumn;
import com.sas.wadmin.visuals.properties.AbstractPropertiesModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsEnumeratedTableColumn;
import com.sas.workspace.WsMetadataTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.visuals.dualselector.DefaultSelectorTableModel;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class OrderByTableModel
extends DefaultSelectorTableModel {
    private static final WAdminResource bundle = WAdminResource.getBundle(OrderByTableModel.class);
    private static final String DEFAULTCOLUMNORDER = OrderBy.DEFAULT_SORT_ORDER;
    private static final String DEFAULTCOLUMNREFERENCE = GroupBy.DEFAULT_COLUMN_REFERENCE;
    protected static final int TABLE_COL = 0;
    protected static final int COLUMN_COL = 1;
    protected static final int ASC_DESC_COL = 2;
    protected static final int COLUMN_REF_COL = 3;
    protected static final int ORDERBYCOLUMN_COL = 4;
    private OrderBy m_orderBy;
    private List m_orderByColumns;

    public OrderByTableModel(OrderBy orderBy) {
        this.m_aColumns = new WsAbstractTableColumn[5];
        this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("OrderByTableModel.TableName.txt"), 75);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("OrderByTableModel.ColumnName.txt"), 100);
        this.m_aColumns[2] = new cListTableColumn(2, bundle.getString("OrderByTableModel.SortOrder.txt"), 75, OrderBy.getSortOrderTranslatedValues(), OrderBy.getSortOrderUnTranslatedValues(), DEFAULTCOLUMNORDER);
        this.m_aColumns[3] = new cListTableColumn(3, bundle.getString("OrderByTableModel.ColumnRef.txt"), 75, GroupBy.getColumnReferenceTranslatedValues(), GroupBy.getColumnReferenceUnTranslatedValues(), DEFAULTCOLUMNREFERENCE);
        this.m_aColumns[4] = new WsMetadataTableColumn();
        this.m_aColumns[0].setEditable(false);
        this.m_aColumns[1].setEditable(false);
        this.m_orderBy = orderBy;
    }

    protected List createRowValues(Object obj) {
        if (obj instanceof TableViewTreeModel.cColumnTreeNode) {
            String sColName = ((WsTreeNode)obj).getName();
            TableViewTreeModel.cColumnTreeNode columnTreeNode = (TableViewTreeModel.cColumnTreeNode)((WsTreeNode)obj);
            TableColumn selectedTableColumn = columnTreeNode.getTableColumn();
            AbstractTable selectedTable = columnTreeNode.getTable();
            String sTableName = selectedTable.getDataTableName();
            OrderByColumn orderByColumn = new OrderByColumn(selectedTableColumn, selectedTable, this.m_orderBy);
            this.m_orderBy.addOrderByColumn(orderByColumn);
            ArrayList<Object> lRowValues = new ArrayList<Object>();
            lRowValues.add(sTableName);
            lRowValues.add(sColName);
            lRowValues.add(DEFAULTCOLUMNORDER);
            lRowValues.add(DEFAULTCOLUMNREFERENCE);
            lRowValues.add(orderByColumn);
            return lRowValues;
        }
        if (obj instanceof List) {
            ArrayList lRowValues = new ArrayList();
            lRowValues = (ArrayList)obj;
            return lRowValues;
        }
        return null;
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public void moveDataToModel() throws MdException, RemoteException {
        super.clear();
        this.m_orderByColumns = this.m_orderBy.getOrderByColumns();
        for (int index = 0; index < this.m_orderByColumns.size(); ++index) {
            OrderByColumn orderByColumn = (OrderByColumn)this.m_orderByColumns.get(index);
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(orderByColumn.getTable().getDataTableName());
            row.add(orderByColumn.getTableColumn().getName());
            row.add(orderByColumn.getSortOrder());
            if (orderByColumn.getDisplayInteger()) {
                row.add("position");
            } else {
                row.add("name");
            }
            row.add(orderByColumn);
            this.m_lData.add(row);
            ++this.m_nRowInstances;
        }
        this.fireTableModelPopulated();
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (this.m_orderBy != null) {
            this.m_orderBy.moveDataToStore();
        }
    }

    public Object getRow(int iRow) {
        String sTable = (String)this.getValueAt(iRow, 0);
        String sName = (String)this.getValueAt(iRow, 1);
        String sOrder = (String)this.getValueAt(iRow, 2);
        String sRef = (String)this.getValueAt(iRow, 3);
        OrderByColumn orderByColumn = (OrderByColumn)this.getValueAt(iRow, 4);
        ArrayList<Object> lRowValues = new ArrayList<Object>();
        lRowValues.add(sTable);
        lRowValues.add(sName);
        lRowValues.add(sOrder);
        lRowValues.add(sRef);
        lRowValues.add(orderByColumn);
        return lRowValues;
    }

    public void deleteRow(int iRow) {
        List lDeletedRowValues = (List)this.m_lData.remove(iRow);
        this.fireTableRowDeleted(iRow, lDeletedRowValues);
        this.m_orderBy.removeOrderByColumn(iRow);
    }

    public void clear() {
        super.clear();
        List orderByCols = this.m_orderBy.getOrderByColumns();
        int size = orderByCols.size();
        for (int i = size - 1; i > -1; --i) {
            this.m_orderBy.removeOrderByColumn((OrderByColumn)orderByCols.get(i));
        }
    }

    public void setRowValues(int iRow, List lRowValues) {
        List lData = (List)this.m_lData.get(iRow);
        lData.clear();
        lData.addAll(lRowValues);
        this.fireTableRowsUpdated(iRow, iRow);
        OrderByColumn orderByCol = (OrderByColumn)lRowValues.get(4);
        this.m_orderBy.moveOrderByColumn(this.m_orderBy.getIndexOfOrderByColumn(orderByCol), iRow);
    }

    public void setValueAt(Object value, int iRow, int iCol) {
        List lRow = (List)this.m_lData.get(iRow);
        lRow.set(iCol, value);
        this.fireTableCellUpdated(iRow, iCol);
        OrderByColumn orderByColumn = (OrderByColumn)this.getValueAt(iRow, 4);
        if (iCol == 2) {
            orderByColumn.setSortOrder((String)value);
        }
        if (iCol == 3) {
            orderByColumn.setDisplayInteger(((String)value).equalsIgnoreCase("position"));
        }
        this.m_orderBy.removeOrderByColumn(orderByColumn);
        this.m_orderBy.addOrderByColumn(iRow, orderByColumn);
    }

    public int getColumnCount() {
        return this.m_aColumns.length - 1;
    }

    protected class cListTableColumn
    extends WsEnumeratedTableColumn {
        protected List m_unTranslatedValues;
        protected List m_translatedValues;

        public cListTableColumn(int iModelIndex, String sName, int cxWidth, List translatedValues, List unTranslatedValues, String sDefault) {
            super(iModelIndex, sName, cxWidth, translatedValues.toArray(new String[translatedValues.size()]), sDefault);
            this.m_translatedValues = translatedValues;
            this.m_unTranslatedValues = unTranslatedValues;
        }

        public TableCellEditor createCellEditor() {
            return new AbstractPropertiesModel.DefaultListTableCellEditor(this.m_translatedValues, this.m_unTranslatedValues);
        }

        protected TableCellRenderer createCellRenderer() {
            return new AbstractPropertiesModel.DefaultListTableCellRenderer(this.m_translatedValues, this.m_unTranslatedValues);
        }
    }
}

