/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sql;

import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.MdException;
import com.sas.swing.visuals.tableview.TableRowModel;
import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.swing.visuals.tableview.TableRowModelListener;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.wadmin.transforms.sql.ChooseValuesPanel;
import com.sas.wadmin.transforms.sql.ColumnSelectorDialog;
import com.sas.wadmin.transforms.sql.SQLExpressionBuilderTab;
import com.sas.wadmin.transforms.sql.TableViewTreeModel;
import com.sas.wadmin.transforms.sql.model.CaseExpression;
import com.sas.wadmin.transforms.sql.model.CaseStatement;
import com.sas.wadmin.transforms.sql.model.CaseStatementChangeEvent;
import com.sas.wadmin.transforms.sql.model.CaseStatementChangeListener;
import com.sas.wadmin.transforms.sql.model.OperandInterface;
import com.sas.wadmin.transforms.sql.model.SimpleExpressionInterface;
import com.sas.wadmin.transforms.sql.model.SubQuery;
import com.sas.wadmin.transforms.sql.model.TableColumn;
import com.sas.wadmin.transforms.sql.model.TextOperand;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAUndoManager;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsDefaultCellEditor;
import com.sas.workspace.WsDefaultTableRowModel;
import com.sas.workspace.WsDropMenuTableCellEditor;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.undo.UndoManager;

public class CasePanel
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(CasePanel.class);
    private static final int SCROLL_PANE_WIDTH = 400;
    private static final int SCROLL_PANE_HEIGHT = 150;
    private static final int WhenColumn = 0;
    private static final int ThenColumn = 1;
    private WsTable m_caseTable;
    private CaseTableModel m_caseTableModel;
    private CaseTableRowModel m_caseTableRowModel;
    private WATextField m_operandField;
    private WATextField m_elseField;
    private WsAbstractAction m_chooseColumnAction;
    private WsAbstractAction m_newAction;
    private WsAbstractAction m_deleteAction;
    private WsAbstractAction m_undoAction;
    private WsAbstractAction m_redoAction;
    private WsAbstractAction m_moveUpAction;
    private WsAbstractAction m_moveDownAction;
    private WsAbstractAction m_advancedExpressionAction;
    private WsAbstractAction m_advancedElseAction;
    private WsAbstractAction m_chooseValuesAction;
    private TableSelectionListener m_caseTableSelectionListener;
    private OperandFieldListener m_operandFieldListener;
    private TableRowModelListener m_caseTableRowModelListener;
    private boolean m_ignoreCellEditing;
    private String m_settingsPrefix;
    private CaseStatement m_caseStatement;

    public CasePanel(CaseStatement caseStatement) {
        this.m_caseStatement = caseStatement;
        this.m_ignoreCellEditing = false;
        this.m_settingsPrefix = "SQL.CasePanel";
        this.setHelpProduct("wdb");
        this.setHelpTopic("sql_case");
        this.initialize();
    }

    protected void initialize() {
        this.m_operandField = new WATextField();
        JLabel operandLabel = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_operandField, (WAdminResource)bundle, (String)"CasePanel.Operand");
        this.m_operandFieldListener = new OperandFieldListener();
        this.m_operandField.addActionListener((ActionListener)this.m_operandFieldListener);
        this.m_operandField.addFocusListener((FocusListener)this.m_operandFieldListener);
        this.m_chooseColumnAction = new ChooseColumnAction();
        JButton columnButton = new JButton((Action)this.m_chooseColumnAction);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout(10, 10));
        topPanel.add((Component)operandLabel, "West");
        topPanel.add((Component)this.m_operandField, "Center");
        topPanel.add((Component)columnButton, "East");
        this.m_caseTableModel = new CaseTableModel();
        this.m_caseTable = new CaseTable(this.m_caseTableModel);
        JScrollPane caseTablePane = new JScrollPane((Component)this.m_caseTable);
        caseTablePane.setPreferredSize(new Dimension(400, 150));
        caseTablePane.setVerticalScrollBarPolicy(22);
        this.m_caseTable.setColumnHidingEnabled(false);
        this.m_caseTable.setColumnHoldingEnabled(false);
        this.m_caseTable.setColumnsReorderable(false);
        this.m_caseTable.setSortingEnabled(false);
        this.m_caseTable.setColumnHeaderVisible(true);
        this.m_caseTable.setRowHeaderVisible(true);
        this.m_caseTable.setRowHoldingEnabled(false);
        this.m_caseTable.setViewportPopupMenuEnabled(false);
        this.m_caseTable.setOriginPopupMenuEnabled(false);
        this.m_caseTable.setCellSelectionEnabled(true);
        this.m_caseTable.setColumnSelectionAllowed(false);
        this.m_caseTable.setRowSelectionAllowed(false);
        this.m_caseTable.setAutoResizeMode(1);
        this.m_caseTable.setSelectionMode(2);
        this.m_caseTable.setEditable(true);
        this.m_caseTable.setToolTipText(bundle.getString("CasePanel.CaseTable.ToolTip.txt"));
        this.m_caseTable.setUndoManager((UndoManager)this.waum);
        this.m_caseTableRowModel = new CaseTableRowModel((TableView)this.m_caseTable);
        this.m_caseTable.setRowModel((TableRowModel)this.m_caseTableRowModel);
        this.m_caseTableRowModelListener = new CaseTableRowModelListener();
        this.m_caseTable.getRowModel().addRowModelListener(this.m_caseTableRowModelListener);
        this.m_caseTableSelectionListener = new TableSelectionListener();
        this.m_caseTable.getSelectionModel().addListSelectionListener(this.m_caseTableSelectionListener);
        WsDropMenuTableCellEditor expressionMenuCellEditor = new WsDropMenuTableCellEditor();
        expressionMenuCellEditor.setDropMenu(this.createExpressionMenu());
        this.m_caseTable.getColumnModel().getColumn(0).setCellEditor((TableCellEditor)expressionMenuCellEditor);
        this.m_caseTable.getColumnModel().getColumn(1).setCellEditor((TableCellEditor)expressionMenuCellEditor);
        this.m_caseTable.restoreSettings(this.getSettingsPrefix());
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout(10, 10));
        this.m_moveUpAction = new MoveUpAction();
        JButton upButton = new JButton((Action)this.m_moveUpAction);
        upButton.setPreferredSize(new Dimension(25, 25));
        this.m_moveDownAction = new MoveDownAction();
        JButton downButton = new JButton((Action)this.m_moveDownAction);
        downButton.setPreferredSize(new Dimension(25, 25));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BorderLayout(10, 0));
        JPanel leftButtonPanel = new JPanel();
        leftButtonPanel.setLayout((LayoutManager)new WsButtonsLayout());
        JPanel middleButtonPanel = new JPanel();
        middleButtonPanel.setLayout((LayoutManager)new WsButtonsLayout());
        JPanel rightButtonPanel = new JPanel();
        rightButtonPanel.setLayout((LayoutManager)new WsButtonsLayout());
        leftButtonPanel.add(upButton);
        leftButtonPanel.add(downButton);
        this.m_chooseValuesAction = new ChooseValuesAction();
        JButton chooseValuesButton = WsUIUtilities.createTextButton((WsAbstractAction)this.m_chooseValuesAction);
        chooseValuesButton.setVisible(true);
        this.m_newAction = new NewAction();
        JButton newFilterButton = new JButton((Action)this.m_newAction);
        this.m_deleteAction = new DeleteAction();
        JButton deleteButton = new JButton((Action)this.m_deleteAction);
        this.m_caseTable.getActionMap().put(this.m_deleteAction, (Action)this.m_deleteAction);
        this.m_caseTable.getInputMap().put(KeyStroke.getKeyStroke(127, 0), this.m_deleteAction);
        rightButtonPanel.add(chooseValuesButton);
        rightButtonPanel.add(newFilterButton);
        rightButtonPanel.add(deleteButton);
        buttonPanel.add((Component)leftButtonPanel, "West");
        buttonPanel.add((Component)middleButtonPanel, "Center");
        buttonPanel.add((Component)rightButtonPanel, "East");
        this.setLayout(new BorderLayout(10, 10));
        JPanel bottomPanel = new JPanel(new BorderLayout(10, 10));
        bottomPanel.add((Component)buttonPanel, "North");
        tablePanel.add((Component)caseTablePane, "Center");
        tablePanel.add((Component)bottomPanel, "South");
        JPanel elsePanel = new JPanel(new BorderLayout(10, 10));
        this.m_elseField = new WATextField();
        JLabel elseLabel = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_elseField, (WAdminResource)bundle, (String)"CasePanel.Else");
        elsePanel.add((Component)elseLabel, "West");
        elsePanel.add((Component)this.m_elseField, "Center");
        this.m_elseField.addActionListener((ActionListener)this.m_operandFieldListener);
        this.m_elseField.addFocusListener((FocusListener)this.m_operandFieldListener);
        this.m_advancedElseAction = new AdvancedElseAction();
        JButton advancedButton = new JButton((Action)this.m_advancedElseAction);
        elsePanel.add((Component)advancedButton, "East");
        this.add(topPanel, "North");
        this.add(tablePanel, "Center");
        this.add(elsePanel, "South");
        this.addUndoAndRedo();
    }

    protected JPopupMenu createExpressionMenu() {
        JPopupMenu menu = new JPopupMenu();
        this.m_advancedExpressionAction = new AdvancedExpressionAction();
        menu.add(new JMenuItem((Action)this.m_advancedExpressionAction));
        return menu;
    }

    protected void addUndoAndRedo() {
        this.m_undoAction = new UndoAction();
        this.m_redoAction = new RedoAction();
        KeyStroke undoKey = KeyStroke.getKeyStroke(90, 2);
        KeyStroke redoKey = KeyStroke.getKeyStroke(89, 2);
        this.getActionMap().put(this.m_undoAction, (Action)this.m_undoAction);
        this.getActionMap().put(this.m_redoAction, (Action)this.m_redoAction);
        this.getInputMap(2).put(undoKey, this.m_undoAction);
        this.getInputMap(2).put(redoKey, this.m_redoAction);
    }

    public void populateStore() throws MdException, RemoteException {
        this.m_caseTableModel.populateStore();
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        OperandInterface caseOperand = this.m_caseStatement.getCaseOperand();
        if (caseOperand != null) {
            this.m_operandField.setText(this.m_caseStatement.getCaseOperand().toString());
        }
        this.m_caseTableModel.moveDataToModel();
        OperandInterface elseOperand = this.m_caseStatement.getElseOperand();
        if (elseOperand != null) {
            this.m_elseField.setText(this.m_caseStatement.getElseOperand().toString());
        }
        if (this.m_caseTable.getRowCount() > 0) {
            this.m_caseTable.selectRow(0);
        }
        this.updateActions();
        this.updateComponents();
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_caseStatement.moveDataToStore();
        this.setDataChanged(false);
    }

    public boolean validateData() {
        this.m_caseTable.stopCellEditing();
        if (this.m_caseTableModel.getRowCount() <= 0) {
            MessageUtil.displayMessage((String)bundle.getString("CasePanel.Error.NoExpressions.txt"), (int)0);
            return false;
        }
        for (int row = 0; row < this.m_caseTableModel.getRowCount(); ++row) {
            String whenOperand = (String)this.m_caseTableModel.getValueAt(row, 0);
            String thenOperand = (String)this.m_caseTableModel.getValueAt(row, 1);
            if (whenOperand == null || whenOperand.length() <= 0) {
                MessageUtil.displayMessage((String)bundle.getString("CasePanel.Error.EmptyWhenOperand.txt"), (int)0);
                this.m_caseTable.selectCell(row, 0);
                return false;
            }
            if (thenOperand != null && thenOperand.length() > 0) continue;
            MessageUtil.displayMessage((String)bundle.getString("CasePanel.Error.EmptyThenOperand.txt"), (int)0);
            this.m_caseTable.selectCell(row, 1);
            return false;
        }
        OperandInterface caseOperand = this.m_caseStatement.getCaseOperand();
        if (caseOperand != null && !caseOperand.validate()) {
            MessageUtil.displayMessage((String)bundle.formatString("CasePanel.Error.InvalidCaseOperand.txt", (Object)Integer.toString(255)), (int)0);
            return false;
        }
        OperandInterface elseOperand = this.m_caseStatement.getElseOperand();
        if (elseOperand != null && !elseOperand.validate()) {
            MessageUtil.displayMessage((String)bundle.formatString("CasePanel.Error.InvalidElseOperand.txt", (Object)Integer.toString(255)), (int)0);
            return false;
        }
        if (!this.m_caseStatement.validate()) {
            List badExpressions = this.m_caseStatement.getInvalidExpresionPositions();
            int[] rows = new int[badExpressions.size()];
            StringBuffer list = new StringBuffer();
            for (int i = 0; i < badExpressions.size(); ++i) {
                Integer row = (Integer)badExpressions.get(i);
                int value = row + 1;
                list.append(value);
                if (i < badExpressions.size() - 1) {
                    list.append(", ");
                }
                rows[i] = row;
            }
            MessageUtil.displayMessage((String)bundle.formatString("CasePanel.Error.InvalidOperand.txt", (Object)list.toString(), (Object)Integer.toString(255)), (int)0);
            this.m_caseTable.selectRows(rows);
            return false;
        }
        return true;
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.updateComponents();
    }

    protected void updateActions() {
        int[] selectedRows = this.m_caseTable.getSelectedRowsFromSelectedCells();
        boolean firstRowSelected = false;
        boolean lastRowSelected = false;
        boolean rowsReorderable = this.m_caseTable.isRowsReorderable();
        for (int index = 0; index < selectedRows.length; ++index) {
            if (selectedRows[index] == 0) {
                firstRowSelected = true;
            }
            if (selectedRows[index] != this.m_caseTable.getRowCount() - 1) continue;
            lastRowSelected = true;
        }
        this.m_newAction.setEnabled(this.isEditable());
        this.m_deleteAction.setEnabled(this.isEditable() && selectedRows.length > 0);
        this.m_moveUpAction.setEnabled(this.isEditable() && selectedRows.length > 0 && !firstRowSelected && rowsReorderable);
        this.m_moveDownAction.setEnabled(this.isEditable() && selectedRows.length > 0 && !lastRowSelected && rowsReorderable);
        this.m_chooseValuesAction.setEnabled(this.isEditable());
    }

    private void updateComponents() {
        this.m_caseTable.setEnabled(this.isEditable());
    }

    public void updateWorkspaceUIComponents(boolean active) {
        super.updateWorkspaceUIComponents(active);
        this.m_newAction.setActive(active);
        this.m_deleteAction.setActive(active);
    }

    public void setInitialSelection() {
        if (this.m_caseTable.getRowCount() > 0) {
            this.m_caseTable.selectRow(0);
        }
    }

    public void setWAUndoManager(WAUndoManager undoManager) {
        super.setWAUndoManager(undoManager);
        this.m_caseTable.setUndoManager((UndoManager)undoManager);
    }

    public boolean ignoreCellEditing() {
        return this.m_ignoreCellEditing;
    }

    public void setOperand(String value) {
        TextOperand textOp = new TextOperand((SimpleExpressionInterface)this.m_caseStatement, value);
        this.m_operandField.setText(textOp.getFullNamedText());
        this.m_caseStatement.undoableSetCaseOperand(textOp);
    }

    public String getElse() {
        return this.m_elseField.getText();
    }

    public void setElse(String value) {
        this.m_elseField.setText(value);
        this.m_caseStatement.undoableSetElseOperand(new TextOperand((SimpleExpressionInterface)this.m_caseStatement, value));
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_caseTable.saveSettings(this.getSettingsPrefix());
        this.m_operandField.removeActionListener((ActionListener)this.m_operandFieldListener);
        this.m_operandField.removeFocusListener((FocusListener)this.m_operandFieldListener);
        this.m_caseTable.getRowModel().removeRowModelListener(this.m_caseTableRowModelListener);
        this.m_caseTable.getSelectionModel().removeListSelectionListener(this.m_caseTableSelectionListener);
        this.m_elseField.removeActionListener((ActionListener)this.m_operandFieldListener);
        this.m_elseField.removeFocusListener((FocusListener)this.m_operandFieldListener);
    }

    public String getSettingsPrefix() {
        return this.m_settingsPrefix;
    }

    public void setSettingsPrefix(String prefix) {
        this.m_settingsPrefix = prefix;
    }

    public void displayCaseStatement() {
        System.out.println("Saving:");
        OperandInterface operand = this.m_caseStatement.getCaseOperand();
        System.out.println("CASE " + (operand != null ? operand.toString() : ""));
        List expressions = this.m_caseStatement.getExpressions();
        for (int index = 0; expressions != null && index < expressions.size(); ++index) {
            CaseExpression expression = (CaseExpression)expressions.get(index);
            System.out.println("WHEN " + expression.getWhenOperand().toString() + " THEN " + expression.getThenOperand().toString());
        }
        OperandInterface elseOperand = this.m_caseStatement.getElseOperand();
        if (elseOperand != null && elseOperand.toString().length() > 0) {
            System.out.println("ELSE " + elseOperand.toString());
        }
    }

    protected void onSelectColumn() {
        TableViewTreeModel mdlTableView = new TableViewTreeModel(this.m_caseStatement);
        ColumnSelectorDialog csDialog = new ColumnSelectorDialog(mdlTableView);
        csDialog.setResizable(true);
        csDialog.show();
        if (csDialog.getReturnValue() == 1) {
            String name = csDialog.getSelectedTableColumnName();
            this.setOperand(name);
        }
    }

    protected class ChooseValuesAction
    extends WsAbstractAction {
        public ChooseValuesAction() {
            super(bundle, "CasePanel.ChooseValues.Import", 0);
        }

        public void actionPerformed(ActionEvent e) {
            OperandInterface op = CasePanel.this.m_caseStatement.getCaseOperand();
            if (op instanceof TextOperand) {
                List selValues;
                TextOperand textOp = (TextOperand)op;
                Column col = null;
                int i = 0;
                List colObjs = textOp.getTableColumns();
                int size = colObjs.size();
                if (i < size) {
                    TableColumn tcol = (TableColumn)colObjs.get(i);
                    col = tcol.getDataTableColumn();
                }
                if (col == null) {
                    MessageUtil.displayMessage((String)bundle.getString("CasePanel.ColumnNotDetermined.Error.txt"), (int)0);
                    return;
                }
                WsAppServer appServer = CasePanel.this.m_caseStatement.getSQLModel().getWsAppServer();
                if (col != null && appServer != null && (selValues = ChooseValuesPanel.showChooseValuesDialog(appServer, col, "sql_import_values")) != null) {
                    int selSize = selValues.size();
                    for (int i2 = 0; i2 < selSize; ++i2) {
                        ArrayList newRow = new ArrayList();
                        newRow.add(selValues.get(i2));
                        newRow.add("");
                        CasePanel.this.m_caseTable.undoableInsertRowAfterLastSelectedRow(newRow);
                    }
                }
            }
        }
    }

    protected class RedoAction
    extends WsAbstractAction {
        protected RedoAction() {
        }

        public void actionPerformed(ActionEvent e) {
            WAUndoManager undoManager = CasePanel.this.getWAUndoManager();
            if (undoManager.canRedo()) {
                undoManager.redo();
            }
        }
    }

    protected class UndoAction
    extends WsAbstractAction {
        protected UndoAction() {
        }

        public void actionPerformed(ActionEvent e) {
            WAUndoManager undoManager = CasePanel.this.getWAUndoManager();
            if (undoManager.canUndo()) {
                undoManager.undo();
            }
        }
    }

    protected class AdvancedExpressionAction
    extends WsAbstractAction {
        public AdvancedExpressionAction() {
            super(bundle, "CasePanel.AdvancedMenu", 0);
        }

        public void actionPerformed(ActionEvent e) {
            SQLExpressionBuilderTab expressionBuilderTab = new SQLExpressionBuilderTab(CasePanel.this.m_caseStatement.getParentClause());
            WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("ExpressionBuilder.Title.txt"), true);
            dialog.setMainPanel((WAPanel)expressionBuilderTab);
            dialog.setResizable(true);
            int row = CasePanel.this.m_caseTable.getCurrentRow();
            int column = CasePanel.this.m_caseTable.getCurrentColumn();
            CasePanel.this.m_caseTable.stopCellEditing();
            String text = (String)CasePanel.this.m_caseTable.getValueAt(row, column);
            if (text != null) {
                expressionBuilderTab.setExpression(text);
            }
            dialog.show();
            if (dialog.getReturnValue() == 1) {
                CasePanel.this.m_caseTable.setValueAt((Object)expressionBuilderTab.getExpression(), row, column);
            }
        }
    }

    protected class AdvancedElseAction
    extends WsAbstractAction {
        public AdvancedElseAction() {
            super(bundle, "CasePanel.Advanced", 0);
        }

        public void actionPerformed(ActionEvent e) {
            SQLExpressionBuilderTab expressionBuilderTab = new SQLExpressionBuilderTab(CasePanel.this.m_caseStatement.getParentClause());
            WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("ExpressionBuilder.Title.txt"), true);
            dialog.setMainPanel((WAPanel)expressionBuilderTab);
            dialog.setResizable(true);
            String text = CasePanel.this.getElse();
            if (text != null) {
                expressionBuilderTab.setExpression(text);
            }
            dialog.show();
            if (dialog.getReturnValue() == 1) {
                CasePanel.this.setElse(expressionBuilderTab.getExpression());
            }
        }
    }

    protected class CaseTableRowModelListener
    implements TableRowModelListener {
        protected CaseTableRowModelListener() {
        }

        public void rowMoved(TableRowModelEvent e) {
            CasePanel.this.m_caseTableModel.moveExpression(e.getFromIndex(), e.getToIndex());
        }

        public void rowMarginChanged(ChangeEvent e) {
        }

        public void rowSelectionChanged(ListSelectionEvent e) {
            CasePanel.this.updateActions();
        }
    }

    protected class CaseTableRowModel
    extends WsDefaultTableRowModel {
        public CaseTableRowModel(TableView table) {
            super(table);
        }

        public void moveRow(int rowIndex, int newIndex) {
            int rowCount = this.getRowCount();
            if (rowIndex < 0 || rowIndex >= rowCount || newIndex < 0 || newIndex >= rowCount) {
                throw new IllegalArgumentException("moveRow() - Index out of range");
            }
            boolean selected = this.selectionModel.isSelectedIndex(rowIndex);
            this.selectionModel.removeIndexInterval(rowIndex, rowIndex);
            this.selectionModel.insertIndexInterval(newIndex, 1, true);
            if (selected) {
                this.selectionModel.addSelectionInterval(newIndex, newIndex);
            } else {
                this.selectionModel.removeSelectionInterval(newIndex, newIndex);
            }
            this.fireRowMoved(new TableRowModelEvent((TableRowModel)this, rowIndex, newIndex));
        }

        public int convertRowIndexToModel(int viewRowIndex) {
            return viewRowIndex;
        }

        public int convertRowIndexToView(int modelRowIndex) {
            return modelRowIndex;
        }
    }

    protected class OperandFieldListener
    implements ActionListener,
    FocusListener {
        protected OperandFieldListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object source = event.getSource();
            if (source == CasePanel.this.m_operandField) {
                CasePanel.this.m_caseStatement.setCaseOperand(new TextOperand((SimpleExpressionInterface)CasePanel.this.m_caseStatement, CasePanel.this.m_operandField.getText()));
            } else if (source == CasePanel.this.m_elseField) {
                CasePanel.this.m_caseStatement.undoableSetElseOperand(new TextOperand((SimpleExpressionInterface)CasePanel.this.m_caseStatement, CasePanel.this.m_elseField.getText()));
            }
        }

        @Override
        public void focusGained(FocusEvent event) {
        }

        @Override
        public void focusLost(FocusEvent event) {
            Component source = event.getComponent();
            if (source == CasePanel.this.m_operandField) {
                CasePanel.this.m_caseStatement.undoableSetCaseOperand(new TextOperand((SimpleExpressionInterface)CasePanel.this.m_caseStatement, CasePanel.this.m_operandField.getText()));
            } else if (source == CasePanel.this.m_elseField) {
                CasePanel.this.m_caseStatement.undoableSetElseOperand(new TextOperand((SimpleExpressionInterface)CasePanel.this.m_caseStatement, CasePanel.this.m_elseField.getText()));
            }
        }
    }

    protected class CaseStatementListener
    implements CaseStatementChangeListener {
        protected CaseStatementListener() {
        }

        @Override
        public void caseStatementChanged(CaseStatementChangeEvent event) {
        }
    }

    protected class DeleteAction
    extends WsAbstractAction {
        public DeleteAction() {
            super(bundle, "CasePanel.Delete", 0);
            this.setMenuSupportId("delete");
        }

        public void actionPerformed(ActionEvent e) {
            CasePanel.this.m_caseTable.undoableDeleteSelectedRows();
            CasePanel.this.setDataChanged(true);
        }
    }

    protected class NewAction
    extends WsAbstractAction {
        public NewAction() {
            super(bundle, "CasePanel.New", 0);
            this.setMenuSupportId("new");
        }

        public void actionPerformed(ActionEvent e) {
            CasePanel.this.m_caseTable.undoableInsertNewRowAfterLastSelectedRow();
        }
    }

    protected class MoveDownAction
    extends WsAbstractAction {
        public MoveDownAction() {
            super(bundle, "CasePanel.MoveDown", 18);
        }

        public void actionPerformed(ActionEvent e) {
            CasePanel.this.m_caseTable.undoableMoveSelectedRows(1);
        }
    }

    protected class MoveUpAction
    extends WsAbstractAction {
        public MoveUpAction() {
            super(bundle, "CasePanel.MoveUp", 18);
        }

        public void actionPerformed(ActionEvent e) {
            CasePanel.this.m_caseTable.undoableMoveSelectedRows(-1);
        }
    }

    protected class ChooseColumnAction
    extends WsAbstractAction {
        public ChooseColumnAction() {
            super(bundle, "CasePanel.ChooseColumn", 0);
        }

        public void actionPerformed(ActionEvent e) {
            CasePanel.this.m_caseTable.stopCellEditing();
            CasePanel.this.onSelectColumn();
        }
    }

    protected class EnumeratedTableCellEditor
    extends WsDefaultCellEditor {
        protected WAComboBox m_comboBox = new WAComboBox();
        protected WsDefaultCellEditor.cEditorDelegate m_textFieldDelegate;
        protected WsDefaultCellEditor.cEditorDelegate m_comboBoxDelegate = new WsDefaultCellEditor.cComboBoxDelegate((WsDefaultCellEditor)this, (JComboBox)this.m_comboBox);

        public EnumeratedTableCellEditor() {
            this.m_comboBox.setEditable(true);
            this.initialize((JComboBox)this.m_comboBox, this.m_comboBoxDelegate);
            this.m_cmpEditor = this.m_comboBox;
            this.m_delegate = this.m_comboBoxDelegate;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean bSelected, int iRow, int iColumn) {
            this.m_delegate.setValue(value);
            return this.m_cmpEditor;
        }
    }

    protected class CenteredCellRenderer
    extends DefaultTableCellRenderer {
        public CenteredCellRenderer() {
            this.setHorizontalAlignment(0);
        }
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private int m_runs = 0;

        private TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (this.m_runs++ < 2) {
                CasePanel.this.setInitialSelection();
            }
            CasePanel.this.updateActions();
        }
    }

    private class CaseTableModel
    extends WsAbstractTableModel {
        protected static final int TOTAL_COLUMNS = 2;
        protected static final int HIDDEN_COLUMNS = 0;

        public CaseTableModel() {
            this.m_aColumns = new WsAbstractTableColumn[2];
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setHorizontalAlignment(0);
            this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("CasePanel.CaseTable.WhenColumn.txt"), 300);
            this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("CasePanel.CaseTable.ThenColumn.txt"), 300);
        }

        public void populateStore() throws MdException, RemoteException {
        }

        public void moveDataToModel() throws MdException, RemoteException {
            List expressions = CasePanel.this.m_caseStatement.getExpressions();
            if (expressions == null) {
                return;
            }
            for (int index = 0; index < expressions.size(); ++index) {
                OperandInterface thenOperand;
                CaseExpression expression = (CaseExpression)expressions.get(index);
                ArrayList<String> row = new ArrayList<String>();
                OperandInterface whenOperand = expression.getWhenOperand();
                if (whenOperand instanceof TextOperand) {
                    String text = ((TextOperand)whenOperand).getFullNamedText();
                    row.add(text != null ? text : "");
                }
                if ((thenOperand = expression.getThenOperand()) instanceof TextOperand) {
                    String text = ((TextOperand)thenOperand).getFullNamedText();
                    row.add(text != null ? text : "");
                }
                this.m_lData.add(row);
            }
            this.fireTableModelPopulated();
        }

        public void moveDataToStore() throws MdException, RemoteException {
        }

        public int getColumnCount() {
            return this.m_aColumns.length - 0;
        }

        public List createDefaultRowValues() {
            List values = super.createDefaultRowValues();
            values.set(0, "");
            values.set(1, "");
            return values;
        }

        public Object getValueAt(int row, int column) {
            List expressions = CasePanel.this.m_caseStatement.getExpressions();
            CaseExpression expression = (CaseExpression)expressions.get(row);
            switch (column) {
                case 0: {
                    OperandInterface object = expression.getWhenOperand();
                    if (object == null) {
                        return "";
                    }
                    if (object instanceof CaseStatement) {
                        return bundle.getString("ExpressionPanel.Case.txt");
                    }
                    if (object instanceof SubQuery) {
                        return bundle.getString("ExpressionPanel.Subquery.txt");
                    }
                    return object.toString();
                }
                case 1: {
                    OperandInterface object = expression.getThenOperand();
                    if (object instanceof CaseStatement) {
                        return bundle.getString("ExpressionPanel.Case.txt");
                    }
                    if (object instanceof SubQuery) {
                        return bundle.getString("ExpressionPanel.Subquery.txt");
                    }
                    return object.toString();
                }
            }
            return super.getValueAt(row, column);
        }

        public void setValueAt(Object value, int row, int column) {
            this.updateCaseExpression(value, row, column);
            super.setValueAt(value, row, column);
            CasePanel.this.updateActions();
            CasePanel.this.updateComponents();
        }

        public void addExpression(int index, List values) {
            CaseExpression expression = new CaseExpression(CasePanel.this.m_caseStatement);
            expression.setSQLModel(CasePanel.this.m_caseStatement.getSQLModel());
            expression.setParent(CasePanel.this.m_caseStatement);
            expression.setParentQuery(CasePanel.this.m_caseStatement.getParentQuery());
            expression.undoableSetWhenOperand(new TextOperand((SimpleExpressionInterface)expression, (String)values.get(0)));
            expression.undoableSetThenOperand(new TextOperand((SimpleExpressionInterface)expression, (String)values.get(1)));
            CasePanel.this.m_caseStatement.addExpression(index + 1, expression);
            CasePanel.this.setDataChanged(true);
        }

        public void updateCaseExpression(Object value, int row, int column) {
            List expressions = CasePanel.this.m_caseStatement.getExpressions();
            CaseExpression expression = (CaseExpression)expressions.get(row);
            switch (column) {
                case 0: {
                    expression.undoableSetWhenOperand(new TextOperand((SimpleExpressionInterface)expression, value.toString()));
                    break;
                }
                case 1: {
                    expression.undoableSetThenOperand(new TextOperand((SimpleExpressionInterface)expression, value.toString()));
                }
            }
            CasePanel.this.setDataChanged(true);
        }

        public void moveExpression(int oldIndex, int newIndex) {
            List caseExpressions = CasePanel.this.m_caseStatement.getExpressions();
            CaseExpression expression = (CaseExpression)caseExpressions.remove(oldIndex);
            caseExpressions.add(newIndex, expression);
            CasePanel.this.m_caseStatement.fireChangeEvent(CasePanel.this.m_caseStatement, "ExpressionChanged");
            if (oldIndex <= newIndex) {
                CasePanel.this.m_caseTableModel.fireTableRowsUpdated(oldIndex, newIndex);
            } else {
                CasePanel.this.m_caseTableModel.fireTableRowsUpdated(newIndex, oldIndex);
            }
            CasePanel.this.setDataChanged(true);
        }

        public void loadDemoData() {
            CasePanel.this.m_operandField.setText("CUSTOMER.Country");
            String[][] data = new String[][]{{"'United States'", "'North America'"}, {"'China'", "'Asia'"}, {"'Brazil'", "'South America'"}, {"'Germany'", "'Europe'"}, {"'Australia'", "'Australia'"}};
            for (int i = 0; i < data.length; ++i) {
                ArrayList<String> row = new ArrayList<String>();
                for (int j = 0; j < data[i].length; ++j) {
                    if (data[i][j] != null) {
                        row.add(data[i][j]);
                        continue;
                    }
                    row.add("");
                }
                this.m_lData.add(row);
            }
        }
    }

    protected class CaseTable
    extends WsTable {
        public CaseTable(WsAbstractTableModel model) {
            super(model);
        }

        protected void insertRowImpl(int row, List rowValues) {
            CasePanel.this.m_caseTableModel.addExpression(row, rowValues);
            super.insertRowImpl(row, rowValues);
            CasePanel.this.updateComponents();
        }

        protected void deleteRowImpl(int row) {
            CasePanel.this.m_caseStatement.undoableRemoveExpression(row);
            super.deleteRowImpl(row);
            CasePanel.this.updateComponents();
        }
    }
}

