/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.splitter;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.ITextExpression;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.splitter.IRowSelector;
import com.sas.etl.models.job.transforms.splitter.IRowSelectorTransform;
import com.sas.etl.models.job.transforms.splitter.SplitterTransformModel;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.visuals.common.ExpressionBuilderTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public class RowSelectionTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(RowSelectionTab.class);
    private IRowSelectorTransform m_model;
    private IRowSelector m_oRowSel;
    private int m_iPreviousIndex = 0;
    private JLabel m_lblTargets;
    private JList m_lstTargets;
    private JScrollPane m_scpTargets;
    private JLabel m_lblRowSelType;
    private WAComboBox m_cmbRowSelType;
    private JLabel m_lblDesc;
    private JScrollPane m_scpDesc;
    private WATextArea m_wtaDesc;
    private JLabel m_lblSubset;
    private JScrollPane m_scpSubset;
    private WATextArea m_wtaSubset;
    private JButton m_btnSubset;
    private WsAbstractAction m_actSubset;
    private IModelListener m_lsnrModel;
    private ActionListener m_lsnrRowType;
    private ListSelectionListener m_lsnrListSelection;
    private static int RowSelALL = 0;
    private static int RowSelIF = 1;
    private static int RowSelUSER = 2;

    public RowSelectionTab(IRowSelectorTransform model) {
        this.setName(bundle.getString("RowSelectionTab.Tabgroup.RowSelection.txt"));
        this.m_model = model;
        this.initialize();
        this.layoutWidgets();
        this.setHelpTopic("row_selection_tab");
    }

    protected void initialize() {
        this.m_lsnrModel = new ModelListener();
        this.m_model.getModel().addModelListener(this.m_lsnrModel);
        this.m_lstTargets = new JList();
        this.m_lstTargets.setCellRenderer(new MyCellRenderer());
        this.m_lstTargets.setToolTipText(bundle.getString("RowSelectionTab.List.Targets.tip"));
        this.m_lsnrListSelection = new cTargetListener();
        this.m_lstTargets.addListSelectionListener(this.m_lsnrListSelection);
        this.m_lblTargets = WsUIUtilities.createLabelForComponent((JComponent)this.m_lstTargets, (String)bundle.getString("RowSelectionTab.Label.Targets.txt"));
        this.m_scpTargets = new JScrollPane(this.m_lstTargets);
        this.m_scpTargets.setPreferredSize(new Dimension(200, 400));
        this.m_scpTargets.setMinimumSize(new Dimension(150, 100));
        this.m_cmbRowSelType = new WAComboBox();
        this.m_cmbRowSelType.setToolTipText(bundle.getString("RowSelectionTab.Combo.Row.tip"));
        this.m_cmbRowSelType.setSorted(false);
        this.m_lblRowSelType = WsUIUtilities.createLabelForComponent((JComponent)this.m_cmbRowSelType, (String)bundle.getString("RowSelectionTab.Label.Row.txt"));
        this.m_cmbRowSelType.addItem((Object)bundle.getString("RowSelectionTab.Choice.ALL.txt"));
        this.m_cmbRowSelType.addItem((Object)bundle.getString("RowSelectionTab.Choice.WHERE.txt"));
        this.m_cmbRowSelType.addItem((Object)bundle.getString("RowSelectionTab.Choice.DATASTEP.txt"));
        this.m_lsnrRowType = new cComboItemListener();
        this.m_cmbRowSelType.addActionListener(this.m_lsnrRowType);
        this.m_wtaDesc = new WATextArea(" ");
        this.m_wtaDesc.setToolTipText(bundle.getString("RowSelectionTab.WATextArea.Desc.tip"));
        this.m_wtaDesc.setLineWrap(true);
        this.m_wtaDesc.setWrapStyleWord(true);
        this.m_wtaDesc.setMaxCharacters(200);
        this.m_scpDesc = new JScrollPane((Component)this.m_wtaDesc);
        this.m_lblDesc = WsUIUtilities.createLabelForComponent((JComponent)this.m_wtaDesc, (String)bundle.getString("RowSelectionTab.Label.Desc.txt"));
        this.listenForDataChangesTo((JTextComponent)this.m_wtaDesc);
        this.m_wtaSubset = new WATextArea(" ");
        this.m_wtaSubset.setToolTipText(bundle.getString("RowSelectionTab.WATextArea.Subset.tip"));
        this.m_wtaSubset.setLineWrap(true);
        this.m_wtaSubset.setWrapStyleWord(true);
        this.m_scpSubset = new JScrollPane((Component)this.m_wtaSubset);
        this.m_lblSubset = WsUIUtilities.createLabelForComponent((JComponent)this.m_wtaSubset, (String)bundle.getString("RowSelectionTab.Label.Select.txt"));
        this.listenForDataChangesTo((JTextComponent)this.m_wtaSubset);
        this.m_actSubset = this.createSubsetAction();
        this.m_btnSubset = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actSubset);
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblTargets, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.m_scpTargets, new GridBagConstraints(0, 1, 1, 5, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.add(this.m_lblRowSelType, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 5), 0, 0));
        this.add((Component)this.m_cmbRowSelType, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add(this.m_lblDesc, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 10, 0, 0), 0, 0));
        this.add(this.m_scpDesc, new GridBagConstraints(1, 3, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 10, 0, 0), 0, 0));
        this.add(this.m_lblSubset, new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(15, 10, 0, 0), 0, 0));
        this.add(this.m_scpSubset, new GridBagConstraints(1, 5, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 10, 0, 0), 0, 0));
        this.add(this.m_btnSubset, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 5, 0), 0, 0));
    }

    public boolean validateData() {
        if (this.m_cmbRowSelType.getSelectedIndex() != 0) {
            String[] lines = this.m_wtaSubset.getText().split("\\n");
            for (int i = 0; i < lines.length; ++i) {
                if (lines[i].length() <= 255 || 1 != SASCodeGeneration.displayLineLengthMessage((String)lines[i], (int)(i + 1))) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveDataToStore() throws MdException, RemoteException {
        this.m_model.getModel().startCompoundUndoable();
        try {
            if (this.m_oRowSel == null) {
                return;
            }
            this.m_oRowSel.setDescription(this.m_wtaDesc.getText());
            int index = this.m_cmbRowSelType.getSelectedIndex();
            if (index == RowSelALL) {
                this.m_oRowSel.setRowSelectorType("All Rows");
            } else if (index == RowSelIF) {
                this.m_oRowSel.setRowSelectorType("Row Selection Conditions");
            } else if (index == RowSelUSER) {
                this.m_oRowSel.setRowSelectorType("User Defined Statements");
            }
            String exprText = this.m_wtaSubset.getText().trim();
            ITextExpression expr = this.m_oRowSel.getExpression();
            if (exprText.length() > 0) {
                if (expr == null) {
                    expr = this.m_model.getModel().getObjectFactory().createNewTextExpression(this.m_oRowSel.getID());
                    expr.setUseSQLSyntax(false);
                    this.m_oRowSel.setExpression(expr);
                }
                expr.setText(exprText, (IObject[])this.m_oRowSel.getTable().getColumns());
            } else if (expr != null) {
                this.m_oRowSel.setExpression(null);
            }
        }
        finally {
            this.m_model.getModel().endCompoundUndoable();
        }
        this.m_iPreviousIndex = 0;
        this.setDataChanged(false);
    }

    public void moveDataToView() {
        this.setListeningForChanges(false);
        IRowSelector[] rowSels = this.m_model.getRowSelectorObjects();
        this.m_lstTargets.setListData(rowSels);
        this.m_lstTargets.setSelectedIndex(0);
        this.setListeningForChanges(true);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        if (this.m_model.getRowSelectorList().size() == 0) {
            this.m_cmbRowSelType.setEnabled(false);
            this.m_wtaDesc.setEnabled(false);
            this.m_wtaSubset.setEnabled(false);
            this.m_btnSubset.setEnabled(false);
        } else {
            this.m_cmbRowSelType.setEnabled(bEditable);
            this.m_wtaDesc.setEnabled(bEditable);
            this.m_wtaSubset.setEnabled(bEditable);
            this.m_btnSubset.setEnabled(bEditable);
        }
    }

    public void setRowSelType() {
        int index = this.m_cmbRowSelType.getSelectedIndex();
        switch (index) {
            case 0: {
                this.m_wtaSubset.setEnabled(false);
                this.m_btnSubset.setEnabled(false);
                break;
            }
            case 1: {
                this.m_wtaSubset.setEnabled(this.isEditable());
                this.m_btnSubset.setEnabled(this.isEditable());
                break;
            }
            case 2: {
                this.m_wtaSubset.setEnabled(this.isEditable());
                this.m_btnSubset.setEnabled(this.isEditable());
            }
        }
    }

    public void saveSettingsAndCleanUp() {
        this.m_model.getModel().removeModelListener(this.m_lsnrModel);
        this.m_lstTargets.removeListSelectionListener(this.m_lsnrListSelection);
        this.m_cmbRowSelType.removeActionListener(this.m_lsnrRowType);
    }

    private WsAbstractAction createSubsetAction() {
        return new cSubsetAction();
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        MyCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            IRowSelector object = (IRowSelector)value;
            IPhysicalTable table = (IPhysicalTable)object.getTable();
            StringBuffer sbufName = new StringBuffer();
            sbufName.append(table.getName());
            sbufName.append(" (");
            sbufName.append(table.getSASTableName());
            sbufName.append(")");
            this.setText(sbufName.toString());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modelChanged(ModelEvent ev) {
            block39: {
                RowSelectionTab.this.setListeningForChanges(false);
                try {
                    String sType = ev.getType();
                    if (RowSelectionTab.this.m_oRowSel == null) {
                        return;
                    }
                    if (sType == "ModelController:UnknownChanges") {
                        String rowType = RowSelectionTab.this.m_oRowSel.getRowSelectorType();
                        if (rowType.equalsIgnoreCase("All Rows")) {
                            RowSelectionTab.this.m_cmbRowSelType.setSelectedIndex(RowSelALL);
                        } else if (rowType.equalsIgnoreCase("Row Selection Conditions")) {
                            RowSelectionTab.this.m_cmbRowSelType.setSelectedIndex(RowSelIF);
                        } else if (rowType.equalsIgnoreCase("User Defined Statements")) {
                            RowSelectionTab.this.m_cmbRowSelType.setSelectedIndex(RowSelUSER);
                        }
                        ITextExpression expr = RowSelectionTab.this.m_oRowSel.getExpression();
                        if (expr == null) {
                            RowSelectionTab.this.m_wtaSubset.setText("");
                        } else {
                            try {
                                RowSelectionTab.this.m_wtaSubset.setText(expr.getText(null, ((SplitterTransformModel)RowSelectionTab.this.m_model).isQuotingNeeded(), false));
                            }
                            catch (RemoteException e1) {
                                Workspace.handleRemoteException((RemoteException)e1);
                            }
                            catch (CodegenException e1) {
                                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
                            }
                            catch (MdException e1) {
                                MessageUtil.displayMetadataExceptionMessage((MdException)e1, (String)"Accessing");
                            }
                            catch (BadServerDefinitionException e1) {
                                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
                            }
                            catch (BadLibraryDefinitionException e1) {
                                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
                            }
                            catch (ServerException e1) {
                                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
                            }
                        }
                        RowSelectionTab.this.m_wtaDesc.setText(RowSelectionTab.this.m_oRowSel.getDescription());
                        break block39;
                    }
                    if (sType == "Object:DescriptionChanged") {
                        RowSelectionTab.this.m_wtaDesc.setText(RowSelectionTab.this.m_oRowSel.getDescription());
                    } else if (sType == "RowSelector:RowSelectionTypeChanged") {
                        String rowType = RowSelectionTab.this.m_oRowSel.getRowSelectorType();
                        if (rowType.equalsIgnoreCase("All Rows")) {
                            RowSelectionTab.this.m_cmbRowSelType.setSelectedIndex(RowSelALL);
                        } else if (rowType.equalsIgnoreCase("Row Selection Conditions")) {
                            RowSelectionTab.this.m_cmbRowSelType.setSelectedIndex(RowSelIF);
                        } else if (rowType.equalsIgnoreCase("User Defined Statements")) {
                            RowSelectionTab.this.m_cmbRowSelType.setSelectedIndex(RowSelUSER);
                        }
                    } else if (sType == "RowSelector:ExpressionChanged" || sType == "TextExpression:TextChanged") {
                        ITextExpression expr = RowSelectionTab.this.m_oRowSel.getExpression();
                        if (expr == null) {
                            RowSelectionTab.this.m_wtaSubset.setText("");
                        } else {
                            try {
                                RowSelectionTab.this.m_wtaSubset.setText(expr.getText(null, ((SplitterTransformModel)RowSelectionTab.this.m_model).isQuotingNeeded(), false));
                            }
                            catch (RemoteException e1) {
                                Workspace.handleRemoteException((RemoteException)e1);
                            }
                            catch (CodegenException e1) {
                                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
                            }
                            catch (MdException e1) {
                                MessageUtil.displayMetadataExceptionMessage((MdException)e1, (String)"Accessing");
                            }
                            catch (BadServerDefinitionException e1) {
                                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
                            }
                            catch (BadLibraryDefinitionException e1) {
                                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
                            }
                            catch (ServerException e1) {
                                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
                            }
                        }
                    }
                }
                finally {
                    RowSelectionTab.this.setListeningForChanges(true);
                }
            }
        }
    }

    class cTargetListener
    implements ListSelectionListener {
        cTargetListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int currInd = RowSelectionTab.this.m_lstTargets.getSelectedIndex();
            if (currInd != RowSelectionTab.this.m_iPreviousIndex && RowSelectionTab.this.hasDataChanged()) {
                RowSelectionTab.this.m_model.getModel().startCompoundUndoable();
                try {
                    RowSelectionTab.this.m_oRowSel.setDescription(RowSelectionTab.this.m_wtaDesc.getText());
                    int index = RowSelectionTab.this.m_cmbRowSelType.getSelectedIndex();
                    if (index == RowSelALL) {
                        RowSelectionTab.this.m_oRowSel.setRowSelectorType("All Rows");
                    } else if (index == RowSelIF) {
                        RowSelectionTab.this.m_oRowSel.setRowSelectorType("Row Selection Conditions");
                    } else if (index == RowSelUSER) {
                        RowSelectionTab.this.m_oRowSel.setRowSelectorType("User Defined Statements");
                    }
                    String exprText = RowSelectionTab.this.m_wtaSubset.getText().trim();
                    ITextExpression expr = RowSelectionTab.this.m_oRowSel.getExpression();
                    if (exprText.length() > 0) {
                        if (expr == null) {
                            expr = RowSelectionTab.this.m_model.getModel().getObjectFactory().createNewTextExpression(RowSelectionTab.this.m_oRowSel.getID());
                            expr.setUseSQLSyntax(false);
                            RowSelectionTab.this.m_oRowSel.setExpression(expr);
                        }
                        expr.setText(exprText, (IObject[])RowSelectionTab.this.m_oRowSel.getTable().getColumns());
                    } else if (expr != null) {
                        RowSelectionTab.this.m_oRowSel.setExpression(null);
                    }
                }
                finally {
                    RowSelectionTab.this.m_model.getModel().endCompoundUndoable();
                }
            }
            RowSelectionTab.this.m_oRowSel = (IRowSelector)RowSelectionTab.this.m_lstTargets.getSelectedValue();
            if (RowSelectionTab.this.m_oRowSel == null) {
                return;
            }
            String rowType = RowSelectionTab.this.m_oRowSel.getRowSelectorType();
            if (rowType.equalsIgnoreCase("All Rows")) {
                RowSelectionTab.this.m_cmbRowSelType.setSelectedIndex(RowSelALL);
            } else if (rowType.equalsIgnoreCase("Row Selection Conditions")) {
                RowSelectionTab.this.m_cmbRowSelType.setSelectedIndex(RowSelIF);
            } else if (rowType.equalsIgnoreCase("User Defined Statements")) {
                RowSelectionTab.this.m_cmbRowSelType.setSelectedIndex(RowSelUSER);
            }
            ITextExpression expr = RowSelectionTab.this.m_oRowSel.getExpression();
            if (expr == null) {
                RowSelectionTab.this.m_wtaSubset.setText("");
            } else {
                try {
                    RowSelectionTab.this.m_wtaSubset.setText(expr.getText(null, ((SplitterTransformModel)RowSelectionTab.this.m_model).isQuotingNeeded(), false));
                }
                catch (RemoteException e1) {
                    Workspace.handleRemoteException((RemoteException)e1);
                }
                catch (CodegenException e1) {
                    MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
                }
                catch (MdException e1) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)e1, (String)"Accessing");
                }
                catch (BadServerDefinitionException e1) {
                    MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
                }
                catch (BadLibraryDefinitionException e1) {
                    MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
                }
                catch (ServerException e1) {
                    MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
                }
            }
            RowSelectionTab.this.m_wtaDesc.setText(RowSelectionTab.this.m_oRowSel.getDescription());
            RowSelectionTab.this.m_iPreviousIndex = currInd;
        }
    }

    class cComboItemListener
    implements ActionListener {
        cComboItemListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RowSelectionTab.this.setRowSelType();
            if (RowSelectionTab.this.m_oRowSel == null) {
                return;
            }
            int index = RowSelectionTab.this.m_cmbRowSelType.getSelectedIndex();
            switch (index) {
                case 0: {
                    RowSelectionTab.this.m_model.getModel().startCompoundUndoable();
                    try {
                        RowSelectionTab.this.m_oRowSel.setRowSelectorType("All Rows");
                        break;
                    }
                    finally {
                        RowSelectionTab.this.m_model.getModel().endCompoundUndoable();
                    }
                }
                case 1: {
                    RowSelectionTab.this.m_oRowSel.setRowSelectorType("Row Selection Conditions");
                    break;
                }
                case 2: {
                    RowSelectionTab.this.m_oRowSel.setRowSelectorType("User Defined Statements");
                }
            }
        }
    }

    class cSubsetAction
    extends WsAbstractAction {
        public cSubsetAction() {
            super(bundle, "RowSelectionTab.Button.Subset", 0);
        }

        public void actionPerformed(ActionEvent e) {
            ExpressionBuilderTab expBldPanel = new ExpressionBuilderTab(null, ((SplitterTransformModel)RowSelectionTab.this.m_model).getSourceTables(), false);
            expBldPanel.setExpression(RowSelectionTab.this.m_wtaSubset.getText());
            expBldPanel.setUseQuotes(((AbstractDataTransform)RowSelectionTab.this.m_model).isQuotingNeeded());
            if (RowSelectionTab.this.m_cmbRowSelType.getSelectedIndex() == RowSelUSER) {
                expBldPanel.getValidateSASCode().setClause("");
            }
            WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("RowSelectionTab.ExpressionBuilder.Title.txt"), true, (WAPanel)expBldPanel);
            expBldPanel.setHelpProduct("expbuild");
            expBldPanel.setHelpTopic("expbuildwindow");
            dialog.setResizable(true);
            dialog.show();
            if (dialog.getReturnValue() == 1) {
                String exprText = expBldPanel.getExpression();
                ITextExpression expr = RowSelectionTab.this.m_oRowSel.getExpression();
                if (expr == null) {
                    expr = RowSelectionTab.this.m_oRowSel.getModel().getObjectFactory().createNewTextExpression(RowSelectionTab.this.m_oRowSel.getID());
                    expr.setUseSQLSyntax(false);
                    RowSelectionTab.this.m_oRowSel.setExpression(expr);
                }
                IColumn[] icols = null;
                if (((SplitterTransformModel)RowSelectionTab.this.m_model).getSourceTables().length > 0) {
                    icols = ((SplitterTransformModel)RowSelectionTab.this.m_model).getSourceTables()[0].getColumns();
                }
                expr.setText(exprText, icols);
                try {
                    RowSelectionTab.this.m_wtaSubset.setText(expr.getText(null, ((SplitterTransformModel)RowSelectionTab.this.m_model).isQuotingNeeded(), false));
                }
                catch (RemoteException e1) {
                    Workspace.handleRemoteException((RemoteException)e1);
                }
                catch (CodegenException e1) {
                    MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
                }
                catch (MdException e1) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)e1, (String)"Accessing");
                }
                catch (BadServerDefinitionException e1) {
                    MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
                }
                catch (BadLibraryDefinitionException e1) {
                    MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
                }
                catch (ServerException e1) {
                    MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
                }
            }
        }
    }
}

