/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.sort;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.ISortingTransform;
import com.sas.etl.models.job.transforms.common.ISortColumn;
import com.sas.etl.models.job.transforms.common.ISorting;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.transforms.sort.SortColsByTreeModel;
import com.sas.wadmin.visuals.properties.AbstractPropertiesModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsEnumeratedTableColumn;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.visuals.dualselector.DefaultSelectorTableModel;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;

public class SortColsByTableModel
extends DefaultSelectorTableModel {
    private static final WAdminResource bundle = WAdminResource.getBundle(SortColsByTableModel.class);
    private static String DEFAULT_SORT_ORDER;
    private static final String DEFAULTCOLUMNORDER;
    protected static final int COLUMN_COL = 0;
    protected static final int ASC_DESC_COL = 1;
    protected static final int ORDERBYCOLUMN_COL = 2;
    protected static final int COLUMNS_IN_TABLE = 3;
    protected static final int HIDDEN_COLUMNS = 1;
    private ISortingTransform m_sortModel;
    private ISorting m_sort;
    private ModelListener m_lsnrModel;

    public SortColsByTableModel(ISortingTransform sort) {
        this.m_sortModel = sort;
        this.m_sort = this.m_sortModel.getSortOrder();
        this.m_aColumns = new WsAbstractTableColumn[3];
        this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("SortColsByTableModel.ColumnName.txt"), 100);
        this.m_aColumns[1] = new cListTableColumn(1, bundle.getString("SortColsByTableModel.SortOrder.txt"), 75, SortColsByTableModel.getSortOrderTranslatedValues(), SortColsByTableModel.getSortOrderUnTranslatedValues(), DEFAULTCOLUMNORDER);
        this.m_aColumns[2] = new WsObjectTableColumn();
        this.m_aColumns[0].setEditable(false);
        this.m_lsnrModel = new ModelListener();
        this.m_sortModel.getModel().addModelListener((IModelListener)this.m_lsnrModel);
    }

    public void dispose() {
        this.m_sortModel.getModel().removeModelListener((IModelListener)this.m_lsnrModel);
    }

    public void addRow(Object obj) {
        if (obj instanceof TreePath) {
            obj = ((TreePath)obj).getLastPathComponent();
            SortColsByTreeModel.cColumnTreeNode columnTreeNode = (SortColsByTreeModel.cColumnTreeNode)((WsTreeNode)obj);
            IColumn column = columnTreeNode.getTableColumn();
            ISortColumn sortColumn = this.m_sort.getModel().getObjectFactory().createNewSortColumn(this.m_sort.getID(), column);
            obj = sortColumn;
        }
        this.insertRow(this.getRowCount() - 1, this.createRowValues(obj));
        if (obj instanceof ISortColumn) {
            this.m_sort.addSortColumn(this.getRowCount() - 1, (ISortColumn)obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveSortModelItems(int[] selectedIndices, boolean bMovingUp) {
        if (selectedIndices != null && selectedIndices.length > 0) {
            this.m_sort.getModel().startCompoundUndoable();
            try {
                if (bMovingUp) {
                    for (int i = 0; i < selectedIndices.length; ++i) {
                        List lSortCols = this.m_sort.getSortColumnList();
                        ISortColumn sortColumn = (ISortColumn)lSortCols.get(selectedIndices[i]);
                        this.m_sort.removeSortColumn(sortColumn);
                        lSortCols = this.m_sort.getSortColumnList();
                        this.m_sort.addSortColumn(selectedIndices[i] - 1, sortColumn);
                    }
                } else {
                    for (int i = selectedIndices.length - 1; i >= 0; --i) {
                        List lSortCols = this.m_sort.getSortColumnList();
                        ISortColumn sortColumn = (ISortColumn)lSortCols.get(selectedIndices[i]);
                        this.m_sort.removeSortColumn(sortColumn);
                        this.m_sort.addSortColumn(selectedIndices[i] + 1, sortColumn);
                    }
                }
            }
            finally {
                this.m_sort.getModel().endCompoundUndoable();
            }
        }
    }

    public void setRow(Object obj, int iRow) {
        if (obj instanceof TreePath) {
            obj = ((TreePath)obj).getLastPathComponent();
        }
        this.setRowValues(iRow, this.createRowValues(obj, iRow));
    }

    private void addSortRow(ISortColumn sortCol) {
        int iRowIndex = this.getRowIndex(sortCol);
        if (iRowIndex > -1) {
            return;
        }
        int iRow = this.m_sort.indexOfSortColumn(sortCol);
        this.insertRow(iRow - 1, this.createRowValues(sortCol));
    }

    private void removeSortRow(ISortColumn sortCol) {
        this.deleteRow(this.getRowIndex(sortCol));
    }

    protected List createRowValues(Object obj, int iRow) {
        if (obj instanceof ISortColumn) {
            ISortColumn sortColumn = (ISortColumn)obj;
            ArrayList<String> lRowValues = new ArrayList<String>();
            IColumn column = sortColumn.getColumn();
            lRowValues.add(column.getName());
            lRowValues.add(sortColumn.getDirection());
            lRowValues.add((String)sortColumn);
            return lRowValues;
        }
        if (obj instanceof List) {
            return (List)obj;
        }
        return null;
    }

    protected List createRowValues(Object obj) {
        return this.createRowValues(obj, -1);
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public void moveDataToModel() {
        super.clear();
        List lSortColumns = this.m_sort.getSortColumnList();
        for (int index = 0; index < lSortColumns.size(); ++index) {
            ISortColumn oSortColumn = (ISortColumn)lSortColumns.get(index);
            ArrayList<String> row = new ArrayList<String>();
            row.add(oSortColumn.getColumn().getName());
            row.add(oSortColumn.getDirection());
            row.add((String)oSortColumn);
            this.m_lData.add(row);
            ++this.m_nRowInstances;
        }
        this.fireTableModelPopulated();
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public Object getRow(int iRow) {
        if (iRow > this.getRowCount() - 1) {
            return null;
        }
        String sName = (String)this.getValueAt(iRow, 0);
        String sOrder = (String)this.getValueAt(iRow, 1);
        ISortColumn sortColumn = (ISortColumn)this.getValueAt(iRow, 2);
        ArrayList<String> lRowValues = new ArrayList<String>();
        lRowValues.add(sName);
        lRowValues.add(sOrder);
        lRowValues.add((String)sortColumn);
        return lRowValues;
    }

    public void deleteRow(int iRow) {
        if (iRow == -1) {
            return;
        }
        ISortColumn sortColumn = (ISortColumn)this.getRowValues(iRow).get(2);
        List lDeletedRowValues = (List)this.m_lData.remove(iRow);
        this.fireTableRowDeleted(iRow, lDeletedRowValues);
        if (this.m_sort.containsSortColumn(sortColumn)) {
            this.m_sort.getSortColumnList().remove(iRow);
        }
    }

    public void clear() {
        super.clear();
        List lSortColumns = this.m_sort.getSortColumnList();
        int size = lSortColumns.size();
        for (int i = size - 1; i > -1; --i) {
            lSortColumns.remove(lSortColumns.get(i));
        }
    }

    public void setValueAt(Object value, int iRow, int iCol) {
        List lRow = (List)this.m_lData.get(iRow);
        lRow.set(iCol, value);
        this.fireTableCellUpdated(iRow, iCol);
        ISortColumn oSortColumn = (ISortColumn)this.getValueAt(iRow, 2);
        if (iCol == 1) {
            oSortColumn.setDirection((String)value);
        }
    }

    public int getColumnCount() {
        return this.m_aColumns.length - 1;
    }

    public static List getSortOrderTranslatedValues() {
        ArrayList<String> sortOrderTranslated = new ArrayList<String>();
        sortOrderTranslated.add(bundle.getString("SortColsByTableModel.Ascending.txt"));
        sortOrderTranslated.add(bundle.getString("SortColsByTableModel.Descending.txt"));
        return sortOrderTranslated;
    }

    public static List getSortOrderUnTranslatedValues() {
        ArrayList<String> sortOrderUnTranslated = new ArrayList<String>();
        sortOrderUnTranslated.add("ascending");
        sortOrderUnTranslated.add("descending");
        return sortOrderUnTranslated;
    }

    public int getRowIndex(ISortColumn sortCol) {
        for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
            List lValues = (List)this.m_lData.get(iRow);
            if (lValues.get(2) != sortCol) continue;
            return iRow;
        }
        return -1;
    }

    static {
        DEFAULTCOLUMNORDER = DEFAULT_SORT_ORDER = "ascending";
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            IObject obj = ev.getModelObject();
            if (sType == "ModelController:UnknownChanges") {
                SortColsByTableModel.this.moveDataToModel();
            } else if (obj == SortColsByTableModel.this.m_sort) {
                if (sType == "Sorting:ColumnAdded") {
                    ISortColumn sortCol = (ISortColumn)ev.getData();
                    int iRow = SortColsByTableModel.this.getRowIndex(sortCol);
                    if (iRow == -1) {
                        SortColsByTableModel.this.addSortRow(sortCol);
                    }
                } else if (sType == "Sorting:ColumnRemoved") {
                    SortColsByTableModel.this.removeSortRow((ISortColumn)ev.getData());
                }
            } else if (obj instanceof IColumn) {
                IColumn col = (IColumn)obj;
                if (SortColsByTableModel.this.m_sort.containsColumn(col)) {
                    ISortColumn sortCol = SortColsByTableModel.this.m_sort.getSortColumnContainingColumn(col);
                    int iRowIndex = SortColsByTableModel.this.getRowIndex(sortCol);
                    if (sType == "Object:NameChanged") {
                        SortColsByTableModel.super.setValueAt(col.getName(), iRowIndex, 0);
                        SortColsByTableModel.this.fireTableCellUpdated(iRowIndex, 0);
                    }
                }
            } else if (obj instanceof ISortColumn && sType == "SortingColumn:DirectionChanged") {
                ISortColumn sortCol = (ISortColumn)obj;
                int iRowIndex = SortColsByTableModel.this.getRowIndex(sortCol);
                SortColsByTableModel.super.setValueAt(sortCol.getDirection(), iRowIndex, 1);
                SortColsByTableModel.this.fireTableCellUpdated(iRowIndex, 1);
            }
        }
    }

    protected class cListTableColumn
    extends WsEnumeratedTableColumn {
        protected List m_unTranslatedValues;
        protected List m_translatedValues;

        public cListTableColumn(int iModelIndex, String sName, int cxWidth, List translatedValues, List unTranslatedValues, String sDefault) {
            super(iModelIndex, sName, cxWidth, translatedValues.toArray(new String[translatedValues.size()]), sDefault);
            this.m_translatedValues = translatedValues;
            this.m_unTranslatedValues = unTranslatedValues;
        }

        public TableCellEditor createCellEditor() {
            return new AbstractPropertiesModel.DefaultListTableCellEditor(this.m_translatedValues, this.m_unTranslatedValues);
        }

        protected TableCellRenderer createCellRenderer() {
            return new AbstractPropertiesModel.DefaultListTableCellRenderer(this.m_translatedValues, this.m_unTranslatedValues);
        }
    }
}

