/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.scd;

import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.transforms.facttable.FactTableTransformModel;
import com.sas.etl.models.job.transforms.facttable.IFactTableMapping;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.transforms.scd.FactTableMappingPanel;
import com.sas.wadmin.transforms.scd.FactTableTabTableModel;
import com.sas.wadmin.visuals.common.ModelUIUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FactTableTab
extends WAPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(FactTableTab.class);
    private FactTableTransformModel m_xfmFact;
    private FactTableTabTableModel m_mdlFactTable;
    private WsTable m_tblFact;
    private JScrollPane m_scrFact;
    private JButton m_btnNew;
    private JButton m_btnEdit;
    private JButton m_btnDelete;
    private WsAbstractAction m_actNew;
    private WsAbstractAction m_actEdit;
    private WsAbstractAction m_actDelete;
    private ListSelectionListener m_lsrFactTable;

    public FactTableTab(FactTableTransformModel factTransform) {
        this.setName(bundle.getString("FactTableTab.Name.txt"));
        this.m_xfmFact = factTransform;
        this.initialize();
        this.layoutWidgets();
    }

    protected void initialize() {
        this.m_mdlFactTable = new FactTableTabTableModel(this.m_xfmFact);
        this.m_tblFact = new WsTable((WsAbstractTableModel)this.m_mdlFactTable);
        this.m_scrFact = new JScrollPane((Component)this.m_tblFact);
        this.m_tblFact.setSortingEnabled(false);
        this.m_tblFact.setRowsReorderable(false);
        this.m_lsrFactTable = new TableSelectionListener();
        this.m_tblFact.getSelectionModel().addListSelectionListener(this.m_lsrFactTable);
        this.m_actNew = this.createNewFactTableMappingAction();
        this.m_actEdit = this.createEditFactTableMappingAction();
        this.m_actDelete = this.createDeleteFactTableMappingAction();
        this.m_btnNew = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actNew);
        this.m_btnEdit = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actEdit);
        this.m_btnDelete = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actDelete);
        this.setHelpProduct("wdb");
        this.setHelpTopic("fact_table_tab");
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add(this.m_scrFact, new GridBagConstraints(0, 0, 4, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_btnNew, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add(this.m_btnEdit, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add(this.m_btnDelete, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void moveDataToView() throws MdException, RemoteException {
        IDataObject[] aSources = this.m_xfmFact.getDataSources();
        IDataObject[] aTargets = this.m_xfmFact.getDataTargets();
        if (aSources.length == 0) {
            MessageUtil.displayMessage((String)bundle.getString("FactTableTab.NoSourceTable.txt"), (int)0);
            this.setEditable(false);
            return;
        }
        if (aTargets.length == 0) {
            MessageUtil.displayMessage((String)bundle.getString("FactTableTab.NoTargetTable.txt"), (int)0);
            this.setEditable(false);
            return;
        }
        IDataObject sourceObject = aSources[0];
        IDataObject targetObject = aTargets[0];
        if (!(sourceObject instanceof ITable) || ((ITable)sourceObject).getColumnCount() == 0) {
            MessageUtil.displayMessage((String)bundle.getString("FactTableTab.NoSourceCols.txt"), (int)0);
            this.setEditable(false);
            return;
        }
        if (!(targetObject instanceof ITable) || ((ITable)targetObject).getColumnCount() == 0) {
            MessageUtil.displayMessage((String)bundle.getString("FactTableTab.NoTargetCols.txt"), (int)0);
            this.setEditable(false);
            return;
        }
        this.m_mdlFactTable.moveDataToModel();
        this.updateActions();
    }

    public void saveSettingsAndCleanUp() {
        this.m_tblFact.getSelectionModel().removeListSelectionListener(this.m_lsrFactTable);
        this.m_mdlFactTable.dispose();
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.updateActions();
    }

    private void updateActions() {
        boolean bEditable = this.isEditable();
        int numSelectedRows = this.m_tblFact.getSelectedRowsFromSelectedCells().length;
        this.m_actNew.setEnabled(bEditable);
        this.m_actEdit.setEnabled(bEditable && numSelectedRows == 1);
        this.m_actDelete.setEnabled(bEditable && numSelectedRows > 0);
    }

    protected WsAbstractAction createNewFactTableMappingAction() {
        return new NewFactTableMappingAction();
    }

    protected WsAbstractAction createEditFactTableMappingAction() {
        return new EditFactTableMappingAction();
    }

    protected WsAbstractAction createDeleteFactTableMappingAction() {
        return new DeleteFactTableMappingAction();
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            FactTableTab.this.updateActions();
        }
    }

    private class DeleteFactTableMappingAction
    extends WsAbstractAction {
        public DeleteFactTableMappingAction() {
            super(bundle, "FactTableTab.DeleteFactTableMappingAction", 256);
        }

        public void actionPerformed(ActionEvent e) {
            int[] aSelectedRows = FactTableTab.this.m_tblFact.getSelectedRowsFromSelectedCells();
            for (int i = aSelectedRows.length - 1; i >= 0; --i) {
                IFactTableMapping factMapping = (IFactTableMapping)FactTableTab.this.m_mdlFactTable.getValueAt(aSelectedRows[i], 6);
                FactTableTab.this.m_xfmFact.removeMapping((IMapping)factMapping);
            }
        }
    }

    private class EditFactTableMappingAction
    extends WsAbstractAction {
        public EditFactTableMappingAction() {
            super(bundle, "FactTableTab.EditFactTableMappingAction", 256);
        }

        public void actionPerformed(ActionEvent e) {
            int[] aSelectedRows = FactTableTab.this.m_tblFact.getSelectedRowsFromSelectedCells();
            IFactTableMapping factMapping = (IFactTableMapping)FactTableTab.this.m_mdlFactTable.getValueAt(aSelectedRows[0], 6);
            FactTableMappingPanel mappingPanel = new FactTableMappingPanel(FactTableTab.this.m_xfmFact, factMapping);
            ModelUIUtilities.showDialog((IObject)FactTableTab.this.m_xfmFact, bundle.getString("FactTableTab.EditFactTableMappingDialog.txt"), mappingPanel);
        }
    }

    private class NewFactTableMappingAction
    extends WsAbstractAction {
        public NewFactTableMappingAction() {
            super(bundle, "FactTableTab.NewFactTableMappingAction", 256);
        }

        public void actionPerformed(ActionEvent e) {
            IFactTableMapping factMapping;
            FactTableMappingPanel mappingPanel = new FactTableMappingPanel(FactTableTab.this.m_xfmFact, null);
            int dialogRC = ModelUIUtilities.showDialog((IObject)FactTableTab.this.m_xfmFact, bundle.getString("FactTableTab.NewFactTableMappingDialog.txt"), mappingPanel);
            if (dialogRC == 1 && (factMapping = mappingPanel.getFactTableMapping()) != null) {
                FactTableTab.this.m_xfmFact.addMapping((IMapping)factMapping);
            }
        }
    }
}

