/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.scd;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.transforms.facttable.FactTableTransformModel;
import com.sas.etl.models.job.transforms.facttable.IFactTableMapping;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.visuals.SelectedColumnPanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.models.SimpleObject;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FactTableMappingPanel
extends WAPanel {
    private static final WAdminResource bundle = WAdminResource.getBundle(FactTableMappingPanel.class);
    private static final int ACTION_MOVE_ROW_TO_ERROR_TABLE_INDEX = 0;
    private static final int ACTION_ABORT_JOB_INDEX = 1;
    private static final int ACTION_NONE_INDEX = 2;
    private JLabel m_lblSourceColumn;
    private JLabel m_lblTargetColumn;
    private JLabel m_lblActionIfUnavailable;
    private WAComboBox m_cmbSourceColumn;
    private WAComboBox m_cmbTargetColumn;
    private WAComboBox m_cmbActionIfUnavailable;
    private IColumn[] m_aSourceColumns;
    private IColumn[] m_aTargetColumns;
    private ActionListener m_lsrSourceColumn;
    private ActionListener m_lsrTargetColumn;
    private ActionListener m_lsrActionIfUnavailable;
    private ChangeListener m_lsrTranslation;
    private IModelListener m_lsrModel;
    private SelectedColumnPanel m_pnlTranslation;
    private MdObjectStore m_store;
    private FactTableTransformModel m_xfmFact;
    private IFactTableMapping m_mapFact;
    private IModel m_model;

    public FactTableMappingPanel(FactTableTransformModel factTransform, IFactTableMapping factMapping) {
        this.m_xfmFact = factTransform;
        this.m_mapFact = factMapping;
        this.m_model = this.m_xfmFact.getModel();
        this.initialize();
        this.layoutWidgets();
    }

    protected void initialize() {
        this.m_cmbSourceColumn = new WAComboBox();
        this.m_cmbTargetColumn = new WAComboBox();
        this.m_cmbActionIfUnavailable = new WAComboBox();
        this.m_lblSourceColumn = WsUIUtilities.createLabelForComponent((JComponent)this.m_cmbSourceColumn, (String)bundle.getString("FactTableMappingPanel.SourceColumn.txt"));
        this.m_lblTargetColumn = WsUIUtilities.createLabelForComponent((JComponent)this.m_cmbSourceColumn, (String)bundle.getString("FactTableMappingPanel.TargetColumn.txt"));
        this.m_lblActionIfUnavailable = WsUIUtilities.createLabelForComponent((JComponent)this.m_cmbSourceColumn, (String)bundle.getString("FactTableMappingPanel.ActionIfUnavailable.txt"));
        this.m_cmbActionIfUnavailable.addItem((Object)bundle.getString("FactTableMappingPanel.MoveAct.txt"));
        this.m_cmbActionIfUnavailable.addItem((Object)bundle.getString("FactTableMappingPanel.AbortAct.txt"));
        this.m_cmbActionIfUnavailable.addItem((Object)bundle.getString("FactTableMappingPanel.NoneAct.txt"));
        this.m_pnlTranslation = new SelectedColumnPanel(1);
        this.m_pnlTranslation.setNumberOfColumnFields(2);
        this.m_pnlTranslation.setColumnSelectorDialogTitle(bundle.getString("FactTableMappingPanel.ColSelection.title.txt"));
        this.m_pnlTranslation.setColumnSelectorDialogDescription(bundle.getString("FactTableMappingPanel.ColSelection.desc.txt"));
        this.m_pnlTranslation.setSelectButtonToolTip(bundle.getString("FactTableMappingPanel.ColSelector.tip"));
        this.m_pnlTranslation.setTableLabel(bundle.getString("FactTableMappingPanel.TranslationTable.txt"), bundle.getString("FactTableMappingPanel.TranslationTable.mnem").charAt(0));
        this.m_pnlTranslation.setColumnLabel(0, bundle.getString("FactTableMappingPanel.TranslationFromColumn.txt"), bundle.getString("FactTableMappingPanel.TranslationFromColumn.mnem").charAt(0));
        this.m_pnlTranslation.setColumnLabel(1, bundle.getString("FactTableMappingPanel.TranslationToColumn.txt"), bundle.getString("FactTableMappingPanel.TranslationToColumn.mnem").charAt(0));
        this.m_lsrSourceColumn = new SourceColumnListener();
        this.m_lsrTargetColumn = new TargetColumnListener();
        this.m_lsrActionIfUnavailable = new ActionIfUnavailableListener();
        this.m_lsrTranslation = new TranslationMappingListener();
        this.m_lsrModel = new ModelListener();
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblSourceColumn, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.m_cmbSourceColumn, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.m_lblTargetColumn, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.m_cmbTargetColumn, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.m_pnlTranslation, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.m_lblActionIfUnavailable, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.m_cmbActionIfUnavailable, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void populateStore() throws MdException, RemoteException {
        this.m_store = Workspace.getMdFactory().createObjectStore(null, "FactTableMappingPanel:Translation Columns");
        this.m_pnlTranslation.setStore(this.m_store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveDataToView() throws MdException, RemoteException {
        boolean bUndo = this.m_model.isUndoSupported();
        this.setListeningForChanges(false);
        this.m_model.setUndoSupported(false);
        try {
            IDataObject[] aTargets;
            IDataObject[] aSources = this.m_xfmFact.getDataSources();
            if (aSources != null && aSources.length != 0 && aSources[0] instanceof ITable) {
                this.m_aSourceColumns = ((ITable)aSources[0]).getColumns();
                if (this.m_aSourceColumns != null) {
                    for (int i = 0; i < this.m_aSourceColumns.length; ++i) {
                        this.m_cmbSourceColumn.addItem((Object)this.m_aSourceColumns[i].getName());
                    }
                }
            }
            if ((aTargets = this.m_xfmFact.getDataTargets()) != null && aTargets.length != 0 && aTargets[0] instanceof ITable) {
                this.m_aTargetColumns = ((ITable)aTargets[0]).getColumns();
                if (this.m_aTargetColumns != null) {
                    for (int i = 0; i < this.m_aTargetColumns.length; ++i) {
                        this.m_cmbTargetColumn.addItem((Object)this.m_aTargetColumns[i].getName());
                    }
                }
            }
            if (this.m_mapFact != null) {
                this.moveSourceColumnToView();
                this.moveTargetColumnToView();
                this.moveTranslationMappingToView();
                this.moveActionIfUnavailableToView();
            } else {
                this.m_mapFact = this.m_xfmFact.createNewFactTableMapping();
                this.m_mapFact.setSourceColumn(this.m_aSourceColumns[0]);
                this.m_mapFact.setTargetColumn(this.m_aTargetColumns[0]);
                this.m_mapFact.setAction("Move row to error table");
            }
            this.m_cmbSourceColumn.addActionListener(this.m_lsrSourceColumn);
            this.m_cmbTargetColumn.addActionListener(this.m_lsrTargetColumn);
            this.m_cmbActionIfUnavailable.addActionListener(this.m_lsrActionIfUnavailable);
            this.m_pnlTranslation.addChangeListener(this.m_lsrTranslation);
            this.m_model.addModelListener(this.m_lsrModel);
        }
        finally {
            this.setListeningForChanges(true);
            this.m_model.setUndoSupported(bUndo);
        }
    }

    public boolean validateData() {
        if (this.m_mapFact.getTranslationSourceColumn() == null) {
            MessageUtil.displayMessage((String)bundle.getString("FactTableMappingPanel.FromColError.txt"), (int)0);
            return false;
        }
        if (this.m_mapFact.getTranslationTargetColumn() == null) {
            MessageUtil.displayMessage((String)bundle.getString("FactTableMappingPanel.ToColError.txt"), (int)0);
            return false;
        }
        if (this.m_mapFact.getTargetColumn().getType() != this.m_mapFact.getTranslationTargetColumn().getType()) {
            MessageUtil.displayMessage((String)bundle.getString("FactTableMappingPanel.MisMatchType.txt"), (int)0);
            return false;
        }
        return true;
    }

    public void setEditable(boolean bEditable) {
        this.m_cmbSourceColumn.setEnabled(bEditable);
        this.m_cmbTargetColumn.setEnabled(bEditable);
        this.m_pnlTranslation.setEditable(bEditable);
        this.m_cmbActionIfUnavailable.setEnabled(bEditable);
        super.setEditable(bEditable);
    }

    public void saveSettingsAndCleanUp() {
        try {
            this.m_cmbSourceColumn.removeActionListener(this.m_lsrSourceColumn);
            this.m_cmbTargetColumn.removeActionListener(this.m_lsrTargetColumn);
            this.m_cmbActionIfUnavailable.removeActionListener(this.m_lsrActionIfUnavailable);
            this.m_pnlTranslation.removeChangeListener(this.m_lsrTranslation);
            this.m_model.removeModelListener(this.m_lsrModel);
            if (this.m_store != null) {
                this.m_store.dispose();
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        super.saveSettingsAndCleanUp();
    }

    public IFactTableMapping getFactTableMapping() {
        return this.m_mapFact;
    }

    private void moveSourceColumnToView() {
        this.m_cmbSourceColumn.setSelectedItem((Object)this.m_mapFact.getSourceColumn().getName());
    }

    private void moveTargetColumnToView() {
        this.m_cmbTargetColumn.setSelectedItem((Object)this.m_mapFact.getTargetColumn().getName());
    }

    private void moveTranslationMappingToView() {
        IColumn sourceColumn = this.m_mapFact.getTranslationSourceColumn();
        IColumn targetColumn = this.m_mapFact.getTranslationTargetColumn();
        Column sourceMetadataColumn = null;
        Column targetMetadataColumn = null;
        try {
            if (sourceColumn != null) {
                sourceMetadataColumn = (Column)ObjectConverter.getInstance().convertToJOMAObject(this.m_store, (SimpleObject)sourceColumn);
            }
            if (targetColumn != null) {
                targetMetadataColumn = (Column)ObjectConverter.getInstance().convertToJOMAObject(this.m_store, (SimpleObject)targetColumn);
            }
            this.m_pnlTranslation.setColumn(0, sourceMetadataColumn);
            this.m_pnlTranslation.setColumn(1, targetMetadataColumn);
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    private void moveActionIfUnavailableToView() {
        String sUnavailableAction = this.m_mapFact.getAction();
        if ("Abort job".equals(sUnavailableAction)) {
            this.m_cmbActionIfUnavailable.setSelectedIndex(1);
        } else if ("None".equals(sUnavailableAction)) {
            this.m_cmbActionIfUnavailable.setSelectedIndex(2);
        } else {
            this.m_cmbActionIfUnavailable.setSelectedIndex(0);
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent e) {
            IObject eventObject = e.getModelObject();
            if (FactTableMappingPanel.this.m_mapFact != null && FactTableMappingPanel.this.m_mapFact.equals(eventObject)) {
                String sType = e.getType();
                if ("Mapping:SourceColumnAdded".equals(sType)) {
                    FactTableMappingPanel.this.moveSourceColumnToView();
                } else if ("Mapping:TargetColumnAdded".equals(sType)) {
                    FactTableMappingPanel.this.moveTargetColumnToView();
                } else if ("IFactTableMapping:TranslationMappingChanged".equals(sType)) {
                    FactTableMappingPanel.this.moveTranslationMappingToView();
                } else if ("IFactTableMapping:ActionChanged".equals(sType)) {
                    FactTableMappingPanel.this.moveActionIfUnavailableToView();
                }
            }
        }
    }

    private class TranslationMappingListener
    implements ChangeListener {
        private TranslationMappingListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent e) {
            Column sourceMetadataColumn = FactTableMappingPanel.this.m_pnlTranslation.getColumn(0);
            Column targetMetadataColumn = FactTableMappingPanel.this.m_pnlTranslation.getColumn(1);
            OMRAdapter omr = null;
            boolean bUndo = FactTableMappingPanel.this.m_model.isUndoSupported();
            if (sourceMetadataColumn != null && targetMetadataColumn != null) {
                FactTableMappingPanel.this.m_model.startCompoundUndoable();
                try {
                    Object translationTable;
                    IColumn targetColumn;
                    IColumn oldTargetColumn = FactTableMappingPanel.this.m_mapFact.getTranslationTargetColumn();
                    if (oldTargetColumn != null && oldTargetColumn.getID().equals(targetMetadataColumn.getFQID())) {
                        return;
                    }
                    omr = new OMRAdapter(FactTableMappingPanel.this.m_model, Workspace.getMdFactory(), "FactTableMappingPanel:loading translation columns");
                    DataTable translationMetadataTable = sourceMetadataColumn.getTable();
                    String sourceColumnID = sourceMetadataColumn.getFQID();
                    String targetColumnID = targetMetadataColumn.getFQID();
                    String translationTableID = translationMetadataTable.getFQID();
                    IColumn sourceColumn = (IColumn)FactTableMappingPanel.this.m_model.getObject(sourceColumnID);
                    if (sourceColumn == null) {
                        sourceColumn = FactTableMappingPanel.this.m_model.getObjectFactory().createColumn(sourceColumnID);
                    }
                    if ((targetColumn = (IColumn)FactTableMappingPanel.this.m_model.getObject(targetColumnID)) == null) {
                        targetColumn = FactTableMappingPanel.this.m_model.getObjectFactory().createColumn(targetColumnID);
                    }
                    if ((translationTable = (ITable)FactTableMappingPanel.this.m_model.getObject(translationTableID)) == null) {
                        translationTable = "ExternalTable".equals(translationMetadataTable.getCMetadataType()) ? FactTableMappingPanel.this.m_model.getObjectFactory().createExternalTable(translationTableID) : FactTableMappingPanel.this.m_model.getObjectFactory().createPhysicalTable(translationTableID);
                    }
                    FactTableMappingPanel.this.m_model.setUndoSupported(false);
                    omr.populateFor((IOMRPersistable)sourceColumn);
                    omr.populateFor((IOMRPersistable)targetColumn);
                    omr.populateFor((IOMRPersistable)translationTable);
                    sourceColumn.loadFromOMR(omr);
                    targetColumn.loadFromOMR(omr);
                    translationTable.loadFromOMR(omr);
                    sourceColumn.setTable(translationTable);
                    targetColumn.setTable(translationTable);
                    FactTableMappingPanel.this.m_model.setUndoSupported(bUndo);
                    FactTableMappingPanel.this.m_mapFact.createNewTranslationMapping(sourceColumn, targetColumn);
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                catch (MdException me) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
                }
                finally {
                    FactTableMappingPanel.this.m_model.endCompoundUndoable();
                    FactTableMappingPanel.this.m_model.setUndoSupported(bUndo);
                    if (omr != null) {
                        omr.dispose();
                    }
                }
            }
        }
    }

    private class ActionIfUnavailableListener
    implements ActionListener {
        private ActionIfUnavailableListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FactTableMappingPanel.this.m_mapFact == null) {
                return;
            }
            int index = FactTableMappingPanel.this.m_cmbActionIfUnavailable.getSelectedIndex();
            if (index == 1) {
                FactTableMappingPanel.this.m_mapFact.setAction("Abort job");
            } else if (index == 2) {
                FactTableMappingPanel.this.m_mapFact.setAction("None");
            } else {
                FactTableMappingPanel.this.m_mapFact.setAction("Move row to error table");
            }
        }
    }

    private class TargetColumnListener
    implements ActionListener {
        private TargetColumnListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FactTableMappingPanel.this.m_mapFact != null) {
                FactTableMappingPanel.this.m_mapFact.setTargetColumn(FactTableMappingPanel.this.m_aTargetColumns[FactTableMappingPanel.this.m_cmbTargetColumn.getSelectedIndex()]);
            }
        }
    }

    private class SourceColumnListener
    implements ActionListener {
        private SourceColumnListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FactTableMappingPanel.this.m_mapFact != null) {
                FactTableMappingPanel.this.m_mapFact.setSourceColumn(FactTableMappingPanel.this.m_aSourceColumns[FactTableMappingPanel.this.m_cmbSourceColumn.getSelectedIndex()]);
            }
        }
    }
}

