/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.scd;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.ICodeSource;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.ITextExpression;
import com.sas.etl.models.job.IUserWrittenCodeContainer;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.scd.ISCDMaximumKeyGeneration;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.transforms.scd.SelectedColumnPanel;
import com.sas.wadmin.visuals.common.CodePane;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DefineMaxGeneratedKeyPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(DefineMaxGeneratedKeyPanel.class);
    private WATextArea m_description;
    private ISCDMaximumKeyGeneration m_model;
    private JPanel m_pnlAutoGenCode;
    private SelectedColumnPanel m_colSelector;
    private JCheckBox m_ckNextAvailableKey;
    private JCheckBox m_ckUpdateTable;
    private CodePane m_pnlSource;
    private JRadioButton m_rbAutoGen;
    private JRadioButton m_rbUserWritten;
    private ButtonGroup m_btnGroup;
    private WsAbstractAction m_actRadioButton;
    private WsAbstractToggleAction m_nextAvailableKeyAction;
    private WsAbstractToggleAction m_updateTableAction;
    private ChangeListener m_columnChangeListener;
    private ChangeListener m_expressionChangeListener;
    private IModelListener m_modelListener;
    protected static final String NEXTKEYPROPERTY = "NextKeyValue";
    protected static final String UPDATETABLEPROPERTY = "MaxKeyUpdate";
    protected static final String USERWRITTENTEXTROLE = "UserWritten";

    public DefineMaxGeneratedKeyPanel(ISCDMaximumKeyGeneration model) {
        this.m_model = model;
        this.initialize();
        this.setHelpProduct("wdb");
        this.setHelpTopic("max_keycode_gen_win");
    }

    protected void initialize() {
        this.m_description = new WATextArea();
        this.m_description.setBehavior(1);
        this.m_description.setText(bundle.getString("DefineMaxGeneratedKeyPanel.Description.txt"));
        this.m_description.setAutosize(true);
        this.m_pnlSource = new CodePane(this.m_model.getMaxKeyUserWrittenCode());
        Dimension preferredSize = this.m_pnlSource.getPreferredSize();
        preferredSize.height = 200;
        this.m_pnlSource.setPreferredSize(preferredSize);
        this.createActions();
        this.createListeners();
        this.createRadioButtons();
        this.createAutoMaxKeyPanel();
        this.layoutComponents();
    }

    protected void createRadioButtons() {
        this.m_rbAutoGen = new JRadioButton(bundle.getString("DefineMaxGeneratedKeyPanel.rbAutoGen.txt"));
        this.m_rbAutoGen.setMnemonic(bundle.getString("DefineMaxGeneratedKeyPanel.rbAutoGen.mnem").charAt(0));
        this.m_rbAutoGen.setToolTipText(bundle.getString("DefineMaxGeneratedKeyPanel.rbAutoGen.Tooltip.txt"));
        this.m_rbAutoGen.addActionListener((ActionListener)this.m_actRadioButton);
        this.m_rbAutoGen.setSelected(true);
        this.m_rbUserWritten = new JRadioButton(bundle.getString("DefineMaxGeneratedKeyPanel.rbUserWritten.txt"));
        this.m_rbUserWritten.setMnemonic(bundle.getString("DefineMaxGeneratedKeyPanel.rbUserWritten.mnem").charAt(0));
        this.m_rbUserWritten.setToolTipText(bundle.getString("DefineMaxGeneratedKeyPanel.rbUserWritten.Tooltip.txt"));
        this.m_rbUserWritten.addActionListener((ActionListener)this.m_actRadioButton);
        this.m_btnGroup = new ButtonGroup();
        this.m_btnGroup.add(this.m_rbAutoGen);
        this.m_btnGroup.add(this.m_rbUserWritten);
    }

    protected void createAutoMaxKeyPanel() {
        this.m_pnlAutoGenCode = new JPanel();
        this.m_colSelector = new SelectedColumnPanel(((IDataTransform)this.m_model).getModel());
        this.m_colSelector.setColumnButtonToolTip(bundle.getString("DefineMaxGeneratedKeyPanel.ColumnEdit.ToolTip.txt"));
        this.m_colSelector.setColumnSelectorDialogDescription(bundle.getString("DefineMaxGeneratedKeyPanel.ColSelection.desc.txt"));
        this.m_colSelector.setColumnSelectorDialogTitle(bundle.getString("DefineMaxGeneratedKeyPanel.ColSelection.title.txt"));
        this.m_colSelector.addColumnChangeListener(this.m_columnChangeListener);
        this.m_colSelector.addExpressionChangeListener(this.m_expressionChangeListener);
        this.m_ckNextAvailableKey = WsUIUtilities.createCheckBox((WsAbstractToggleAction)this.m_nextAvailableKeyAction);
        this.m_ckUpdateTable = WsUIUtilities.createCheckBox((WsAbstractToggleAction)this.m_updateTableAction);
    }

    public void loadCodePane() throws MdException {
        IUserWrittenCodeContainer codeContainer = this.m_model.getMaxKeyUserWrittenCode();
        if (codeContainer != null) {
            this.m_pnlSource.setCodeSource(codeContainer);
        }
    }

    protected void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.m_pnlAutoGenCode.setLayout(new GridBagLayout());
        this.m_pnlAutoGenCode.add((Component)this.m_colSelector, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlAutoGenCode.add((Component)this.m_ckNextAvailableKey, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.m_pnlAutoGenCode.add((Component)this.m_ckUpdateTable, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.m_description, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_rbAutoGen, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.m_pnlAutoGenCode, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 15, 0, 5), 0, 0));
        this.add(this.m_rbUserWritten, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)((Object)this.m_pnlSource), new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 15, 0, 0), 0, 0));
    }

    protected void createActions() {
        this.m_actRadioButton = this.createRadioButtonAction();
        this.m_nextAvailableKeyAction = this.createNextAvailableKeyAction();
        this.m_updateTableAction = this.createUpdateTableAction();
    }

    protected void createListeners() {
        this.m_columnChangeListener = new ColumnChangeListener();
        this.m_expressionChangeListener = new ExpressionChangeListener();
        this.m_modelListener = new ModelListener();
        ((IDataTransform)this.m_model).getModel().addModelListener(this.m_modelListener);
    }

    protected WsAbstractAction createRadioButtonAction() {
        return new cRadioButtonAction();
    }

    protected WsAbstractToggleAction createNextAvailableKeyAction() {
        return new NextAvailableKeyAction();
    }

    protected WsAbstractToggleAction createUpdateTableAction() {
        return new UpdateTableAction();
    }

    public void moveDataToView() throws MdException {
        this.setListeningForChanges(false);
        IColumn maxKeyColumn = this.m_model.getMaxKeyColumn();
        if (maxKeyColumn != null) {
            this.m_colSelector.setColumn(maxKeyColumn);
        }
        this.m_rbAutoGen.setSelected(this.m_model.isGenerateMaxKeyCode());
        this.m_rbUserWritten.setSelected(this.m_model.isUseMaxKeyUserWrittenCode());
        this.m_ckNextAvailableKey.setSelected(this.m_model.isNextKeyValueInGenKey());
        this.m_ckUpdateTable.setSelected(this.m_model.isUpdateTableWithMaxKey());
        ITextExpression expression = this.m_model.getMaxKeyRowSelectorExpression();
        if (expression != null) {
            try {
                String text = expression.getText(null, ((IDataTransform)this.m_model).isQuotingNeeded());
                this.m_colSelector.setExpression(text);
            }
            catch (RemoteException e1) {
                Workspace.handleRemoteException((RemoteException)e1);
            }
            catch (CodegenException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
            }
            catch (MdException e1) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e1, (String)"Accessing");
            }
            catch (BadServerDefinitionException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
            }
            catch (BadLibraryDefinitionException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
            }
            catch (ServerException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
            }
        }
        this.loadCodePane();
        this.updateActions();
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() {
        if (this.m_model.isUseMaxKeyUserWrittenCode()) {
            this.m_pnlSource.save();
        }
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_rbAutoGen.setEnabled(bEditable);
        this.m_rbUserWritten.setEnabled(bEditable);
        this.m_colSelector.setEditable(bEditable);
        this.updateActions();
    }

    protected void updateActions() {
        boolean bEditable = this.isEditable();
        this.m_colSelector.setEnabled(bEditable && this.m_rbAutoGen.isSelected());
        this.m_ckNextAvailableKey.setEnabled(bEditable && this.m_rbAutoGen.isSelected());
        this.m_ckUpdateTable.setEnabled(bEditable && this.m_rbAutoGen.isSelected());
        this.m_pnlSource.setEditable(this.m_rbUserWritten.isSelected());
    }

    protected void updateUserWrittenCode() {
        try {
            ICodeSource codeSource;
            IUserWrittenCodeContainer container = this.m_model.getMaxKeyUserWrittenCode();
            if (container != null && (codeSource = container.getUserWrittenSourceCode()) != null) {
                String text = codeSource.getCode();
                this.m_pnlSource.setText(text);
            }
        }
        catch (ServerException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage());
        }
    }

    public void saveSettingsAndCleanUp() {
        ((IDataTransform)this.m_model).getModel().removeModelListener(this.m_modelListener);
        this.m_colSelector.removeColumnChangeListener(this.m_columnChangeListener);
        this.m_colSelector.removeExpressionChangeListener(this.m_expressionChangeListener);
        super.saveSettingsAndCleanUp();
    }

    public boolean validateData() {
        if (this.m_rbUserWritten.isSelected()) {
            return this.m_pnlSource.validateData();
        }
        if (this.m_colSelector.getColumn() == this.m_model.getGenerateKeyColumn()) {
            if (this.m_colSelector.getExpression().length() > 0) {
                MessageUtil.displayMessage((String)bundle.getString("DefineMaxGeneratedKeyPanel.RowSelectorOnGenkeyError.txt"), (int)0);
                this.m_colSelector.grabFocus();
                return false;
            }
            if (this.m_model.isUpdateTableWithMaxKey()) {
                MessageUtil.displayMessage((String)bundle.getString("DefineMaxGeneratedKeyPanel.UpdateFlagError.txt"), (int)0);
                this.m_ckUpdateTable.grabFocus();
                return false;
            }
            if (this.m_model.isNextKeyValueInGenKey()) {
                MessageUtil.displayMessage((String)bundle.getString("DefineMaxGeneratedKeyPanel.NextAvailFlagError.txt"), (int)0);
                this.m_ckNextAvailableKey.grabFocus();
                return false;
            }
        }
        return true;
    }

    protected class ModelListener
    implements IModelListener {
        protected ModelListener() {
        }

        public void modelChanged(ModelEvent event) {
            String type = event.getType();
            IObject object = event.getModelObject();
            if (object != DefineMaxGeneratedKeyPanel.this.m_model && object != DefineMaxGeneratedKeyPanel.this.m_model.getMaxKeyRowSelectorExpression()) {
                return;
            }
            if (type == "SCDTransformModel:GenerateMaxKeyCodeChanged" || type == "IUserWrittenCode:activeChanged") {
                DefineMaxGeneratedKeyPanel.this.m_rbUserWritten.setSelected(DefineMaxGeneratedKeyPanel.this.m_model.isUseMaxKeyUserWrittenCode());
                DefineMaxGeneratedKeyPanel.this.m_rbAutoGen.setSelected(DefineMaxGeneratedKeyPanel.this.m_model.isGenerateMaxKeyCode());
            } else if (type == "SCDTransformModel:MaxkeyColumnChanged") {
                DefineMaxGeneratedKeyPanel.this.m_colSelector.setColumn(DefineMaxGeneratedKeyPanel.this.m_model.getMaxKeyColumn());
            } else if (type == "SCDTransformModel:MaxkeyExpressionChanged") {
                String expression = DefineMaxGeneratedKeyPanel.this.m_model.getMaxKeyRowSelectorExpressionText();
                DefineMaxGeneratedKeyPanel.this.m_colSelector.setExpression(expression);
            } else if (type == "SCDTransformModel:NextKeyInGenKeyChanged") {
                DefineMaxGeneratedKeyPanel.this.m_ckNextAvailableKey.setSelected(DefineMaxGeneratedKeyPanel.this.m_model.isNextKeyValueInGenKey());
            } else if (type == "SCDTransformModel:UpdateTableWithMaxKeyChanged") {
                DefineMaxGeneratedKeyPanel.this.m_ckUpdateTable.setSelected(DefineMaxGeneratedKeyPanel.this.m_model.isUpdateTableWithMaxKey());
            } else if (type == "TextExpression:TextChanged") {
                String sCurrentExpr;
                String expression = DefineMaxGeneratedKeyPanel.this.m_model.getMaxKeyRowSelectorExpressionText();
                if (expression.equals(sCurrentExpr = DefineMaxGeneratedKeyPanel.this.m_colSelector.getExpression())) {
                    return;
                }
                DefineMaxGeneratedKeyPanel.this.m_colSelector.setExpression(expression);
            }
            DefineMaxGeneratedKeyPanel.this.updateActions();
        }
    }

    private class ExpressionChangeListener
    implements ChangeListener {
        private ExpressionChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            if (!DefineMaxGeneratedKeyPanel.this.isListeningForChanges()) {
                return;
            }
            try {
                ((IDataTransform)DefineMaxGeneratedKeyPanel.this.m_model).getModel().startCompoundUndoable();
                DefineMaxGeneratedKeyPanel.this.m_model.setMaxKeyRowSelectorExpressionText(DefineMaxGeneratedKeyPanel.this.m_colSelector.getExpression());
            }
            finally {
                ((IDataTransform)DefineMaxGeneratedKeyPanel.this.m_model).getModel().endCompoundUndoable();
            }
        }
    }

    private class ColumnChangeListener
    implements ChangeListener {
        private ColumnChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            if (!DefineMaxGeneratedKeyPanel.this.isListeningForChanges()) {
                return;
            }
            try {
                ((IDataTransform)DefineMaxGeneratedKeyPanel.this.m_model).getModel().startCompoundUndoable();
                DefineMaxGeneratedKeyPanel.this.m_model.setMaxKeyColumn(DefineMaxGeneratedKeyPanel.this.m_colSelector.getColumn());
            }
            finally {
                ((IDataTransform)DefineMaxGeneratedKeyPanel.this.m_model).getModel().endCompoundUndoable();
            }
        }
    }

    protected class UpdateTableAction
    extends WsAbstractToggleAction {
        public UpdateTableAction() {
            super(bundle, "DefineMaxGeneratedKeyPanel.Action.UpdateTable", 0);
        }

        public void actionPerformed(ActionEvent e) {
            if (!DefineMaxGeneratedKeyPanel.this.isListeningForChanges()) {
                return;
            }
            try {
                ((IDataTransform)DefineMaxGeneratedKeyPanel.this.m_model).getModel().startCompoundUndoable();
                DefineMaxGeneratedKeyPanel.this.m_model.setUpdateTableWithMaxKey(DefineMaxGeneratedKeyPanel.this.m_ckUpdateTable.isSelected());
            }
            finally {
                ((IDataTransform)DefineMaxGeneratedKeyPanel.this.m_model).getModel().endCompoundUndoable();
            }
        }
    }

    protected class NextAvailableKeyAction
    extends WsAbstractToggleAction {
        public NextAvailableKeyAction() {
            super(bundle, "DefineMaxGeneratedKeyPanel.Action.NextAvailableKey", 0);
        }

        public void actionPerformed(ActionEvent e) {
            if (!DefineMaxGeneratedKeyPanel.this.isListeningForChanges()) {
                return;
            }
            try {
                ((IDataTransform)DefineMaxGeneratedKeyPanel.this.m_model).getModel().startCompoundUndoable();
                DefineMaxGeneratedKeyPanel.this.m_model.setNextKeyValueInGenKey(DefineMaxGeneratedKeyPanel.this.m_ckNextAvailableKey.isSelected());
            }
            finally {
                ((IDataTransform)DefineMaxGeneratedKeyPanel.this.m_model).getModel().endCompoundUndoable();
            }
        }
    }

    protected class cRadioButtonAction
    extends WsAbstractAction {
        protected cRadioButtonAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!DefineMaxGeneratedKeyPanel.this.isListeningForChanges()) {
                return;
            }
            try {
                ((IDataTransform)DefineMaxGeneratedKeyPanel.this.m_model).getModel().startCompoundUndoable();
                if (DefineMaxGeneratedKeyPanel.this.m_rbAutoGen.isSelected()) {
                    DefineMaxGeneratedKeyPanel.this.m_model.setGenerateMaxKeyCode(true);
                    DefineMaxGeneratedKeyPanel.this.m_model.setUseMaxKeyUserWrittenCode(false);
                } else if (DefineMaxGeneratedKeyPanel.this.m_rbUserWritten.isSelected()) {
                    DefineMaxGeneratedKeyPanel.this.m_model.setGenerateMaxKeyCode(false);
                    DefineMaxGeneratedKeyPanel.this.m_model.setUseMaxKeyUserWrittenCode(true);
                }
            }
            finally {
                ((IDataTransform)DefineMaxGeneratedKeyPanel.this.m_model).getModel().endCompoundUndoable();
            }
            DefineMaxGeneratedKeyPanel.this.updateActions();
        }
    }
}

