/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.scd;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.scd.ISCDTransformModel;
import com.sas.etl.models.job.transforms.scd.ISCDType2TransformModel;
import com.sas.util.OrderedMap;
import com.sas.wadmin.transforms.scd.ColumnItem;
import com.sas.wadmin.visuals.common.DateRangePanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ChangeTrackingTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(ChangeTrackingTab.class);
    private JPanel m_methodPanel;
    private WATextArea m_methodDescription;
    private JCheckBox m_cbDateRange;
    private DateRangePanel m_dateRangePanel;
    private JCheckBox m_cbVersNumber;
    private WAComboBox m_cbVersionColumn;
    private JLabel m_lVersionColumn;
    private JCheckBox m_cbCurrInd;
    private JLabel m_lCurrIndColumn;
    private WAComboBox m_cbCurrIndColumn;
    private WsAbstractAction m_checkBoxAction;
    private WsAbstractAction m_cbAction;
    private ModelListener m_modelListener;
    private ISCDType2TransformModel m_model;
    private static final String VERSION = "VERSION";
    private static final String CURRENT_IND = "CURRENTINDICATOR";
    private static final String NONE = bundle.getString("ChangeTrackingTab.None.txt");
    private static final String VERSION_ROLE = bundle.getString("ChangeTrackingTab.VersRole.txt");
    private static final String CURRENT_INDICATOR_ROLE = bundle.getString("ChangeTrackingTab.CurrIndRole.txt");
    private static final String FROM_DATE_ROLE = bundle.getString("ChangeTrackingTab.FromDateRole.txt");
    private static final String TO_DATE_ROLE = bundle.getString("ChangeTrackingTab.ToDateRole.txt");

    public ChangeTrackingTab(ISCDType2TransformModel model) {
        this.m_model = model;
        this.m_modelListener = new ModelListener();
        this.m_model.getModel().addModelListener((IModelListener)this.m_modelListener);
        this.initialize();
        this.setName(bundle.getString("ChangeTrackingTab.Name.txt"));
        this.setHelpProduct("wdb");
        this.setHelpTopic("change_tracking_tab");
    }

    protected void initialize() {
        this.createActions();
        this.createMethodPanel();
        this.layoutComponents();
    }

    protected void createMethodPanel() {
        this.m_methodPanel = new JPanel();
        this.m_methodDescription = new WATextArea();
        this.m_methodDescription.setBehavior(1);
        this.m_methodDescription.setText(bundle.getString("ChangeTrackingTab.Desc.txt"));
        this.m_methodDescription.setAutosize(true);
        this.m_cbDateRange = new JCheckBox(bundle.getString("ChangeTrackingTab.rbDateRange.txt"));
        this.m_cbDateRange.setMnemonic(bundle.getString("ChangeTrackingTab.rbDateRange.mnem").charAt(0));
        this.m_cbDateRange.setToolTipText(bundle.getString("ChangeTrackingTab.rbDateRange.Tooltip.txt"));
        this.m_cbDateRange.addActionListener((ActionListener)this.m_checkBoxAction);
        this.m_cbDateRange.setSelected(true);
        this.m_cbVersNumber = new JCheckBox(bundle.getString("ChangeTrackingTab.rbVersion.txt"));
        this.m_cbVersNumber.setMnemonic(bundle.getString("ChangeTrackingTab.rbVersion.mnem").charAt(0));
        this.m_cbVersNumber.setToolTipText(bundle.getString("ChangeTrackingTab.rbVersion.Tooltip.txt"));
        this.m_cbVersNumber.addActionListener((ActionListener)this.m_checkBoxAction);
        this.m_cbCurrInd = new JCheckBox(bundle.getString("ChangeTrackingTab.rbCurrInd.txt"));
        this.m_cbCurrInd.setMnemonic(bundle.getString("ChangeTrackingTab.rbCurrInd.mnem").charAt(0));
        this.m_cbCurrInd.setToolTipText(bundle.getString("ChangeTrackingTab.rbCurrInd.Tooltip.txt"));
        this.m_cbCurrInd.addActionListener((ActionListener)this.m_checkBoxAction);
        this.m_cbVersionColumn = new WAComboBox();
        this.m_cbVersionColumn.setToolTipText(bundle.getString("ChangeTrackingTab.VersColumn.Tooltip.txt"));
        this.m_lVersionColumn = new JLabel(bundle.getString("ChangeTrackingTab.VersColumn.txt"));
        this.m_lVersionColumn.setDisplayedMnemonic(bundle.getString("ChangeTrackingTab.VersColumn.mnem").charAt(0));
        this.m_lVersionColumn.setLabelFor((Component)this.m_cbVersionColumn);
        this.m_cbVersionColumn.setActionCommand(VERSION);
        this.m_cbVersionColumn.addActionListener((ActionListener)this.m_cbAction);
        this.m_cbCurrIndColumn = new WAComboBox();
        this.m_cbCurrIndColumn.setToolTipText(bundle.getString("ChangeTrackingTab.CurrIndColumn.Tooltip.txt"));
        this.m_lCurrIndColumn = new JLabel(bundle.getString("ChangeTrackingTab.CurrIndColumn.txt"));
        this.m_lCurrIndColumn.setDisplayedMnemonic(bundle.getString("ChangeTrackingTab.CurrIndColumn.mnem").charAt(0));
        this.m_lCurrIndColumn.setLabelFor((Component)this.m_cbCurrIndColumn);
        this.m_cbCurrIndColumn.setActionCommand(CURRENT_IND);
        this.m_cbCurrIndColumn.addActionListener((ActionListener)this.m_cbAction);
        this.m_dateRangePanel = new DateRangePanel((ISCDTransformModel)this.m_model);
    }

    protected void createActions() {
        this.m_checkBoxAction = this.createCheckBoxAction();
        this.m_cbAction = this.createComboBoxAction();
    }

    protected void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.m_methodPanel.setLayout(new GridBagLayout());
        this.m_methodPanel.add((Component)this.m_methodDescription, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_methodPanel.add((Component)this.m_cbDateRange, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.m_methodPanel.add((Component)((Object)this.m_dateRangePanel), new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.m_methodPanel.add((Component)this.m_cbVersNumber, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.m_methodPanel.add((Component)this.m_lVersionColumn, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.m_methodPanel.add((Component)this.m_cbVersionColumn, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.m_methodPanel.add((Component)this.m_cbCurrInd, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.m_methodPanel.add((Component)this.m_lCurrIndColumn, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.m_methodPanel.add((Component)this.m_cbCurrIndColumn, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_methodPanel, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
    }

    public boolean validateData() {
        OrderedMap selectedColumns = new OrderedMap();
        if (this.m_model.getDataTargetsCount() == 1) {
            IColumn column;
            List<String> roles;
            if (!(this.m_cbDateRange.isSelected() || this.m_cbCurrInd.isSelected() || this.m_cbVersNumber.isSelected())) {
                MessageUtil.displayMessage((String)bundle.getString("ChangeTrackingTab.NoMethodSelected.txt"), (int)0);
                return false;
            }
            if (this.m_cbDateRange.isSelected()) {
                if (!this.m_dateRangePanel.validateData()) {
                    return false;
                }
                IColumn fromDateColumn = this.m_model.getFromDateColumn();
                roles = (ArrayList<String>)selectedColumns.get((Object)fromDateColumn);
                if (roles == null) {
                    roles = new ArrayList<String>();
                    selectedColumns.put((Object)fromDateColumn, roles);
                }
                roles.add(FROM_DATE_ROLE);
                IColumn toDateColumn = this.m_model.getToDateColumn();
                roles = (List)selectedColumns.get((Object)toDateColumn);
                if (roles == null) {
                    roles = new ArrayList();
                    selectedColumns.put((Object)toDateColumn, roles);
                }
                roles.add(TO_DATE_ROLE);
            }
            if (this.m_cbVersNumber.isSelected()) {
                column = this.m_model.getVersionColumn();
                if (column == null) {
                    MessageUtil.displayMessage((String)bundle.getString("ChangeTrackingTab.NoVersionNumberColumn.txt"), (int)0);
                    return false;
                }
                if (column.getType() != 1) {
                    MessageUtil.displayMessage((String)bundle.formatString("ChangeTrackingTab.ColumnNotNumeric.txt", (Object)column.getName(), (Object)bundle.getString("ChangeTrackingTab.VersRole.txt")), (int)0);
                    return false;
                }
                roles = (List)selectedColumns.get((Object)column);
                if (roles == null) {
                    roles = new ArrayList();
                    selectedColumns.put((Object)column, roles);
                }
                roles.add(VERSION_ROLE);
            }
            if (this.m_cbCurrInd.isSelected()) {
                column = this.m_model.getCurrentIndicatorColumn();
                if (column == null) {
                    MessageUtil.displayMessage((String)bundle.getString("ChangeTrackingTab.NoCurrentIndicatorColumn.txt"), (int)0);
                    return false;
                }
                roles = (List)selectedColumns.get((Object)column);
                if (roles == null) {
                    roles = new ArrayList();
                    selectedColumns.put((Object)column, roles);
                }
                roles.add(CURRENT_INDICATOR_ROLE);
            }
            List keys = selectedColumns.getKeyList();
            for (int i = 0; i < keys.size(); ++i) {
                IColumn column2 = (IColumn)keys.get(i);
                List roles2 = (List)selectedColumns.get((Object)column2);
                if (roles2 == null || roles2.size() <= 1) continue;
                MessageUtil.displayListMessage((String)bundle.formatString("ChangeTrackingTab.DuplicateColumn.txt", (Object)column2.getName()), (List)roles2, (int)0);
                return false;
            }
        }
        return true;
    }

    public void moveDataToView() {
        ColumnItem item;
        int index;
        this.setListeningForChanges(false);
        ITable[] targets = this.m_model.getTargetTables();
        if (targets == null || targets.length == 0) {
            this.setEditable(false);
            return;
        }
        IColumn[] columns = targets[0].getColumns();
        if (columns.length < 1) {
            MessageUtil.displayMessage((String)bundle.getString("ChangeTrackingTab.NoTargetColumns.txt"), (int)0);
            return;
        }
        this.m_cbVersionColumn.removeAllItems();
        this.m_cbCurrIndColumn.removeAllItems();
        this.m_cbVersionColumn.addItem((Object)NONE);
        this.m_cbCurrIndColumn.addItem((Object)NONE);
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getType() == 0) {
                this.m_cbCurrIndColumn.addItem((Object)new ColumnItem(columns[i]));
            }
            if (columns[i].getType() != 1) continue;
            this.m_cbVersionColumn.addItem((Object)new ColumnItem(columns[i]));
            this.m_cbCurrIndColumn.addItem((Object)new ColumnItem(columns[i]));
        }
        this.m_cbVersionColumn.setSorted(true);
        this.m_cbCurrIndColumn.setSorted(true);
        this.m_dateRangePanel.moveDataToView();
        this.m_cbDateRange.setSelected(this.m_model.isTrackChangesByDates());
        this.m_cbVersNumber.setSelected(this.m_model.isTrackChangesByVersionNumber());
        IColumn column = this.m_model.getVersionColumn();
        if (column != null) {
            for (index = 0; index < this.m_cbVersionColumn.getItemCount(); ++index) {
                if (!(this.m_cbVersionColumn.getItemAt(index) instanceof ColumnItem) || (item = (ColumnItem)this.m_cbVersionColumn.getItemAt(index)).getColumn() != column) continue;
                this.m_cbVersionColumn.setSelectedIndex(index);
                break;
            }
        } else {
            this.m_cbVersionColumn.setSelectedItem((Object)NONE);
        }
        this.m_cbCurrInd.setSelected(this.m_model.isTrackChangesByCurrentIndicator());
        column = this.m_model.getCurrentIndicatorColumn();
        if (column != null) {
            for (index = 0; index < this.m_cbCurrIndColumn.getItemCount(); ++index) {
                if (!(this.m_cbCurrIndColumn.getItemAt(index) instanceof ColumnItem) || (item = (ColumnItem)this.m_cbCurrIndColumn.getItemAt(index)).getColumn() != column) continue;
                this.m_cbCurrIndColumn.setSelectedIndex(index);
                break;
            }
        } else {
            this.m_cbCurrIndColumn.setSelectedItem((Object)NONE);
        }
        this.updateActions();
        this.setListeningForChanges(true);
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_cbCurrInd.setEnabled(bEditable);
        this.m_cbDateRange.setEnabled(bEditable);
        this.m_cbVersNumber.setEnabled(bEditable);
        this.m_dateRangePanel.setEditable(bEditable);
        this.m_cbCurrIndColumn.setEditable(false);
        this.m_cbVersionColumn.setEditable(false);
        this.updateActions();
    }

    protected WsAbstractAction createCheckBoxAction() {
        return new CheckBoxAction();
    }

    protected WsAbstractAction createComboBoxAction() {
        return new cComboBoxAction();
    }

    protected void updateActions() {
        boolean bEditable = this.isEditable();
        this.m_dateRangePanel.setEditable(bEditable && this.m_cbDateRange.isSelected());
        if (this.m_cbDateRange.isSelected()) {
            this.m_dateRangePanel.selectFirstRow();
        } else {
            this.m_dateRangePanel.clearSelection();
        }
        this.m_lCurrIndColumn.setEnabled(bEditable && this.m_cbCurrInd.isSelected());
        this.m_cbCurrIndColumn.setEnabled(bEditable && this.m_cbCurrInd.isSelected());
        this.m_lVersionColumn.setEnabled(bEditable && this.m_cbVersNumber.isSelected());
        this.m_cbVersionColumn.setEnabled(bEditable && this.m_cbVersNumber.isSelected());
    }

    public void saveSettingsAndCleanUp() {
        this.m_model.getModel().removeModelListener((IModelListener)this.m_modelListener);
        this.m_dateRangePanel.saveSettingsAndCleanUp();
    }

    protected class ModelListener
    implements IModelListener {
        protected ModelListener() {
        }

        public void modelChanged(ModelEvent event) {
            String type = event.getType();
            if (type == "ModelController:UnknownChanges") {
                ChangeTrackingTab.this.moveDataToView();
            } else if (type == "SCDTransform:TrackByDatesChanged") {
                ChangeTrackingTab.this.m_cbDateRange.setSelected(ChangeTrackingTab.this.m_model.isTrackChangesByDates());
            } else if (type == "SCDType2TransformModel:CurrentIndicatorTrackingChanged") {
                ChangeTrackingTab.this.m_cbCurrInd.setSelected(ChangeTrackingTab.this.m_model.isTrackChangesByCurrentIndicator());
            } else if (type == "SCDType2TransformModel:CurrentIndicatiorColumnChanged") {
                IColumn column = ChangeTrackingTab.this.m_model.getCurrentIndicatorColumn();
                if (column != null) {
                    ChangeTrackingTab.this.m_cbCurrIndColumn.setSelectedItem((Object)new ColumnItem(column));
                } else {
                    ChangeTrackingTab.this.m_cbCurrIndColumn.setSelectedItem((Object)NONE);
                }
            } else if (type == "SCDType2TransformModel:VersionNumberTrackingChanged") {
                ChangeTrackingTab.this.m_cbVersNumber.setSelected(ChangeTrackingTab.this.m_model.isTrackChangesByVersionNumber());
            } else if (type == "SCDType2TransformModel:VersionColumnChanged") {
                IColumn column = ChangeTrackingTab.this.m_model.getVersionColumn();
                if (column != null) {
                    ChangeTrackingTab.this.m_cbVersionColumn.setSelectedItem((Object)new ColumnItem(column));
                } else {
                    ChangeTrackingTab.this.m_cbVersionColumn.setSelectedItem((Object)NONE);
                }
            }
        }
    }

    protected class cComboBoxAction
    extends WsAbstractAction {
        protected cComboBoxAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            if (!ChangeTrackingTab.this.m_dateRangePanel.stopTableEditing()) {
                return;
            }
            if (!ChangeTrackingTab.this.isListeningForChanges()) {
                return;
            }
            String action = e.getActionCommand();
            Object item = null;
            try {
                ChangeTrackingTab.this.m_model.getModel().startCompoundUndoable();
                if (action.equals(ChangeTrackingTab.VERSION)) {
                    item = ChangeTrackingTab.this.m_cbVersionColumn.getSelectedItem();
                    if (item.equals(NONE)) {
                        ChangeTrackingTab.this.m_model.setVersionColumn(null);
                    } else if (item instanceof ColumnItem) {
                        ColumnItem columnItem = (ColumnItem)item;
                        ChangeTrackingTab.this.m_model.setVersionColumn(columnItem.getColumn());
                    }
                } else if (action.equals(ChangeTrackingTab.CURRENT_IND)) {
                    item = ChangeTrackingTab.this.m_cbCurrIndColumn.getSelectedItem();
                    if (item.equals(NONE)) {
                        ChangeTrackingTab.this.m_model.setCurrentIndicatorColumn(null);
                    } else if (item instanceof ColumnItem) {
                        ColumnItem columnItem = (ColumnItem)item;
                        ChangeTrackingTab.this.m_model.setCurrentIndicatorColumn(columnItem.getColumn());
                    }
                }
            }
            finally {
                ChangeTrackingTab.this.m_model.getModel().endCompoundUndoable();
            }
        }
    }

    protected class CheckBoxAction
    extends WsAbstractAction {
        protected CheckBoxAction() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (!ChangeTrackingTab.this.m_dateRangePanel.stopTableEditing()) {
                    return;
                }
                ChangeTrackingTab.this.m_model.getModel().startCompoundUndoable();
                if (e.getSource() == ChangeTrackingTab.this.m_cbDateRange) {
                    ChangeTrackingTab.this.m_model.setTrackChangesByDates(ChangeTrackingTab.this.m_cbDateRange.isSelected());
                } else if (e.getSource() == ChangeTrackingTab.this.m_cbCurrInd) {
                    ChangeTrackingTab.this.m_model.setTrackChangesByCurrentIndicator(ChangeTrackingTab.this.m_cbCurrInd.isSelected());
                } else if (e.getSource() == ChangeTrackingTab.this.m_cbVersNumber) {
                    ChangeTrackingTab.this.m_model.setTrackChangesByVersionNumber(ChangeTrackingTab.this.m_cbVersNumber.isSelected());
                }
            }
            finally {
                ChangeTrackingTab.this.m_model.getModel().endCompoundUndoable();
            }
            ChangeTrackingTab.this.updateActions();
        }
    }
}

